/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.portallinkingcompass.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.Level;

public record LinkedPortalTracker(Optional<BlockPos> originalPosition, Optional<ResourceKey<Level>> originalDimension, Optional<BlockPos> targetPosition, Optional<ResourceKey<Level>> targetDimension) {
    public static final Codec<LinkedPortalTracker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.optionalFieldOf("originalPosition").forGetter(LinkedPortalTracker::originalPosition), (App)Level.RESOURCE_KEY_CODEC.optionalFieldOf("originalDimension").forGetter(LinkedPortalTracker::originalDimension), (App)BlockPos.CODEC.optionalFieldOf("targetPosition").forGetter(LinkedPortalTracker::targetPosition), (App)Level.RESOURCE_KEY_CODEC.optionalFieldOf("targetDimension").forGetter(LinkedPortalTracker::targetDimension)).apply((Applicative)instance, LinkedPortalTracker::new));
    public static final StreamCodec<ByteBuf, LinkedPortalTracker> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), LinkedPortalTracker::originalPosition, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)Level.RESOURCE_KEY_CODEC)), LinkedPortalTracker::originalDimension, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), LinkedPortalTracker::targetPosition, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)Level.RESOURCE_KEY_CODEC)), LinkedPortalTracker::targetDimension, LinkedPortalTracker::new);

    public LinkedPortalTracker(BlockPos originalPosition, Level level) {
        this(Optional.of(originalPosition), Optional.of(level.dimension()), Optional.of(LinkedPortalTracker.determineTargetPosition(originalPosition, level)), Optional.of(level.dimension() == Level.NETHER ? Level.OVERWORLD : Level.NETHER));
    }

    public static LinkedPortalTracker empty() {
        return new LinkedPortalTracker(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public LinkedPortalTracker tick(Level level) {
        if (this.originalDimension.isEmpty() || this.originalPosition.isEmpty()) {
            return this;
        }
        MinecraftServer server = level.getServer();
        ServerLevel originalDimension = server.getLevel(this.originalDimension.get());
        if (originalDimension == null) {
            return this;
        }
        PoiManager poiManager = originalDimension.getPoiManager();
        boolean originalPortalBlockExists = poiManager.existsAtPosition(PoiTypes.NETHER_PORTAL, this.originalPosition.get());
        if (originalPortalBlockExists) {
            return this;
        }
        return LinkedPortalTracker.empty();
    }

    public boolean isNotLinked() {
        return this.originalPosition.isEmpty() || this.originalDimension.isEmpty() || this.targetPosition.isEmpty() || this.targetDimension.isEmpty();
    }

    private static BlockPos determineTargetPosition(BlockPos originalPosition, Level level) {
        double overworldCoordinateScale = 1.0;
        double netherCoordinateScale = 8.0;
        double coordinateScale = level.dimension() == ServerLevel.NETHER ? netherCoordinateScale / overworldCoordinateScale : overworldCoordinateScale / netherCoordinateScale;
        double x = (double)originalPosition.getX() * coordinateScale;
        double y = Math.max((double)originalPosition.getY(), 0.0);
        double z = (double)originalPosition.getZ() * coordinateScale;
        return level.getWorldBorder().clampToBounds(x, y, z);
    }

    public Optional<GlobalPos> getTargetPos(ClientLevel clientLevel) {
        if (this.isNotLinked() || this.originalPosition().isEmpty() || this.originalDimension().isEmpty() || this.targetPosition().isEmpty() || this.targetDimension().isEmpty()) {
            return Optional.empty();
        }
        ResourceKey currentDimension = clientLevel.dimension();
        ResourceKey<Level> originalDimension = this.originalDimension().get();
        ResourceKey<Level> targetDimension = this.targetDimension().get();
        BlockPos originalPosition = this.originalPosition().get();
        BlockPos targetPosition = this.targetPosition().get();
        if (currentDimension == originalDimension) {
            return Optional.of(GlobalPos.of(originalDimension, (BlockPos)originalPosition));
        }
        if (currentDimension == targetDimension) {
            return Optional.of(GlobalPos.of(targetDimension, (BlockPos)targetPosition));
        }
        return Optional.empty();
    }
}

