/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBabyMummy
extends EntityCreepBase
implements IMob {
    private static final String[] textures = new String[]{"textures/entity/mummy1", "textures/entity/mummy2", "textures/entity/mummy3"};

    public EntityBabyMummy(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.6f);
        this.creatureType = EnumCreatureType.MONSTER;
        this.spawnOnlyAtNight = true;
        this.baseHealth = 15.0f;
        this.baseSpeed = 0.25;
        this.baseAttackDamage = 1.0;
        this.setModelSize(this.field_70146_Z.nextFloat() * 0.45f + 0.25f);
        this.updateAttributes();
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150325_L), this.field_70146_Z.nextInt(6) + 1);
        } else {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150354_m), this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.babyMummyHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.babyMummyDeathSound;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.babyMummySound;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f + (0.7f - this.getModelSize()) * 2.0f;
    }

    @Override
    protected String[] getAvailableTextures() {
        return textures;
    }

    @Override
    protected boolean shouldJumpWhileAttacking(Entity entity) {
        return true;
    }

    @Override
    protected void doAttackJump(Entity entity) {
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(entity.field_70161_v - this.field_70161_v, entity.field_70165_t - this.field_70165_t)) - 90.0f;
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        this.field_70159_w = d0 / f * 0.5 * 0.8000000019209289 + this.field_70159_w * 0.18000000098023225;
        this.field_70179_y = d1 / f * 0.5 * 0.7000000019209289 + this.field_70179_y * 0.18000000098023225;
        this.field_70143_R = -25.0f;
    }

    @Override
    public boolean func_70652_k(@Nonnull Entity entity) {
        int z;
        int y;
        int x;
        double dist = this.func_70068_e(entity);
        if (this.field_70122_E && dist > 2.0 && dist < 6.0 && this.func_70013_c() >= 0.5f && this.field_70146_Z.nextInt(100) > 0 && this.field_70146_Z.nextInt(10) == 0 && this.field_70170_p.func_180495_p(new BlockPos(x = MathHelper.func_76128_c((double)entity.field_70165_t), (y = MathHelper.func_76128_c((double)entity.field_70163_u)) - 2, z = MathHelper.func_76128_c((double)entity.field_70161_v))).func_177230_c() == Blocks.field_150354_m) {
            int i;
            int r;
            if (this.field_70146_Z.nextInt(5) == 0) {
                r = this.field_70146_Z.nextInt(4) + 1;
                for (i = 0; i < r; ++i) {
                    this.field_70170_p.func_175698_g(new BlockPos(x, y - (i + 2), z));
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        this.field_70170_p.func_175698_g(new BlockPos(x + i, y - 2, z));
                    }
                    if (this.field_70146_Z.nextInt(5) != 0) continue;
                    this.field_70170_p.func_175698_g(new BlockPos(x, y - 2, z + i));
                }
            }
            if (this.field_70146_Z.nextInt(5) == 0) {
                if (this.field_70146_Z.nextInt(2) == 0) {
                    r = this.field_70146_Z.nextInt(5);
                    for (i = -3; i < 3; ++i) {
                        this.field_70170_p.func_175656_a(new BlockPos(x + i, y + r, z + 2), Blocks.field_150354_m.func_176223_P());
                        this.field_70170_p.func_175656_a(new BlockPos(x + i, y + r, z - 2), Blocks.field_150354_m.func_176223_P());
                    }
                }
                if (this.field_70146_Z.nextInt(2) == 0) {
                    r = this.field_70146_Z.nextInt(5);
                    for (i = -3; i < 3; ++i) {
                        this.field_70170_p.func_175656_a(new BlockPos(x + 2, y + r, z + i), Blocks.field_150354_m.func_176223_P());
                        this.field_70170_p.func_175656_a(new BlockPos(x - 2, y + r, z + i), Blocks.field_150354_m.func_176223_P());
                    }
                }
            }
        }
        return super.func_70652_k(entity);
    }
}

