/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBaseOwnable;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBlorp
extends EntityCreepBaseOwnable
implements IEntityCanChangeSize {
    private static final DataParameter<Boolean> hungry = EntityDataManager.func_187226_a(EntityBlorp.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> hungryTime = EntityDataManager.func_187226_a(EntityBlorp.class, (DataSerializer)DataSerializers.field_187192_b);
    private BlockPos targetTree = null;

    public EntityBlorp(World worldIn) {
        super(worldIn);
        this.setModelSize(1.0f);
        this.func_70105_a(1.0f, 1.5f);
        this.baseAttackDamage = 2.0;
        this.baseHealth = 35.0f;
        this.baseSpeed = 0.25;
        this.updateAttributes();
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/blorp.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(hungry, (Object)false);
        this.field_70180_af.func_187214_a(hungryTime, (Object)(this.field_70146_Z.nextInt(20) + 20));
    }

    @Override
    public void func_70636_d() {
        if (this.getModelSize() > 2.0f) {
            this.field_70158_ak = true;
        }
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            this.setHungry(false);
            this.targetTree = null;
            this.setHungryTime(100);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getHungry()) {
                BlockPos blockPos = this.targetTree != null ? this.targetTree : this.findTree(2.0);
                if (blockPos != null) {
                    this.func_184185_a(CreepsSoundHandler.blorpEatSound, this.func_70599_aP(), this.func_70647_i());
                    this.field_70170_p.func_175698_g(blockPos);
                    this.setHungryTime(this.getHungryTime() + this.field_70146_Z.nextInt(100) + 25);
                    if (this.getHungryTime() > 1000) {
                        this.setHungry(false);
                        if (this.getModelSize() < this.maxGrowth()) {
                            this.growModelSize(0.15f, this.maxGrowth());
                            float growthDifference = 100.0f - this.currentSize * 100.0f / this.getModelSize();
                            this.growHitboxSize(this.currentSize / 100.0f * growthDifference);
                        }
                        this.setLevel(this.getLevel() + 1);
                        this.updateAttributes();
                        this.addHealth(this.getLevelHealthMultiplier());
                        this.func_184185_a(CreepsSoundHandler.blorpGrowSound, this.func_70599_aP(), this.func_70647_i());
                    }
                    this.faceTreeTop();
                    this.field_70699_by.func_75492_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 1.0);
                } else {
                    this.setHungryTime(100);
                }
            } else {
                this.setHungryTime(this.getHungryTime() - 1);
                if (this.getHungryTime() < 1) {
                    this.setHungry(true);
                    this.setHungryTime(1);
                }
            }
        }
    }

    public boolean getHungry() {
        return (Boolean)this.field_70180_af.func_187225_a(hungry);
    }

    private void setHungry(boolean b) {
        this.field_70180_af.func_187227_b(hungry, (Object)b);
    }

    public int getHungryTime() {
        return (Integer)this.field_70180_af.func_187225_a(hungryTime);
    }

    private void setHungryTime(int i) {
        this.field_70180_af.func_187227_b(hungryTime, (Object)i);
    }

    @Override
    public boolean func_70094_T() {
        return false;
    }

    @Override
    protected void dropItemsOnDeath() {
        this.func_145779_a(CreepsItemHandler.blorpCola, this.getLevel());
    }

    public int func_70641_bl() {
        return 3;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.blorpSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.blorpHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.blorpDeathSound;
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBlorp.class, true));
    }

    private BlockPos findTree(double d1) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(d1, d1, d1);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    Block block = this.field_70170_p.func_180495_p(blockPos).func_177230_c();
                    if (block == Blocks.field_150362_t || block == Blocks.field_150361_u) {
                        return blockPos;
                    }
                    if (this.getLevel() <= 3 || block != Blocks.field_150364_r && block != Blocks.field_150363_s) continue;
                    return blockPos;
                }
            }
        }
        return null;
    }

    @Override
    public float func_180484_a(BlockPos blockPos) {
        Block block = this.field_70170_p.func_180495_p(blockPos).func_177230_c();
        if (block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
            return 10.0f;
        }
        return super.func_180484_a(blockPos);
    }

    private void faceTreeTop() {
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) / Math.PI);
    }

    @Override
    protected float getLevelHealthMultiplier() {
        return 10.0f;
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource damageSource, float amt) {
        boolean flag = super.func_70097_a(damageSource, amt);
        if (flag) {
            this.setHungry(false);
            this.setHungryTime(100);
        }
        return flag;
    }

    @Override
    protected void doAttackJump(Entity entity) {
        this.func_184185_a(CreepsSoundHandler.blorpBounceSound, this.func_70599_aP(), this.func_70647_i());
        double d = entity.field_70165_t - this.field_70165_t;
        double d2 = entity.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        this.field_70159_w = d / (double)f1 * 0.2 * (double)0.8f + this.field_70159_w * (double)0.2f;
        this.field_70179_y = d2 / (double)f1 * 0.2 * (double)0.8f + this.field_70179_y * (double)0.2f;
        this.field_70181_x = 0.7000000059624645 + (double)this.getModelSize() * 0.050000004559;
        this.field_70143_R = -25.0f + this.getModelSize() * -5.0f;
    }

    @Override
    protected boolean shouldJumpWhileAttacking(Entity entity) {
        return true;
    }

    @Override
    public float maxShrink() {
        return 0.3f;
    }

    @Override
    public float getRayAmount() {
        return 0.25f;
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }
}

