/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityCaveman
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final DataParameter<Boolean> caveGirl = EntityDataManager.func_187226_a(EntityCaveman.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> evil = EntityDataManager.func_187226_a(EntityCaveman.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> frozenLevel = EntityDataManager.func_187226_a(EntityCaveman.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> houseChunk = EntityDataManager.func_187226_a(EntityCaveman.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> housePos = EntityDataManager.func_187226_a(EntityCaveman.class, (DataSerializer)DataSerializers.field_187200_j);
    private int talkDelay = 0;

    public EntityCaveman(World worldIn) {
        super(worldIn);
        float fat = this.field_70146_Z.nextFloat() * 1.0f - this.field_70146_Z.nextFloat() * 0.55f;
        this.func_70105_a(this.field_70130_N * 0.8f + fat, this.field_70131_O * 1.3f + fat);
        this.setModelSize(1.25f + this.field_70146_Z.nextFloat() * 1.0f - this.field_70146_Z.nextFloat() * 0.75f);
        this.baseHealth = 25.0f;
        this.baseSpeed = 0.3;
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        if (this.getEvil()) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(caveGirl, (Object)(this.field_70146_Z.nextInt(100) > 50 ? 1 : 0));
        this.field_70180_af.func_187214_a(evil, (Object)false);
        this.field_70180_af.func_187214_a(frozenLevel, (Object)5);
        this.field_70180_af.func_187214_a(houseChunk, (Object)0);
        this.field_70180_af.func_187214_a(housePos, (Object)new BlockPos(0, 0, 0));
    }

    public boolean getCaveGirl() {
        return (Boolean)this.field_70180_af.func_187225_a(caveGirl);
    }

    protected void setCaveGirl(boolean b) {
        this.field_70180_af.func_187227_b(caveGirl, (Object)b);
    }

    public boolean getEvil() {
        return (Boolean)this.field_70180_af.func_187225_a(evil);
    }

    protected void setEvil(boolean b) {
        this.field_70180_af.func_187227_b(evil, (Object)b);
    }

    public int getFrozenLevel() {
        return (Integer)this.field_70180_af.func_187225_a(frozenLevel);
    }

    protected void setFrozenLevel(int i) {
        this.field_70180_af.func_187227_b(frozenLevel, (Object)i);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getFrozenLevel() > 0 && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)))) {
            this.field_70163_u -= 1.0;
        }
        if (this.func_70072_I() || this.func_70026_G()) {
            this.setFrozenLevel(0);
        }
        this.updateMoveSpeed();
        if (this.getWanderState() == 0 && this.getFrozenLevel() < 1 && !this.getEvil() && this.field_70146_Z.nextInt(100) == 0) {
            this.setWanderState(1);
        }
        if (this.getWanderState() == 1 && this.field_70146_Z.nextInt(201) == 200 && !this.getEvil() && this.checkArea()) {
            this.setWanderState(2);
            this.setHouseChunk(0);
            for (int i = 0; i < 4; ++i) {
                int houseZ;
                int houseY;
                BlockPos blockPos = this.getHousePos();
                int houseX = blockPos.func_177958_n();
                if (!this.field_70170_p.func_175623_d(new BlockPos(houseX, houseY = blockPos.func_177956_o(), houseZ = blockPos.func_177952_p())) && !this.field_70170_p.func_175623_d(new BlockPos(houseX + 1, houseY, houseZ)) && !this.field_70170_p.func_175623_d(new BlockPos(houseX + 2, houseY, houseZ + 4)) && !this.field_70170_p.func_175623_d(new BlockPos(houseX, houseY, houseZ + 2))) continue;
                this.setHousePos(new BlockPos(houseX, houseY - 1, houseZ));
            }
        }
        if (this.getWanderState() == 2) {
            BlockPos blockPos = this.getHousePos();
            int houseX = blockPos.func_177958_n();
            int houseY = blockPos.func_177956_o();
            int houseZ = blockPos.func_177952_p();
            this.field_70165_t = houseX - 1;
            this.func_70101_b(45.0f, this.field_70125_A);
            if (this.field_70146_Z.nextInt(50) == 0) {
                switch (this.getHouseChunk()) {
                    case 0: {
                        this.field_70170_p.func_175656_a(new BlockPos(houseX + 1, houseY, houseZ), Blocks.field_150433_aE.func_176223_P());
                        this.snowFX(houseX + 1, houseY, houseZ);
                        this.moveNextStage();
                        break;
                    }
                    case 1: {
                        this.field_70170_p.func_175656_a(new BlockPos(houseX + 1, houseY + 1, houseZ), Blocks.field_150433_aE.func_176223_P());
                        this.snowFX(houseX + 1, houseY + 1, houseZ);
                        this.moveNextStage();
                        break;
                    }
                    case 2: {
                        this.field_70170_p.func_175656_a(new BlockPos(houseX + 3, houseY, houseZ), Blocks.field_150433_aE.func_176223_P());
                        this.snowFX(houseX + 3, houseY, houseZ);
                        this.moveNextStage();
                        break;
                    }
                    case 3: {
                        this.field_70170_p.func_175656_a(new BlockPos(houseX + 3, houseY + 1, houseZ), Blocks.field_150433_aE.func_176223_P());
                        this.snowFX(houseX + 3, houseY + 1, houseZ);
                        this.moveNextStage();
                        break;
                    }
                    case 4: {
                        int i;
                        for (i = 1; i < 4; ++i) {
                            this.field_70170_p.func_175656_a(new BlockPos(houseX, houseY, houseZ + i), Blocks.field_150433_aE.func_176223_P());
                            this.snowFX(houseX, houseY, houseZ + i);
                        }
                        this.moveNextStage();
                        break;
                    }
                    case 5: {
                        int i;
                        for (i = 1; i < 4; ++i) {
                            this.field_70170_p.func_175656_a(new BlockPos(houseX, houseY + 1, houseZ + i), Blocks.field_150433_aE.func_176223_P());
                            this.snowFX(houseX, houseY + 1, houseZ + i);
                        }
                        this.moveNextStage();
                        break;
                    }
                    case 6: {
                        int i;
                        for (i = 1; i < 4; ++i) {
                            this.field_70170_p.func_175656_a(new BlockPos(houseX + 4, houseY, houseZ + i), Blocks.field_150433_aE.func_176223_P());
                            this.snowFX(houseX + 4, houseY, houseZ + i);
                        }
                        this.moveNextStage();
                        break;
                    }
                    case 7: {
                        int i;
                        for (i = 1; i < 4; ++i) {
                            this.field_70170_p.func_175656_a(new BlockPos(houseX + 4, houseY + 1, houseZ + i), Blocks.field_150433_aE.func_176223_P());
                            this.snowFX(houseX + 4, houseY + 1, houseZ + i);
                        }
                        this.moveNextStage();
                        break;
                    }
                    case 8: {
                        int i;
                        for (i = 1; i < 4; ++i) {
                            this.field_70170_p.func_175656_a(new BlockPos(houseX + i, houseY, houseZ + 4), Blocks.field_150433_aE.func_176223_P());
                            this.snowFX(houseX + i, houseY, houseZ + 4);
                        }
                        this.moveNextStage();
                        break;
                    }
                    case 9: {
                        int i;
                        for (i = 1; i < 4; ++i) {
                            this.field_70170_p.func_175656_a(new BlockPos(houseX + i, houseY + 1, houseZ + 4), Blocks.field_150433_aE.func_176223_P());
                            this.snowFX(houseX + i, houseY + 1, houseZ + 4);
                        }
                        this.moveNextStage();
                        break;
                    }
                    case 10: {
                        int i;
                        for (i = 1; i < 4; ++i) {
                            for (int k = 1; k < 4; ++k) {
                                this.field_70170_p.func_175656_a(new BlockPos(houseX + k, houseY + 2, houseZ + i), Blocks.field_150433_aE.func_176223_P());
                                this.snowFX(houseX + k, houseY + 2, houseZ + i);
                            }
                        }
                        this.moveNextStage();
                        break;
                    }
                    case 11: {
                        this.field_70170_p.func_175656_a(new BlockPos(houseX + 2, houseY + 3, houseZ + 2), Blocks.field_150433_aE.func_176223_P());
                        this.snowFX(houseX + 2, houseY + 3, houseZ + 2);
                        this.moveNextStage();
                        break;
                    }
                    case 12: {
                        Item itemToGive = CreepsItemHandler.popsicle;
                        if (this.field_70146_Z.nextInt(5) == 0) {
                            itemToGive = Items.field_151115_aP;
                        }
                        EntityItem entityItem = new EntityItem(this.field_70170_p, (double)(houseX + 3), (double)houseY, (double)(houseZ + 3), new ItemStack(itemToGive, this.field_70146_Z.nextInt(4) + 1));
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d((Entity)entityItem);
                        }
                        this.setWanderState(3);
                        break;
                    }
                }
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.setHammerSwing(-2.8f);
                this.func_184185_a(CreepsSoundHandler.cavemanBuildSound, 1.0f, this.func_70647_i());
            }
        }
    }

    protected boolean func_70610_aX() {
        if (this.getFrozenLevel() >= 1 || this.getWanderState() == 2) {
            return true;
        }
        return super.func_70610_aX();
    }

    @Override
    protected double getMoveSpeed() {
        if (this.getFrozenLevel() >= 1) {
            return 0.0;
        }
        return super.getMoveSpeed();
    }

    private boolean checkArea() {
        int b;
        int a;
        int houseZ;
        int houseY;
        int houseX = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_175623_d(new BlockPos(houseX, (houseY = MathHelper.func_76128_c((double)this.field_70163_u)) - 1, houseZ = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            --houseY;
        }
        this.setHousePos(new BlockPos(houseX, houseY, houseZ));
        int area = 0;
        for (a = -3; a < 7; ++a) {
            for (b = -3; b < 7; ++b) {
                for (int c = 0; c < 3; ++c) {
                    if (!this.field_70170_p.func_175623_d(new BlockPos(houseX + b, houseY + c, houseZ + a))) continue;
                    ++area;
                }
            }
        }
        if (area < 220) {
            return false;
        }
        for (a = -2; a < 7; ++a) {
            for (b = -2; b < 7; ++b) {
                Block block1 = this.field_70170_p.func_180495_p(new BlockPos(houseX + b, houseY, houseZ + a)).func_177230_c();
                Block block2 = this.field_70170_p.func_180495_p(new BlockPos(houseX + b, houseY - 1, houseZ + a)).func_177230_c();
                if (block1 == Blocks.field_150433_aE || block1 == Blocks.field_150432_aD) {
                    ++area;
                }
                if (block2 != Blocks.field_150433_aE && block2 != Blocks.field_150432_aD) continue;
                ++area;
            }
        }
        return area > 75;
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double xRatio, double zRatio) {
        if (this.getFrozenLevel() >= 1) {
            return;
        }
        super.func_70653_a(entity, strength, xRatio, zRatio);
    }

    @Override
    public float func_180484_a(BlockPos blockPos) {
        Block block = this.field_70170_p.func_180495_p(blockPos).func_177230_c();
        if (block == Blocks.field_150351_n || block == Blocks.field_150348_b) {
            return 10.0f;
        }
        return super.func_180484_a(blockPos);
    }

    @Override
    protected void updateTexture() {
        if (this.getEvil()) {
            if (this.getCaveGirl()) {
                this.setTexture("textures/entity/cavemanladyevil.png");
            } else {
                this.setTexture("textures/entity/cavemanevil.png");
            }
        } else if (this.getCaveGirl()) {
            this.setTexture("textures/entity/cavemanlady.png");
        } else {
            this.setTexture("textures/entity/caveman.png");
        }
    }

    @Override
    public int func_70627_aG() {
        if (this.getEvil()) {
            return 120;
        }
        return 180;
    }

    public int func_70641_bl() {
        return 2;
    }

    protected SoundEvent func_184639_G() {
        if (this.getEvil()) {
            return CreepsSoundHandler.cavemanEvilSound;
        }
        if (this.func_70638_az() != null) {
            if (this.getCaveGirl()) {
                return CreepsSoundHandler.cavewomanFreeSound;
            }
            return CreepsSoundHandler.cavemanFreeSound;
        }
        if (this.getCaveGirl()) {
            if (this.getFrozenLevel() < 1) {
                return CreepsSoundHandler.cavewomanFreeSound;
            }
            return CreepsSoundHandler.cavewomanFrozenSound;
        }
        if (this.getFrozenLevel() < 1) {
            return CreepsSoundHandler.cavemanFreeSound;
        }
        return CreepsSoundHandler.cavemanFrozenSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.getFrozenLevel() > 0) {
            return null;
        }
        if (this.getCaveGirl()) {
            return CreepsSoundHandler.cavewomanHurtSound;
        }
        return CreepsSoundHandler.cavemanHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        if (this.getCaveGirl()) {
            return CreepsSoundHandler.cavewomanDeadSound;
        }
        return CreepsSoundHandler.cavemanDeadSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(Items.field_151147_al, this.field_70146_Z.nextInt(3) + 1);
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(CreepsItemHandler.popsicle, this.field_70146_Z.nextInt(3) + 1);
        }
        if (this.field_70146_Z.nextInt(8) == 0) {
            this.func_145779_a(CreepsItemHandler.cavemanClub, 1);
        }
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.getFrozenLevel() < 1) {
            this.setEvil(true);
            this.updateTexture();
            this.func_184651_r();
            return super.func_70097_a(source, amount);
        }
        if (source.func_76346_g() instanceof EntityPlayer) {
            this.func_184185_a(CreepsSoundHandler.cavemanNiceSound, 0.5f, this.func_70647_i());
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(100) > 65) {
                this.setFrozenLevel(this.getFrozenLevel() - 1);
                for (int i = 0; i < 35; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SNOWBALL, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        this.field_70737_aN = 0;
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsCaveman");
        props.func_74768_a("FrozenLevel", this.getFrozenLevel());
        props.func_74757_a("CaveGirl", this.getCaveGirl());
        props.func_74757_a("Evil", this.getEvil());
        props.func_74768_a("HouseChunk", this.getHouseChunk());
        BlockPos blockPos = this.getHousePos();
        props.func_74768_a("HouseX", blockPos.func_177958_n());
        props.func_74768_a("HouseY", blockPos.func_177956_o());
        props.func_74768_a("HouseZ", blockPos.func_177952_p());
        compound.func_74782_a("MoreCreepsCaveman", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsCaveman");
        if (props.func_74764_b("FrozenLevel")) {
            this.setFrozenLevel(props.func_74762_e("FrozenLevel"));
        }
        if (props.func_74764_b("CaveGirl")) {
            this.setCaveGirl(props.func_74767_n("CaveGirl"));
        }
        if (props.func_74764_b("Evil")) {
            this.setEvil(props.func_74767_n("Evil"));
        }
        if (props.func_74764_b("HouseChunk")) {
            this.setHouseChunk(props.func_74762_e("HouseChunk"));
        }
        if (props.func_74764_b("HouseX") && props.func_74764_b("HouseY") && props.func_74764_b("HouseZ")) {
            this.setHousePos(new BlockPos(props.func_74762_e("HouseX"), props.func_74762_e("HouseY"), props.func_74762_e("HouseZ")));
        }
        this.updateAttributes();
        this.func_184651_r();
    }

    @Override
    public boolean func_70652_k(@Nonnull Entity entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if ((double)f < 2.9 && entity.func_174813_aQ().field_72337_e > this.func_174813_aQ().field_72338_b && entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
            if (this.getHammerSwing() == 0.0f) {
                this.setHammerSwing(-2.8f);
            }
            if (this.talkDelay-- < 0) {
                this.func_184185_a(CreepsSoundHandler.cavemanEvilSound, 0.5f, this.func_70647_i());
                this.talkDelay = 2;
            }
        }
        return super.func_70652_k(entity);
    }

    private void snowFX(int x, int y, int z) {
        for (int i = 0; i < 40; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, (double)x, (double)y + 0.5, (double)z, 1.0, 1.0, 1.0, new int[0]);
        }
    }

    private void moveNextStage() {
        this.setHammerSwing(-2.8f);
        this.func_184185_a(CreepsSoundHandler.cavemanBuildSound, 1.0f, this.func_70647_i());
        this.setHouseChunk(this.getHouseChunk() + 1);
    }

    public int getHouseChunk() {
        return (Integer)this.field_70180_af.func_187225_a(houseChunk);
    }

    protected void setHouseChunk(int i) {
        this.field_70180_af.func_187227_b(houseChunk, (Object)i);
    }

    public BlockPos getHousePos() {
        return (BlockPos)this.field_70180_af.func_187225_a(housePos);
    }

    protected void setHousePos(BlockPos pos) {
        this.field_70180_af.func_187227_b(housePos, (Object)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        this.field_70180_af.func_187217_b(housePos);
    }

    @Override
    public float maxShrink() {
        return 0.4f;
    }

    @Override
    public float getRayAmount() {
        return 0.2f;
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }
}

