/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityFloob;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFloobShip
extends EntityCreepBase
implements IMob {
    private static final DataParameter<Integer> lifespan = EntityDataManager.func_187226_a(EntityFloobShip.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> floobCounter = EntityDataManager.func_187226_a(EntityFloobShip.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> landed = EntityDataManager.func_187226_a(EntityFloobShip.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> bump = EntityDataManager.func_187226_a(EntityFloobShip.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> firstReset = EntityDataManager.func_187226_a(EntityFloobShip.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityFloobShip(World worldIn) {
        super(worldIn);
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = (float)this.field_70146_Z.nextInt(100) + 50.0f;
        this.baseSpeed = 0.0;
        this.func_70105_a(4.0f, 3.0f);
        this.field_70159_w = this.field_70146_Z.nextFloat() * 0.8f;
        this.field_70179_y = this.field_70146_Z.nextFloat() * 0.8f;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(lifespan, (Object)(this.field_70146_Z.nextInt(10000) + 1500));
        this.field_70180_af.func_187214_a(floobCounter, (Object)(this.field_70146_Z.nextInt(500) + 400));
        this.field_70180_af.func_187214_a(landed, (Object)false);
        this.field_70180_af.func_187214_a(bump, (Object)Float.valueOf(2.0f));
        this.field_70180_af.func_187214_a(firstReset, (Object)false);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/floobship.png");
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.floobShipSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.floobShipSound;
    }

    protected SoundEvent func_184615_bR() {
        if ((Integer)this.field_70180_af.func_187225_a(lifespan) > 0) {
            return CreepsSoundHandler.floobShipDeathSound;
        }
        return null;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if ((Integer)this.field_70180_af.func_187225_a(floobCounter) > 0) {
            this.field_70180_af.func_187227_b(floobCounter, (Object)((Integer)this.field_70180_af.func_187225_a(floobCounter) - 1));
        }
        if ((Integer)this.field_70180_af.func_187225_a(lifespan) > 0) {
            this.field_70180_af.func_187227_b(lifespan, (Object)((Integer)this.field_70180_af.func_187225_a(lifespan) - 1));
        }
        if ((Integer)this.field_70180_af.func_187225_a(lifespan) < 1) {
            this.func_70106_y();
        }
        if (this.func_70072_I()) {
            this.field_70181_x += (double)0.28f;
            this.field_70159_w += 0.98;
            this.field_70159_w += 0.98;
        }
        if (this.getLanded()) {
            this.field_70181_x = 0.0;
            this.field_70180_af.func_187227_b(bump, (Object)Float.valueOf(0.0f));
        }
        if (!this.getLanded() || !this.field_70122_E) {
            if (this.field_70163_u < 100.0 && !this.getFirstReset()) {
                this.field_70181_x = 4.0;
                this.field_70180_af.func_187227_b(bump, (Object)Float.valueOf(4.0f));
                this.setFirstReset(true);
            }
            this.field_70181_x = -0.2f + ((Float)this.field_70180_af.func_187225_a(bump)).floatValue();
            this.field_70180_af.func_187227_b(bump, (Object)Float.valueOf(((Float)this.field_70180_af.func_187225_a(bump)).floatValue() * 0.96f));
            this.field_70159_w *= 0.98;
            this.field_70179_y *= 0.98;
            if (this.field_70122_E) {
                Block block = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c();
                if (block == Blocks.field_150358_i || block == Blocks.field_150355_j || block == Blocks.field_150362_t || block == Blocks.field_150434_aF) {
                    this.thrusters();
                    this.field_70180_af.func_187227_b(bump, (Object)Float.valueOf(3.0f));
                    this.field_70159_w = this.field_70146_Z.nextFloat() * 2.8f;
                    this.field_70181_x = this.field_70146_Z.nextFloat() * 0.6f;
                    this.field_70179_y = this.field_70146_Z.nextFloat() * 2.8f;
                } else {
                    this.setLanded(true);
                }
            }
        } else if ((Integer)this.field_70180_af.func_187225_a(floobCounter) < 1) {
            this.thrusters();
            this.field_70180_af.func_187227_b(floobCounter, (Object)(this.field_70146_Z.nextInt(300) + 400));
            this.func_184185_a(CreepsSoundHandler.floobShipSpawnSound, this.func_70599_aP(), this.func_70647_i());
            int randInt = this.field_70146_Z.nextInt(2) + 3;
            for (int i = 0; i < randInt; ++i) {
                EntityFloob floob = new EntityFloob(this.field_70170_p);
                floob.setInitialHealth();
                floob.func_70012_b(this.field_70165_t + 3.0 + (double)i, this.field_70163_u + 1.0, this.field_70161_v + (double)i, this.field_70177_z, 0.0f);
                floob.field_70159_w = this.field_70146_Z.nextFloat() * 1.5f;
                floob.field_70181_x = this.field_70146_Z.nextFloat() * 1.2f;
                floob.field_70179_y = this.field_70146_Z.nextFloat() * 1.5f;
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_72838_d((Entity)floob);
            }
        }
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource damageSource, float amt) {
        Block block;
        if (damageSource.func_76346_g() instanceof EntityPlayer) {
            this.thrusters();
            this.func_184185_a(CreepsSoundHandler.floobShipClangSound, 1.0f, this.func_70647_i());
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.field_70180_af.func_187227_b(bump, (Object)Float.valueOf(this.field_70146_Z.nextInt(3)));
            this.field_70159_w = this.field_70146_Z.nextFloat() * 0.8f;
            this.field_70179_y = this.field_70146_Z.nextFloat() * 0.8f;
        }
        if ((block = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()) == Blocks.field_150358_i || block == Blocks.field_150355_j || block == Blocks.field_150362_t || block == Blocks.field_150434_aF) {
            this.thrusters();
            this.field_70180_af.func_187227_b(bump, (Object)Float.valueOf(3.0f));
            this.field_70159_w = this.field_70146_Z.nextFloat() * 0.8f;
            this.field_70181_x = this.field_70146_Z.nextFloat() * 0.8f;
            this.field_70179_y = this.field_70146_Z.nextFloat() * 0.8f;
        }
        return super.func_70097_a(damageSource, amt);
    }

    private void thrusters() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (Integer)this.field_70180_af.func_187225_a(lifespan) > 0 && MoreCreepsConfig.Miscellaneous.floobShipExplode) {
            this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0f, true);
        }
    }

    public boolean getLanded() {
        return (Boolean)this.field_70180_af.func_187225_a(landed);
    }

    private void setLanded(boolean b) {
        this.field_70180_af.func_187227_b(landed, (Object)b);
    }

    public boolean getFirstReset() {
        return (Boolean)this.field_70180_af.func_187225_a(firstReset);
    }

    private void setFirstReset(boolean b) {
        this.field_70180_af.func_187227_b(firstReset, (Object)b);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsFloobShip");
        props.func_74757_a("Landed", this.getLanded());
        props.func_74768_a("FloobCounter", ((Integer)this.field_70180_af.func_187225_a(floobCounter)).intValue());
        props.func_74757_a("FirstReset", this.getFirstReset());
        props.func_74768_a("Lifespan", ((Integer)this.field_70180_af.func_187225_a(lifespan)).intValue());
        compound.func_74782_a("MoreCreepsFloobShip", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsFloobShip");
        if (props.func_74764_b("Landed")) {
            this.setLanded(props.func_74767_n("Landed"));
        }
        if (props.func_74764_b("FloobCounter")) {
            this.field_70180_af.func_187227_b(floobCounter, (Object)props.func_74762_e("FloobCounter"));
        }
        if (props.func_74764_b("FirstReset")) {
            this.setFirstReset(props.func_74767_n("FirstReset"));
        }
        if (props.func_74764_b("Lifespan")) {
            this.field_70180_af.func_187227_b(lifespan, (Object)props.func_74762_e("Lifespan"));
        }
    }
}

