/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBaseOwnable;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.helpers.EffectHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHunchbackSkeleton
extends EntityCreepBaseOwnable
implements IRangedAttackMob,
IEntityCanChangeSize {
    private static final DataParameter<Integer> timeLeft = EntityDataManager.func_187226_a(EntityHunchbackSkeleton.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityHunchbackSkeleton.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityHunchbackSkeleton(World worldIn) {
        super(worldIn);
        this.creatureType = EnumCreatureType.MONSTER;
        this.func_70105_a(0.6f, 1.99f);
        this.baseHealth = (float)this.field_70146_Z.nextInt(10) + 10.0f;
        this.baseSpeed = 0.25;
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack((Item)Items.field_151031_f));
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 25, 75, 15.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(timeLeft, (Object)(this.field_70146_Z.nextInt(500) + 200));
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
    }

    @Override
    protected void updateTexture() {
        int iTimeLeft = this.getTimeLeft();
        int textureNum = 1;
        if (iTimeLeft < 500 && iTimeLeft > 300) {
            textureNum = 2;
        } else if (iTimeLeft < 300 && iTimeLeft > 200) {
            textureNum = 3;
        } else if (iTimeLeft < 200 && iTimeLeft > 100) {
            textureNum = 4;
        } else if (iTimeLeft < 100 && iTimeLeft > 1) {
            textureNum = 5;
        }
        this.setTexture("textures/entity/hunchbackskeleton" + textureNum + ".png");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        EntityLivingBase target = this.func_70638_az();
        EntityPlayer owner = this.getOwner();
        if (target != null && owner != null && (target.equals((Object)owner) || target instanceof EntityCreepBaseOwnable && owner.equals((Object)((EntityCreepBaseOwnable)target).getOwner()) || target instanceof EntityTameable && owner.equals((Object)((EntityTameable)target).func_70902_q()))) {
            this.func_70624_b(null);
        }
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.setTimeLeft(this.getTimeLeft() - 1);
        }
        this.updateTexture();
        if (this.getTimeLeft() < 1) {
            EffectHelper.smoke(this.field_70170_p, (Entity)this, this.field_70146_Z, false);
            this.func_70106_y();
        }
    }

    public int getTimeLeft() {
        return (Integer)this.field_70180_af.func_187225_a(timeLeft);
    }

    private void setTimeLeft(int i) {
        this.field_70180_af.func_187227_b(timeLeft, (Object)i);
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            if (this.field_70146_Z.nextInt(2) == 0) {
                this.func_145779_a(Items.field_151032_g, this.field_70146_Z.nextInt(3));
            }
            if (this.field_70146_Z.nextInt(2) == 0) {
                this.func_145779_a(Items.field_151103_aS, this.field_70146_Z.nextInt(2));
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187864_fh;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
        return entitytippedarrow;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getRayAmount() {
        return 0.2f;
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }
}

