/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBaseOwnable;
import com.morecreepsrevival.morecreeps.common.entity.EntityGuineaPig;
import com.morecreepsrevival.morecreeps.common.entity.EntityHotdog;
import com.morecreepsrevival.morecreeps.common.helpers.EffectHelper;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityTombstone
extends EntityCreepBaseOwnable {
    private NBTTagCompound additionalProps;
    private static final DataParameter<String> tombstoneType = EntityDataManager.func_187226_a(EntityTombstone.class, (DataSerializer)DataSerializers.field_187194_d);
    private TombstoneType type;

    public EntityTombstone(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.additionalProps = new NBTTagCompound();
    }

    public EntityTombstone(World worldIn, EntityCreepBaseOwnable deadEntity) {
        this(worldIn);
        this.creatureType = EnumCreatureType.AMBIENT;
        this.field_70728_aV = 0;
        this.func_70012_b(deadEntity.field_70165_t, deadEntity.field_70163_u, deadEntity.field_70161_v, deadEntity.field_70177_z, 0.0f);
        this.baseSpeed = 0.0;
        this.setBaseTexture(deadEntity.getBaseTexture());
        this.setLevel(deadEntity.getLevel());
        this.setExperience(deadEntity.getExperience());
        this.setTotalDamage(deadEntity.getTotalDamage());
        this.setArmor(deadEntity.getArmor());
        this.setInterest(deadEntity.getInterest());
        this.setOwner(deadEntity.func_184753_b());
        this.setWanderState(deadEntity.getWanderState());
        this.setHealthBoost(deadEntity.getHealthBoost());
        this.setSkillAttack(deadEntity.getSkillAttack());
        this.setSkillDefend(deadEntity.getSkillDefend());
        this.setSkillHealing(deadEntity.getSkillHealing());
        this.setSkillSpeed(deadEntity.getSkillSpeed());
        if (deadEntity.func_145818_k_()) {
            this.func_96094_a(deadEntity.func_95999_t());
        }
        this.setTombstoneType(TombstoneType.getTombstoneType(((Object)((Object)deadEntity)).getClass()));
        deadEntity.onTombstoneCreate(this.additionalProps);
        this.updateAttributes();
    }

    @Override
    public void func_184206_a(DataParameter<?> parameter) {
        super.func_184206_a(parameter);
        if (parameter.func_187155_a() == tombstoneType.func_187155_a()) {
            String tsType = (String)this.field_70180_af.func_187225_a(tombstoneType);
            this.setTombstoneType(tsType.isEmpty() ? null : TombstoneType.valueOf(tsType));
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(tombstoneType, (Object)(this.type == null ? "" : this.type.name()));
    }

    public boolean func_174833_aM() {
        return false;
    }

    public boolean func_94059_bO() {
        return false;
    }

    public String getDeadCreatureTypeName() {
        EntityEntry entry = this.type == null ? null : EntityRegistry.getEntry(this.type.getEntityClass());
        String s = entry == null || entry.getName() == null ? "generic" : entry.getName();
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            return CreepsSoundHandler.tombstoneSound;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Override
    public boolean func_70094_T() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        EntityCreepBaseOwnable entity;
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != CreepsItemHandler.lifeGem) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.tombstone.lifegem", new Object[0]));
            }
            return true;
        }
        if (!this.isPlayerOwner(player)) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.tombstone.notyour", new Object[0]));
            }
            return true;
        }
        itemStack.func_190918_g(1);
        player.func_184609_a(hand);
        EffectHelper.smoke(this.field_70170_p, (Entity)this, this.field_70146_Z, false);
        if (!this.field_70170_p.field_72995_K && this.type != null && (entity = this.type.getNewInstance().apply(this.func_130014_f_())) != null) {
            entity.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            entity.setBaseTexture(this.getBaseTexture());
            entity.setLevel(Math.max(1, this.getLevel() - 1));
            if (this.func_145818_k_()) {
                entity.func_96094_a(this.func_95999_t());
            }
            entity.setExperience(this.getExperience());
            entity.setTotalDamage(this.getTotalDamage());
            entity.setArmor(this.getArmor());
            entity.setInterest(this.getInterest());
            entity.setOwner(this.func_184753_b());
            entity.setWanderState(this.getWanderState());
            entity.setHealthBoost(this.getHealthBoost());
            entity.setSkillAttack(this.getSkillAttack());
            entity.setSkillDefend(this.getSkillDefend());
            entity.setSkillHealing(this.getSkillHealing());
            entity.setSkillSpeed(this.getSkillSpeed());
            entity.onRevive(this.additionalProps);
            entity.setInitialHealth();
            this.field_70170_p.func_72838_d((Entity)entity);
            this.func_70106_y();
        }
        return true;
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/tombstone.png");
    }

    @Override
    public void func_70636_d() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70636_d();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("MoreCreepsTombstone", (NBTBase)this.additionalProps);
        compound.func_74778_a("MoreCreepsTombstoneType", this.type.name());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.additionalProps = compound.func_74775_l("MoreCreepsTombstone");
        this.setTombstoneType(TombstoneType.valueOf(compound.func_74779_i("MoreCreepsTombstoneType")));
    }

    @Override
    public boolean func_70097_a(@Nullable DamageSource damageSource, float amt) {
        return false;
    }

    private void setTombstoneType(TombstoneType type) {
        if (type == null) {
            return;
        }
        this.type = type;
        this.field_70180_af.func_187227_b(tombstoneType, (Object)type.name());
    }

    private static enum TombstoneType {
        GUINEA_PIG(EntityGuineaPig.class, EntityGuineaPig::new),
        HOTDOG(EntityHotdog.class, EntityHotdog::new);

        private final Class<? extends Entity> entityClass;
        private final Function<World, EntityCreepBaseOwnable> newInstance;

        private TombstoneType(Class<? extends Entity> entityClass, Function<World, EntityCreepBaseOwnable> newInstance) {
            this.entityClass = entityClass;
            this.newInstance = newInstance;
        }

        public Class<? extends Entity> getEntityClass() {
            return this.entityClass;
        }

        public Function<World, EntityCreepBaseOwnable> getNewInstance() {
            return this.newInstance;
        }

        public static TombstoneType getTombstoneType(Class<? extends Entity> entityClass) {
            for (TombstoneType type : TombstoneType.values()) {
                if (type.getEntityClass() != entityClass) continue;
                return type;
            }
            return null;
        }
    }
}

