/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.world;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBaseOwnable;
import com.morecreepsrevival.morecreeps.common.entity.EntityLawyerFromHell;
import com.morecreepsrevival.morecreeps.common.entity.EntityMummy;
import com.morecreepsrevival.morecreeps.common.entity.EntityPrisoner;
import com.morecreepsrevival.morecreeps.common.entity.EntityRatMan;
import com.morecreepsrevival.morecreeps.common.helpers.CreepsUtil;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class JailManager {
    private static final int maxObstruct = 99999;
    static Template STRUCTURE = null;

    public static boolean tryCasheStructure(World world) {
        if (STRUCTURE != null) {
            return true;
        }
        ResourceLocation location = new ResourceLocation("morecreeps", "prison(with mobs)");
        MinecraftServer serv = world.func_73046_m();
        TemplateManager manager = ((WorldServer)world).func_184163_y();
        STRUCTURE = manager.func_189942_b(serv, location);
        return STRUCTURE != null;
    }

    public static boolean buildJail(EntityPlayer player, World world, Random rand) {
        boolean loaded = JailManager.tryCasheStructure(world);
        if (!loaded) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("worldgen.morecreeps.jail.fail2", new Object[0]));
            return false;
        }
        return JailManager.newBuildJail(player, world, rand);
    }

    private static boolean newBuildJail(EntityPlayer player, World world, Random rand) {
        int jailZ;
        int jailY;
        int jailX;
        BlockPos structuresize = STRUCTURE.func_186259_a();
        int randInt = rand.nextInt(200) - 100;
        if (rand.nextInt(2) == 0) {
            randInt *= -1;
        }
        if (!JailManager.isJailPossible(player, world, rand, jailX = (int)player.field_70165_t + randInt, jailY = rand.nextInt(20) + 25, jailZ = (int)player.field_70161_v + randInt)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("worldgen.morecreeps.jail.fail1", new Object[0]));
            return false;
        }
        BlockPos structurepos = new BlockPos(jailX - structuresize.func_177952_p() / 2, jailY - structuresize.func_177956_o() / 2, jailZ - structuresize.func_177952_p() / 2);
        PlacementSettings settings = new PlacementSettings().func_186226_b(false);
        IBlockState state = world.func_180495_p(structurepos);
        world.func_184138_a(structurepos, state, state, 3);
        STRUCTURE.func_186253_b(world, structurepos, settings);
        Vec3i playerpos = new Vec3i(structurepos.func_177958_n(), jailY, jailZ);
        for (int i = 0; i < 10; ++i) {
            JailManager.spawnLawyerGoul(world, playerpos.func_177958_n(), playerpos.func_177956_o(), playerpos.func_177952_p());
        }
        JailManager.fixPlayer(player, playerpos);
        return true;
    }

    private static boolean oldBuildJail(EntityPlayer player, World world, Random rand) {
        int i;
        ItemStack itemStack2;
        int i2;
        int q;
        int k;
        int i3;
        int q2;
        int k2;
        int i4;
        int jailZ;
        int jailY;
        int jailX;
        int randInt = rand.nextInt(200) - 100;
        if (rand.nextInt(2) == 0) {
            randInt *= -1;
        }
        if (!(world.func_175667_e(new BlockPos(jailX = (int)player.field_70165_t + randInt, jailY = rand.nextInt(20) + 25, (jailZ = (int)player.field_70161_v + randInt) - 31)) && world.func_175667_e(new BlockPos(jailX + 14, jailY, jailZ - 31)) && world.func_175667_e(new BlockPos(jailX, jailY, jailZ + 45)) && world.func_175667_e(new BlockPos(jailX + 14, jailY, jailZ + 45)))) {
            return false;
        }
        int area = 0;
        for (int i5 = -1; i5 < 6; ++i5) {
            for (int k3 = -1; k3 < 14; ++k3) {
                for (int q3 = -1; q3 < 14; ++q3) {
                    if (!world.func_175623_d(new BlockPos(jailX + k3, jailY + i5, jailZ + q3)) || ++area <= 99999) continue;
                    return false;
                }
            }
        }
        Block block = world.func_180495_p(new BlockPos(jailX + 16, jailY + 20, jailZ + 7)).func_177230_c();
        if ((block == Blocks.field_150358_i || block == Blocks.field_150355_j) && ++area > 99999) {
            return false;
        }
        for (i4 = -1; i4 < 6; ++i4) {
            for (k2 = -41; k2 < 55; ++k2) {
                for (q2 = -1; q2 < 16; ++q2) {
                    int a = rand.nextInt(100);
                    if (a < 1) {
                        world.func_175656_a(new BlockPos(jailX + q2, jailY + i4, jailZ + k2), Blocks.field_150351_n.func_176223_P());
                        continue;
                    }
                    if (a < 15) {
                        world.func_175656_a(new BlockPos(jailX + q2, jailY + i4, jailZ + k2), Blocks.field_150341_Y.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(new BlockPos(jailX + q2, jailY + i4, jailZ + k2), Blocks.field_150348_b.func_176223_P());
                }
            }
        }
        for (i4 = 0; i4 < 5; ++i4) {
            for (k2 = 0; k2 < 13; ++k2) {
                for (q2 = 0; q2 < 13; ++q2) {
                    world.func_175698_g(new BlockPos(jailX + q2, jailY + i4, jailZ + k2 + 1));
                }
            }
        }
        for (i4 = 0; i4 < 5; ++i4) {
            for (k2 = 3; k2 < 11; ++k2) {
                for (q2 = 3; q2 < 11; ++q2) {
                    world.func_175656_a(new BlockPos(jailX + q2, jailY + i4, jailZ + k2 + 1), Blocks.field_150348_b.func_176223_P());
                }
            }
        }
        for (i4 = 0; i4 < 5; ++i4) {
            for (k2 = 5; k2 < 9; ++k2) {
                for (q2 = 5; q2 < 9; ++q2) {
                    world.func_175698_g(new BlockPos(jailX + q2, jailY + i4, jailZ + k2 + 1));
                }
            }
        }
        world.func_175698_g(new BlockPos(jailX + 7, jailY + 1, jailZ + 4));
        world.func_175656_a(new BlockPos(jailX + 7, jailY + 1, jailZ + 5), Blocks.field_150411_aY.func_176223_P());
        world.func_175656_a(new BlockPos(jailX + 3, jailY + 1, jailZ + 7), Blocks.field_150359_w.func_176223_P());
        world.func_175656_a(new BlockPos(jailX + 4, jailY + 1, jailZ + 7), Blocks.field_150359_w.func_176223_P());
        world.func_175698_g(new BlockPos(jailX + 10, jailY + 1, jailZ + 7));
        world.func_175656_a(new BlockPos(jailX + 9, jailY + 1, jailZ + 7), Blocks.field_150411_aY.func_176223_P());
        world.func_175698_g(new BlockPos(jailX + 7, jailY + 1, jailZ + 11));
        world.func_175656_a(new BlockPos(jailX + 7, jailY + 1, jailZ + 10), Blocks.field_150411_aY.func_176223_P());
        world.func_175698_g(new BlockPos(jailX + 4, jailY, jailZ + 8));
        world.func_175698_g(new BlockPos(jailX + 3, jailY, jailZ + 8));
        world.func_175698_g(new BlockPos(jailX + 4, jailY + 1, jailZ + 8));
        world.func_175698_g(new BlockPos(jailX + 3, jailY + 1, jailZ + 8));
        world.func_175656_a(new BlockPos(jailX + 3, jailY, jailZ + 8), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
        world.func_175656_a(new BlockPos(jailX + 3, jailY + 1, jailZ + 8), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
        int offsetX = 15;
        int offsetZ = 7;
        int stairHeight = 80;
        while (world.func_175623_d(new BlockPos(jailX + offsetX, stairHeight, jailZ + offsetZ)) || world.func_180495_p(new BlockPos(jailX + offsetX, stairHeight, jailZ + offsetZ)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(new BlockPos(jailX + offsetX, stairHeight, jailZ + offsetZ)).func_177230_c() == Blocks.field_150362_t) {
            --stairHeight;
        }
        int maxI = stairHeight - jailY;
        for (int i6 = 0; i6 < maxI; ++i6) {
            for (int k4 = 0; k4 < 2; ++k4) {
                for (int q4 = 0; q4 < 2; ++q4) {
                    world.func_175698_g(new BlockPos(jailX + k4 + offsetX, jailY + i6, jailZ + offsetZ + q4));
                }
            }
        }
        int side = 0;
        for (i3 = 0; i3 < maxI; ++i3) {
            switch (side) {
                case 0: {
                    world.func_175656_a(new BlockPos(jailX + offsetX, jailY + i3, jailZ + offsetZ), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
                    break;
                }
                case 1: {
                    world.func_175656_a(new BlockPos(jailX + offsetX + 1, jailY + i3, jailZ + offsetZ), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
                    break;
                }
                case 2: {
                    world.func_175656_a(new BlockPos(jailX + offsetX + 1, jailY + i3, jailZ + offsetZ + 1), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
                    break;
                }
                case 3: {
                    world.func_175656_a(new BlockPos(jailX + offsetX, jailY + i3, jailZ + offsetZ + 1), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
                    break;
                }
            }
            if (side++ != 3) continue;
            side = 0;
        }
        for (i3 = 0; i3 < 3; ++i3) {
            world.func_175698_g(new BlockPos(jailX + 13 + i3, jailY, jailZ + 7));
            world.func_175698_g(new BlockPos(jailX + 13 + i3, jailY + 1, jailZ + 7));
        }
        world.func_175656_a(new BlockPos(jailX + 13, jailY, jailZ + offsetZ), Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
        world.func_175656_a(new BlockPos(jailX + 13, jailY + 1, jailZ + offsetZ), Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
        world.func_175656_a(new BlockPos(jailX + 15, jailY, jailZ + offsetZ), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        world.func_175698_g(new BlockPos(jailX + 14, jailY + 2, jailZ + offsetZ));
        for (i3 = 0; i3 < 32; ++i3) {
            for (k = 6; k < 9; ++k) {
                for (q = 0; q < 4; ++q) {
                    world.func_175698_g(new BlockPos(jailX + k, jailY + q, jailZ - i3 - 1));
                    world.func_175698_g(new BlockPos(jailX + k, jailY + q, jailZ + i3 + 15));
                }
            }
        }
        for (i3 = 1; i3 < 5; ++i3) {
            for (k = 0; k < 3; ++k) {
                for (q = 0; q < 3; ++q) {
                    for (int z = 0; z < 4; ++z) {
                        world.func_175698_g(new BlockPos(jailX + 10 + q, jailY + z, jailZ - i3 * 7 + k));
                        world.func_175698_g(new BlockPos(jailX + 2 + q, jailY + z, jailZ - i3 * 7 + k));
                        world.func_175698_g(new BlockPos(jailX + 10 + q, jailY + z, jailZ + i3 * 7 + 12 + k));
                        world.func_175698_g(new BlockPos(jailX + 2 + q, jailY + z, jailZ + i3 * 7 + 12 + k));
                    }
                }
            }
        }
        world.func_175698_g(new BlockPos(jailX + 7, jailY, jailZ));
        world.func_175698_g(new BlockPos(jailX + 7, jailY + 1, jailZ));
        world.func_175698_g(new BlockPos(jailX + 7, jailY, jailZ + 14));
        world.func_175698_g(new BlockPos(jailX + 7, jailY + 1, jailZ + 14));
        for (i3 = 0; i3 < 4; ++i3) {
            world.func_175656_a(new BlockPos(jailX + 5, jailY + 1, jailZ - i3 * 7 - 7), Blocks.field_150411_aY.func_176223_P());
            world.func_175656_a(new BlockPos(jailX + 5, jailY, jailZ - i3 * 7 - 5), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            world.func_175656_a(new BlockPos(jailX + 5, jailY + 1, jailZ - i3 * 7 - 5), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            world.func_175656_a(new BlockPos(jailX + 9, jailY + 1, jailZ - i3 * 7 - 7), Blocks.field_150411_aY.func_176223_P());
            world.func_175698_g(new BlockPos(jailX + 9, jailY, jailZ - i3 * 7 - 5));
            world.func_175698_g(new BlockPos(jailX + 9, jailY + 1, jailZ - i3 * 7 - 5));
            world.func_175656_a(new BlockPos(jailX + 9, jailY, jailZ - i3 * 7 - 5), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            world.func_175656_a(new BlockPos(jailX + 9, jailY + 1, jailZ - i3 * 7 - 5), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            world.func_175656_a(new BlockPos(jailX + 5, jailY + 1, jailZ + i3 * 7 + 21), Blocks.field_150411_aY.func_176223_P());
            world.func_175656_a(new BlockPos(jailX + 5, jailY, jailZ + i3 * 7 + 19), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            world.func_175656_a(new BlockPos(jailX + 5, jailY + 1, jailZ + i3 * 7 + 19), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            world.func_175656_a(new BlockPos(jailX + 9, jailY + 1, jailZ + i3 * 7 + 21), Blocks.field_150411_aY.func_176223_P());
            world.func_175698_g(new BlockPos(jailX + 9, jailY, jailZ + i3 * 7 + 19));
            world.func_175698_g(new BlockPos(jailX + 9, jailY + 1, jailZ + i3 * 7 + 19));
            world.func_175656_a(new BlockPos(jailX + 9, jailY, jailZ + i3 * 7 + 19), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            world.func_175656_a(new BlockPos(jailX + 9, jailY + 1, jailZ + i3 * 7 + 19), Blocks.field_180413_ao.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            if (rand.nextInt(1) == 0) {
                CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 12, jailY + 2, jailZ - i3 * 7 - 5));
            }
            if (rand.nextInt(1) == 0) {
                CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 2, jailY + 2, jailZ - i3 * 7 - 5));
            }
            if (rand.nextInt(1) == 0) {
                CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 12, jailY + 2, jailZ + i3 * 7 + 19));
            }
            if (rand.nextInt(1) != 0) continue;
            CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 2, jailY + 2, jailZ + i3 * 7 + 19));
        }
        for (i3 = 0; i3 < 9; ++i3) {
            if (rand.nextInt(2) == 0) {
                CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 6, jailY + 2, jailZ - i3 * 4 - 2));
            }
            if (rand.nextInt(2) == 0) {
                CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 8, jailY + 2, jailZ - i3 * 4 - 2));
            }
            if (rand.nextInt(2) == 0) {
                CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 6, jailY + 2, jailZ + i3 * 4 + 18));
            }
            if (rand.nextInt(2) != 0) continue;
            CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 8, jailY + 2, jailZ + i3 * 4 + 18));
        }
        BlockPos chest1Pos = new BlockPos(jailX + 12, jailY, jailZ + 12);
        BlockPos chest1Pos2 = new BlockPos(jailX + 12, jailY, jailZ + 13);
        world.func_175656_a(chest1Pos, Blocks.field_150486_ae.func_176223_P());
        world.func_175656_a(chest1Pos2, Blocks.field_150486_ae.func_176223_P());
        TileEntityChest chest1 = new TileEntityChest();
        world.func_175690_a(chest1Pos, (TileEntity)chest1);
        TileEntityChest chest12 = new TileEntityChest();
        world.func_175690_a(chest1Pos2, (TileEntity)chest12);
        BlockPos chest2Pos = new BlockPos(jailX + 12, jailY, jailZ + 1);
        world.func_175656_a(chest2Pos, Blocks.field_150486_ae.func_176223_P());
        TileEntityChest chest2 = new TileEntityChest();
        world.func_175690_a(chest2Pos, (TileEntity)chest2);
        BlockPos chest3Pos = new BlockPos(jailX, jailY, jailZ + 13);
        world.func_175656_a(chest3Pos, Blocks.field_150486_ae.func_176223_P());
        TileEntityChest chest3 = new TileEntityChest();
        world.func_175690_a(chest3Pos, (TileEntity)chest3);
        BlockPos chest4Pos = new BlockPos(jailX, jailY, jailZ + 1);
        world.func_175656_a(chest4Pos, Blocks.field_150486_ae.func_176223_P());
        TileEntityChest chest4 = new TileEntityChest();
        world.func_175690_a(chest4Pos, (TileEntity)chest4);
        int chestIndex = 0;
        int chest1Size = chest1.func_70302_i_();
        TileEntityChest chestToUse = chest1;
        for (i2 = 0; i2 < player.field_71071_by.field_70462_a.size(); ++i2) {
            itemStack2 = (ItemStack)player.field_71071_by.field_70462_a.get(i2);
            if (itemStack2.func_190926_b()) continue;
            if (chestToUse.equals(chest1) && chestIndex + 1 > chest1Size) {
                chestToUse = chest12;
                chestIndex = 0;
            }
            chestToUse.func_70299_a(chestIndex++, itemStack2.func_77946_l());
            itemStack2.func_190918_g(itemStack2.func_190916_E());
        }
        for (i2 = 0; i2 < player.field_71071_by.field_70460_b.size(); ++i2) {
            itemStack2 = (ItemStack)player.field_71071_by.field_70460_b.get(i2);
            if (itemStack2.func_190926_b()) continue;
            if (chestToUse.equals(chest1) && chestIndex + 1 > chest1Size) {
                chestToUse = chest12;
                chestIndex = 0;
            }
            chestToUse.func_70299_a(chestIndex++, itemStack2.func_77946_l());
            itemStack2.func_190918_g(itemStack2.func_190916_E());
        }
        for (i2 = 0; i2 < player.field_71071_by.field_184439_c.size(); ++i2) {
            itemStack2 = (ItemStack)player.field_71071_by.field_184439_c.get(i2);
            if (itemStack2.func_190926_b()) continue;
            if (chestToUse.equals(chest1) && chestIndex + 1 > chest1Size) {
                chestToUse = chest12;
                chestIndex = 0;
            }
            chestToUse.func_70299_a(chestIndex++, itemStack2.func_77946_l());
            itemStack2.func_190918_g(itemStack2.func_190916_E());
        }
        for (ItemStack itemStack2 : player.func_184209_aF()) {
            if (itemStack2.func_190926_b()) continue;
            if (chestToUse.equals(chest1) && chestIndex + 1 > chest1Size) {
                chestToUse = chest12;
                chestIndex = 0;
            }
            chestToUse.func_70299_a(chestIndex++, itemStack2.func_77946_l());
            itemStack2.func_190918_g(itemStack2.func_190916_E());
        }
        for (int i7 = 1; i7 < chest4.func_70302_i_(); ++i7) {
            int r = rand.nextInt(10);
            if (r == 1) {
                chest4.func_70299_a(i7, new ItemStack(CreepsItemHandler.bandaid, rand.nextInt(2) + 1));
                continue;
            }
            if (r != 2) continue;
            chest4.func_70299_a(i7, new ItemStack(CreepsItemHandler.money, rand.nextInt(24) + 1));
        }
        BlockPos mobSpawnerBlockPos = new BlockPos(jailX + 11, jailY, jailZ + 13);
        world.func_175656_a(mobSpawnerBlockPos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner mobSpawner = new TileEntityMobSpawner();
        world.func_175690_a(mobSpawnerBlockPos, (TileEntity)mobSpawner);
        mobSpawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntitySkeleton.class));
        chest2.func_70299_a(rand.nextInt(5), new ItemStack(Items.field_151050_s, 1));
        chest2.func_70299_a(rand.nextInt(5) + 5, new ItemStack(Items.field_151034_e, 1));
        chest3.func_70299_a(rand.nextInt(5) + 5, new ItemStack(Item.func_150898_a((Block)Blocks.field_150478_aa), rand.nextInt(16)));
        chest3.func_70299_a(rand.nextInt(5), new ItemStack(Items.field_151034_e, 1));
        CreepsUtil.TryPlaceTorch(world, new BlockPos(jailX + 6, jailY + 2, jailZ + 9));
        int petRoom = rand.nextInt(11);
        for (int i8 = 0; i8 < 4; ++i8) {
            for (int k5 = 0; k5 < 4; ++k5) {
                int placeZ;
                int placeX;
                switch (k5 + 1) {
                    case 2: {
                        placeX = jailX + 2;
                        placeZ = jailZ - i8 * 7 - 5;
                        break;
                    }
                    case 3: {
                        placeX = jailX + 12;
                        placeZ = jailZ + i8 * 7 + 19;
                        break;
                    }
                    case 4: {
                        placeX = jailX + 2;
                        placeZ = jailZ + i8 * 7 + 19;
                        break;
                    }
                    default: {
                        placeX = jailX + 12;
                        placeZ = jailZ - i8 * 7 - 5;
                    }
                }
                if (i8 * 4 + k5 == petRoom) {
                    JailManager.populateCell(player, world, rand, placeX, jailY, placeZ, true);
                } else {
                    JailManager.populateCell(player, world, rand, placeX, jailY, placeZ, false);
                }
                if (rand.nextInt(3) == 0) {
                    JailManager.dropTreasure(world, rand, jailX + 12, jailY + 2, jailZ - i8 * 7 - 6);
                }
                if (rand.nextInt(3) == 0) {
                    JailManager.dropTreasure(world, rand, jailX + 2, jailY + 2, jailZ - i8 * 7 - 6);
                }
                if (rand.nextInt(3) == 0) {
                    JailManager.dropTreasure(world, rand, jailX + 12, jailY + 2, jailZ + i8 * 7 + 20);
                }
                if (rand.nextInt(3) != 0) continue;
                JailManager.dropTreasure(world, rand, jailX + 2, jailY + 2, jailZ + i8 * 7 + 20);
            }
        }
        int lawyerCount = rand.nextInt(5) + 3;
        for (i = 1; i < lawyerCount; ++i) {
            EntityLawyerFromHell lawyer = new EntityLawyerFromHell(world);
            lawyer.func_70012_b(jailX + 8, jailY + 1, jailZ - 12, player.field_70177_z, 0.0f);
            lawyer.setUndead(true);
            lawyer.determineBaseTexture();
            lawyer.setInitialHealth();
            world.func_72838_d((Entity)lawyer);
            EntityLawyerFromHell lawyer2 = new EntityLawyerFromHell(world);
            lawyer2.func_70012_b(jailX + 8, jailY + 1, jailZ + 26, player.field_70177_z, 0.0f);
            lawyer2.setUndead(true);
            lawyer2.determineBaseTexture();
            lawyer2.setInitialHealth();
            world.func_72838_d((Entity)lawyer2);
        }
        lawyerCount = rand.nextInt(3) + 3;
        for (i = 2; i < lawyerCount; ++i) {
            EntityLawyerFromHell lawyer = new EntityLawyerFromHell(world);
            lawyer.func_70012_b(jailX + i, jailY + 2, jailZ + 2, player.field_70177_z, 0.0f);
            lawyer.setUndead(true);
            lawyer.determineBaseTexture();
            lawyer.setInitialHealth();
            world.func_72838_d((Entity)lawyer);
            EntityLawyerFromHell lawyer2 = new EntityLawyerFromHell(world);
            lawyer2.func_70012_b(jailX + 2, jailY + 2, jailZ + i, player.field_70177_z, 0.0f);
            lawyer2.setUndead(true);
            lawyer2.determineBaseTexture();
            lawyer2.setInitialHealth();
            world.func_72838_d((Entity)lawyer2);
        }
        player.func_70107_b((double)(jailX + 7), (double)(jailY + 2), (double)(jailZ + 7));
        player.func_70691_i(20.0f);
        player.func_184185_a(CreepsSoundHandler.lawyerBustedSound, 1.0f, 1.0f);
        if (rand.nextInt(5) == 0) {
            JailManager.dropTreasure(world, rand, jailX + 8, jailY + 2, jailZ + 8);
        }
        return true;
    }

    private static void dropTreasure(World world, Random rand, int x, int y, int z) {
        ItemStack itemStack;
        int treasureIndex = rand.nextInt(12);
        switch (treasureIndex) {
            case 1: {
                itemStack = new ItemStack(Items.field_151015_O, rand.nextInt(2) + 1);
                break;
            }
            case 2: {
                itemStack = new ItemStack(Items.field_151106_aX, rand.nextInt(3) + 3);
                break;
            }
            case 3: {
                itemStack = new ItemStack(Items.field_151121_aF, 1);
                break;
            }
            case 4: {
                itemStack = new ItemStack(CreepsItemHandler.blorpCola, rand.nextInt(3) + 1);
                break;
            }
            case 5: {
                itemStack = new ItemStack(Items.field_151025_P, 1);
                break;
            }
            case 6: {
                itemStack = new ItemStack(CreepsItemHandler.evilEgg, rand.nextInt(2) + 1);
                break;
            }
            case 7: {
                itemStack = new ItemStack(Items.field_151131_as, 1);
                break;
            }
            case 8: 
            case 11: {
                itemStack = new ItemStack(Items.field_151105_aU, 1);
                break;
            }
            case 9: {
                itemStack = new ItemStack(CreepsItemHandler.money, rand.nextInt(5) + 5);
                break;
            }
            case 10: {
                itemStack = new ItemStack(CreepsItemHandler.lolly, rand.nextInt(2) + 1);
                break;
            }
            case 12: {
                itemStack = new ItemStack(CreepsItemHandler.gooDonut, rand.nextInt(2) + 1);
                break;
            }
            default: {
                itemStack = new ItemStack(Items.field_151106_aX, rand.nextInt(2) + 1);
            }
        }
        EntityItem entityItem = new EntityItem(world, (double)x, (double)y, (double)z, itemStack);
        entityItem.func_174867_a(10);
        world.func_72838_d((Entity)entityItem);
    }

    private static void populateCell(EntityPlayer player, World world, Random rand, int placeX, int placeY, int placeZ, boolean flag) {
        if (flag) {
            for (Entity entity : world.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(26.0, 26.0, 26.0))) {
                EntityCreepBaseOwnable creep;
                if (!(entity instanceof EntityCreepBaseOwnable) || !(creep = (EntityCreepBaseOwnable)entity).isTamed()) continue;
                creep.setWanderState(1);
                if (creep.getModelSize() > 1.0f) {
                    creep.resetModelSize();
                }
                creep.func_70012_b(placeX, placeY, placeZ, player.field_70177_z, 0.0f);
            }
            return;
        }
        switch (rand.nextInt(5) + 1) {
            case 1: {
                EntityRatMan ratMan = new EntityRatMan(world);
                ratMan.func_70012_b((float)placeX + 1.0f, placeY, (float)placeZ + 1.0f, player.field_70177_z, 0.0f);
                ratMan.setInitialHealth();
                ratMan.determineBaseTexture();
                world.func_72838_d((Entity)ratMan);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                EntityMummy mummy = new EntityMummy(world);
                mummy.func_70012_b(placeX, placeY, placeZ, player.field_70177_z, 0.0f);
                mummy.setInitialHealth();
                mummy.determineBaseTexture();
                world.func_72838_d((Entity)mummy);
                break;
            }
            default: {
                EntityPrisoner prisoner = new EntityPrisoner(world);
                prisoner.func_70012_b((float)placeX + 1.0f, placeY, (float)placeZ + 1.0f, player.field_70177_z, 0.0f);
                prisoner.setInitialHealth();
                prisoner.determineBaseTexture();
                world.func_72838_d((Entity)prisoner);
            }
        }
    }

    public static boolean isJailPossible(EntityPlayer player, World world, Random rand, int jailX, int jailY, int jailZ) {
        if (!(world.func_175667_e(new BlockPos(jailX, jailY, jailZ - 31)) && world.func_175667_e(new BlockPos(jailX + 14, jailY, jailZ - 31)) && world.func_175667_e(new BlockPos(jailX, jailY, jailZ + 45)) && world.func_175667_e(new BlockPos(jailX + 14, jailY, jailZ + 45)))) {
            return false;
        }
        int area = 0;
        for (int i = -1; i < 6; ++i) {
            for (int k = -1; k < 14; ++k) {
                for (int q = -1; q < 14; ++q) {
                    if (!world.func_175623_d(new BlockPos(jailX + k, jailY + i, jailZ + q)) || ++area <= 99999) continue;
                    return false;
                }
            }
        }
        Block block = world.func_180495_p(new BlockPos(jailX + 16, jailY + 20, jailZ + 7)).func_177230_c();
        return block != Blocks.field_150358_i && block != Blocks.field_150355_j || ++area <= 99999;
    }

    private static void fixPlayer(EntityPlayer player, Vec3i structurepos) {
        player.func_70634_a((double)(structurepos.func_177958_n() + 7), (double)(structurepos.func_177956_o() - 2), (double)(structurepos.func_177952_p() + 2));
        player.func_70691_i(20.0f);
        player.func_184185_a(CreepsSoundHandler.lawyerBustedSound, 1.0f, 1.0f);
    }

    private static void spawnLawyerGoul(World world, double strux, double struy, double struz) {
        EntityLawyerFromHell lawyer = new EntityLawyerFromHell(world);
        lawyer.func_70107_b(strux + 7.0, struy - 2.0, struz + 6.0);
        world.func_72838_d((Entity)lawyer);
        lawyer.setUndead(true);
        lawyer.setInitialHealth();
    }
}

