/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.world;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessagePlayBattleCastleSound;
import com.morecreepsrevival.morecreeps.common.networking.message.MessagePlayPyramidDiscoveredSound;
import com.morecreepsrevival.morecreeps.common.world.WorldGenCastle;
import com.morecreepsrevival.morecreeps.common.world.WorldGenPyramid;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WorldGenStructures
implements IWorldGenerator {
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateStructures(world, rand, chunkX, chunkZ);
    }

    private void generateStructures(World world, Random rand, int chunkX, int chunkZ) {
        BlockPos pos;
        float pyramidChance;
        if (MoreCreepsConfig.WorldGen.pyramidGen && (pyramidChance = Math.max(0.0f, MoreCreepsConfig.WorldGen.pyramidRarityChance / 100.0f)) > 0.0f && rand.nextFloat() < pyramidChance && new WorldGenPyramid().func_180709_b(world, rand, pos = new BlockPos((chunkX << 4) + rand.nextInt(16), 65, (chunkZ << 4) + rand.nextInt(16)))) {
            for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72314_b(256.0, 256.0, 256.0))) {
                CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayPyramidDiscoveredSound(), (EntityPlayerMP)player);
            }
        }
        if (MoreCreepsConfig.WorldGen.castleGen) {
            float castleChance = Math.max(0.0f, MoreCreepsConfig.WorldGen.castleRarityChance / 100.0f);
            if (rand.nextFloat() < castleChance && new WorldGenCastle().func_180709_b(world, rand, pos = new BlockPos((chunkX << 4) + rand.nextInt(16), rand.nextInt(40) + 80, (chunkZ << 4) + rand.nextInt(16)))) {
                for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72314_b(256.0, 256.0, 256.0))) {
                    CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayBattleCastleSound(), (EntityPlayerMP)player);
                }
            }
        }
    }
}

