/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.config;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class MoreCreepsConfig {
    private static Configuration config;
    private static final String miscProperty = "Misc Property";
    private static final String spawnNbr = "Spawn Number";
    private static final String mobProperty = "Mob Property";
    private static final String itemProperty = "Item Property";
    private static final String worldGen = "World Gen";
    private static final String worldGenRarity = "World Gen Rarity";
    public static boolean pyramidGen;
    public static int pyramidRarity;
    public static boolean castleGen;
    public static int castleRarity;
    public static boolean rayGunFire;
    public static boolean rayGunMelt;
    public static boolean floobTargetVillagers;
    public static boolean floobShipExplode;
    public static boolean publicUrination;
    public static boolean jailActive;
    public static boolean blood;
    private static boolean unlimitedSpawn;
    public static int blorpMaxSize;
    public static int guineaPigSpawnAmt;
    public static int babyMummySpawnAmt;
    public static int blackSoulSpawnAmt;
    public static int mummySpawnAmt;
    public static int armyGuySpawnAmt;
    public static int hotdogSpawnAmt;
    public static int gooGoatSpawnAmt;
    public static int kidSpawnAmt;
    public static int lollimanSpawnAmt;
    public static int gSpawnAmt;
    public static int robotTedSpawnAmt;
    public static int robotToddSpawnAmt;
    public static int lawyerFromHellSpawnAmt;
    public static boolean playWelcomeSound;
    public static int bigBabySpawnAmt;
    public static int thiefSpawnAmt;
    public static int floobSpawnAmt;
    public static int floobShipSpawnAmt;
    public static boolean sendWelcomeMessage;
    public static boolean sendVersionInfo;
    public static boolean sendDiscordLink;
    public static int horseHeadSpawnAmt;
    public static int digBugSpawnAmt;
    public static int bubbleScumSpawnAmt;
    public static int sneakySalSpawnAmt;
    public static int snowDevilSpawnAmt;
    public static boolean classicMode;
    public static int blorpSpawnAmt;
    public static int camelSpawnAmt;
    public static int camelJockeySpawnAmt;
    public static int bumSpawnAmt;
    public static int cavemanSpawnAmt;
    public static int desertLizardSpawnAmt;
    public static int evilScientistSpawnAmt;
    public static int hippoSpawnAmt;
    public static int hunchbackSpawnAmt;
    public static int invisibleManSpawnAmt;
    public static int mandogSpawnAmt;
    public static int nonSwimmerSpawnAmt;
    public static int preacherSpawnAmt;
    public static int rockMonsterSpawnAmt;
    public static int rocketGiraffeSpawnAmt;
    public static int zebraSpawnAmt;
    public static int growbotGreggSpawnAmt;
    public static int ponyGirlSpawnAmt;
    public static int vhsSpawnAmt;
    public static int moneyManSSpawnAmt;
    public static String hideUpdateGuiVersion;
    public static double globalSpawnRate;
    public static boolean spawnInNonVanillaBiomes;
    public static int[] dimensionGenWl;
    public static String[] nonVanillaBiomes;

    public static void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            playWelcomeSound = config.get(miscProperty, "Play Welcome Sound", true, "Toggles the playing of the welcome sound when you load the world.").getBoolean();
            sendVersionInfo = config.get(miscProperty, "Send Version Info", true, "Sends the current version of MoreCreeps in the chat when a player joins.").getBoolean();
            sendWelcomeMessage = config.get(miscProperty, "Send Welcome Message", true, "Sends a welcome message in the chat to each player joining.").getBoolean();
            sendDiscordLink = config.get(miscProperty, "Send Discord Link", true, "Sends a link to the official MoreCreeps Discord when a player joins.").getBoolean();
            classicMode = config.get(miscProperty, "Classic Mode", true, "Keep this on if you want to play the mod the way Freakstritch intended it. Turning this off will add additional content the original mod didn't have.").getBoolean();
            unlimitedSpawn = config.get("Spawn", "Unlimited Spawn Length", false, "Once activated, you can set what value you want for mob spawning.").getBoolean();
            globalSpawnRate = config.get("Spawn", "Global Spawn Rate", 1.0, "This setting controls the overall spawn rate. The spawn rate of every mob is multiplied by this number. So 1.0 is the default rate, 2.0 is 2x the rate, 0.5 is half the rate, etc.").getDouble();
            spawnInNonVanillaBiomes = config.get("Spawn", "Spawn In Non-Vanilla Biomes", false, "Setting this to true will cause More Creeps mobs to spawn in biomes added by other mods.").getBoolean();
            nonVanillaBiomes = config.get("Spawn", "Non-Vanilla Biomes", new String[0], "This a list of Non-Vanilla biomes that More Creeps mobs should spawn in.").getStringList();
            dimensionGenWl = config.get(worldGen, "Dimensionswl", new int[0], "This a list of dimensions that mocreeps generation will occur in").getIntList();
            pyramidGen = config.get(worldGen, "Enable Pyramid Gen", true).getBoolean();
            pyramidRarity = config.get(worldGenRarity, "Pyramid Rarity", 500, "By default : 500").getInt();
            castleGen = config.get(worldGen, "Enable Castle", true).getBoolean();
            castleRarity = config.get(worldGenRarity, "Castle Rarity", 500, "By default : 500").getInt();
            rayGunFire = config.get(itemProperty, "Enable Raygun Fire", true).getBoolean();
            rayGunMelt = config.get(itemProperty, "Enable Raygun Melt", true).getBoolean();
            floobShipExplode = config.get(mobProperty, "Allow Floobship Explosion", false).getBoolean();
            floobTargetVillagers = config.get(mobProperty, "Allow Floobs to Target Villagers", true).getBoolean();
            publicUrination = config.get(mobProperty, "Allow Bum Public Urination", true).getBoolean();
            jailActive = config.get(worldGen, "Enable Jail", true).getBoolean();
            blood = config.get(mobProperty, "Enable Blood", true).getBoolean();
            blorpMaxSize = config.get(mobProperty, "Blorp Max Size", 6).getInt();
            guineaPigSpawnAmt = config.get(spawnNbr, "Guinea Pig", 5).getInt();
            babyMummySpawnAmt = config.get(spawnNbr, "Baby Mummy", 1).getInt();
            blackSoulSpawnAmt = config.get(spawnNbr, "Black Soul", 1).getInt();
            mummySpawnAmt = config.get(spawnNbr, "Mummy", 1).getInt();
            armyGuySpawnAmt = config.get(spawnNbr, "Army Guy", 1).getInt();
            hotdogSpawnAmt = config.get(spawnNbr, "Hot Dog", 5).getInt();
            gooGoatSpawnAmt = config.get(spawnNbr, "Goo Goat", 3).getInt();
            kidSpawnAmt = config.get(spawnNbr, "Kid", 1).getInt();
            lollimanSpawnAmt = config.get(spawnNbr, "Lolliman", 1).getInt();
            gSpawnAmt = config.get(spawnNbr, "G", 3).getInt();
            robotTedSpawnAmt = config.get(spawnNbr, "Robot Ted", 1).getInt();
            robotToddSpawnAmt = config.get(spawnNbr, "Robot Todd", 1).getInt();
            lawyerFromHellSpawnAmt = config.get(spawnNbr, "Lawyer From Hell", 3).getInt();
            bigBabySpawnAmt = config.get(spawnNbr, "Big Baby", 5).getInt();
            thiefSpawnAmt = config.get(spawnNbr, "Thief", 3).getInt();
            floobSpawnAmt = config.get(spawnNbr, "Floob", 3).getInt();
            floobShipSpawnAmt = config.get(spawnNbr, "Floob Ship", 1).getInt();
            horseHeadSpawnAmt = config.get(spawnNbr, "Horse Head", 1).getInt();
            digBugSpawnAmt = config.get(spawnNbr, "Dig Bug", 3).getInt();
            bubbleScumSpawnAmt = config.get(spawnNbr, "Bubble Scum", 3).getInt();
            sneakySalSpawnAmt = config.get(spawnNbr, "Sneaky Sal", 5).getInt();
            snowDevilSpawnAmt = config.get(spawnNbr, "Snow Devil", 1).getInt();
            blorpSpawnAmt = config.get(spawnNbr, "Blorp", 4).getInt();
            camelSpawnAmt = config.get(spawnNbr, "Camel", 1).getInt();
            camelJockeySpawnAmt = config.get(spawnNbr, "Camel Jockey", 1).getInt();
            bumSpawnAmt = config.get(spawnNbr, "Bum", 1).getInt();
            cavemanSpawnAmt = config.get(spawnNbr, "Caveman", 1).getInt();
            desertLizardSpawnAmt = config.get(spawnNbr, "Desert Lizard", 4).getInt();
            evilScientistSpawnAmt = config.get(spawnNbr, "Evil Scientist", 3).getInt();
            hippoSpawnAmt = config.get(spawnNbr, "Hippo", 3).getInt();
            hunchbackSpawnAmt = config.get(spawnNbr, "Hunchback", 1).getInt();
            invisibleManSpawnAmt = config.get(spawnNbr, "Invisible Man", 1).getInt();
            mandogSpawnAmt = config.get(spawnNbr, "Mandog", 1).getInt();
            nonSwimmerSpawnAmt = config.get(spawnNbr, "Non Swimmer", 1).getInt();
            preacherSpawnAmt = config.get(spawnNbr, "Preacher", 1).getInt();
            rockMonsterSpawnAmt = config.get(spawnNbr, "Rock Monster", 1).getInt();
            rocketGiraffeSpawnAmt = config.get(spawnNbr, "Rocket Giraffe", 1).getInt();
            zebraSpawnAmt = config.get(spawnNbr, "Zebra", 1).getInt();
            growbotGreggSpawnAmt = config.get(spawnNbr, "Growbot Gregg", 1).getInt();
            ponyGirlSpawnAmt = config.get(spawnNbr, "Pony Girl", 1).getInt();
            moneyManSSpawnAmt = config.get(spawnNbr, "Money Man S", 1).getInt();
            vhsSpawnAmt = config.get(spawnNbr, "Walking VHS", 1).getInt();
            hideUpdateGuiVersion = config.get(miscProperty, "Hide Update for Version", "", "This property is set when you choose to ignore the Update Available popup with the version you're being offered.").getString();
            config.save();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
        MoreCreepsConfig.applySpawnLimit();
    }

    private static void applySpawnLimit() {
        if (unlimitedSpawn) {
            return;
        }
        if (moneyManSSpawnAmt < 0 || moneyManSSpawnAmt > 12) {
            moneyManSSpawnAmt = 1;
        }
        if (vhsSpawnAmt < 0 || vhsSpawnAmt > 12) {
            vhsSpawnAmt = 1;
        }
        if (armyGuySpawnAmt < 0 || armyGuySpawnAmt > 12) {
            armyGuySpawnAmt = 1;
        }
        if (babyMummySpawnAmt < 0 || babyMummySpawnAmt > 12) {
            babyMummySpawnAmt = 1;
        }
        if (bigBabySpawnAmt < 0 || bigBabySpawnAmt > 12) {
            bigBabySpawnAmt = 5;
        }
        if (blorpSpawnAmt < 0 || blorpSpawnAmt > 12) {
            blorpSpawnAmt = 3;
        }
        if (bubbleScumSpawnAmt < 0 || bubbleScumSpawnAmt > 12) {
            bubbleScumSpawnAmt = 3;
        }
        if (bumSpawnAmt < 0 || bumSpawnAmt > 12) {
            bumSpawnAmt = 1;
        }
        if (camelSpawnAmt < 0 || camelSpawnAmt > 12) {
            camelSpawnAmt = 1;
        }
        if (camelJockeySpawnAmt < 0 || camelJockeySpawnAmt > 12) {
            camelJockeySpawnAmt = 1;
        }
        if (cavemanSpawnAmt < 0 || cavemanSpawnAmt > 12) {
            cavemanSpawnAmt = 1;
        }
        if (desertLizardSpawnAmt < 0 || desertLizardSpawnAmt > 12) {
            desertLizardSpawnAmt = 4;
        }
        if (digBugSpawnAmt < 0 || digBugSpawnAmt > 12) {
            digBugSpawnAmt = 3;
        }
        if (evilScientistSpawnAmt < 0 || evilScientistSpawnAmt > 12) {
            evilScientistSpawnAmt = 3;
        }
        if (floobSpawnAmt < 0 || floobShipSpawnAmt > 12) {
            floobSpawnAmt = 3;
        }
        if (floobShipSpawnAmt < 0 || floobShipSpawnAmt > 12) {
            floobShipSpawnAmt = 1;
        }
        if (gSpawnAmt < 0 || gSpawnAmt > 12) {
            gSpawnAmt = 3;
        }
        if (gooGoatSpawnAmt < 0 || gooGoatSpawnAmt > 12) {
            gooGoatSpawnAmt = 3;
        }
        if (guineaPigSpawnAmt < 0 || guineaPigSpawnAmt > 12) {
            guineaPigSpawnAmt = 5;
        }
        if (hippoSpawnAmt < 0 || hippoSpawnAmt > 12) {
            hippoSpawnAmt = 3;
        }
        if (horseHeadSpawnAmt < 0 || horseHeadSpawnAmt > 12) {
            horseHeadSpawnAmt = 1;
        }
        if (hunchbackSpawnAmt < 0 || hunchbackSpawnAmt > 12) {
            hunchbackSpawnAmt = 1;
        }
        if (invisibleManSpawnAmt < 0 || invisibleManSpawnAmt > 12) {
            invisibleManSpawnAmt = 1;
        }
        if (kidSpawnAmt < 0 || kidSpawnAmt > 12) {
            kidSpawnAmt = 1;
        }
        if (lawyerFromHellSpawnAmt < 0 || lawyerFromHellSpawnAmt > 12) {
            lawyerFromHellSpawnAmt = 3;
        }
        if (lollimanSpawnAmt < 0 || lollimanSpawnAmt > 12) {
            lollimanSpawnAmt = 1;
        }
        if (mandogSpawnAmt < 0 || mandogSpawnAmt > 12) {
            mandogSpawnAmt = 1;
        }
        if (mummySpawnAmt < 0 || mummySpawnAmt > 12) {
            mummySpawnAmt = 1;
        }
        if (nonSwimmerSpawnAmt < 0 || nonSwimmerSpawnAmt > 12) {
            nonSwimmerSpawnAmt = 1;
        }
        if (sneakySalSpawnAmt < 0 || sneakySalSpawnAmt > 12) {
            sneakySalSpawnAmt = 1;
        }
        if (preacherSpawnAmt < 0 || preacherSpawnAmt > 12) {
            preacherSpawnAmt = 1;
        }
        if (robotTedSpawnAmt < 0 || robotTedSpawnAmt > 12) {
            robotTedSpawnAmt = 1;
        }
        if (robotToddSpawnAmt < 0 || robotToddSpawnAmt > 12) {
            robotToddSpawnAmt = 1;
        }
        if (rockMonsterSpawnAmt < 0 || rockMonsterSpawnAmt > 5) {
            rockMonsterSpawnAmt = 1;
        }
        if (rocketGiraffeSpawnAmt < 0 || rocketGiraffeSpawnAmt > 12) {
            rocketGiraffeSpawnAmt = 1;
        }
        if (snowDevilSpawnAmt < 0 || snowDevilSpawnAmt > 12) {
            snowDevilSpawnAmt = 1;
        }
        if (thiefSpawnAmt < 0 || thiefSpawnAmt > 12) {
            thiefSpawnAmt = 3;
        }
        if (zebraSpawnAmt < 0 || zebraSpawnAmt > 12) {
            zebraSpawnAmt = 1;
        }
        if (growbotGreggSpawnAmt < 0 || growbotGreggSpawnAmt > 12) {
            growbotGreggSpawnAmt = 1;
        }
        if (ponyGirlSpawnAmt < 0 || ponyGirlSpawnAmt > 10) {
            ponyGirlSpawnAmt = 1;
        }
        if (pyramidRarity < 1 || pyramidRarity > 10) {
            pyramidRarity = 5;
        }
        if (castleRarity < 1 || castleRarity > 10) {
            castleRarity = 5;
        }
        if (blorpMaxSize < 6 || blorpMaxSize > 99) {
            blorpMaxSize = 6;
        }
    }

    public static boolean shouldShowUpdateGuiForVersion(String version) {
        return !hideUpdateGuiVersion.equals(version);
    }

    public static void hideUpdateGuiForVersion(String version) {
        try {
            config.get(miscProperty, "Hide Update for Version", "").set(version);
            config.save();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static int calculateSpawnRate(int baseRate) {
        return (int)Math.floor((double)baseRate * globalSpawnRate);
    }

    public static boolean hasBiome(String biome) {
        for (String str : nonVanillaBiomes) {
            if (!str.equals(biome)) continue;
            return true;
        }
        return false;
    }

    static {
        pyramidGen = false;
        pyramidRarity = 0;
        castleGen = false;
        castleRarity = 0;
        rayGunFire = false;
        rayGunMelt = false;
        floobTargetVillagers = true;
        floobShipExplode = false;
        publicUrination = true;
        jailActive = true;
        blood = true;
        unlimitedSpawn = false;
        blorpMaxSize = 0;
        guineaPigSpawnAmt = 0;
        babyMummySpawnAmt = 0;
        blackSoulSpawnAmt = 0;
        mummySpawnAmt = 0;
        armyGuySpawnAmt = 0;
        hotdogSpawnAmt = 0;
        gooGoatSpawnAmt = 0;
        kidSpawnAmt = 0;
        lollimanSpawnAmt = 0;
        gSpawnAmt = 0;
        robotTedSpawnAmt = 0;
        robotToddSpawnAmt = 0;
        lawyerFromHellSpawnAmt = 0;
        playWelcomeSound = true;
        bigBabySpawnAmt = 0;
        thiefSpawnAmt = 0;
        floobSpawnAmt = 0;
        floobShipSpawnAmt = 0;
        sendWelcomeMessage = true;
        sendVersionInfo = true;
        sendDiscordLink = true;
        horseHeadSpawnAmt = 0;
        digBugSpawnAmt = 0;
        bubbleScumSpawnAmt = 0;
        sneakySalSpawnAmt = 0;
        snowDevilSpawnAmt = 0;
        classicMode = true;
        blorpSpawnAmt = 0;
        camelSpawnAmt = 0;
        camelJockeySpawnAmt = 0;
        bumSpawnAmt = 0;
        cavemanSpawnAmt = 0;
        desertLizardSpawnAmt = 0;
        evilScientistSpawnAmt = 0;
        hippoSpawnAmt = 0;
        hunchbackSpawnAmt = 0;
        invisibleManSpawnAmt = 0;
        mandogSpawnAmt = 0;
        nonSwimmerSpawnAmt = 0;
        preacherSpawnAmt = 0;
        rockMonsterSpawnAmt = 0;
        rocketGiraffeSpawnAmt = 0;
        zebraSpawnAmt = 0;
        growbotGreggSpawnAmt = 0;
        ponyGirlSpawnAmt = 0;
        vhsSpawnAmt = 0;
        moneyManSSpawnAmt = 0;
        hideUpdateGuiVersion = "";
        globalSpawnRate = 1.0;
        spawnInNonVanillaBiomes = false;
        dimensionGenWl = new int[0];
        nonVanillaBiomes = new String[0];
    }
}

