/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIAttackMelee;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntityBigBaby
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private static final DataParameter<Integer> skin = EntityDataManager.func_187226_a(EntityBigBaby.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skinTimer = EntityDataManager.func_187226_a(EntityBigBaby.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> skinDirection = EntityDataManager.func_187226_a(EntityBigBaby.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityBigBaby(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Big Baby");
        this.creatureType = EnumCreatureType.MONSTER;
        this.func_70105_a(6.5f, 6.5f);
        this.setModelSize(6.0f);
        this.baseHealth = (float)this.field_70146_Z.nextInt(40) + 40.0f;
        this.baseSpeed = 0.25;
        this.baseAttackDamage = 1.0;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(skin, (Object)0);
        this.field_70180_af.func_187214_a(skinTimer, (Object)0);
        this.field_70180_af.func_187214_a(skinDirection, (Object)true);
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityCreepAIAttackMelee(this, 1.0, 4.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/bigbaby" + this.field_70180_af.func_187225_a(skin) + ".png");
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void dropItemsOnDeath() {
        this.func_145779_a(Items.field_151147_al, this.field_70146_Z.nextInt(6) + 5);
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.bigBabySound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.bigBabyHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.bigBabyHurtSound;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.15f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getHammerSwing() < 0.0f) {
            this.addHammerSwing(0.1000055f);
        } else {
            this.setHammerSwing(0.0f);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70180_af.func_187227_b(skinTimer, (Object)((Integer)this.field_70180_af.func_187225_a(skinTimer) + 1));
        if ((Integer)this.field_70180_af.func_187225_a(skinTimer) > 60) {
            this.field_70180_af.func_187227_b(skinTimer, (Object)0);
            int iSkin = (Integer)this.field_70180_af.func_187225_a(skin);
            iSkin += this.getSkinDirection() ? 1 : -1;
            if (this.func_70638_az() != null) {
                iSkin = 0;
            }
            if (iSkin < 0 || iSkin > 4) {
                iSkin = 0;
            }
            if (iSkin == 0 || iSkin == 4) {
                this.setSkinDirection(!this.getSkinDirection());
            }
            this.field_70180_af.func_187227_b(skin, (Object)iSkin);
            this.updateTexture();
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_77973_b() == CreepsItemHandler.babyJarEmpty) {
            if (this.getModelSize() < 1.0f) {
                this.func_70106_y();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(CreepsItemHandler.babyJarFull));
                this.func_184185_a(CreepsSoundHandler.babyTakeHomeSound, 1.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Now turn that baby into a Schlump on the floor!"));
                }
            } else {
                this.func_184185_a(CreepsSoundHandler.babyShrinkSound, 1.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString("That baby is too large."));
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean func_70652_k(@Nonnull Entity entity) {
        if (this.getHammerSwing() == 0.0f) {
            this.setHammerSwing(-1.1f);
        }
        return super.func_70652_k(entity);
    }

    private void setSkinDirection(boolean b) {
        this.field_70180_af.func_187227_b(skinDirection, (Object)b);
    }

    private boolean getSkinDirection() {
        return (Boolean)this.field_70180_af.func_187225_a(skinDirection);
    }

    @Override
    public float maxShrink() {
        return 0.25f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.25f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 8.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.25f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

