/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBubbleScum
extends EntityCreepBase
implements IEntityCanChangeSize {
    public EntityBubbleScum(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Bubble Scum");
        this.func_70105_a(0.5f, 0.5f);
        this.baseSpeed = 0.3;
        this.baseHealth = (float)this.field_70146_Z.nextInt(15) + 5.0f;
        this.updateAttributes();
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        if (!this.func_184218_aH()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        }
    }

    @Override
    public boolean canMount(Entity entity) {
        if (this.func_70638_az() instanceof EntityPlayer) {
            return false;
        }
        return super.canMount(entity);
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(25) == 0) {
            this.func_145779_a(Items.field_151106_aX, 1);
        }
    }

    protected SoundEvent func_184639_G() {
        if (!this.func_184218_aH() && this.field_70146_Z.nextInt(1) == 0) {
            return CreepsSoundHandler.bubbleScumSound;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.bubbleScumHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.bubbleScumDeathSound;
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/bubblescum.png");
    }

    @Override
    protected SoundEvent getMountSound() {
        return CreepsSoundHandler.bubbleScumPickupSound;
    }

    @Override
    protected SoundEvent getUnmountSound() {
        return CreepsSoundHandler.bubbleScumPutDownSound;
    }

    @Override
    protected void onDismount(Entity entity) {
        double d = -MathHelper.func_76126_a((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
        double d1 = MathHelper.func_76134_b((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
        double d2 = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70159_w = 1.0 * d;
        this.field_70179_y = 1.0 * d1;
        this.field_70181_x = 1.0 * d2;
    }

    @Override
    public float maxShrink() {
        return 0.3f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.15f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 3.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.15f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

