/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntitySneakySal;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBullet
extends Entity {
    private static final DataParameter<Integer> shootingEntity = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int damage;
    protected boolean playerFire;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private boolean inGround = false;
    private int ticksInAir = 0;
    public double accelerationX = 0.0;
    public double accelerationY = 0.0;
    public double accelerationZ = 0.0;
    public double speed = 1.0;

    public EntityBullet(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.damage = 2;
        this.playerFire = false;
    }

    public EntityBullet(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    public EntityBullet(World world, EntityLivingBase entityliving) {
        this(world);
        this.field_70180_af.func_187227_b(shootingEntity, (Object)entityliving.func_145782_y());
        if (entityliving instanceof EntityPlayer) {
            this.damage = 4;
            this.playerFire = true;
        }
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        double xHeading = -MathHelper.func_76126_a((float)(entityliving.field_70177_z * (float)Math.PI / 180.0f));
        double zHeading = MathHelper.func_76134_b((float)(entityliving.field_70177_z * (float)Math.PI / 180.0f));
        double par13 = xHeading * 0.5;
        double par15 = entityliving.field_70125_A;
        double par17 = zHeading * 0.5;
        double par9 = MathHelper.func_76126_a((float)((float)(par13 * par13 + par15 * par15 + par17 * par17)));
        this.accelerationX = par13 / par9 * 1.1;
        this.accelerationZ = par17 / par9 * 1.1;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.3500000014901161;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
    }

    public EntityBullet(World world, EntityLivingBase entityliving, double targetx, double targety, double targetz) {
        this(world);
        this.field_70180_af.func_187227_b(shootingEntity, (Object)entityliving.func_145782_y());
        if (entityliving instanceof EntitySneakySal) {
            // empty if block
        }
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)(entityliving.field_70131_O / 2.0f), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        Vec3d direction = new Vec3d((targetx += this.field_70146_Z.nextGaussian() * 0.4) - this.field_70165_t, (targety += this.field_70146_Z.nextGaussian() * 0.4) - this.field_70163_u, (targetz += this.field_70146_Z.nextGaussian() * 0.4) - this.field_70161_v).func_72432_b();
        this.field_70159_w = direction.field_72450_a * this.speed;
        this.field_70181_x = direction.field_72448_b * this.speed;
        this.field_70179_y = direction.field_72449_c * this.speed;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(shootingEntity, (Object)0);
    }

    public boolean func_70112_a(double d) {
        return true;
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(shooter, f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74768_a("inTile", this.inTile);
        compound.func_74757_a("inGround", this.inGround);
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.inTile = compound.func_74762_e("inTile");
        this.inGround = compound.func_74767_n("inGround");
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    private void blast(Vec3d pos) {
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    private void blood(Vec3d hitPlace) {
        double x = hitPlace.field_72450_a;
        double y = hitPlace.field_72448_b;
        double z = hitPlace.field_72449_c;
        this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.ticksInAir > 75) {
            this.func_70106_y();
            return;
        }
        Vec3d var15 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d var2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult rtr = this.field_70170_p.func_72933_a(var15, var2);
        var15 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        var2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (rtr != null) {
            var2 = new Vec3d(rtr.field_72307_f.field_72450_a, rtr.field_72307_f.field_72448_b, rtr.field_72307_f.field_72449_c);
        }
        Entity var4 = null;
        double var6 = 0.0;
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0))) {
            double var13;
            if (!entity.func_70067_L() || entity.equals((Object)this.getShootingEntity()) && this.ticksInAir < 25) continue;
            float var10 = 0.3f;
            AxisAlignedBB boundingBox = entity.func_174813_aQ().func_72321_a((double)var10, (double)var10, (double)var10);
            RayTraceResult rtr2 = boundingBox.func_72327_a(var15, var2);
            if (rtr2 == null || !((var13 = var15.func_72438_d(rtr2.field_72307_f)) < var6) && var6 != 0.0) continue;
            var4 = entity;
            var6 = var13;
        }
        if (var4 != null) {
            rtr = new RayTraceResult(var4);
        }
        if (rtr != null) {
            this.onHit(rtr);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float var16 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var16) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float var17 = 0.95f;
        if (this.func_70072_I()) {
            for (int i = 0; i < 4; ++i) {
                float var18 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)var18, this.field_70163_u - this.field_70181_x * (double)var18, this.field_70161_v - this.field_70179_y * (double)var18, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            var17 = 0.8f;
        }
        this.field_70159_w += this.accelerationX;
        this.field_70181_x += this.accelerationY;
        this.field_70179_y += this.accelerationZ;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        ++this.ticksInAir;
    }

    private void onHit(RayTraceResult rtr) {
        BlockPos blockHitPos;
        Entity entityHit = rtr.field_72308_g;
        if (entityHit != null && entityHit == this.getShootingEntity()) {
            return;
        }
        if (entityHit != null && entityHit.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getShootingEntity()), (float)this.damage) && MoreCreepsConfig.blood && (!(entityHit instanceof EntityCreepBase) || ((EntityCreepBase)entityHit).canBleed())) {
            this.blood(rtr.field_72307_f);
        }
        if (rtr.field_72313_a == RayTraceResult.Type.BLOCK && !this.field_70170_p.func_175623_d(blockHitPos = rtr.func_178782_a())) {
            Block blockHit = this.field_70170_p.func_180495_p(blockHitPos).func_177230_c();
            if (blockHit == Blocks.field_150432_aD) {
                this.field_70170_p.func_175656_a(blockHitPos, Blocks.field_150355_j.func_176223_P());
            } else if (blockHit == Blocks.field_150359_w) {
                this.blast(rtr.field_72307_f);
                this.field_70170_p.func_175655_b(blockHitPos, false);
            } else {
                this.blast(rtr.field_72307_f);
            }
        }
        this.func_184185_a(CreepsSoundHandler.raygunSound, 0.2f, 1.0f / (this.field_70146_Z.nextFloat() * 0.1f + 0.95f));
        this.func_70106_y();
    }

    public Entity getShootingEntity() {
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(shootingEntity)).intValue());
    }
}

