/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityCastleGuard
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private static final DataParameter<Boolean> attacked = EntityDataManager.func_187226_a(EntityCastleGuard.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String[] textures = new String[]{"textures/entity/castleguard1", "textures/entity/castleguard2", "textures/entity/castleguard3", "textures/entity/castleguard4", "textures/entity/castleguard5"};

    public EntityCastleGuard(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Castle Guard");
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = 20.0f;
        this.baseSpeed = 0.25;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(attacked, (Object)false);
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f + (1.0f - this.getModelSize()) * 2.0f;
    }

    protected SoundEvent func_184639_G() {
        if (this.getAttacked() && this.field_70146_Z.nextInt(5) == 0) {
            return CreepsSoundHandler.castleGuardMadSound;
        }
        if (this.field_70146_Z.nextInt(12) == 0) {
            return CreepsSoundHandler.castleGuardSound;
        }
        return null;
    }

    public boolean getAttacked() {
        return (Boolean)this.field_70180_af.func_187225_a(attacked);
    }

    private void setAttacked(boolean b) {
        this.field_70180_af.func_187227_b(attacked, (Object)b);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.castleGuardHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.castleGuardDeathSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_145779_a(CreepsItemHandler.donut, this.field_70146_Z.nextInt(2) + 1);
        }
    }

    @Override
    protected String[] getAvailableTextures() {
        return textures;
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource damageSource, float amt) {
        if (damageSource.func_76346_g() instanceof EntityPlayer) {
            this.setAttacked(true);
        }
        return super.func_70097_a(damageSource, amt);
    }

    @Override
    public boolean func_70601_bi() {
        return true;
    }

    @Override
    public float maxShrink() {
        return 0.4f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

