/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityTombstone;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIFollowOwner;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIFollowOwnerTarget;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIOwnerHurtByTarget;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIOwnerHurtTarget;
import com.morecreepsrevival.morecreeps.common.helpers.EffectHelper;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageDismountEntity;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageOpenGuiTamableEntity;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCreepBase
extends EntityCreature
implements IEntityOwnable {
    private static final DataParameter<String> name = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> level = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> texture = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> speedBoost = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> owner = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> wanderState = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> experience = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> totalDamage = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> creepTypeName = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> modelSize = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> skillHealing = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skillAttack = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skillDefend = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skillSpeed = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> interest = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> healTimer = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> healthBoost = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> criticalHitCooldown = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> armor = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> unmountTimer = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> noDespawn = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> hammerSwing = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> size = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected String baseTexture = "";
    protected float baseHealth = 100.0f;
    protected double baseSpeed = 1.0;
    protected double baseAttackDamage = 1.0;
    protected float currentSize = 1.0f;
    protected float widthActual;
    protected float heightActual;
    protected EnumCreatureType creatureType = EnumCreatureType.CREATURE;
    protected boolean spawnOnlyAtNight = false;
    private int internalWanderState = 0;

    public EntityCreepBase(World worldIn) {
        super(worldIn);
        this.field_70143_R = -25.0f;
        this.field_70728_aV = 5;
        this.updateAttributes();
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width * this.currentSize, height * this.currentSize);
        this.widthActual = width;
        this.heightActual = height;
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        if (this.getCreatureType() == EnumCreatureType.MONSTER) {
            return SoundCategory.HOSTILE;
        }
        return SoundCategory.NEUTRAL;
    }

    protected void onDismount(Entity entity) {
    }

    public void func_184210_p() {
        if (!this.field_70170_p.field_72995_K) {
            CreepsPacketHandler.INSTANCE.sendToAll((IMessage)new MessageDismountEntity(this.func_145782_y()));
        }
        this.field_70143_R = -25.0f;
        this.field_70180_af.func_187227_b(unmountTimer, (Object)20);
        SoundEvent unmountSound = this.getUnmountSound();
        if (unmountSound != null) {
            this.func_184185_a(unmountSound, this.func_70599_aP(), this.func_70647_i());
        }
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        this.onDismount(entity);
    }

    public boolean func_180431_b(@Nonnull DamageSource damageSource) {
        if (this.func_184218_aH()) {
            return true;
        }
        return super.func_180431_b(damageSource);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(name, (Object)"");
        this.field_70180_af.func_187214_a(level, (Object)1);
        this.field_70180_af.func_187214_a(texture, (Object)"");
        this.field_70180_af.func_187214_a(size, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(speedBoost, (Object)0);
        this.field_70180_af.func_187214_a(owner, (Object)"");
        this.field_70180_af.func_187214_a(wanderState, (Object)0);
        this.field_70180_af.func_187214_a(experience, (Object)0);
        this.field_70180_af.func_187214_a(totalDamage, (Object)0);
        this.field_70180_af.func_187214_a(creepTypeName, (Object)"creep");
        this.field_70180_af.func_187214_a(modelSize, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(skillHealing, (Object)0);
        this.field_70180_af.func_187214_a(skillAttack, (Object)0);
        this.field_70180_af.func_187214_a(skillDefend, (Object)0);
        this.field_70180_af.func_187214_a(skillSpeed, (Object)0);
        this.field_70180_af.func_187214_a(interest, (Object)0);
        this.field_70180_af.func_187214_a(healTimer, (Object)0);
        this.field_70180_af.func_187214_a(healthBoost, (Object)0);
        this.field_70180_af.func_187214_a(criticalHitCooldown, (Object)5);
        this.field_70180_af.func_187214_a(armor, (Object)0);
        this.field_70180_af.func_187214_a(unmountTimer, (Object)0);
        this.field_70180_af.func_187214_a(noDespawn, (Object)false);
        this.field_70180_af.func_187214_a(hammerSwing, (Object)Float.valueOf(0.0f));
    }

    protected void updateAttributes() {
        this.updateHealth();
        this.updateMoveSpeed();
        this.updateTexture();
        this.updateAttackStrength();
        this.updateModelSize();
    }

    protected void updateModelSize() {
        this.widthActual = this.field_70130_N;
        this.heightActual = this.field_70131_O;
    }

    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        switch (this.getWanderState()) {
            case 0: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
                if (!this.isTamed()) break;
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
                break;
            }
            case 1: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
                if (!this.isTamed()) break;
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
                break;
            }
            case 2: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityCreepAIFollowOwner(this, 1.0, 6.0f, 2.0f));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
                this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
                if (!this.isTamed()) break;
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityCreepAIOwnerHurtByTarget(this));
                this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityCreepAIOwnerHurtTarget(this));
                this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityCreepAIFollowOwnerTarget(this));
                break;
            }
        }
    }

    protected void clearAITasks() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.updateAttributes();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEntity");
        props.func_74776_a("ModelSize", this.getModelSize());
        props.func_74778_a("Name", this.getCreepName());
        props.func_74778_a("BaseTexture", this.baseTexture);
        props.func_74776_a("SizeCreep", ((Float)this.field_70180_af.func_187225_a(size)).floatValue());
        props.func_74768_a("HealthBoost", ((Integer)this.field_70180_af.func_187225_a(healthBoost)).intValue());
        props.func_74768_a("Level", this.getLevel());
        props.func_74768_a("SpeedBoost", this.getSpeedBoost());
        props.func_74768_a("Interest", ((Integer)this.field_70180_af.func_187225_a(interest)).intValue());
        props.func_74768_a("TotalDamage", this.getTotalDamage());
        props.func_74768_a("Experience", this.getExperience());
        props.func_74768_a("WanderState", this.getWanderState());
        props.func_74768_a("Armor", ((Integer)this.field_70180_af.func_187225_a(armor)).intValue());
        props.func_74768_a("SkillHealing", this.getSkillHealing());
        props.func_74768_a("SkillAttack", this.getSkillAttack());
        props.func_74768_a("SkillDefend", this.getSkillDefend());
        props.func_74768_a("SkillSpeed", this.getSkillSpeed());
        UUID owner = this.func_184753_b();
        if (owner != null) {
            props.func_74778_a("Owner", owner.toString());
        }
        props.func_74778_a("CreepTypeName", this.getCreepTypeName());
        compound.func_74782_a("MoreCreepsEntity", (NBTBase)props);
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEntity");
        if (props.func_74764_b("ModelSize")) {
            this.setModelSize(props.func_74760_g("ModelSize"));
        }
        if (props.func_74764_b("Name")) {
            this.setCreepName(props.func_74779_i("Name"));
        }
        if (props.func_74764_b("HealthBoost")) {
            this.setHealthBoost(props.func_74762_e("HealthBoost"));
        }
        if (props.func_74764_b("BaseTexture")) {
            this.baseTexture = props.func_74779_i("BaseTexture");
        } else {
            String[] availableTextures = this.getAvailableTextures();
            if (availableTextures.length > 0) {
                this.baseTexture = availableTextures[this.field_70146_Z.nextInt(availableTextures.length)];
            }
        }
        if (props.func_74764_b("SizeCreep")) {
            this.putSizeNBT(props.func_74760_g("SizeCreep"));
        }
        if (props.func_74764_b("Level")) {
            this.setLevel(props.func_74762_e("Level"));
        }
        if (props.func_74764_b("SpeedBoost")) {
            this.setSpeedBoost(props.func_74762_e("SpeedBoost"));
        }
        if (props.func_74764_b("Interest")) {
            this.setInterest(props.func_74762_e("Interest"));
        }
        if (props.func_74764_b("TotalDamage")) {
            this.setTotalDamage(props.func_74762_e("TotalDamage"));
        }
        if (props.func_74764_b("Experience")) {
            this.setExperience(props.func_74762_e("Experience"));
        }
        if (props.func_74764_b("WanderState")) {
            this.setWanderState(props.func_74762_e("WanderState"));
        }
        if (props.func_74764_b("Armor")) {
            this.setArmor(props.func_74762_e("Armor"));
        }
        if (props.func_74764_b("SkillHealing")) {
            this.setSkillHealing(props.func_74762_e("SkillHealing"));
        }
        if (props.func_74764_b("SkillAttack")) {
            this.setSkillAttack(props.func_74762_e("SkillAttack"));
        }
        if (props.func_74764_b("SkillDefend")) {
            this.setSkillDefend(props.func_74762_e("SkillDefend"));
        }
        if (props.func_74764_b("SkillSpeed")) {
            this.setSkillSpeed(props.func_74762_e("SkillSpeed"));
        }
        if (props.func_74764_b("Owner")) {
            this.setOwner(UUID.fromString(props.func_74779_i("Owner")));
        }
        if (props.func_74764_b("CreepTypeName")) {
            this.setCreepTypeName(props.func_74779_i("CreepTypeName"));
        }
        this.updateAttributes();
        super.func_70037_a(compound);
    }

    public void determineBaseTexture() {
        if (!this.baseTexture.isEmpty()) {
            return;
        }
        String[] availableTextures = this.getAvailableTextures();
        if (availableTextures.length > 0) {
            this.baseTexture = availableTextures[this.field_70146_Z.nextInt(availableTextures.length)];
        }
        this.updateTexture();
    }

    public void setInitialHealth() {
        this.func_70606_j(this.func_110138_aP());
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        super.func_180482_a(difficulty, livingData);
        this.determineBaseTexture();
        this.setInitialHealth();
        return livingData;
    }

    protected double getMoveSpeed() {
        return this.baseSpeed;
    }

    protected double getAttackDamage() {
        return this.baseAttackDamage;
    }

    protected void updateMoveSpeed() {
        double speed = this.getMoveSpeed() + this.getLevelSpeedMultiplier() * (double)(this.getLevel() - 1);
        if (this.getSpeedBoost() > 0) {
            speed += 0.75;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
    }

    public boolean isCreatureType(@Nullable EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return this.getCreatureType() == type;
    }

    public EnumCreatureType getCreatureType() {
        return this.creatureType;
    }

    protected static float getArmorHealthBonus(int armorLevel) {
        switch (armorLevel) {
            case 1: {
                return 5.0f;
            }
            case 2: {
                return 15.0f;
            }
            case 3: {
                return 9.0f;
            }
            case 4: {
                return 22.0f;
            }
        }
        return 0.0f;
    }

    protected float getBaseHealth() {
        return this.baseHealth;
    }

    protected void updateHealth() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.getBaseHealth() + this.getLevelHealthMultiplier() * (float)(this.getLevel() - 1) + (float)this.getHealthBoost() + EntityCreepBase.getArmorHealthBonus(this.getArmor())));
    }

    protected void updateAttackStrength() {
        double attackDamage = this.getAttackDamage() + this.getLevelDamageMultiplier() * (double)(this.getLevel() - 1);
        switch (this.getArmor()) {
            case 1: {
                attackDamage += 1.0;
                break;
            }
            case 2: {
                attackDamage += 3.0;
                break;
            }
            case 3: {
                attackDamage += 2.0;
                break;
            }
            case 4: {
                attackDamage += 6.0;
                break;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(attackDamage);
    }

    public void addHealth(float amt) {
        this.func_70606_j(Math.max(0.0f, Math.min(this.func_110138_aP(), this.func_110143_aJ() + amt)));
    }

    protected void setInterest(int i) {
        this.field_70180_af.func_187227_b(interest, (Object)Math.max(0, Math.min(100, i)));
    }

    public int getInterest() {
        return (Integer)this.field_70180_af.func_187225_a(interest);
    }

    protected void addInterest(int i, EntityPlayer player) {
        if (!this.isTamable() || this.isTamed()) {
            return;
        }
        this.setInterest(this.getInterest() + i);
        if (this.getInterest() >= 100) {
            this.tame(player);
        }
    }

    public void feed(EntityPlayer player, float healthToAdd, int interestToAdd) {
        this.addHealth(healthToAdd);
        this.addInterest(interestToAdd, player);
        SoundEvent fullSound = this.getFullSound();
        SoundEvent eatSound = this.func_110143_aJ() >= this.func_110138_aP() && fullSound != null ? fullSound : this.getEatSound();
        if (eatSound != null) {
            this.func_184185_a(eatSound, this.func_70599_aP(), this.func_70647_i());
        }
    }

    protected void updateTexture() {
        if (this.baseTexture == null || this.baseTexture.length() < 1) {
            return;
        }
        StringBuilder builder = new StringBuilder().append(this.baseTexture);
        switch (this.getArmor()) {
            case 1: {
                builder.append("l");
                break;
            }
            case 2: {
                builder.append("g");
                break;
            }
            case 3: {
                builder.append("i");
                break;
            }
            case 4: {
                builder.append("d");
                break;
            }
        }
        builder.append(".png");
        this.setTexture(builder.toString());
    }

    public void setWanderState(int i) {
        this.field_70180_af.func_187227_b(wanderState, (Object)i);
    }

    public int getWanderState() {
        return (Integer)this.field_70180_af.func_187225_a(wanderState);
    }

    protected void setArmor(int i) {
        this.field_70180_af.func_187227_b(armor, (Object)i);
        this.updateHealth();
        this.updateAttackStrength();
        this.updateTexture();
    }

    public int getArmor() {
        return (Integer)this.field_70180_af.func_187225_a(armor);
    }

    protected double getRidingYOffset() {
        return 0.5;
    }

    public double func_70033_W() {
        Entity entity = this.func_184187_bx();
        if (entity != null) {
            return this.getRidingYOffset() * (double)(entity.func_184188_bt().indexOf((Object)this) + 1);
        }
        return 0.0;
    }

    protected boolean shouldJumpWhileAttacking(Entity entity) {
        return false;
    }

    protected void doAttackJump(Entity entity) {
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(entity.field_70161_v - this.field_70161_v, entity.field_70165_t - this.field_70165_t)) - 90.0f;
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        this.field_70159_w = d0 / f * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
        this.field_70179_y = d1 / f * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
        this.field_70181_x = 0.4f;
        this.field_70143_R = -25.0f;
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        SoundEvent angrySound;
        if (this.field_70122_E && this.shouldJumpWhileAttacking(entity)) {
            this.doAttackJump(entity);
        }
        if (this.field_70146_Z.nextInt(5) == 0 && (angrySound = this.getAngrySound()) != null) {
            this.func_184185_a(angrySound, this.func_70599_aP(), this.func_70647_i());
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (flag) {
            int j = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
            if (j > 0) {
                entity.func_70015_d(j * 4);
            }
            if (entity instanceof EntityPlayer) {
                ItemStack itemStack2;
                EntityPlayer player = (EntityPlayer)entity;
                ItemStack itemStack = this.func_184614_ca();
                ItemStack itemStack3 = itemStack2 = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemStack.func_190926_b() && !itemStack2.func_190926_b() && itemStack.func_77973_b().canDisableShield(itemStack, itemStack2, (EntityLivingBase)player, (EntityLivingBase)this) && itemStack2.func_77973_b().isShield(itemStack2, (EntityLivingBase)player)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        player.func_184811_cZ().func_185145_a(itemStack2.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entity);
            if (this.isTamed() && this.canLevelUp()) {
                int iSkillAttack = this.getSkillAttack();
                this.addTotalDamage((int)((double)f * (1.85 + (double)iSkillAttack)));
                double hitChance = 1.0 + (double)(this.getLevel() * 5) + (double)(iSkillAttack * 4);
                if (hitChance < 5.0) {
                    hitChance = 5.0;
                }
                if ((double)this.field_70146_Z.nextInt(100) > 100.0 - hitChance) {
                    SoundEvent killSound;
                    float damageDealt = f * 0.75f;
                    if (damageDealt < 1.0f) {
                        damageDealt = 1.0f;
                    }
                    if ((Integer)this.field_70180_af.func_187225_a(criticalHitCooldown) > 0) {
                        this.field_70180_af.func_187227_b(criticalHitCooldown, (Object)((Integer)this.field_70180_af.func_187225_a(criticalHitCooldown) - 1));
                    }
                    if (iSkillAttack > 1 && this.field_70146_Z.nextInt(100) > 100 - iSkillAttack * 2 && (Integer)this.field_70180_af.func_187225_a(criticalHitCooldown) < 1) {
                        float hp = ((EntityLivingBase)entity).func_110143_aJ();
                        if (damageDealt < hp) {
                            damageDealt = hp;
                        }
                        this.field_70180_af.func_187227_b(criticalHitCooldown, (Object)(50 - iSkillAttack * 8));
                        SoundEvent criticalHitSound = this.getCriticalHitSound();
                        if (criticalHitSound != null) {
                            entity.func_184185_a(criticalHitSound, 1.0f, 1.0f);
                        }
                        this.addTotalDamage(25);
                    }
                    if (((EntityLivingBase)entity).func_110143_aJ() - damageDealt <= 0.0f && (killSound = this.getKillSound()) != null) {
                        this.func_184185_a(killSound, this.func_70599_aP(), this.func_70647_i());
                    }
                    this.addTotalDamage((int)((double)damageDealt * (1.85 + (double)iSkillAttack)));
                    return entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)entity), damageDealt);
                }
            }
        }
        return flag;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean canMount(Entity entity) {
        return true;
    }

    public boolean func_184205_a(@Nonnull Entity entity, boolean force) {
        if (!force && !this.canMount(entity)) {
            return false;
        }
        boolean flag = super.func_184205_a(entity, force);
        if (flag) {
            this.field_70177_z = entity.field_70177_z;
            SoundEvent mountSound = this.getMountSound();
            if (mountSound != null) {
                this.func_184185_a(mountSound, this.func_70599_aP(), this.func_70647_i());
            }
            this.field_70180_af.func_187227_b(unmountTimer, (Object)20);
        }
        return flag;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.func_70089_S()) {
            if (itemStack.func_190926_b()) {
                if (player.func_70093_af() && this.isTamed() && this.isPlayerOwner(player) && this.canUseTamableMenu()) {
                    if (!this.field_70170_p.field_72995_K) {
                        CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageOpenGuiTamableEntity(this.func_145782_y()), (EntityPlayerMP)player);
                    }
                    return true;
                }
                if (this.canRidePlayer() && this.canRidePlayer(player)) {
                    if (!player.equals((Object)this.func_184187_bx())) {
                        if (this.isStackable()) {
                            this.func_82149_j((Entity)player);
                            this.func_184205_a((Entity)player, true);
                        } else {
                            this.func_184220_m((Entity)player);
                        }
                    } else {
                        this.func_184210_p();
                    }
                    return true;
                }
                if (this.isRideable() && this.canPlayerRide(player) && !player.equals((Object)this.getFirstPassenger()) && player.func_184220_m((Entity)this)) {
                    return true;
                }
            } else {
                Item item = itemStack.func_77973_b();
                if (this.isTamed() && this.isPlayerOwner(player) && this.canUseTamableMenu() && (item == Items.field_151122_aG || item == Items.field_151121_aF || this.shouldOpenTamableMenu(item))) {
                    if (!this.field_70170_p.field_72995_K) {
                        CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageOpenGuiTamableEntity(this.func_145782_y()), (EntityPlayerMP)player);
                    }
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void spawnTrophy(Entity entity) {
        EffectHelper.spawnTrophy(this.field_70170_p, entity);
    }

    public void spawnTrophy() {
        this.spawnTrophy((Entity)this);
    }

    public void explode() {
        EffectHelper.explode(this.field_70170_p, (Entity)this);
    }

    public void smoke(boolean plain) {
        EffectHelper.smoke(this.field_70170_p, (Entity)this, this.field_70146_Z, plain);
    }

    public void smoke() {
        this.smoke(false);
    }

    public void smokePlain() {
        this.smoke(true);
    }

    public void smoke2() {
        EffectHelper.smoke2(this.field_70170_p, (Entity)this, this.field_70146_Z);
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        if (!this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            if (this.isTamed() && this.canBeRevived()) {
                if (!(this instanceof EntityTombstone)) {
                    EntityTombstone tombstone = new EntityTombstone(this.field_70170_p, this);
                    tombstone.determineBaseTexture();
                    tombstone.setInitialHealth();
                    this.field_70170_p.func_72838_d((Entity)tombstone);
                }
            } else {
                this.dropItemsOnDeath();
            }
        }
        super.func_70645_a(cause);
    }

    protected void dropItemsOnDeath() {
    }

    public boolean func_70094_T() {
        if (this.func_184218_aH() || (Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0) {
            return false;
        }
        return super.func_70094_T();
    }

    public boolean func_70648_aU() {
        return this.func_184218_aH() || (Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0;
    }

    public boolean func_82171_bF() {
        return this.isRideable() && this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_70636_d() {
        float f;
        int speedBoost;
        super.func_70636_d();
        float networkedSize = ((Float)this.field_70180_af.func_187225_a(size)).floatValue();
        if (this.currentSize != networkedSize) {
            this.currentSize = networkedSize;
            this.func_70105_a(this.widthActual, this.heightActual);
        }
        this.func_82168_bl();
        if (this.func_70013_c() > 0.5f) {
            this.field_70708_bq += 2;
        }
        if ((Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0) {
            this.field_70180_af.func_187227_b(unmountTimer, (Object)((Integer)this.field_70180_af.func_187225_a(unmountTimer) - 1));
        }
        int iSkillHealing = this.getSkillHealing();
        if ((Integer)this.field_70180_af.func_187225_a(healTimer) > 0) {
            this.field_70180_af.func_187227_b(healTimer, (Object)((Integer)this.field_70180_af.func_187225_a(healTimer) - 1));
        }
        if (iSkillHealing > 0 && (Integer)this.field_70180_af.func_187225_a(healTimer) < 1 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.field_70180_af.func_187227_b(healTimer, (Object)((6 - iSkillHealing) * 200));
            this.addHealth(iSkillHealing);
            for (int i = 0; i < iSkillHealing; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
            }
            this.func_70626_be();
        }
        if ((speedBoost = this.getSpeedBoost()) > 0) {
            this.setSpeedBoost(--speedBoost);
            if (speedBoost < 1) {
                SoundEvent speedDownSound;
                EntityPlayer owner;
                if (!this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
                    owner.func_145747_a((ITextComponent)new TextComponentString("\u00a7b" + this.getCreepName() + "\u00a76 has run out of speedboost."));
                }
                if ((speedDownSound = this.getSpeedDownSound()) != null) {
                    this.func_184185_a(speedDownSound, this.func_70599_aP(), this.func_70647_i());
                }
                this.updateMoveSpeed();
            }
        }
        if (this.shouldBurnInDay() && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            this.func_70015_d(this.getBurnInDayTime());
        }
    }

    protected int getBurnInDayTime() {
        return 20;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected void giveSpeedBoost(int speedBoost) {
        EntityPlayer owner;
        this.smokePlain();
        this.setSpeedBoost(Math.max(0, this.getSpeedBoost()) + speedBoost);
        this.updateMoveSpeed();
        SoundEvent speedUpSound = this.getSpeedUpSound();
        if (speedUpSound != null) {
            this.func_184185_a(speedUpSound, this.func_70599_aP(), this.func_70647_i());
        }
        int speedBoostLeft = Math.max(this.getSpeedBoost() / 21 / 60, 0);
        if (!this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
            owner.func_145747_a((ITextComponent)new TextComponentString("\u00a73" + this.getCreepName() + "\u00a76 has\u00a7f " + speedBoostLeft + "\u00a76 minute" + (speedBoostLeft > 1 ? "s" : "") + " of speedboost left."));
        }
    }

    protected SoundEvent getMountSound() {
        return null;
    }

    protected SoundEvent getUnmountSound() {
        return null;
    }

    protected SoundEvent getEatSound() {
        return null;
    }

    protected SoundEvent getFullSound() {
        return null;
    }

    protected SoundEvent getSpeedUpSound() {
        return null;
    }

    protected SoundEvent getSpeedDownSound() {
        return null;
    }

    protected SoundEvent getLevelUpSound() {
        return null;
    }

    protected SoundEvent getCriticalHitSound() {
        return null;
    }

    protected SoundEvent getAngrySound() {
        return null;
    }

    protected String[] getTamedNames() {
        return new String[0];
    }

    protected String[] getAvailableTextures() {
        return new String[0];
    }

    protected boolean func_70692_ba() {
        return this.getCreatureType() == EnumCreatureType.MONSTER && !this.getNoDespawn() && !this.isTamed();
    }

    public int func_70627_aG() {
        return 120;
    }

    public void resetTarget() {
        this.func_70624_b(null);
        this.func_70604_c(null);
    }

    public void resetModelSize() {
        this.setModelSize(1.0f);
    }

    protected void setModelSize(float f) {
        this.field_70180_af.func_187227_b(modelSize, (Object)Float.valueOf(f));
    }

    public float getModelSize() {
        return ((Float)this.field_70180_af.func_187225_a(modelSize)).floatValue();
    }

    public void shrinkModelSize(float f) {
        this.setModelSize(Math.max(0.0f, this.getModelSize() - f));
    }

    public void growModelSize(float f) {
        this.setModelSize(Math.max(0.0f, this.getModelSize() + f));
    }

    public void growHitboxSize(float f) {
        this.field_70180_af.func_187227_b(size, (Object)Float.valueOf(((Float)this.field_70180_af.func_187225_a(size)).floatValue() + f));
    }

    public void shrinkHitboxSize(float f) {
        this.field_70180_af.func_187227_b(size, (Object)Float.valueOf(((Float)this.field_70180_af.func_187225_a(size)).floatValue() - f));
    }

    public void decreaseMoveSpeed(float f) {
        this.baseSpeed -= (double)f;
        this.updateMoveSpeed();
    }

    public void increaseMoveSpeed(float f) {
        this.baseSpeed += (double)f;
        this.updateMoveSpeed();
    }

    protected void setSpeedBoost(int i) {
        this.field_70180_af.func_187227_b(speedBoost, (Object)i);
    }

    public int getSpeedBoost() {
        return (Integer)this.field_70180_af.func_187225_a(speedBoost);
    }

    protected void setTexture(String textureIn) {
        this.field_70180_af.func_187227_b(texture, (Object)textureIn);
    }

    public String getTexture() {
        return (String)this.field_70180_af.func_187225_a(texture);
    }

    public void setCreepName(String s) {
        this.field_70180_af.func_187227_b(name, (Object)s);
    }

    public String getCreepName() {
        return (String)this.field_70180_af.func_187225_a(name);
    }

    public void setOwner(UUID uuid) {
        this.field_70180_af.func_187227_b(owner, (Object)uuid.toString());
    }

    public void setOwner(EntityPlayer player) {
        this.field_70180_af.func_187227_b(owner, (Object)player.func_110124_au().toString());
    }

    protected void clearOwner() {
        this.field_70180_af.func_187227_b(owner, (Object)"");
    }

    @Nullable
    public UUID func_184753_b() {
        String uuid = (String)this.field_70180_af.func_187225_a(owner);
        if (uuid.isEmpty()) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    public boolean isPlayerOwner(EntityPlayer player) {
        if (player == null || this.func_184753_b() == null) {
            return false;
        }
        return player.func_110124_au().equals(this.func_184753_b());
    }

    @Nullable
    public EntityPlayer getOwner() {
        UUID owner = this.func_184753_b();
        if (owner != null) {
            return this.field_70170_p.func_152378_a(owner);
        }
        return null;
    }

    protected void putSizeNBT(float f) {
        this.field_70180_af.func_187227_b(size, (Object)Float.valueOf(f));
    }

    protected void setLevel(int i) {
        this.field_70180_af.func_187227_b(level, (Object)i);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(level);
    }

    public void tame(EntityPlayer player) {
        this.setInterest(0);
        this.setOwner(player);
        boolean emptyName = true;
        if (this.getCreepName().length() < 1 && !this.field_70170_p.field_72995_K) {
            String[] names = this.getTamedNames();
            if (names.length > 0) {
                this.setCreepName(names[this.field_70146_Z.nextInt(names.length)]);
                emptyName = false;
            } else {
                this.setCreepName("");
            }
        }
        this.updateAttributes();
        this.func_70606_j(this.func_110138_aP());
        this.setWanderState(2);
        SoundEvent tamedSound = this.getTamedSound();
        if (tamedSound != null) {
            this.func_184185_a(tamedSound, this.func_70599_aP(), this.func_70647_i());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (emptyName) {
                player.func_145747_a((ITextComponent)new TextComponentString("You have successfully tamed: \u00a76" + this.getCreepTypeName()));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a76" + this.getCreepName() + " \u00a7fhas been tamed!"));
            }
        }
    }

    public void untame() {
        this.clearOwner();
        this.setCreepName("");
        this.setInterest(0);
    }

    public boolean isTamed() {
        return this.func_184753_b() != null;
    }

    public boolean isTamable() {
        return false;
    }

    public boolean canRidePlayer() {
        return false;
    }

    public boolean canRidePlayer(EntityPlayer player) {
        return !this.isTamable() || this.isTamed() && this.isPlayerOwner(player);
    }

    public boolean isRideable() {
        return false;
    }

    public boolean canPlayerRide(EntityPlayer player) {
        return !this.isTamable() || this.isTamed() && this.isPlayerOwner(player);
    }

    protected boolean shouldOpenTamableMenu(Item item) {
        return false;
    }

    protected boolean canUseTamableMenu() {
        return false;
    }

    public String getLevelName() {
        return "";
    }

    public int getLevelDamage() {
        return 0;
    }

    public int getMaxLevel() {
        return 1;
    }

    protected void setExperience(int i) {
        this.field_70180_af.func_187227_b(experience, (Object)i);
    }

    protected void addExperience(int i) {
        this.setExperience(this.getExperience() + i);
    }

    public int getExperience() {
        return (Integer)this.field_70180_af.func_187225_a(experience);
    }

    protected void setTotalDamage(int i) {
        this.field_70180_af.func_187227_b(totalDamage, (Object)i);
    }

    public void addTotalDamage(int i) {
        this.addExperience(i);
        if ((i += this.getTotalDamage()) >= this.getLevelDamage() && this.getLevel() < this.getMaxLevel()) {
            SoundEvent levelUpSound;
            EntityPlayer player;
            int lvl = this.getLevel() + 1;
            this.setLevel(lvl);
            this.setTotalDamage(0);
            int healthBoostNew = this.field_70146_Z.nextInt(4);
            this.setHealthBoost(healthBoostNew);
            this.updateAttributes();
            this.addHealth((float)healthBoostNew + this.getLevelHealthMultiplier());
            if (!this.field_70170_p.field_72995_K && (player = this.getOwner()) != null) {
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7b" + this.getCreepName() + " \u00a7fincreased to level \u00a76" + lvl + "!"));
            }
            if ((levelUpSound = this.getLevelUpSound()) != null) {
                this.func_184185_a(levelUpSound, this.func_70599_aP(), this.func_70647_i());
            }
            return;
        }
        this.setTotalDamage(i);
    }

    public int getTotalDamage() {
        return (Integer)this.field_70180_af.func_187225_a(totalDamage);
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected float getLevelHealthMultiplier() {
        return 1.0f;
    }

    protected double getLevelDamageMultiplier() {
        return 1.0;
    }

    protected double getLevelSpeedMultiplier() {
        return 0.0;
    }

    public boolean shouldAttackEntity(EntityLivingBase target) {
        return !this.isTamed() || !(target instanceof EntityCreepBase) || !((EntityCreepBase)target).isPlayerOwner(this.getOwner());
    }

    public Team func_96124_cp() {
        EntityPlayer owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entity) {
        EntityPlayer owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            if (owner.equals((Object)entity)) {
                return true;
            }
            return owner.func_184191_r(entity);
        }
        return super.func_184191_r(entity);
    }

    protected void setHealthBoost(int healthBoostIn) {
        this.field_70180_af.func_187227_b(healthBoost, (Object)healthBoostIn);
    }

    public int getHealthBoost() {
        return (Integer)this.field_70180_af.func_187225_a(healthBoost);
    }

    protected void setSkillAttack(int i) {
        this.field_70180_af.func_187227_b(skillAttack, (Object)i);
    }

    public int getSkillAttack() {
        return (Integer)this.field_70180_af.func_187225_a(skillAttack);
    }

    protected void setSkillHealing(int i) {
        this.field_70180_af.func_187227_b(skillHealing, (Object)i);
    }

    public int getSkillHealing() {
        return (Integer)this.field_70180_af.func_187225_a(skillHealing);
    }

    protected void setSkillDefend(int i) {
        this.field_70180_af.func_187227_b(skillDefend, (Object)i);
    }

    public int getSkillDefend() {
        return (Integer)this.field_70180_af.func_187225_a(skillDefend);
    }

    protected void setSkillSpeed(int i) {
        this.field_70180_af.func_187227_b(skillSpeed, (Object)i);
    }

    public int getSkillSpeed() {
        return (Integer)this.field_70180_af.func_187225_a(skillSpeed);
    }

    public int getSkillLevel(String skill) {
        switch (skill) {
            case "attack": {
                return this.getSkillAttack();
            }
            case "defend": {
                return this.getSkillDefend();
            }
            case "healing": {
                return this.getSkillHealing();
            }
            case "speed": {
                return this.getSkillSpeed();
            }
        }
        return 0;
    }

    public int getRequiredLevelForSkill(String skill) {
        return this.getSkillLevel(skill) * 5;
    }

    public boolean canLevelSkill(String skill) {
        return this.getSkillLevel(skill) < 5 && this.getLevel() >= this.getRequiredLevelForSkill(skill);
    }

    public void levelUpSkill(String skill) {
        if (this.getSkillLevel(skill) >= 5) {
            return;
        }
        switch (skill) {
            case "attack": {
                this.setSkillAttack(this.getSkillAttack() + 1);
                this.updateAttackStrength();
                break;
            }
            case "defend": {
                this.setSkillDefend(this.getSkillDefend() + 1);
                break;
            }
            case "healing": {
                this.setSkillHealing(this.getSkillHealing() + 1);
                break;
            }
            case "speed": {
                this.setSkillSpeed(this.getSkillSpeed() + 1);
                this.updateMoveSpeed();
                break;
            }
        }
    }

    public boolean isStackable() {
        return false;
    }

    protected void setCreepTypeName(String creepTypeNameIn) {
        this.field_70180_af.func_187227_b(creepTypeName, (Object)creepTypeNameIn);
    }

    public String getCreepTypeName() {
        return (String)this.field_70180_af.func_187225_a(creepTypeName);
    }

    protected void setBaseTexture(String baseTextureIn) {
        this.baseTexture = baseTextureIn;
    }

    public String getBaseTexture() {
        return this.baseTexture;
    }

    public void setNoDespawn(boolean b) {
        this.field_70180_af.func_187227_b(noDespawn, (Object)b);
    }

    public boolean getNoDespawn() {
        return (Boolean)this.field_70180_af.func_187225_a(noDespawn);
    }

    public boolean func_70601_bi() {
        switch (this.getCreatureType()) {
            case AMBIENT: {
                return true;
            }
            case MONSTER: {
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel()) break;
                return false;
            }
        }
        return super.func_70601_bi();
    }

    public void func_70071_h_() {
        EntityLivingBase target;
        if (this.internalWanderState != this.getWanderState()) {
            this.func_184651_r();
            this.internalWanderState = this.getWanderState();
        }
        if ((target = this.func_70638_az()) != null && target.equals((Object)this.getOwner())) {
            this.func_70624_b(null);
        }
        super.func_70071_h_();
        if (this.getHammerSwing() < 0.0f) {
            this.addHammerSwing(0.45f);
        } else {
            this.setHammerSwing(0.0f);
        }
        if (this.getCreatureType() == EnumCreatureType.MONSTER && !this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public float func_180484_a(BlockPos blockPos) {
        if (this.getCreatureType() == EnumCreatureType.MONSTER && this.spawnOnlyAtNight) {
            return 0.5f - this.field_70170_p.func_175724_o(blockPos);
        }
        return this.field_70170_p.func_175724_o(blockPos) - 0.5f;
    }

    protected boolean isValidLightLevel() {
        if (!this.spawnOnlyAtNight) {
            return true;
        }
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockPos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockPos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockPos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public void onRevive(NBTTagCompound compound) {
    }

    public void onTombstoneCreate(NBTTagCompound compound) {
    }

    public void setHammerSwing(float f) {
        this.field_70180_af.func_187227_b(hammerSwing, (Object)Float.valueOf(f));
    }

    public float getHammerSwing() {
        return ((Float)this.field_70180_af.func_187225_a(hammerSwing)).floatValue();
    }

    public void addHammerSwing(float f) {
        this.setHammerSwing(this.getHammerSwing() + f);
    }

    public void takeHammerSwing(float f) {
        this.setHammerSwing(this.getHammerSwing() - f);
    }

    public boolean func_184638_cS() {
        return false;
    }

    public boolean canBleed() {
        return true;
    }

    protected Entity getFirstPassenger() {
        Iterator iterator = this.func_184188_bt().iterator();
        if (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            return entity;
        }
        return null;
    }

    protected SoundEvent getKillSound() {
        return null;
    }

    protected SoundEvent getMissSound() {
        return null;
    }

    protected SoundEvent getTamedSound() {
        return null;
    }

    public int getUnmountTimer() {
        return (Integer)this.field_70180_af.func_187225_a(unmountTimer);
    }

    public boolean canLevelUp() {
        return false;
    }

    public boolean canBeRevived() {
        return false;
    }

    public void cloneEntity() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(World.class);
            EntityCreepBase newEntity = (EntityCreepBase)((Object)constructor.newInstance(this.field_70170_p));
            newEntity.func_82149_j((Entity)this);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_70014_b(compound);
            newEntity.func_70037_a(compound);
            newEntity.func_70606_j(this.func_110143_aJ());
            this.field_70170_p.func_72838_d((Entity)newEntity);
            this.func_70106_y();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean func_70055_a(@Nonnull Material material) {
        if (material == Material.field_151586_h && this.func_184218_aH() && (Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0) {
            return false;
        }
        return super.func_70055_a(material);
    }
}

