/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class EntityCreepItem
extends Entity {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityCreepItem.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> pickupDelay = EntityDataManager.func_187226_a(EntityCreepItem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> age = EntityDataManager.func_187226_a(EntityCreepItem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> thrower = EntityDataManager.func_187226_a(EntityCreepItem.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> lifespan = EntityDataManager.func_187226_a(EntityCreepItem.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> owner = EntityDataManager.func_187226_a(EntityCreepItem.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityCreepItem(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityCreepItem(World world, ItemStack itemStack) {
        this(world);
        this.setItem(new ItemStack(itemStack.func_77973_b(), itemStack.func_190916_E()));
    }

    public EntityCreepItem(World world, double x, double y, double z, ItemStack itemStack) {
        this(world, itemStack);
        this.func_70107_b(x, y, z);
    }

    public EntityCreepItem(World world, Entity entity, ItemStack itemStack) {
        this(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(pickupDelay, (Object)0);
        this.field_70180_af.func_187214_a(age, (Object)0);
        this.field_70180_af.func_187214_a(thrower, (Object)"");
        this.field_70180_af.func_187214_a(lifespan, (Object)6000);
        this.field_70180_af.func_187214_a(owner, (Object)"");
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Age", this.getAge());
        compound.func_74768_a("PickupDelay", this.getPickupDelay());
        compound.func_74768_a("Lifespan", this.getLifespan());
        compound.func_74778_a("Thrower", this.getThrower());
        compound.func_74778_a("Owner", this.getOwner());
        ItemStack itemStack = this.getItem();
        if (!itemStack.func_190926_b()) {
            compound.func_74782_a("Item", (NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("Age")) {
            this.setAge(compound.func_74762_e("Age"));
        }
        if (compound.func_74764_b("PickupDelay")) {
            this.setPickupDelay(compound.func_74762_e("PickupDelay"));
        }
        if (compound.func_74764_b("Owner")) {
            this.setOwner(compound.func_74779_i("Owner"));
        }
        if (compound.func_74764_b("Thrower")) {
            this.setThrower(compound.func_74779_i("Thrower"));
        }
        this.setItem(new ItemStack(compound.func_74775_l("Item")));
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        }
        if (compound.func_74764_b("Lifespan")) {
            this.setLifespan(compound.func_74762_e("Lifespan"));
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70071_h_() {
        boolean flag;
        ItemStack item = this.getItem();
        if (item.func_190926_b()) {
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
        int delay = this.getPickupDelay();
        if (delay > 0 && delay != Short.MAX_VALUE) {
            this.setPickupDelay(delay - 1);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double d0 = this.field_70159_w;
        double d1 = this.field_70181_x;
        double d2 = this.field_70179_y;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70145_X = false;
        } else {
            AxisAlignedBB boundingBox = this.func_174813_aQ();
            this.field_70145_X = this.func_145771_j(this.field_70165_t, (boundingBox.field_72338_b + boundingBox.field_72337_e) / 2.0, this.field_70161_v);
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
        if (flag || this.field_70173_aa % 25 == 0) {
            if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
                this.field_70181_x = 0.2f;
                this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                this.field_70181_x = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.searchForOtherItemsNearby();
            }
        }
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        if (this.getAge() != Short.MIN_VALUE) {
            this.setAge(this.getAge() + 1);
        }
        this.func_70072_I();
        if (!this.field_70170_p.field_72995_K) {
            double d3 = this.field_70159_w - d0;
            double d4 = this.field_70181_x - d1;
            double d5 = this.field_70179_y - d2;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 > 0.01) {
                this.field_70160_al = true;
            }
            if (this.getAge() >= this.getLifespan()) {
                this.func_70106_y();
            }
        }
        if (item.func_190926_b()) {
            this.func_70106_y();
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return I18n.func_135052_a((String)("item." + this.getItem().func_77977_a()), (Object[])new Object[0]);
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void setItem(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(ITEM, (Object)itemStack);
        this.field_70180_af.func_187217_b(ITEM);
    }

    public void setAge(int ageIn) {
        this.field_70180_af.func_187227_b(age, (Object)ageIn);
    }

    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(age);
    }

    public void setPickupDelay(int delay) {
        this.field_70180_af.func_187227_b(pickupDelay, (Object)delay);
    }

    public int getPickupDelay() {
        return (Integer)this.field_70180_af.func_187225_a(pickupDelay);
    }

    public void setLifespan(int lifespanIn) {
        this.field_70180_af.func_187227_b(lifespan, (Object)lifespanIn);
    }

    public int getLifespan() {
        return (Integer)this.field_70180_af.func_187225_a(lifespan);
    }

    public void setThrower(String throwerIn) {
        this.field_70180_af.func_187227_b(thrower, (Object)throwerIn);
    }

    public String getThrower() {
        return (String)this.field_70180_af.func_187225_a(thrower);
    }

    public void setOwner(String ownerIn) {
        this.field_70180_af.func_187227_b(owner, (Object)ownerIn);
    }

    public String getOwner() {
        return (String)this.field_70180_af.func_187225_a(owner);
    }

    public EntityPlayer getThrowerEntity() {
        try {
            return this.field_70170_p.func_152378_a(UUID.fromString(this.getThrower()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDefaultPickupDelay() {
        this.setPickupDelay(10);
    }

    public void setNoPickupDelay() {
        this.setPickupDelay(0);
    }

    public void setInfinitePickupDelay() {
        this.setPickupDelay(Short.MAX_VALUE);
    }

    public boolean cannotPickup() {
        return this.getPickupDelay() > 0;
    }

    public void setNoDespawn() {
        this.setAge(-6000);
    }

    public boolean func_70075_an() {
        return false;
    }

    @Nullable
    public Entity changeDimension(int dimension, @Nonnull ITeleporter teleporter) {
        Entity entity = super.changeDimension(dimension, teleporter);
        if (!this.field_70170_p.field_72995_K && entity instanceof EntityCreepItem) {
            ((EntityCreepItem)entity).searchForOtherItemsNearby();
        }
        return entity;
    }

    private void searchForOtherItemsNearby() {
    }

    public static void registerFixesItem(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackData(EntityCreepItem.class, new String[]{"Item"}));
    }

    public void makeFakeItem() {
        this.setInfinitePickupDelay();
        ItemStack itemStack = this.getItem();
        this.setAge(itemStack.func_77973_b().getEntityLifespan(itemStack, this.field_70170_p) - 1);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K || this.getPickupDelay() > 0) {
            return;
        }
        ItemStack itemStack = this.getItem();
        Item item = itemStack.func_77973_b();
        int i = itemStack.func_190916_E();
        ItemStack clone = itemStack.func_77946_l();
        String ownerIn = this.getOwner();
        if ((ownerIn.isEmpty() || this.getLifespan() - this.getAge() <= 200 || ownerIn.equals(player.func_70005_c_())) && (i <= 0 || player.field_71071_by.func_70441_a(itemStack) || clone.func_190916_E() > this.getItem().func_190916_E())) {
            clone.func_190920_e(clone.func_190916_E() - this.getItem().func_190916_E());
            if (itemStack.func_190926_b()) {
                player.func_71001_a((Entity)this, i);
                this.func_70106_y();
                itemStack.func_190920_e(i);
            }
            player.func_71064_a(StatList.func_188056_d((Item)item), i);
        }
    }
}

