/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityDesertLizardFireball;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityDesertLizard
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final String[] textures = new String[]{"textures/entity/desertlizard1", "textures/entity/desertlizard2", "textures/entity/desertlizard3", "textures/entity/desertlizard4", "textures/entity/desertlizard5"};

    public EntityDesertLizard(World worldin) {
        super(worldin);
        this.setCreepTypeName("Desert Lizard");
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = 15.0f;
        this.func_70105_a(1.75f, 0.75f);
        this.baseSpeed = 0.25;
        this.baseAttackDamage = 2.0;
        this.field_70728_aV = 10;
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AILizardFireballAttack(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public float func_70047_e() {
        return 0.1f;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_145779_a(Items.field_151157_am, this.field_70146_Z.nextInt(5) + 1);
        }
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_145779_a(Items.field_151103_aS, this.field_70146_Z.nextInt(8) + 1);
        }
    }

    @Override
    protected String[] getAvailableTextures() {
        return textures;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.desertLizardHurt;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.desertLizardDeath;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.desertLizard;
    }

    @Override
    public float maxShrink() {
        return 0.4f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }

    public class AILizardFireballAttack
    extends EntityAIBase {
        public int fireballTime;
        private final EntityDesertLizard parentEntity;

        public AILizardFireballAttack(EntityDesertLizard lizard) {
            this.parentEntity = lizard;
        }

        public boolean func_75250_a() {
            EntityLivingBase entityLivingBase = this.parentEntity.func_70638_az();
            return entityLivingBase != null && entityLivingBase.func_70089_S();
        }

        public void func_75249_e() {
            this.fireballTime = 0;
        }

        public void func_75246_d() {
            double d1;
            --this.fireballTime;
            EntityPlayer entityLivingBase = EntityDesertLizard.this.field_70170_p.func_72890_a((Entity)this.parentEntity, 30.0);
            double d = 64.0;
            if (entityLivingBase != null && EntityDesertLizard.this.func_70685_l((Entity)entityLivingBase) && (d1 = entityLivingBase.func_70068_e((Entity)this.parentEntity)) < d * d && d1 > 10.0 && this.fireballTime <= 0) {
                double d2 = entityLivingBase.field_70165_t - EntityDesertLizard.this.field_70165_t;
                double d3 = entityLivingBase.func_174813_aQ().field_72338_b + (double)(entityLivingBase.field_70131_O / 1.0f) - (EntityDesertLizard.this.field_70163_u + (double)(EntityDesertLizard.this.field_70131_O / 1.0f));
                double d4 = entityLivingBase.field_70161_v - EntityDesertLizard.this.field_70161_v + 0.5;
                EntityDesertLizard.this.field_70761_aq = EntityDesertLizard.this.field_70177_z = -((float)Math.atan2(d2, d4)) * 180.0f / (float)Math.PI;
                EntityDesertLizardFireball fireball = new EntityDesertLizardFireball(EntityDesertLizard.this.field_70170_p, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                double d5 = 2.0;
                Vec3d vec3d = this.parentEntity.func_70676_i(1.0f);
                fireball.field_70165_t = EntityDesertLizard.this.field_70165_t + vec3d.field_72450_a * d5;
                fireball.field_70163_u = EntityDesertLizard.this.field_70163_u + (double)(EntityDesertLizard.this.field_70131_O / 2.0f) + 0.5;
                fireball.field_70161_v = EntityDesertLizard.this.field_70161_v + vec3d.field_72449_c * d5;
                this.parentEntity.func_184185_a(CreepsSoundHandler.desertLizardFireball, 1.0f, 1.0f);
                EntityDesertLizard.this.field_70170_p.func_72838_d((Entity)fireball);
                this.fireballTime = 180;
            }
        }
    }
}

