/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.helpers.EffectHelper;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDevRay
extends Entity
implements IProjectile {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70067_L();
        }
    }});
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityDevRay.class, (DataSerializer)DataSerializers.field_187191_a);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    protected boolean inGround;
    public Entity shootingEntity;
    private int ticksInAir;
    private double damage = 50.0;

    public EntityDevRay(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
        this.func_189654_d(true);
    }

    public EntityDevRay(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityDevRay(World worldIn, EntityLivingBase shooter) {
        this(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.shootingEntity = shooter;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityDevRay.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != null && axisalignedbb != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.inGround) {
            int j = block.func_176201_c(iblockstate);
            if (!(block == this.inTile && j == this.inData || this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05)))) {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInAir = 0;
            } else {
                this.func_70106_y();
            }
        } else {
            Entity entity;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onHit(raytraceresult);
            }
            this.checkMeltBlock(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.checkMeltBlock(this.field_70165_t + 1.0, this.field_70163_u, this.field_70161_v);
            this.checkMeltBlock(this.field_70165_t - 1.0, this.field_70163_u, this.field_70161_v);
            this.checkMeltBlock(this.field_70165_t, this.field_70163_u, this.field_70161_v - 1.0);
            this.checkMeltBlock(this.field_70165_t, this.field_70163_u, this.field_70161_v + 1.0);
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            this.field_70159_w *= (double)f1;
            this.field_70181_x *= (double)f1;
            this.field_70179_y *= (double)f1;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.05f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.ticksInAir >= 100) {
                this.func_70106_y();
            }
            this.func_145775_I();
        }
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity == this) {
            this.func_70106_y();
        }
        if (entity != null) {
            DamageSource damagesource;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int i = MathHelper.func_76143_f((double)((double)f * this.damage));
            if (this.shootingEntity == null) {
                damagesource = DamageSource.func_76356_a((Entity)this, (Entity)this);
            } else {
                damagesource = DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity);
                this.func_70106_y();
            }
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
                this.func_70106_y();
            }
            if (entity.func_70097_a(damagesource, (float)i)) {
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(CreepsSoundHandler.raygunSound, 0.2f, 1.0f / (this.field_70146_Z.nextFloat() * 0.1f + 0.95f));
                this.blast();
                if (!(entity instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    this.func_70106_y();
                }
            }
        } else {
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.inData = this.inTile.func_176201_c(iblockstate);
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.func_184185_a(CreepsSoundHandler.raygunSound, 0.2f, 1.0f / (this.field_70146_Z.nextFloat() * 0.1f + 0.95f));
            this.blast();
            this.inGround = true;
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
                if (!this.field_70170_p.field_72995_K && this.inTile != Blocks.field_150357_h && this.field_70146_Z.nextInt(3) == 0) {
                    if (MoreCreepsConfig.rayGunFire) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                    } else {
                        this.field_70170_p.func_175698_g(blockpos);
                    }
                }
                this.func_70106_y();
            }
        }
    }

    private void blast() {
        for (int i = 0; i < 8; ++i) {
            EffectHelper.smokeRay(this.field_70170_p, this, this.field_70146_Z);
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        if (this.inGround) {
            this.xTile = MathHelper.func_76128_c((double)this.field_70165_t);
            this.yTile = MathHelper.func_76128_c((double)this.field_70163_u);
            this.zTile = MathHelper.func_76128_c((double)this.field_70161_v);
        }
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        double d0 = 0.0;
        for (Entity entity1 : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS)) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            if (entity1 == this.shootingEntity && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        try {
            ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
            compound.func_74778_a("inTile", resourcelocation.toString());
        }
        catch (Exception ignored) {
            compound.func_74778_a("inTile", "");
        }
        compound.func_74774_a("inData", (byte)this.inData);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        compound.func_74780_a("damage", this.damage);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.inTile = compound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)compound.func_74779_i("inTile")) : Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inData = compound.func_74771_c("inData") & 0xFF;
        boolean bl = this.inGround = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    private void checkMeltBlock(double x, double y, double z) {
        if (!MoreCreepsConfig.rayGunMelt) {
            return;
        }
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150432_aD) {
            this.field_70170_p.func_175656_a(blockPos, Blocks.field_150355_j.func_176223_P());
        }
    }

    private void checkFireBlock(double x, double y, double z) {
        if (!MoreCreepsConfig.rayGunFire) {
            return;
        }
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        if (this.field_70170_p.func_175623_d(blockPos)) {
            this.field_70170_p.func_175656_a(blockPos, Blocks.field_150480_ab.func_176223_P());
        }
    }
}

