/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityEvilCreature
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private static final DataParameter<Boolean> jumping = EntityDataManager.func_187226_a(EntityEvilCreature.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityEvilCreature(World world) {
        super(world);
        this.setCreepTypeName("Evil Creature");
        this.creatureType = EnumCreatureType.MONSTER;
        this.func_70105_a(this.field_70130_N * 3.0f, this.field_70131_O * 3.0f);
        this.setModelSize(3.0f);
        this.baseHealth = (float)this.field_70146_Z.nextInt(75) + 35.0f;
        this.baseSpeed = 0.2;
        this.baseAttackDamage = 3.0;
        this.field_70178_ae = true;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(jumping, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/evilcreature.png");
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.evilCreatureSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.evilCreatureHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.evilCreatureDeathSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_145779_a(Items.field_151025_P, this.field_70146_Z.nextInt(3) + 1);
        } else {
            this.func_145779_a(Items.field_151115_aP, this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    protected boolean shouldJumpWhileAttacking(Entity entity) {
        return true;
    }

    protected float func_70599_aP() {
        return 1.0f * (this.getModelSize() / 3.0f);
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f + (3.0f - this.getModelSize()) * 2.0f;
    }

    @Override
    protected void doAttackJump(Entity entity) {
        if (this.getJumping()) {
            this.field_70180_af.func_187227_b(jumping, (Object)false);
            this.func_184185_a(CreepsSoundHandler.evilCreatureJumpSound, this.func_70599_aP(), this.func_70647_i());
            for (Entity ent : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(18.0, 18.0, 18.0))) {
                if (!(ent instanceof EntityLiving) || ent.func_70072_I() || !ent.field_70122_E) continue;
                double dist = this.func_70032_d(ent);
                ent.field_70181_x += (17.0 - dist) * (double)0.067058f * (double)(this.getModelSize() / 3.0f);
            }
        }
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(entity.field_70161_v - this.field_70161_v, entity.field_70165_t - this.field_70165_t)) - 90.0f;
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        this.field_70159_w = d0 / f * 0.5 * 0.40000000192092894 + this.field_70159_w * 0.20000000098023224;
        this.field_70179_y = d1 / f * 0.5 * 0.30000000192092896 + this.field_70179_y * 0.20000000098023224;
        this.field_70181_x = 0.35f;
        this.field_70143_R = -25.0f;
        this.field_70180_af.func_187227_b(jumping, (Object)true);
    }

    @Override
    public boolean func_70652_k(@Nonnull Entity entity) {
        AxisAlignedBB myBB = this.func_174813_aQ();
        AxisAlignedBB theirBB = entity.func_174813_aQ();
        if (theirBB.field_72337_e > myBB.field_72338_b && theirBB.field_72338_b < myBB.field_72337_e) {
            entity.field_70181_x += (double)0.77f;
        }
        return super.func_70652_k(entity);
    }

    public void func_70637_d(boolean b) {
        super.func_70637_d(b);
        this.field_70180_af.func_187227_b(jumping, (Object)b);
    }

    public boolean getJumping() {
        return (Boolean)this.field_70180_af.func_187225_a(jumping);
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    public float maxShrink() {
        return 0.7f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 7.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

