/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityEvilSnowman
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private int updateSizeTime = 0;

    public EntityEvilSnowman(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Evil Snowman");
        this.creatureType = EnumCreatureType.MONSTER;
        this.func_70105_a(0.7f, 1.5f);
        this.baseHealth = 25.0f;
        this.baseSpeed = 0.3;
        this.field_70178_ae = true;
        this.updateAttributes();
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/evilsnowman.png");
    }

    @Override
    public boolean func_70601_bi() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.snowmanSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.snowmanHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.snowmanDeathSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150432_aD), this.field_70146_Z.nextInt(3) + 1);
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150433_aE), this.field_70146_Z.nextInt(10) + 1);
        } else {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150433_aE), this.field_70146_Z.nextInt(5) + 2);
        }
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    public void func_70636_d() {
        int z;
        int y;
        int x;
        super.func_70636_d();
        if (!this.field_70122_E && !this.field_70703_bu) {
            this.field_70181_x -= (double)0.002f;
        }
        if (this.field_70170_p.func_180495_p(new BlockPos(x = MathHelper.func_76128_c((double)this.field_70165_t), (y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b)) - 1, z = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == Blocks.field_150433_aE) {
            this.setModelSize(this.getModelSize() + 0.001f);
        } else {
            this.setModelSize(this.getModelSize() + 0.002f);
        }
        if (this.field_70171_ac) {
            this.setModelSize(this.getModelSize() - 0.02f);
        }
        if (this.getModelSize() > 6.0f) {
            this.setModelSize(6.0f);
        }
        float f = this.getModelSize();
        if (this.updateSizeTime-- < 1) {
            this.func_70105_a(f * 0.45f, f * 2.0f);
            this.updateSizeTime = 100;
        }
        if ((double)f < 0.05) {
            this.func_70106_y();
        }
    }

    @Override
    protected boolean shouldJumpWhileAttacking(Entity entity) {
        return true;
    }

    @Override
    protected void doAttackJump(Entity entity) {
        for (int i = 0; i < 8; ++i) {
            this.func_184185_a(CreepsSoundHandler.snowmanBounceSound, 1.0f, 2.0f - this.getModelSize());
            this.field_70170_p.func_175688_a(EnumParticleTypes.SNOWBALL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        double d = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        this.field_70159_w = d / (double)f1 * 0.5 * 0.30000000192092896 + this.field_70159_w * 0.20000000098023224;
        this.field_70179_y = d1 / (double)f1 * 0.5 * 0.25000000192092897 + this.field_70179_y * 0.20000000098023224;
        this.field_70181_x = 0.3500000019604645;
        if (this.field_70146_Z.nextInt(20) == 0) {
            double d2 = -MathHelper.func_76126_a((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
            double d5 = MathHelper.func_76134_b((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
            this.field_70159_w -= d2 * (double)0.4f;
            this.field_70179_y -= d5 * (double)0.4f;
        }
        if (this.field_70146_Z.nextInt(20) == 0) {
            double d3 = -MathHelper.func_76126_a((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
            this.field_70159_w -= d3 * 1.0;
            this.field_70181_x += (double)0.166f;
        }
        if (this.field_70146_Z.nextInt(40) == 0) {
            double d4 = -MathHelper.func_76126_a((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
            double d7 = MathHelper.func_76134_b((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
            this.field_70159_w -= d4 * (double)0.3f;
            this.field_70179_y -= d7 * (double)0.3f;
            this.field_70181_x += (double)0.766f;
        }
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        Entity entity;
        boolean flag = super.func_70097_a(source, amount);
        if (flag && (entity = source.func_76346_g()) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            double d = -MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f));
            double d1 = MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f));
            this.field_70159_w += d * 2.0;
            this.field_70179_y += d1 * 2.0;
            this.setModelSize(this.getModelSize() - 0.02f);
        }
        return flag;
    }

    public void func_180430_e(float dist, float damage) {
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f + (1.0f - this.getModelSize()) * 2.0f;
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double xRatio, double zRatio) {
        float f = this.getModelSize();
        for (int j = 0; j < 8 + (int)(f * 20.0f); ++j) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SNOWBALL, this.field_70165_t, this.field_70163_u + (double)f, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        strength *= strength;
        this.field_70181_x += (double)0.333f;
        super.func_70653_a(entity, strength, xRatio *= (double)8.2f, zRatio *= (double)8.3f);
    }

    @Override
    public float maxShrink() {
        return 0.7f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 7.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

