/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityRay;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityFloob
extends EntityCreepBase
implements IRangedAttackMob,
IMob,
IEntityCanChangeSize {
    public EntityFloob(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Floob");
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = (float)this.field_70146_Z.nextInt(15) + 10.0f;
        this.baseSpeed = 0.3;
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(CreepsItemHandler.floobRaygun));
        this.updateAttributes();
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/floob.png");
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 25, 75, 50.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        if (MoreCreepsConfig.floobTargetVillagers) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, true));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
    }

    public int func_70641_bl() {
        return 1;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.floobSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.floobHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.floobDeathSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.func_145779_a(CreepsItemHandler.raygun, 1);
        }
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        EntityRay ray = new EntityRay(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - ray.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        ray.func_70186_c(d0, d1, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.field_70170_p.func_72838_d((Entity)ray);
        this.func_184185_a(CreepsSoundHandler.raygunSound, this.func_70599_aP(), this.func_70647_i());
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

