/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityHippo
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final String[] textures = new String[]{"textures/entity/hippo2"};

    public EntityHippo(World worldin) {
        super(worldin);
        this.setCreepTypeName("Hippo");
        this.func_70105_a(2.5f, 2.0f);
        this.setModelSize(2.0f);
        this.baseHealth = 35.0f;
        this.baseSpeed = 0.2;
        this.baseAttackDamage = 2.0;
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new GoToWaterGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    protected String[] getAvailableTextures() {
        return textures;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(3) == 1) {
            this.func_145779_a(Items.field_151120_aE, this.field_70146_Z.nextInt(5) + 3);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.hippoHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.hippoDeathSound;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.hippoAmbientSound;
    }

    public int func_70641_bl() {
        return 2;
    }

    @Override
    public float maxShrink() {
        return 0.3f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.25f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 3.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.25f;
    }

    @Override
    public void onGrow(EntityGrow source) {
        this.increaseMoveSpeed(0.15f);
    }

    public static class GoToWaterGoal
    extends EntityAIMoveToBlock {
        private final EntityHippo hippo;
        private boolean isAboveDestination2;
        private int timeoutCounter2;
        private double speed;

        public GoToWaterGoal(EntityHippo hippo, double speed) {
            super((EntityCreature)hippo, speed, 24);
            this.hippo = hippo;
            this.speed = speed;
        }

        public boolean func_75253_b() {
            return !this.hippo.func_70090_H() && this.timeoutCounter2 <= 1200 && this.func_179488_a(this.hippo.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            if (this.hippo.func_70631_g_() && !this.hippo.func_70090_H()) {
                return this.shouldExecute2();
            }
            return !this.hippo.func_70090_H() && this.shouldExecute2();
        }

        public boolean shouldExecute2() {
            if (this.field_179496_a > 0) {
                --this.field_179496_a;
                return false;
            }
            this.field_179496_a = 200 + this.hippo.func_70681_au().nextInt(200);
            return this.searchForDestination2();
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.timeoutCounter2 = 0;
        }

        private boolean searchForDestination2() {
            int i = 24;
            BlockPos blockpos = new BlockPos((Entity)this.hippo);
            int k = -1;
            while (k <= 1) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            BlockPos blockpos1 = blockpos.func_177982_a(i1, k - 1, j1);
                            if (this.hippo.func_180485_d(blockpos1) && this.func_179488_a(this.hippo.field_70170_p, blockpos1)) {
                                this.field_179494_b = blockpos1;
                                return true;
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            return false;
        }

        public void func_75246_d() {
            if (this.hippo.func_174831_c(this.field_179494_b.func_177984_a()) > 1.0) {
                this.isAboveDestination2 = false;
                ++this.timeoutCounter2;
                if (this.timeoutCounter2 % 160 == 0) {
                    this.hippo.func_70661_as().func_75492_a((double)this.field_179494_b.func_177958_n() + 0.5, (double)(this.field_179494_b.func_177956_o() + 1), (double)this.field_179494_b.func_177952_p() + 0.5, this.speed);
                }
            } else {
                this.isAboveDestination2 = true;
                --this.timeoutCounter2;
            }
        }

        protected boolean func_179487_f() {
            return this.isAboveDestination2;
        }

        protected boolean func_179488_a(World worldIn, BlockPos pos) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return block == Blocks.field_150355_j;
        }
    }
}

