/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityDogHouse;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntityHotdog
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final DataParameter<Boolean> heavenBuilt = EntityDataManager.func_187226_a(EntityHotdog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String[] textures = new String[]{"textures/entity/hotdg1", "textures/entity/hotdg2", "textures/entity/hotdg3"};
    private static final String[] names = new String[]{"Pogo", "Spot", "King", "Prince", "Bosco", "Ralph", "Wendy", "Trixie", "Bowser", "The Heat", "Weiner", "Wendon the Weiner", "Wallace the Weiner", "William the Weiner", "Terrance", "Elijah", "Good Boy", "Boy", "Girl", "Tennis Shoe", "Rusty", "Mean Joe Green", "Lawrence", "Foxy", "SlyFoxHound", "Leroy Brown", "Mickey", "Holly", "Yeontan"};
    private static final String[] levelNames = new String[]{"Just A Pup", "Hotdog", "A Dirty Dog", "An Alley Dog", "Scrapyard Puppy", "Army Dog", "Private", "Private First Class", "Corporal", "Sergeant", "Staff Sergeant", "Sergeant First Class", "Master Segeant", "First Sergeant", "Sergeant Major", "Command Sergeant Major", "Second Lieutenant", "First Lieutenant", "Captain", "Major", "Lieutenant Colonel", "Colonel", "General of the Hotdog Army", "General of the Hotdog Army", "Sparky the Wonder Pooch", "Sparky the Wonder Pooch"};
    private static final int[] levelDamages = new int[]{0, 50, 100, 250, 500, 800, 1200, 1700, 2200, 2700, 3300, 3900, 4700, 5400, 6200, 7000, 7900, 8800, 9750, 10750, 12500, 17500, 22500, 30000, 40000, 50000, 60000};

    public EntityHotdog(World world) {
        super(world);
        this.setCreepTypeName("Hotdog");
        this.func_70105_a(0.5f, 0.75f);
        this.setModelSize(0.6f);
        this.baseHealth = (float)this.field_70146_Z.nextInt(15) + 5.0f;
        this.baseSpeed = 0.35f;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(heavenBuilt, (Object)false);
    }

    public int func_70641_bl() {
        return 2;
    }

    protected SoundEvent func_184639_G() {
        if (!this.func_184218_aH()) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                return CreepsSoundHandler.hotdogSound;
            }
        } else if (this.field_70146_Z.nextInt(10) == 0) {
            return SoundEvents.field_187865_gI;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.hotdogHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.hotdogDeathSound;
    }

    @Override
    protected SoundEvent getMountSound() {
        return CreepsSoundHandler.hotdogPickupSound;
    }

    @Override
    protected SoundEvent getUnmountSound() {
        return CreepsSoundHandler.hotdogPutDownSound;
    }

    @Override
    protected SoundEvent getEatSound() {
        return CreepsSoundHandler.hotdogEatSound;
    }

    @Override
    protected SoundEvent getKillSound() {
        return CreepsSoundHandler.hotdogKillSound;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return CreepsSoundHandler.hotdogAttackSound;
    }

    @Override
    protected SoundEvent getLevelUpSound() {
        return CreepsSoundHandler.guineaPigLevelUpSound;
    }

    @Override
    protected SoundEvent getSpeedUpSound() {
        return CreepsSoundHandler.guineaPigSpeedUpSound;
    }

    @Override
    protected SoundEvent getSpeedDownSound() {
        return CreepsSoundHandler.guineaPigSpeedDownSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        this.func_145779_a(Items.field_151147_al, 1);
    }

    @Override
    protected String[] getTamedNames() {
        return names;
    }

    @Override
    protected String[] getAvailableTextures() {
        return textures;
    }

    @Override
    public boolean isTamable() {
        return true;
    }

    @Override
    public boolean isStackable() {
        return true;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    @Override
    public String getLevelName() {
        return levelNames[this.getLevel()];
    }

    @Override
    public int getLevelDamage() {
        return levelDamages[this.getLevel()];
    }

    @Override
    public int getMaxLevel() {
        return 25;
    }

    @Override
    public void onRevive(NBTTagCompound compound) {
        super.onRevive(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsHotDog");
        this.setHeavenBuilt(props.func_74767_n("HeavenBuilt"));
    }

    @Override
    public void onTombstoneCreate(NBTTagCompound compound) {
        super.onTombstoneCreate(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsHotDog");
        props.func_74757_a("HeavenBuilt", this.getHeavenBuilt());
        compound.func_74782_a("MoreCreepsHeavenBuilt", (NBTBase)props);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (!itemStack.func_190926_b()) {
            Item item = itemStack.func_77973_b();
            if (this.isTamed() && this.isPlayerOwner(player)) {
                if (item == Items.field_151045_i) {
                    if (this.func_184218_aH()) {
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString("Put your Hotdog down before building the Hotdog Heaven!"));
                        }
                    } else if (!this.getHeavenBuilt()) {
                        if (this.getLevel() >= 25) {
                            if (this.buildHeaven(player, MathHelper.func_76128_c((double)player.field_70165_t) + 2, MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)player.field_70161_v) + 2)) {
                                this.func_184185_a(SoundEvents.field_187904_gd, 1.0f, 0.5f);
                                itemStack.func_190918_g(1);
                            }
                        } else if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString("Your Hotdog must be level 25 to build a Hotdog Heaven."));
                            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7b" + this.getCreepName() + " is only level \u00a7f" + this.getLevel() + "."));
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentString("\u00a7b" + this.getCreepName() + "\u00a7f has already built a Hotdog Heaven."));
                    }
                    return true;
                }
                if (item == Item.func_150898_a((Block)Blocks.field_150328_O) || item == Item.func_150898_a((Block)Blocks.field_150327_N)) {
                    this.smokePlain();
                    switch (this.getWanderState()) {
                        case 0: {
                            if (!this.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentString("\u00a73" + this.getCreepName() + "\u00a76 will \u00a7dWANDER\u00a76 around and have fun."));
                            }
                            this.setWanderState(1);
                            break;
                        }
                        case 1: {
                            if (!this.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentString("\u00a73" + this.getCreepName() + "\u00a76 will \u00a7dFIGHT\u00a76 and follow you!"));
                            }
                            this.setWanderState(2);
                            break;
                        }
                        case 2: {
                            if (!this.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentString("\u00a73" + this.getCreepName() + "\u00a76 will \u00a7dSTAY\u00a76 right here."));
                            }
                            this.setWanderState(0);
                            break;
                        }
                    }
                    itemStack.func_190918_g(1);
                    return true;
                }
                if (item == Items.field_151120_aE) {
                    this.giveSpeedBoost(13000);
                    itemStack.func_190918_g(1);
                    return true;
                }
                if (item == Items.field_151021_T || item == Items.field_151027_R || item == Items.field_151024_Q || item == Items.field_151026_S) {
                    this.setArmor(1);
                    this.func_70606_j(this.func_110138_aP());
                    this.smoke();
                    this.func_184185_a(CreepsSoundHandler.guineaPigArmorSound, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    itemStack.func_190918_g(1);
                    return true;
                }
                if (item == Items.field_151151_aj || item == Items.field_151171_ah || item == Items.field_151169_ag || item == Items.field_151149_ai) {
                    this.setArmor(2);
                    this.func_70606_j(this.func_110138_aP());
                    this.smoke();
                    this.func_184185_a(CreepsSoundHandler.guineaPigArmorSound, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    itemStack.func_190918_g(1);
                    return true;
                }
                if (item == Items.field_151167_ab || item == Items.field_151030_Z || item == Items.field_151028_Y || item == Items.field_151165_aa) {
                    this.setArmor(3);
                    this.func_70606_j(this.func_110138_aP());
                    this.smoke();
                    this.func_184185_a(CreepsSoundHandler.guineaPigArmorSound, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    itemStack.func_190918_g(1);
                    return true;
                }
                if (item == Items.field_151175_af || item == Items.field_151163_ad || item == Items.field_151161_ac || item == Items.field_151173_ae) {
                    this.setArmor(4);
                    this.func_70606_j(this.func_110138_aP());
                    this.smoke();
                    this.func_184185_a(CreepsSoundHandler.guineaPigArmorSound, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    itemStack.func_190918_g(1);
                    return true;
                }
            }
            if (item == Items.field_151110_aK) {
                this.func_184185_a(SoundEvents.field_187904_gd, 1.0f, 0.5f);
                this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
                this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
                this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
                double d = this.field_70159_w / 100.0;
                double d1 = this.field_70179_y / 100.0;
                for (int i = 0; i < 2000; ++i) {
                    this.func_70091_d(MoverType.SELF, d, 0.0, d1);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                }
                this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.1f, true);
                this.func_70106_y();
                itemStack.func_190918_g(1);
                return true;
            }
            if (item == Items.field_151103_aS) {
                this.feed(player, 10.0f, 15);
                this.smoke();
                itemStack.func_190918_g(1);
                return true;
            }
            if (item == Items.field_151147_al) {
                this.feed(player, 15.0f, 30);
                this.smoke();
                itemStack.func_190918_g(1);
                return true;
            }
            if (item == Items.field_151157_am) {
                this.feed(player, 25.0f, 55);
                this.smoke();
                itemStack.func_190918_g(1);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void updateModelSize() {
        float dogSize = 0.6f + (float)(this.getLevel() - 1) * 0.05f;
        if (dogSize > 1.5f) {
            dogSize = 1.5f;
        }
        this.setModelSize(dogSize);
    }

    protected void setHeavenBuilt(boolean b) {
        this.field_70180_af.func_187227_b(heavenBuilt, (Object)b);
    }

    public boolean getHeavenBuilt() {
        return (Boolean)this.field_70180_af.func_187225_a(heavenBuilt);
    }

    @Override
    protected boolean canUseTamableMenu() {
        return true;
    }

    @Override
    protected SoundEvent getTamedSound() {
        return CreepsSoundHandler.hotdogTamedSound;
    }

    private boolean buildHeaven(EntityPlayer player, int x, int y, int z) {
        int i;
        if (y > 95) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are too far up to build Hotdog Heaven!"));
            return false;
        }
        int byte0 = 40;
        int byte1 = 40;
        int l = (105 - y) / 2;
        int area = 0;
        for (int h = 0; h < l * 2; ++h) {
            for (i = -2; i < byte0 + 2; ++i) {
                for (int j = -2; j < byte1 + 2; ++j) {
                    if (this.field_70170_p.func_175623_d(new BlockPos(x + i, y + h, z + j))) continue;
                    ++area;
                }
            }
        }
        if (area < 3000) {
            int i2;
            int i3;
            BlockPos blockPos;
            int i4;
            int q;
            int q2;
            int i5;
            this.setHeavenBuilt(true);
            this.func_184185_a(CreepsSoundHandler.hotdogHeavenSound, this.func_70599_aP(), this.func_70647_i());
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("HOT DOG HEAVEN HAS BEEN BUILT!"));
            }
            this.field_70170_p.func_175656_a(new BlockPos(x, y, z), Blocks.field_150344_f.func_176223_P());
            this.field_70170_p.func_175656_a(new BlockPos(x, y + 1, z), Blocks.field_150478_aa.func_176223_P());
            this.field_70170_p.func_175656_a(new BlockPos(x + 5, y, z), Blocks.field_150344_f.func_176223_P());
            this.field_70170_p.func_175656_a(new BlockPos(x + 5, y + 1, z), Blocks.field_150344_f.func_176223_P());
            for (i5 = 0; i5 < l; ++i5) {
                for (q2 = 0; q2 < 4; ++q2) {
                    this.field_70170_p.func_175656_a(new BlockPos(x + q2 + 1, y + i5, z + i5), Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
                }
            }
            for (i5 = 0; i5 < l - 1; ++i5) {
                for (q2 = 0; q2 < 4; ++q2) {
                    this.field_70170_p.func_175656_a(new BlockPos(x - q2, y + l + i5, z + l - i5), Blocks.field_150476_ad.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
                }
            }
            boolean flag = false;
            for (i = 0; i < 10; ++i) {
                this.field_70170_p.func_175656_a(new BlockPos(x - i + 5, y + l, z + l + 6), Blocks.field_180407_aO.func_176223_P());
                for (q = 0; q < 7; ++q) {
                    this.field_70170_p.func_175656_a(new BlockPos(x + 5, y + l, z + l + q), Blocks.field_180407_aO.func_176223_P());
                    this.field_70170_p.func_175656_a(new BlockPos(x - 4, y + l, z + l + q), Blocks.field_180407_aO.func_176223_P());
                    boolean bl = flag = !flag;
                    if (flag) {
                        this.field_70170_p.func_175656_a(new BlockPos(x + 5, y + l + 1, z + l + q), Blocks.field_150478_aa.func_176223_P());
                        this.field_70170_p.func_175656_a(new BlockPos(x - 4, y + l + 1, z + l + q), Blocks.field_150478_aa.func_176223_P());
                    }
                    this.field_70170_p.func_175656_a(new BlockPos(x - i + 5, y + l - 1, z + l + q), Blocks.field_150344_f.func_176223_P());
                }
            }
            for (i = 0; i < byte0; ++i) {
                for (q = 0; q < byte1; ++q) {
                    for (int k = -this.field_70146_Z.nextInt(3) - 2; k < 1; ++k) {
                        if (k < 0) {
                            this.field_70170_p.func_175656_a(new BlockPos(x + i - byte0 / 2, y + l * 2 + k - 2, z + q - byte1), Blocks.field_150346_d.func_176223_P());
                            continue;
                        }
                        this.field_70170_p.func_175656_a(new BlockPos(x + i - byte0 / 2, y + l * 2 + k - 2, z + q - byte1 + 2), Blocks.field_150349_c.func_176223_P());
                    }
                }
            }
            int randInt = this.field_70146_Z.nextInt(10) + 2;
            for (i4 = 0; i4 < randInt; ++i4) {
                this.field_70170_p.func_175656_a(new BlockPos(x + this.field_70146_Z.nextInt(byte0 - 10) - byte0 / 2, y + l * 2 - 1, z + this.field_70146_Z.nextInt(byte1 - 6) - byte1), Blocks.field_150330_I.func_176223_P());
            }
            randInt = this.field_70146_Z.nextInt(10) + 2;
            for (i4 = 0; i4 < randInt; ++i4) {
                this.field_70170_p.func_175656_a(new BlockPos(x + this.field_70146_Z.nextInt(byte0 - 10) - byte0 / 2, y + l * 2 - 1, z + this.field_70146_Z.nextInt(byte1 - 6) - byte1), Blocks.field_150327_N.func_176223_P());
            }
            randInt = this.field_70146_Z.nextInt(10) + 2;
            for (i4 = 0; i4 < randInt; ++i4) {
                this.field_70170_p.func_175656_a(new BlockPos(x + this.field_70146_Z.nextInt(byte0 - 10) - byte0 / 2, y + l * 2 - 1, z + this.field_70146_Z.nextInt(byte1 - 6) - byte1), Blocks.field_150328_O.func_176223_P());
            }
            randInt = this.field_70146_Z.nextInt(30) + 2;
            for (i4 = 0; i4 < randInt; ++i4) {
                int l7;
                int j6 = this.field_70146_Z.nextInt(byte0 - 12);
                blockPos = new BlockPos(x + j6 - byte0 / 2, y + l * 2 - 1, z + (l7 = this.field_70146_Z.nextInt(byte1 - 8)) - byte1);
                if (!this.field_70170_p.func_175623_d(blockPos)) continue;
                this.field_70170_p.func_175656_a(blockPos, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS));
            }
            randInt = this.field_70146_Z.nextInt(50) + 2;
            for (i4 = 0; i4 < randInt; ++i4) {
                int i8;
                int k6 = this.field_70146_Z.nextInt(byte0 - 12);
                blockPos = new BlockPos(x + k6 - byte0 / 2, y + l * 2 - 1, z + (i8 = this.field_70146_Z.nextInt(byte1 - 8)) - byte1);
                if (!this.field_70170_p.func_175623_d(blockPos)) continue;
                this.field_70170_p.func_175656_a(blockPos, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN));
            }
            for (i4 = 1; i4 < byte0 - 1; ++i4) {
                this.field_70170_p.func_175656_a(new BlockPos(x + i4 - byte0 / 2, y + l * 2 - 1, z - byte1 + 3), Blocks.field_180407_aO.func_176223_P());
                this.field_70170_p.func_175656_a(new BlockPos(x + i4 - byte0 / 2, y + l * 2 - 1, z), Blocks.field_180407_aO.func_176223_P());
                boolean bl = flag = !flag;
                if (!flag) continue;
                this.field_70170_p.func_175656_a(new BlockPos(x + i4 - byte0 / 2, y + l * 2, z - byte1 + 3), Blocks.field_150478_aa.func_176223_P());
                this.field_70170_p.func_175656_a(new BlockPos(x + i4 - byte0 / 2, y + l * 2, z), Blocks.field_150478_aa.func_176223_P());
            }
            for (i4 = 4; i4 < byte1; ++i4) {
                this.field_70170_p.func_175656_a(new BlockPos(x - byte0 / 2 + 1, y + l * 2 - 1, z + i4 - byte1), Blocks.field_180407_aO.func_176223_P());
                this.field_70170_p.func_175656_a(new BlockPos(x + byte0 - byte0 / 2 - 2, y + l * 2 - 1, z + i4 - byte1), Blocks.field_180407_aO.func_176223_P());
                boolean bl = flag = !flag;
                if (!flag) continue;
                this.field_70170_p.func_175656_a(new BlockPos(x - byte0 / 2 + 1, y + l * 2, z + i4 - byte1), Blocks.field_150478_aa.func_176223_P());
                this.field_70170_p.func_175656_a(new BlockPos(x + byte0 - byte0 / 2 - 2, y + l * 2, z + i4 - byte1), Blocks.field_150478_aa.func_176223_P());
            }
            this.field_70170_p.func_175656_a(new BlockPos(x - 1, y + l * 2 - 1, z), Blocks.field_180390_bo.func_176223_P());
            this.field_70170_p.func_175656_a(new BlockPos(x - 2, y + l * 2 - 1, z), Blocks.field_180390_bo.func_176223_P());
            for (i4 = 0; i4 < 6; ++i4) {
                EntityDogHouse dogHouse = new EntityDogHouse(this.field_70170_p);
                dogHouse.func_70012_b(x + 15, y + l * 2 - 1, z - 7 - i4 * 5, 90.0f, 0.0f);
                dogHouse.setInitialHealth();
                dogHouse.determineBaseTexture();
                this.field_70170_p.func_72838_d((Entity)dogHouse);
            }
            randInt = this.field_70146_Z.nextInt(15) + 5;
            for (i4 = 0; i4 < randInt; ++i4) {
                int l6 = this.field_70146_Z.nextInt(byte0 - 10) + 3;
                int j8 = this.field_70146_Z.nextInt(byte1 - 6) + 3;
                blockPos = new BlockPos(x + l6 - byte0 / 2, y + l * 2 - 1, z + j8 - byte1);
                this.field_70170_p.func_175656_a(blockPos, Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(1)));
                ((BlockSapling)Blocks.field_150345_g).func_176478_d(this.field_70170_p, blockPos, this.field_70170_p.func_180495_p(blockPos), this.field_70146_Z);
            }
            randInt = byte0 / 2 + this.field_70146_Z.nextInt(10) - 5 + 8;
            for (i4 = byte0 / 2 + this.field_70146_Z.nextInt(8) - 8; i4 < randInt; ++i4) {
                int randInt2 = byte1 / 2 + this.field_70146_Z.nextInt(10) - 5 + 8;
                for (int q3 = byte1 / 2 + this.field_70146_Z.nextInt(8) - 8; q3 < randInt2; ++q3) {
                    this.field_70170_p.func_175656_a(new BlockPos(x + i4 - byte0 / 2, y + l * 2 - 2, z + q3 - byte1), Blocks.field_150355_j.func_176223_P());
                    this.field_70170_p.func_175656_a(new BlockPos(x + i4 - byte0 / 2, y + l * 2 - 3, z + q3 - byte1), Blocks.field_150355_j.func_176223_P());
                }
            }
            BlockPos chest1Pos = new BlockPos(x + 7, y + l * 2 - 1, z - 5);
            this.field_70170_p.func_175656_a(chest1Pos, Blocks.field_150486_ae.func_176223_P());
            TileEntityChest chest1 = new TileEntityChest();
            this.field_70170_p.func_175690_a(chest1Pos, (TileEntity)chest1);
            BlockPos chest2Pos = new BlockPos(x + 7, y + l * 2 - 1, z - 6);
            this.field_70170_p.func_175656_a(chest2Pos, Blocks.field_150486_ae.func_176223_P());
            TileEntityChest chest2 = new TileEntityChest();
            this.field_70170_p.func_175690_a(chest2Pos, (TileEntity)chest2);
            int maxI = chest1.func_70302_i_() - 9;
            for (i3 = 0; i3 < maxI; ++i3) {
                chest1.func_70299_a(i3, new ItemStack(Items.field_151103_aS, 32));
                chest2.func_70299_a(i3, new ItemStack(Items.field_151137_ax, 32));
            }
            maxI = chest1.func_70302_i_();
            for (i3 = maxI - 9; i3 < maxI; ++i3) {
                chest1.func_70299_a(i3, new ItemStack((Item)Items.field_151169_ag, 1));
                chest2.func_70299_a(i3, new ItemStack(Items.field_151043_k, 1));
            }
            BlockPos chest3Pos = new BlockPos(x - 7, y + l * 2 - 1, z - 5);
            this.field_70170_p.func_175656_a(chest3Pos, Blocks.field_150486_ae.func_176223_P());
            TileEntityChest chest3 = new TileEntityChest();
            this.field_70170_p.func_175690_a(chest3Pos, (TileEntity)chest3);
            BlockPos chest4Pos = new BlockPos(x - 7, y + l * 2 - 1, z - 6);
            this.field_70170_p.func_175656_a(chest4Pos, Blocks.field_150486_ae.func_176223_P());
            TileEntityChest chest4 = new TileEntityChest();
            this.field_70170_p.func_175690_a(chest4Pos, (TileEntity)chest4);
            maxI = chest3.func_70302_i_() - 9;
            for (i2 = 0; i2 < maxI; ++i2) {
                chest3.func_70299_a(i2, new ItemStack(Items.field_151103_aS, 32));
                chest4.func_70299_a(i2, new ItemStack(Items.field_151137_ax, 32));
            }
            maxI = chest3.func_70302_i_();
            for (i2 = maxI - 9; i2 < maxI; ++i2) {
                chest3.func_70299_a(i2, new ItemStack((Item)Items.field_151161_ac, 1));
                chest4.func_70299_a(i2, new ItemStack(Items.field_151045_i, 1));
            }
        } else if (!this.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Too many obstructions, choose another spot!"));
        }
        return false;
    }

    @Override
    public boolean canLevelUp() {
        return true;
    }

    @Override
    public boolean canBeRevived() {
        return true;
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.15f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.15f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

