/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityHunchbackSkeleton;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIFollowOwner;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityHunchback
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final DataParameter<Integer> cakeTimer = EntityDataManager.func_187226_a(EntityHunchback.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityHunchback(World world) {
        super(world);
        this.setCreepTypeName("Hunchback");
        this.baseSpeed = 0.3f;
        this.baseHealth = (float)this.field_70146_Z.nextInt(30) + 10.0f;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(cakeTimer, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        if (this.isTamed()) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityCreepAIFollowOwner(this, 1.0, 6.0f, 2.0f));
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        }
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void updateTexture() {
        if (this.isTamed()) {
            this.setTexture("textures/entity/hunchbackcake.png");
        } else {
            this.setTexture("textures/entity/hunchback.png");
        }
    }

    private void setCakeTimer(int i) {
        this.field_70180_af.func_187227_b(cakeTimer, (Object)i);
    }

    public int getCakeTimer() {
        return (Integer)this.field_70180_af.func_187225_a(cakeTimer);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.func_70089_S()) {
            if (this.isTamed()) {
                if (itemStack.func_77973_b() == Items.field_151103_aS) {
                    this.smoke();
                    this.smoke();
                    this.func_184185_a(CreepsSoundHandler.guineaPigArmorSound, this.func_70599_aP(), this.func_70647_i());
                    this.func_184185_a(CreepsSoundHandler.hunchArmySound, 2.0f, this.func_70647_i());
                    for (int i = 0; i < 5; ++i) {
                        EntityHunchbackSkeleton skeleton = new EntityHunchbackSkeleton(this.field_70170_p);
                        skeleton.func_70012_b(this.field_70165_t + 3.0, this.field_70163_u, this.field_70161_v + (double)i, this.field_70177_z, 0.0f);
                        skeleton.setModelSize(this.getModelSize());
                        skeleton.determineBaseTexture();
                        skeleton.setInitialHealth();
                        skeleton.tame(player);
                        if (this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_72838_d((Entity)skeleton);
                    }
                    itemStack.func_190918_g(1);
                    return true;
                }
            } else if (itemStack.func_77973_b() == Items.field_151105_aU || Item.func_150891_b((Item)itemStack.func_77973_b()) == 92) {
                this.smoke();
                this.tame(player);
                if (this.getCakeTimer() < 4000) {
                    this.setCakeTimer(this.getCakeTimer() + this.field_70146_Z.nextInt(500) + 250);
                }
                itemStack.func_190918_g(1);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (entity != null) {
            double d = -MathHelper.func_76126_a((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
            double d1 = MathHelper.func_76134_b((float)(entity.field_70177_z * (float)Math.PI / 180.0f));
            if (entity instanceof EntityPlayer && this.isTamed()) {
                this.field_70181_x = this.field_70146_Z.nextFloat() * 0.9f;
                this.field_70179_y = d1 * (double)0.4f;
                this.field_70159_w = d * 0.5;
                this.func_184185_a(CreepsSoundHandler.hunchThankYouSound, 2.0f, this.func_70647_i());
                return super.func_70097_a(source, amount / 6.0f);
            }
            if (amount > 0.0f && entity instanceof EntityLivingBase) {
                this.field_70181_x = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
                this.field_70179_y = d1 * (double)0.4f;
                this.field_70159_w = d * 0.5;
                this.func_184185_a(CreepsSoundHandler.hunchHurtSound, 2.0f, this.func_70647_i());
                this.func_70624_b((EntityLivingBase)entity);
            }
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() instanceof EntityHunchbackSkeleton) {
            this.func_70624_b(null);
        }
        if (this.isTamed() && this.getCakeTimer() > 0 && this.field_70146_Z.nextInt(10) == 0) {
            this.setCakeTimer(this.getCakeTimer() - 1);
            if (this.getCakeTimer() == 0) {
                this.clearOwner();
                this.updateTexture();
                this.setCakeTimer(this.field_70146_Z.nextInt(700) + 300);
            }
        }
    }

    @Override
    protected void dropItemsOnDeath() {
        if (!this.isTamed()) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.func_145779_a(Items.field_151147_al, this.field_70146_Z.nextInt(3) + 1);
            } else {
                this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150354_m), this.field_70146_Z.nextInt(3) + 1);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        if (this.isTamed()) {
            return CreepsSoundHandler.hunchQuietSound;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return CreepsSoundHandler.hunchCakeSound;
        }
        return CreepsSoundHandler.hunchQuietSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.hunchHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.hunchDeathSound;
    }

    @Override
    protected SoundEvent getTamedSound() {
        return CreepsSoundHandler.hunchThankYouSound;
    }

    @Override
    protected float getBaseHealth() {
        float health = super.getBaseHealth();
        if (this.isTamed()) {
            health += 2.0f;
        }
        return health;
    }

    private void setUntamed() {
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
        if (this.isTamed()) {
            this.setUntamed();
        }
    }
}

