/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityLolliman;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityKid
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final DataParameter<Integer> checkTimer = EntityDataManager.func_187226_a(EntityKid.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityKid(World world) {
        super(world);
        this.setCreepTypeName("Kid");
        this.setModelSize(0.6f);
        this.func_70105_a(this.field_70130_N * 0.6f, this.field_70131_O * 0.6f);
        this.baseHealth = 25.0f;
        this.baseSpeed = 0.25;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(checkTimer, (Object)0);
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        if (!this.func_184218_aH()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        }
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/kid.png");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if ((Integer)this.field_70180_af.func_187225_a(checkTimer) > 0) {
            this.field_70180_af.func_187227_b(checkTimer, (Object)((Integer)this.field_70180_af.func_187225_a(checkTimer) - 1));
        }
        if (this.func_184218_aH() && (Integer)this.field_70180_af.func_187225_a(checkTimer) < 1) {
            this.field_70180_af.func_187227_b(checkTimer, (Object)60);
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(8.0, 8.0, 8.0))) {
                if (!(entity instanceof EntityLolliman)) continue;
                this.func_184185_a(CreepsSoundHandler.kidFindSound, this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    @Override
    public double func_70033_W() {
        Entity entity = this.func_184187_bx();
        if (entity instanceof EntityPlayer) {
            double size = this.getModelSize();
            double d = 0.6 - size;
            if (size > 1.0) {
                d *= 0.55;
            }
            return 0.25 + d;
        }
        if (entity instanceof EntityLolliman) {
            return 2.6 + (0.6 - (double)this.getModelSize()) - (2.0 - (double)((EntityLolliman)entity).getModelSize()) * 2.75;
        }
        return 1.0;
    }

    protected SoundEvent func_184639_G() {
        if (!(this.func_70638_az() instanceof EntityPlayer)) {
            int z;
            int y;
            int x;
            Block block;
            if (this.field_70146_Z.nextInt(5) == 0 && ((block = this.field_70170_p.func_180495_p(new BlockPos(x = MathHelper.func_76128_c((double)this.field_70165_t), (y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b)) - 1, z = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()) == Blocks.field_150433_aE || block == Blocks.field_150432_aD || this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_150433_aE)) {
                return CreepsSoundHandler.kidColdSound;
            }
            if (this.func_184218_aH()) {
                return CreepsSoundHandler.kidRideSound;
            }
            return CreepsSoundHandler.kidSound;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.kidHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.kidDeathSound;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    @Override
    protected SoundEvent getMountSound() {
        return CreepsSoundHandler.kidMountSound;
    }

    @Override
    protected SoundEvent getUnmountSound() {
        return CreepsSoundHandler.kidUnmountSound;
    }

    @Override
    public boolean canMount(Entity entity) {
        if (this.func_70638_az() instanceof EntityPlayer) {
            this.func_184185_a(CreepsSoundHandler.kidNoPickupSound, this.func_70599_aP(), this.func_70647_i());
            return false;
        }
        return super.canMount(entity);
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f + (0.6f - this.getModelSize()) * 2.0f;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(Items.field_151147_al, this.field_70146_Z.nextInt(3) + 1);
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(Items.field_151015_O, this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.15f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.15f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

