/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.capabilities.ILawyerFine;
import com.morecreepsrevival.morecreeps.common.capabilities.LawyerFineProvider;
import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.entity.EntityBum;
import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityMoney;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageSetLawyerFine;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import com.morecreepsrevival.morecreeps.common.world.JailManager;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityLawyerFromHell
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private static final DataParameter<Boolean> undead = EntityDataManager.func_187226_a(EntityLawyerFromHell.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityLawyerFromHell(World world) {
        super(world);
        this.setCreepTypeName("Lawyer From Hell");
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = (float)this.field_70146_Z.nextInt(40) + 40.0f;
        this.baseSpeed = 0.3;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(undead, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        if (this.getUndead()) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        }
    }

    @Override
    protected void updateTexture() {
        if (this.getUndead()) {
            this.setTexture("textures/entity/lawyerfromhellundead.png");
            return;
        }
        this.setTexture("textures/entity/lawyerfromhell.png");
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.getUndead()) {
            EntityPlayer targetPlayer;
            ILawyerFine capability;
            EntityLivingBase target = this.func_70638_az();
            if (target == null) {
                int fine;
                ILawyerFine capability2;
                EntityPlayer player = this.field_70170_p.func_184136_b((Entity)this, 16.0);
                if (player != null && (capability2 = (ILawyerFine)player.getCapability(LawyerFineProvider.capability, null)) != null && (fine = capability2.getFine()) > 0) {
                    this.func_70624_b((EntityLivingBase)player);
                }
            } else if (target instanceof EntityPlayer && (capability = (ILawyerFine)(targetPlayer = (EntityPlayer)target).getCapability(LawyerFineProvider.capability, null)) != null && capability.getFine() < 1) {
                this.func_70624_b(null);
            }
        }
    }

    public void setUndead(boolean b) {
        if (this.getUndead() == b) {
            return;
        }
        this.field_70180_af.func_187227_b(undead, (Object)b);
        if (b) {
            this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151103_aS));
        } else {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        this.updateAttributes();
        this.func_184651_r();
    }

    public boolean getUndead() {
        return (Boolean)this.field_70180_af.func_187225_a(undead);
    }

    @Override
    public boolean func_70094_T() {
        if (this.getUndead() && !this.func_70058_J()) {
            return false;
        }
        return super.func_70094_T();
    }

    protected SoundEvent func_184639_G() {
        if (this.getUndead()) {
            return CreepsSoundHandler.undeadLawyerSound;
        }
        return CreepsSoundHandler.lawyerSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.getUndead()) {
            return CreepsSoundHandler.undeadLawyerHurtSound;
        }
        return CreepsSoundHandler.lawyerHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        if (this.getUndead()) {
            return CreepsSoundHandler.undeadLawyerDeathSound;
        }
        return CreepsSoundHandler.lawyerDeathSound;
    }

    public int func_70641_bl() {
        return 4;
    }

    @Override
    protected double getMoveSpeed() {
        if (this.getUndead()) {
            return 0.24;
        }
        return super.getMoveSpeed();
    }

    @Override
    protected double getAttackDamage() {
        if (this.getUndead()) {
            return 2.0;
        }
        return super.getAttackDamage();
    }

    @Override
    public boolean func_70652_k(@Nonnull Entity entity) {
        ILawyerFine capability;
        if (entity instanceof EntityPlayer && (capability = (ILawyerFine)entity.getCapability(LawyerFineProvider.capability, null)) != null) {
            EntityPlayer player = (EntityPlayer)entity;
            int fine = capability.getFine();
            if (fine < 1 && !this.getUndead()) {
                this.func_70624_b(null);
                this.func_70604_c(null);
                return false;
            }
            if (this.field_70146_Z.nextInt(50) == 0) {
                this.suckMoney(player);
            }
            if (!this.field_70170_p.field_72995_K && MoreCreepsConfig.jailActive && fine >= 2500 && !this.getUndead() && JailManager.buildJail(player, this.field_70170_p, this.field_70146_Z)) {
                capability.setFine(0);
                CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetLawyerFine(0), (EntityPlayerMP)player);
            }
        }
        return super.func_70652_k(entity);
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource damageSource, float amt) {
        if (!this.getUndead()) {
            EntityCreepBase creep;
            EntityPlayer playerTarget = null;
            Entity entity = damageSource.func_76346_g();
            if (entity instanceof EntityPlayer) {
                ILawyerFine capability;
                int i;
                int randInt;
                playerTarget = (EntityPlayer)entity;
                if (this.field_70146_Z.nextInt(5) == 0) {
                    randInt = this.field_70146_Z.nextInt(20) + 5;
                    for (i = 0; i < randInt; ++i) {
                        capability = (ILawyerFine)playerTarget.getCapability(LawyerFineProvider.capability, null);
                        if (capability != null) {
                            capability.addFine(25);
                            if (!this.field_70170_p.field_72995_K) {
                                CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetLawyerFine(capability.getFine()), (EntityPlayerMP)playerTarget);
                            }
                        }
                        this.func_184185_a(CreepsSoundHandler.lawyerMoneyHitSound, this.func_70599_aP(), this.func_70647_i());
                        EntityMoney money = new EntityMoney(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        money.setDefaultPickupDelay();
                        money.setNoDespawn();
                        if (this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_72838_d((Entity)money);
                    }
                }
                if (this.field_70146_Z.nextInt(5) == 0) {
                    randInt = this.field_70146_Z.nextInt(3) + 1;
                    for (i = 0; i < randInt; ++i) {
                        capability = (ILawyerFine)playerTarget.getCapability(LawyerFineProvider.capability, null);
                        if (capability != null) {
                            capability.addFine(10);
                            if (!this.field_70170_p.field_72995_K) {
                                CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetLawyerFine(capability.getFine()), (EntityPlayerMP)playerTarget);
                            }
                        }
                        this.func_184185_a(CreepsSoundHandler.lawyerMoneyHitSound, this.func_70599_aP(), this.func_70647_i());
                        if (this.field_70170_p.field_72995_K) continue;
                        this.func_145779_a(Items.field_151121_aF, 1);
                    }
                }
            } else if (entity instanceof EntityCreepBase && (creep = (EntityCreepBase)entity).isTamed()) {
                playerTarget = creep.getOwner();
            }
            if (playerTarget != null) {
                ILawyerFine capability = (ILawyerFine)playerTarget.getCapability(LawyerFineProvider.capability, null);
                if (capability != null) {
                    capability.addFine(50);
                    if (!this.field_70170_p.field_72995_K) {
                        CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetLawyerFine(capability.getFine()), (EntityPlayerMP)playerTarget);
                    }
                }
                this.func_70604_c((EntityLivingBase)playerTarget);
            }
        }
        return super.func_70097_a(damageSource, amt);
    }

    private void suckMoney(EntityPlayer player) {
        int invSize = player.field_71071_by.field_70462_a.size();
        boolean take = false;
        boolean isUndead = this.getUndead();
        for (int i = 0; i < invSize; ++i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (itemStack.func_77973_b() != CreepsItemHandler.money) continue;
            if (!isUndead) {
                this.func_184185_a(CreepsSoundHandler.lawyerSuckSound, this.func_70599_aP(), this.func_70647_i());
            }
            int stackSize = itemStack.func_190916_E();
            itemStack.func_190918_g(Math.min(stackSize, this.field_70146_Z.nextInt(stackSize) + 1));
            take = true;
        }
        if (take && !isUndead) {
            this.func_184185_a(CreepsSoundHandler.lawyerTakeSound, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsLawyerFromHell");
        props.func_74757_a("Undead", ((Boolean)this.field_70180_af.func_187225_a(undead)).booleanValue());
        compound.func_74782_a("MoreCreepsLawyerFromHell", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsLawyerFromHell");
        if (props.func_74764_b("Undead")) {
            this.setUndead(props.func_74767_n("Undead"));
        }
        this.field_70180_af.func_187217_b(undead);
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource cause) {
        if (!this.getUndead()) {
            Entity entity = cause.func_76346_g();
            if (this.field_70146_Z.nextInt(3) == 0 && entity instanceof EntityPlayer) {
                int randAmt = this.field_70146_Z.nextInt(4) + 3;
                for (int i = 0; i < randAmt; ++i) {
                    this.smoke2();
                    EntityLawyerFromHell lawyer = new EntityLawyerFromHell(this.field_70170_p);
                    lawyer.func_70012_b(entity.field_70165_t + (double)(this.field_70146_Z.nextInt(4) - this.field_70146_Z.nextInt(4)), entity.field_70163_u - 1.5, entity.field_70161_v + (double)(this.field_70146_Z.nextInt(4) - this.field_70146_Z.nextInt(4)), this.field_70177_z, 0.0f);
                    lawyer.field_70181_x = 20.0;
                    lawyer.setUndead(true);
                    lawyer.determineBaseTexture();
                    lawyer.setInitialHealth();
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_72838_d((Entity)lawyer);
                }
            } else if (this.field_70146_Z.nextInt(5) == 0) {
                EntityBum bum = new EntityBum(this.field_70170_p);
                this.field_70170_p.func_72838_d((Entity)bum);
            } else if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(10) == 0) {
                int randInt = this.field_70146_Z.nextInt(40) + 10;
                for (int i = 0; i < randInt; ++i) {
                    this.func_145779_a(CreepsItemHandler.money, 1);
                }
            }
        }
        this.smoke2();
        super.func_70645_a(cause);
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
        EntityLivingBase raythrower = source.func_85052_h();
        if (raythrower == null || !(raythrower instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer playerTarget = (EntityPlayer)raythrower;
        ILawyerFine capability = (ILawyerFine)playerTarget.getCapability(LawyerFineProvider.capability, null);
        if (capability != null) {
            capability.addFine(50);
            if (!this.field_70170_p.field_72995_K) {
                CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetLawyerFine(capability.getFine()), (EntityPlayerMP)playerTarget);
            }
        }
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
        EntityLivingBase raythrower = source.func_85052_h();
        if (raythrower == null || !(raythrower instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer playerTarget = (EntityPlayer)raythrower;
        ILawyerFine capability = (ILawyerFine)playerTarget.getCapability(LawyerFineProvider.capability, null);
        if (capability != null) {
            capability.addFine(50);
            if (!this.field_70170_p.field_72995_K) {
                CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageSetLawyerFine(capability.getFine()), (EntityPlayerMP)playerTarget);
            }
        }
    }
}

