/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityFrisbee;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityManDog
extends EntityCreepBase {
    private static final DataParameter<Boolean> superDog = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> tamedFood = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> chase = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> fetch = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> frisbeeTime = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> frisbeeEnt = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> attempts = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> frisbeeHold = EntityDataManager.func_187226_a(EntityManDog.class, (DataSerializer)DataSerializers.field_187198_h);
    private double dist = 0.0;
    private double prevDist = 0.0;

    public EntityManDog(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Mandog");
        this.baseHealth = 45.0f;
        this.baseSpeed = 0.333;
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(superDog, (Object)false);
        this.field_70180_af.func_187214_a(tamedFood, (Object)(this.field_70146_Z.nextInt(3) + 1));
        this.field_70180_af.func_187214_a(chase, (Object)false);
        this.field_70180_af.func_187214_a(fetch, (Object)false);
        this.field_70180_af.func_187214_a(frisbeeTime, (Object)0);
        this.field_70180_af.func_187214_a(frisbeeEnt, (Object)0);
        this.field_70180_af.func_187214_a(attempts, (Object)0);
        this.field_70180_af.func_187214_a(frisbeeHold, (Object)false);
    }

    @Override
    protected void updateTexture() {
        if (this.isTamed()) {
            this.setTexture("textures/entity/mandogtamed.png");
        } else {
            this.setTexture("textures/entity/mandog.png");
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            if (this.isTamed()) {
                this.setChase(false);
                this.setFetch(false);
                this.setFrisbeeEntity(null);
            }
        } else {
            Item item = itemStack.func_77973_b();
            if (item == Items.field_151157_am && !this.isTamed()) {
                itemStack.func_190918_g(1);
                this.setTamedFood(this.getTamedFood() - 1);
                this.smoke();
                if (this.getTamedFood() < 1) {
                    this.smoke();
                    this.tame(player);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected SoundEvent getTamedSound() {
        return CreepsSoundHandler.manDogTamedSound;
    }

    protected SoundEvent func_184639_G() {
        if (this.getSuperDog()) {
            return CreepsSoundHandler.superDogNameSound;
        }
        return CreepsSoundHandler.manDogSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.manDogHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.manDogDeathSound;
    }

    protected void setSuperDog(boolean b) {
        this.field_70180_af.func_187227_b(superDog, (Object)b);
    }

    public boolean getSuperDog() {
        return (Boolean)this.field_70180_af.func_187225_a(superDog);
    }

    protected void setTamedFood(int i) {
        this.field_70180_af.func_187227_b(tamedFood, (Object)i);
    }

    public int getTamedFood() {
        return (Integer)this.field_70180_af.func_187225_a(tamedFood);
    }

    protected void setChase(boolean b) {
        this.field_70180_af.func_187227_b(chase, (Object)b);
    }

    public boolean getChase() {
        return (Boolean)this.field_70180_af.func_187225_a(chase);
    }

    protected void setFetch(boolean b) {
        this.field_70180_af.func_187227_b(fetch, (Object)b);
    }

    public boolean getFetch() {
        return (Boolean)this.field_70180_af.func_187225_a(fetch);
    }

    protected void setFrisbeeTime(int i) {
        this.field_70180_af.func_187227_b(frisbeeTime, (Object)i);
    }

    public int getFrisbeeTime() {
        return (Integer)this.field_70180_af.func_187225_a(frisbeeTime);
    }

    protected void setFrisbeeEntity(Entity entity) {
        if (entity == null) {
            this.field_70180_af.func_187227_b(frisbeeEnt, (Object)0);
            return;
        }
        this.field_70180_af.func_187227_b(frisbeeEnt, (Object)entity.func_145782_y());
    }

    public Entity getFrisbeeEntity() {
        if ((Integer)this.field_70180_af.func_187225_a(frisbeeEnt) == 0) {
            return null;
        }
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(frisbeeEnt)).intValue());
    }

    protected void setAttempts(int i) {
        this.field_70180_af.func_187227_b(attempts, (Object)i);
    }

    public int getAttempts() {
        return (Integer)this.field_70180_af.func_187225_a(attempts);
    }

    protected void setFrisbeeHold(boolean b) {
        this.field_70180_af.func_187227_b(frisbeeHold, (Object)b);
    }

    public boolean getFrisbeeHold() {
        return (Boolean)this.field_70180_af.func_187225_a(frisbeeHold);
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void dropItemsOnDeath() {
        this.func_145779_a(Items.field_151103_aS, 1);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isTamed()) {
            this.setFrisbeeTime(this.getFrisbeeTime() + 1);
            if (!(this.getFrisbeeTime() < 20 || this.field_70128_L || this.getChase() || this.getFetch())) {
                for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(25.0, 25.0, 25.0))) {
                    if (!(entity instanceof EntityFrisbee)) continue;
                    this.func_70625_a(entity, 360.0f, 0.0f);
                    this.setFrisbeeEntity(entity);
                    this.setChase(true);
                    this.setAttempts(0);
                }
            }
            Entity frisbeeEntity = this.getFrisbeeEntity();
            if (this.getChase()) {
                if (frisbeeEntity == null || frisbeeEntity.field_70128_L) {
                    this.setChase(false);
                    this.setFrisbeeTime(0);
                } else {
                    if (Math.abs(this.field_70163_u - frisbeeEntity.field_70163_u) < 2.0) {
                        this.func_70625_a(frisbeeEntity, 360.0f, 0.0f);
                    }
                    this.field_70143_R = -25.0f;
                    this.prevDist = this.dist;
                    this.dist = frisbeeEntity.field_70165_t - this.field_70165_t;
                    if (this.dist == this.prevDist) {
                        if (this.field_70146_Z.nextInt(2) == 0) {
                            this.field_70159_w += 0.75;
                            this.field_70179_y += 0.75;
                        } else {
                            this.field_70159_w -= 0.75;
                            this.field_70179_y -= 0.75;
                        }
                    }
                    if (Math.abs(frisbeeEntity.field_70165_t - this.field_70165_t) < 1.0 && Math.abs(frisbeeEntity.field_70163_u - this.field_70163_u) < 1.0 && Math.abs(frisbeeEntity.field_70161_v - this.field_70161_v) < 1.0) {
                        this.func_184185_a(SoundEvents.field_187662_cZ, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        frisbeeEntity.func_70106_y();
                        this.setChase(false);
                        this.setFetch(true);
                        this.setFrisbeeHold(true);
                        EntityPlayer player = this.getOwner();
                        if (player != null) {
                            this.setFrisbeeEntity((Entity)player);
                            this.func_70625_a((Entity)player, 360.0f, 0.0f);
                        }
                    }
                    double d = frisbeeEntity.field_70165_t - this.field_70165_t;
                    double d2 = frisbeeEntity.field_70161_v - this.field_70161_v;
                    float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
                    this.field_70159_w = d / (double)f * 0.4 * 0.500000001920929 + this.field_70159_w * 0.18000000098023225;
                    this.field_70179_y = d2 / (double)f * 0.4 * 0.40000000192092894 + this.field_70179_y * 0.18000000098023225;
                    if (this.field_70122_E) {
                        double d4 = (frisbeeEntity.field_70163_u - this.field_70163_u) * 0.18000000098023225;
                        if (d4 > 0.5) {
                            d4 = 0.5;
                        }
                        this.field_70181_x = d4;
                    }
                    if (Math.abs(frisbeeEntity.field_70165_t - this.field_70165_t) < 5.0 && Math.abs(frisbeeEntity.field_70161_v - this.field_70161_v) < 5.0 && frisbeeEntity.field_70159_w == 0.0) {
                        this.setAttempts(this.getAttempts() + 1);
                        if (this.getAttempts() > 100) {
                            this.setChase(false);
                            this.setFrisbeeTime(0);
                            this.setFrisbeeEntity(null);
                            this.setFetch(true);
                            this.setFrisbeeHold(false);
                            EntityPlayer player = this.getOwner();
                            if (player != null) {
                                this.setFrisbeeEntity((Entity)player);
                                this.func_70625_a((Entity)player, 360.0f, 0.0f);
                            }
                        }
                    }
                }
            }
            if (this.getFetch() && (frisbeeEntity = this.getFrisbeeEntity()) != null) {
                if (Math.abs(frisbeeEntity.field_70165_t - this.field_70165_t) < 2.0 && Math.abs(frisbeeEntity.field_70163_u - this.field_70163_u) < 2.0 && Math.abs(frisbeeEntity.field_70161_v - this.field_70161_v) < 2.0) {
                    this.func_184185_a(SoundEvents.field_187662_cZ, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.07f + 1.0f) * 2.0f);
                    if (!this.field_70170_p.field_72995_K && this.getFrisbeeHold()) {
                        this.func_145779_a(CreepsItemHandler.frisbee, 1);
                    }
                    this.setChase(false);
                    this.setFetch(false);
                }
                this.field_70143_R = -25.0f;
                double d1 = frisbeeEntity.field_70165_t - this.field_70165_t;
                double d3 = frisbeeEntity.field_70161_v - this.field_70161_v;
                float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
                this.field_70159_w = d1 / (double)f1 * 0.4 * 0.500000001920929 + this.field_70159_w * 0.18000000098023225;
                this.field_70179_y = d3 / (double)f1 * 0.4 * 0.40000000192092894 + this.field_70179_y * 0.18000000098023225;
                if (this.field_70122_E) {
                    double d5 = (frisbeeEntity.field_70163_u - this.field_70163_u) * 0.18000000098023225;
                    if (d5 > 0.5) {
                        d5 = 0.5;
                    }
                    this.field_70181_x = d5;
                }
            }
        }
    }

    @Override
    public boolean isTamable() {
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsManDog");
        props.func_74768_a("Attempts", this.getAttempts());
        props.func_74757_a("FrisbeeHold", this.getFrisbeeHold());
        props.func_74757_a("Chase", this.getChase());
        props.func_74757_a("Fetch", this.getFetch());
        props.func_74768_a("TamedFood", this.getTamedFood());
        compound.func_74782_a("MoreCreepsManDog", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsManDog");
        if (props.func_74764_b("Attempts")) {
            this.setAttempts(props.func_74762_e("Attempts"));
        }
        if (props.func_74764_b("FrisbeeHold")) {
            this.setFrisbeeHold(props.func_74767_n("FrisbeeHold"));
        }
        if (props.func_74764_b("Chase")) {
            this.setChase(props.func_74767_n("Chase"));
        }
        if (props.func_74764_b("Fetch")) {
            this.setFetch(props.func_74767_n("Fetch"));
        }
        if (props.func_74764_b("TamedFood")) {
            this.setTamedFood(props.func_74762_e("TamedFood"));
        }
    }
}

