/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityRocket;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityPreacher
extends EntityCreepBase
implements IMob {
    private static final DataParameter<Integer> raise = EntityDataManager.func_187226_a(EntityPreacher.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> raiseLevel = EntityDataManager.func_187226_a(EntityPreacher.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ritual = EntityDataManager.func_187226_a(EntityPreacher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> waitTime = EntityDataManager.func_187226_a(EntityPreacher.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> hasVictim = EntityDataManager.func_187226_a(EntityPreacher.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> victimId = EntityDataManager.func_187226_a(EntityPreacher.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityPreacher(World world) {
        super(world);
        this.setCreepTypeName("Preacher");
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = (float)this.field_70146_Z.nextInt(50) + 25.0f;
        this.baseSpeed = 0.35;
        this.baseAttackDamage = 5.0;
        this.updateAttributes();
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(raise, (Object)0);
        this.field_70180_af.func_187214_a(raiseLevel, (Object)0);
        this.field_70180_af.func_187214_a(ritual, (Object)false);
        this.field_70180_af.func_187214_a(waitTime, (Object)(this.field_70146_Z.nextInt(500) + 500));
        this.field_70180_af.func_187214_a(hasVictim, (Object)false);
        this.field_70180_af.func_187214_a(victimId, (Object)0);
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/preacher" + this.field_70146_Z.nextInt(3) + ".png");
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.updateTexture();
        }
        if (this.func_180799_ab()) {
            if (this.field_70146_Z.nextInt(25) == 0) {
                this.func_184185_a(CreepsSoundHandler.preacherBurnSound, this.func_70599_aP(), this.func_70647_i());
            }
            this.func_70044_A();
        }
    }

    @Override
    public void func_70636_d() {
        BlockPos pos;
        super.func_70636_d();
        if ((this.field_70171_ac || this.func_70094_T()) && !this.field_70170_p.func_175623_d(pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v)))) {
            this.field_70170_p.func_175698_g(pos);
            this.field_70181_x += 0.5;
        }
        Entity victim = this.getVictim();
        if (this.getHasVictim() && victim != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.setRaise(this.getRaise() + 1);
            if (this.getRaise() > this.getRaiseLevel()) {
                this.setHasVictim(false);
                this.setRitual(false);
                victim.field_70181_x = -0.8f;
                this.setRaise(0);
                this.setWaitTime(this.field_70146_Z.nextInt(500) + 500);
            } else {
                BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b + 2.0, this.field_70161_v);
                if (!this.field_70170_p.func_175623_d(blockPos) && victim instanceof EntityPlayer) {
                    this.field_70170_p.func_175698_g(blockPos);
                }
                victim.field_70181_x = 0.2f;
                this.setWaitTime(1000);
                this.smokeVictim(victim);
                this.smoke();
                if (this.field_70146_Z.nextInt(10) == 0) {
                    victim.field_70159_w = this.field_70146_Z.nextFloat() * 0.85f - 0.5f;
                } else if (this.field_70146_Z.nextInt(10) == 0) {
                    victim.field_70179_y = this.field_70146_Z.nextFloat() * 0.8f - 0.5f;
                }
            }
        }
        if (this.getRitual() && victim == null) {
            for (Entity entity : this.field_70170_p.field_72996_f) {
                if (!(entity instanceof EntitySheep) && !(entity instanceof EntityPig)) continue;
                this.setHasVictim(true);
                this.setVictim(entity);
                this.setRaiseLevel(this.field_70146_Z.nextInt(50) + 50);
                this.func_184185_a(CreepsSoundHandler.preacherRaiseSound, this.func_70599_aP(), this.func_70647_i());
                break;
            }
            if (this.getVictim() == null) {
                this.setRitual(false);
            }
        } else if (this.field_70146_Z.nextInt(2) == 0) {
            this.setWaitTime(this.getWaitTime() - 1);
            if (this.getWaitTime() < 1) {
                this.setRitual(true);
                this.setWaitTime(1000);
            }
        }
    }

    private void setRaise(int i) {
        this.field_70180_af.func_187227_b(raise, (Object)i);
    }

    public int getRaise() {
        return (Integer)this.field_70180_af.func_187225_a(raise);
    }

    private void setRaiseLevel(int i) {
        this.field_70180_af.func_187227_b(raiseLevel, (Object)i);
    }

    public int getRaiseLevel() {
        return (Integer)this.field_70180_af.func_187225_a(raiseLevel);
    }

    private void setRitual(boolean b) {
        this.field_70180_af.func_187227_b(ritual, (Object)b);
    }

    public boolean getRitual() {
        return (Boolean)this.field_70180_af.func_187225_a(ritual);
    }

    private void setWaitTime(int i) {
        this.field_70180_af.func_187227_b(waitTime, (Object)i);
    }

    public int getWaitTime() {
        return (Integer)this.field_70180_af.func_187225_a(waitTime);
    }

    private void setHasVictim(boolean b) {
        this.field_70180_af.func_187227_b(hasVictim, (Object)b);
    }

    public boolean getHasVictim() {
        return (Boolean)this.field_70180_af.func_187225_a(hasVictim);
    }

    private void setVictim(Entity entity) {
        this.field_70180_af.func_187227_b(victimId, (Object)entity.func_145782_y());
    }

    public Entity getVictim() {
        int entityId = (Integer)this.field_70180_af.func_187225_a(victimId);
        if (entityId == 0) {
            return null;
        }
        return this.field_70170_p.func_73045_a(entityId);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.preacherSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.preacherHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.preacherDeathSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(50) == 0) {
            this.func_145779_a(Items.field_151045_i, this.field_70146_Z.nextInt(2) + 1);
        }
        if (this.field_70146_Z.nextInt(50) == 0) {
            this.func_70099_a(new ItemStack(Items.field_151100_aR, 1, 4), 1.0f);
        }
        if (this.field_70146_Z.nextInt(50) == 0) {
            this.func_70099_a(new ItemStack(Items.field_151100_aR, 1, 3), 1.0f);
        }
        if (this.field_70146_Z.nextInt(50) == 0) {
            this.func_70099_a(new ItemStack(Items.field_151100_aR, 1, 1), 1.0f);
        }
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_145779_a(Items.field_151043_k, this.field_70146_Z.nextInt(5) + 2);
        } else {
            this.func_145779_a(Items.field_151122_aG, 1);
            this.func_145779_a(Items.field_151034_e, 1);
        }
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double xRatio, double zRatio) {
        this.field_70159_w *= 1.5;
        this.field_70179_y *= 1.5;
        this.field_70181_x += 0.5;
    }

    @Override
    public void smoke() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
    }

    private void smokeVictim(Entity entity) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, entity.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, entity.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) + (double)i - 2.0, entity.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (flag) {
            Entity attacker = source.func_76346_g();
            if (this.getHasVictim() && attacker != null && !(attacker instanceof EntityRocket)) {
                attacker.field_70159_w += (double)(this.field_70146_Z.nextFloat() * 1.98f);
                attacker.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 1.98f);
                attacker.field_70179_y += (double)(this.field_70146_Z.nextFloat() * 1.98f);
                return true;
            }
            if (attacker instanceof EntityRocket && (attacker = this.field_70170_p.func_72890_a((Entity)this, 30.0)) != null) {
                attacker.func_184210_p();
                this.setVictim(attacker);
                this.setHasVictim(true);
                attacker.field_70159_w = 0.0;
                attacker.field_70181_x = 0.0;
                attacker.field_70179_y = 0.0;
                this.setRaiseLevel(this.field_70146_Z.nextInt(50) + 50);
                this.func_184185_a(CreepsSoundHandler.preacherRaiseSound, this.func_70599_aP(), this.func_70647_i());
            }
            if (attacker != null) {
                this.setRaise(1);
                this.setWaitTime(0);
                this.smoke();
                this.setHasVictim(true);
                this.setVictim(attacker);
                attacker.field_70159_w = 0.0;
                attacker.field_70181_x = 0.0;
                attacker.field_70179_y = 0.0;
                this.setRaiseLevel(this.field_70146_Z.nextInt(50) + 50);
                this.func_184185_a(CreepsSoundHandler.preacherRaiseSound, this.func_70599_aP(), this.func_70647_i());
            }
        }
        return flag;
    }
}

