/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityPrisoner
extends EntityCreepBase {
    private static final String[] textures = new String[]{"textures/entity/prisoner1", "textures/entity/prisoner2", "textures/entity/prisoner3", "textures/entity/prisoner4", "textures/entity/prisoner5"};
    private static final DataParameter<Boolean> evil = EntityDataManager.func_187226_a(EntityPrisoner.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> saved = EntityDataManager.func_187226_a(EntityPrisoner.class, (DataSerializer)DataSerializers.field_187198_h);
    private int timeOnLand = 0;

    public EntityPrisoner(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Prisoner");
        this.baseHealth = (float)this.field_70146_Z.nextInt(10) + 15.0f;
        this.baseSpeed = 0.25;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(evil, (Object)(this.field_70146_Z.nextInt(2) == 0 ? 1 : 0));
        this.field_70180_af.func_187214_a(saved, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        if (this.getEvil()) {
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        }
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            return CreepsSoundHandler.prisonerSound;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.prisonerHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.prisonerDeathSound;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected String[] getAvailableTextures() {
        return textures;
    }

    private void setEvil(boolean b) {
        this.field_70180_af.func_187227_b(evil, (Object)b);
    }

    public boolean getEvil() {
        return (Boolean)this.field_70180_af.func_187225_a(evil);
    }

    private void setSaved(boolean b) {
        this.field_70180_af.func_187227_b(saved, (Object)b);
    }

    public boolean getSaved() {
        return (Boolean)this.field_70180_af.func_187225_a(saved);
    }

    @Override
    public boolean func_70094_T() {
        return false;
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource damageSource, float amt) {
        if (damageSource.func_76346_g() instanceof EntityPlayer && !this.getEvil()) {
            this.setEvil(true);
            this.func_184651_r();
        }
        return super.func_70097_a(damageSource, amt);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsPrisoner");
        props.func_74757_a("Evil", this.getEvil());
        props.func_74757_a("Saved", this.getSaved());
        compound.func_74782_a("MoreCreepsPrisoner", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsPrisoner");
        if (props.func_74764_b("Evil")) {
            this.setEvil(props.func_74767_n("Evil"));
        }
        if (props.func_74764_b("Saved")) {
            this.setSaved(props.func_74767_n("Saved"));
        }
    }

    @Override
    public void smoke() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
    }

    @Override
    public void func_70636_d() {
        double dist;
        EntityPlayer player;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.func_70090_H() && !this.getEvil() && !this.getSaved() && this.timeOnLand++ > 50 && (player = this.field_70170_p.func_72890_a((Entity)this, 2.0)) != null && (dist = player.func_70068_e((Entity)this)) < 9.0 && this.func_70685_l((Entity)player)) {
            this.giveReward(player);
        }
    }

    private void giveReward(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_184185_a(CreepsSoundHandler.prisonerSorrySound, 1.0f, 1.0f);
            return;
        }
        this.func_184185_a(CreepsSoundHandler.prisonerRewardSound, 1.0f, 1.0f);
        this.setSaved(true);
        this.func_70625_a((Entity)player, 0.0f, 0.0f);
        EntityItem item = null;
        switch (this.field_70146_Z.nextInt(4) + 1) {
            case 1: {
                item = this.func_70099_a(new ItemStack(CreepsItemHandler.lolly, this.field_70146_Z.nextInt(2) + 1), 1.0f);
                break;
            }
            case 2: {
                item = this.func_70099_a(new ItemStack(Items.field_151025_P, 1), 1.0f);
                break;
            }
            case 3: {
                item = this.func_70099_a(new ItemStack(Items.field_151105_aU, 1), 1.0f);
                break;
            }
            case 4: {
                item = this.func_70099_a(new ItemStack(CreepsItemHandler.money, this.field_70146_Z.nextInt(20) + 1), 1.0f);
                break;
            }
            default: {
                item = this.func_70099_a(new ItemStack(CreepsItemHandler.money, this.field_70146_Z.nextInt(5) + 1), 1.0f);
            }
        }
        if (item == null) {
            return;
        }
        double d = -MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f));
        double d1 = MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f));
        item.field_70165_t = player.field_70165_t + d * 0.5;
        item.field_70163_u = player.field_70163_u + 0.5;
        item.field_70161_v = player.field_70161_v + d1 * 0.5;
    }
}

