/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntitySchlump
extends EntityCreepBase {
    private static final DataParameter<Integer> age = EntityDataManager.func_187226_a(EntitySchlump.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ageTimer = EntityDataManager.func_187226_a(EntitySchlump.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> placed = EntityDataManager.func_187226_a(EntitySchlump.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> payoutTimer = EntityDataManager.func_187226_a(EntitySchlump.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> waitTime = EntityDataManager.func_187226_a(EntitySchlump.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> deathTimer = EntityDataManager.func_187226_a(EntitySchlump.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySchlump(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Schlump");
        this.baseSpeed = 0.0;
        this.baseHealth = (float)this.field_70146_Z.nextInt(10) + 10.0f;
        this.setModelSize(0.4f);
        this.func_70105_a(this.field_70130_N * 0.4f, this.field_70131_O * 0.4f);
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(age, (Object)0);
        this.field_70180_af.func_187214_a(ageTimer, (Object)0);
        this.field_70180_af.func_187214_a(placed, (Object)false);
        this.field_70180_af.func_187214_a(payoutTimer, (Object)0);
        this.field_70180_af.func_187214_a(waitTime, (Object)0);
        this.field_70180_af.func_187214_a(deathTimer, (Object)0);
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/schlump.png");
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70171_ac) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70158_ak = true;
        this.field_70180_af.func_187227_b(ageTimer, (Object)((Integer)this.field_70180_af.func_187225_a(ageTimer) + 1));
        if ((Integer)this.field_70180_af.func_187225_a(ageTimer) > 50) {
            if (this.getAge() < 22000) {
                this.setAge(this.getAge() + 1);
            }
            if (this.getAge() > 20000) {
                this.func_70106_y();
            }
            if (this.getModelSize() < 3.5f) {
                this.setModelSize(this.getModelSize() + 0.001f);
            }
            this.field_70180_af.func_187227_b(ageTimer, (Object)0);
            int i = this.getAge() / 100 * 2;
            if (i > 150) {
                i = 150;
            }
            if (this.getAge() > 200 && this.field_70146_Z.nextInt(200 - i) == 0) {
                this.giveReward();
            }
        }
        if (!this.getPlaced()) {
            this.setPlaced(true);
            if (!this.checkHouse()) {
                this.field_70180_af.func_187227_b(deathTimer, (Object)200);
            }
        } else if ((Integer)this.field_70180_af.func_187225_a(deathTimer) > 0) {
            this.field_70180_af.func_187227_b(deathTimer, (Object)((Integer)this.field_70180_af.func_187225_a(deathTimer) - 1));
            if ((Integer)this.field_70180_af.func_187225_a(deathTimer) == 0) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public boolean func_70692_ba() {
        return this.func_110143_aJ() < 1.0f;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            return CreepsSoundHandler.schlumpSound;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.schlumpHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.schlumpDeathSound;
    }

    public void func_70106_y() {
        super.func_70106_y();
        SoundEvent deathSound = this.func_184615_bR();
        if (deathSound != null) {
            this.func_184185_a(deathSound, this.func_70599_aP(), this.func_70647_i());
        }
        this.smoke();
    }

    private boolean checkItems() {
        int i = 0;
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(6.0, 6.0, 6.0))) {
            if (!(entity instanceof EntityItem)) continue;
            ++i;
        }
        return i > 25;
    }

    @Override
    public void smoke() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) + (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N - (double)i, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)i - (double)this.field_70130_N, d, d1, d2, new int[0]);
            }
        }
    }

    @Override
    public boolean func_70094_T() {
        return this.func_110143_aJ() <= 0.0f;
    }

    public void setAge(int i) {
        this.field_70180_af.func_187227_b(age, (Object)i);
    }

    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(age);
    }

    private void setPlaced(boolean b) {
        this.field_70180_af.func_187227_b(placed, (Object)b);
    }

    public boolean getPlaced() {
        return (Boolean)this.field_70180_af.func_187225_a(placed);
    }

    private boolean checkHouse() {
        EntityPlayer owner = this.getOwner();
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(16.0, 16.0, 16.0))) {
            if (!(entity instanceof EntitySchlump)) continue;
            if (owner != null) {
                owner.func_145747_a((ITextComponent)new TextComponentString("Too close to another Schlump. SCHLUMP OVERLOAD!"));
            }
            this.func_184185_a(CreepsSoundHandler.schlumpOverloadSound, this.func_70599_aP(), this.func_70647_i());
            return false;
        }
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175710_j(blockPos)) {
            if (owner != null) {
                owner.func_145747_a((ITextComponent)new TextComponentString("Your Schlump needs to be indoors or it will die!"));
            }
            this.func_184185_a(CreepsSoundHandler.schlumpIndoorsSound, this.func_70599_aP(), this.func_70647_i());
            return false;
        }
        if (this.field_70170_p.getBlockLightOpacity(blockPos) > 11) {
            if (owner != null) {
                owner.func_145747_a((ITextComponent)new TextComponentString("It is too bright in here for your little Schlump!"));
            }
            this.func_184185_a(CreepsSoundHandler.schlumpBrightSound, this.func_70599_aP(), this.func_70647_i());
            return false;
        }
        int l = 0;
        for (int i = -2; i < 2; ++i) {
            for (int k = -2; k < 2; ++k) {
                for (int q = 0; q < 5; ++q) {
                    if (!this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t + (double)i, this.field_70163_u + (double)q, this.field_70161_v + (double)k))) continue;
                    ++l;
                }
            }
        }
        if (l < 60) {
            if (owner != null) {
                owner.func_145747_a((ITextComponent)new TextComponentString("Your Schlump doesn't have enough room to grow!"));
            }
            this.func_184185_a(CreepsSoundHandler.schlumpRoomSound, this.func_70599_aP(), this.func_70647_i());
            return false;
        }
        int j1 = 0;
        for (int i = -5; i < 5; ++i) {
            for (int k = -5; k < 5; ++k) {
                for (int q = -5; q < 5; ++q) {
                    Block block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t + (double)i, this.field_70163_u + (double)q, this.field_70161_v + (double)k)).func_177230_c();
                    if (block == Blocks.field_180413_ao) {
                        j1 += 10;
                        continue;
                    }
                    if (block == Blocks.field_150454_av) {
                        j1 += 20;
                        continue;
                    }
                    if (block == Blocks.field_150359_w) {
                        j1 += 5;
                        continue;
                    }
                    if (block == Blocks.field_150486_ae) {
                        j1 += 15;
                        continue;
                    }
                    if (block == Blocks.field_150324_C) {
                        j1 += 20;
                        continue;
                    }
                    if (block == Blocks.field_150342_X) {
                        j1 += 15;
                        continue;
                    }
                    if (block == Blocks.field_150336_V) {
                        j1 += 3;
                        continue;
                    }
                    if (block == Blocks.field_150344_f) {
                        j1 += 3;
                        continue;
                    }
                    if (block == Blocks.field_150325_L) {
                        j1 += 2;
                        continue;
                    }
                    if (block == Blocks.field_150414_aQ) {
                        j1 += 10;
                        continue;
                    }
                    if (block == Blocks.field_150460_al) {
                        j1 += 15;
                        continue;
                    }
                    if (block == Blocks.field_150470_am) {
                        j1 += 10;
                        continue;
                    }
                    if (block == Blocks.field_150328_O) {
                        j1 += 5;
                        continue;
                    }
                    if (block != Blocks.field_150462_ai) continue;
                    j1 += 10;
                }
            }
        }
        if (j1 > 275) {
            if (this.getAge() < 10) {
                if (owner != null) {
                    owner.func_145747_a((ITextComponent)new TextComponentString("This location is great! Your Schlump will love it here!"));
                }
                this.func_184185_a(CreepsSoundHandler.schlumpOkSound, this.func_70599_aP(), this.func_70647_i());
            }
            return true;
        }
        if (owner != null) {
            owner.func_145747_a((ITextComponent)new TextComponentString("This is not a good location for your Schlump. It will die here!"));
        }
        this.func_184185_a(CreepsSoundHandler.schlumpSucksSound, this.func_70599_aP(), this.func_70647_i());
        return false;
    }

    private void giveReward() {
        EntityPlayer owner = this.getOwner();
        if (!this.checkHouse()) {
            this.field_70180_af.func_187227_b(deathTimer, (Object)200);
            return;
        }
        if (this.checkItems()) {
            return;
        }
        this.func_184185_a(CreepsSoundHandler.schlumpRewardSound, this.func_70599_aP(), this.func_70647_i());
        if (owner != null && !this.field_70170_p.field_72995_K) {
            EntityItem entityItem;
            int i = this.field_70146_Z.nextInt(this.getAge() / 100) + 1;
            if (i > 42) {
                i = 42;
            }
            switch (i) {
                case 1: 
                case 18: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.lolly, this.field_70146_Z.nextInt(2) + 1), 1.0f);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151015_O, 1), 1.0f);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.bandaid, 1), 1.0f);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151025_P, 1), 1.0f);
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.money, this.field_70146_Z.nextInt(4) + 1), 1.0f);
                    break;
                }
                case 19: 
                case 20: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151034_e, 1), 1.0f);
                    break;
                }
                case 21: 
                case 25: 
                case 26: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151147_al, 1), 1.0f);
                    break;
                }
                case 22: 
                case 23: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151044_h, 1), 1.0f);
                    break;
                }
                case 24: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151081_bc, 1), 1.0f);
                    break;
                }
                case 27: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151042_j, 1), 1.0f);
                    break;
                }
                case 28: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151115_aP, 1), 1.0f);
                    break;
                }
                case 29: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.evilEgg, this.field_70146_Z.nextInt(5) + 1), 1.0f);
                    break;
                }
                case 30: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_179566_aV, 1), 1.0f);
                    break;
                }
                case 31: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.gun, 1), 1.0f);
                    break;
                }
                case 32: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.extinguisher, this.field_70146_Z.nextInt(2) + 1), 1.0f);
                    break;
                }
                case 33: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.rocket, 1), 1.0f);
                    break;
                }
                case 34: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.atom, this.field_70146_Z.nextInt(7) + 1), 1.0f);
                    break;
                }
                case 35: 
                case 37: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.armyGem, 1), 1.0f);
                    break;
                }
                case 36: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.money, this.field_70146_Z.nextInt(24) + 1), 1.0f);
                    break;
                }
                case 38: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.horseHeadGem, 1), 1.0f);
                    break;
                }
                case 39: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151043_k, 1), 1.0f);
                    break;
                }
                case 40: {
                    entityItem = this.func_70099_a(new ItemStack(Items.field_151045_i, 1), 1.0f);
                    break;
                }
                case 41: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.raygun, 1), 1.0f);
                    break;
                }
                case 42: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.money, this.field_70146_Z.nextInt(49) + 1), 1.0f);
                    break;
                }
                default: {
                    entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.money, this.field_70146_Z.nextInt(3) + 1), 1.0f);
                }
            }
            if (entityItem != null) {
                double d = -MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                double d1 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                entityItem.field_70165_t = owner.field_70165_t + d * 0.5;
                entityItem.field_70163_u = owner.field_70161_v + d1 * 0.5;
                entityItem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.15f);
                entityItem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.15f);
            }
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_77973_b() == CreepsItemHandler.babyJarEmpty) {
            if (this.getModelSize() > 0.5f) {
                player.func_145747_a((ITextComponent)new TextComponentString("That Schlump is too big to fit in a jar!"));
                this.func_184185_a(CreepsSoundHandler.schlumpBigSound, this.func_70599_aP(), this.func_70647_i());
                return true;
            }
            this.func_70106_y();
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(CreepsItemHandler.babyJarFull));
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        this.giveReward();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsSchlump");
        props.func_74768_a("Age", this.getAge());
        props.func_74768_a("DeathTimer", ((Integer)this.field_70180_af.func_187225_a(deathTimer)).intValue());
        compound.func_74782_a("MoreCreepsSchlump", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsSchlump");
        if (props.func_74764_b("Age")) {
            this.setAge(props.func_74762_e("Age"));
        }
        if (props.func_74764_b("DeathTimer")) {
            this.field_70180_af.func_187227_b(deathTimer, (Object)props.func_74762_e("DeathTimer"));
        }
    }
}

