/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageOpenGuiTamableEntityName;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntitySnowDevil
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private static final String[] textures = new String[]{"textures/entity/snowdevil1", "textures/entity/snowdevil2"};
    private static final String[] names = new String[]{"Satan", "The Butcher", "Killer", "Tad", "Death Spanker", "Death Toll", "Bruiser", "Bones", "The Devil", "Little Devil", "Skinny", "Death to All", "I Will Hurt You", "Pierre", "Bonecruncher", "Bone Breaker", "Blood 'N Guts", "Kill Kill", "Murder", "The Juicer", "Scream", "Bloody Buddy", "Sawblade", "Ripper", "Razor", "Valley Strangler", "Choppy Joe", "Wiconsin Shredder", "Urinal", "Johnny Choke", "Annihilation", "Bloodshed", "Destructo", "Rub Out", "Massacre", "Felony", "The Mangler", "Destroyer", "The Marauder", "Wreck", "Vaporizer", "Wasteland", "Demolition Duo", "Two Knocks", "Double Trouble", "Thing One & Thing Two", "Wipeout", "Devil Duo", "Two Shot", "Misunderstood", "Twice As Nice"};

    public EntitySnowDevil(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Snow Devil");
        this.creatureType = EnumCreatureType.MONSTER;
        this.func_70105_a(this.field_70130_N * 1.6f, this.field_70131_O * 1.0f);
        this.baseHealth = (float)this.field_70146_Z.nextInt(50) + 15.0f;
        this.baseAttackDamage = 3.0;
        this.baseSpeed = 0.3;
        this.updateAttributes();
    }

    @Override
    protected String[] getAvailableTextures() {
        return textures;
    }

    @Override
    protected String[] getTamedNames() {
        return names;
    }

    @Override
    public boolean isTamable() {
        return true;
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public int func_70641_bl() {
        return 2;
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.snowDevilSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.snowDevilHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.snowDevilDeathSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150432_aD), this.field_70146_Z.nextInt(3) + 1);
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150433_aE), this.field_70146_Z.nextInt(10) + 1);
        } else {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150433_aE), this.field_70146_Z.nextInt(5) + 2);
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        if (this.isTamed()) {
            if (player.func_70093_af() && this.isPlayerOwner(player)) {
                if (!this.field_70170_p.field_72995_K) {
                    CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageOpenGuiTamableEntityName(this.func_145782_y()), (EntityPlayerMP)player);
                }
                return true;
            }
        } else {
            Item item;
            ItemStack itemStack = player.func_184586_b(hand);
            if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) == Items.field_151126_ay) {
                this.tame(player);
                this.addHealth(2.0f);
                itemStack.func_190918_g(1);
                this.smoke();
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected SoundEvent getTamedSound() {
        return CreepsSoundHandler.snowDevilTamedSound;
    }

    @Override
    public float maxShrink() {
        return 0.4f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

