/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityAIThief;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityThief
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private static final DataParameter<Boolean> stolen = EntityDataManager.func_187226_a(EntityThief.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityThief.class, (DataSerializer)DataSerializers.field_187196_f);
    private double goX;
    private double goZ;

    public EntityThief(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Thief");
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = (float)this.field_70146_Z.nextInt(20) + 10.0f;
        this.baseSpeed = 0.35;
        this.updateAttributes();
    }

    @Override
    public boolean func_70692_ba() {
        return !this.getStolen();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(stolen, (Object)false);
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/thief.png");
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIThief(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != ((ItemStack)this.field_70180_af.func_187225_a(ITEM)).func_77973_b()) {
            this.func_184611_a(EnumHand.MAIN_HAND, ((ItemStack)this.field_70180_af.func_187225_a(ITEM)).func_77946_l());
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 25.0) != null && !this.getStolen()) {
            this.findPlayerToAttack();
        } else {
            this.func_70624_b(null);
        }
        if (this.getStolen()) {
            this.func_70624_b(null);
            if (this.field_70703_bu) {
                this.field_70159_w += this.goX * (double)0.3f;
                this.field_70179_y += this.goZ * (double)0.3f;
            } else {
                this.field_70159_w += this.goX;
                this.field_70179_y += this.goZ;
            }
            if (this.field_70167_r / this.field_70163_u == 1.0) {
                this.field_70159_w = this.field_70146_Z.nextInt(25) == 0 ? (this.field_70159_w -= this.goX) : (this.field_70159_w += this.goX);
                this.field_70179_y = this.field_70146_Z.nextInt(25) == 0 ? (this.field_70179_y -= this.goZ) : (this.field_70179_y += this.goZ);
            }
            if (this.field_70169_q == this.field_70165_t && this.field_70146_Z.nextInt(50) == 0) {
                this.goX *= -1.0;
            }
            if (this.field_70166_s == this.field_70161_v && this.field_70146_Z.nextInt(50) == 0) {
                this.goZ *= -1.0;
            }
            if (this.field_70146_Z.nextInt(500) == 0) {
                this.goX *= -1.0;
            }
            if (this.field_70146_Z.nextInt(700) == 0) {
                this.goZ *= -1.0;
            }
        } else {
            EntityLivingBase target = this.func_70638_az();
            if (target instanceof EntityPlayer && this.func_70068_e((Entity)target) < 16.0 && this.func_70685_l((Entity)target) && this.func_110143_aJ() > 0.0f) {
                EntityPlayer player = (EntityPlayer)target;
                ItemStack itemStack = null;
                for (ItemStack itemStack1 : player.field_71071_by.field_70462_a) {
                    if (itemStack1.func_190926_b()) continue;
                    itemStack = itemStack1;
                    if (this.field_70146_Z.nextInt(4) != 0) continue;
                    break;
                }
                if (itemStack == null) {
                    this.func_70624_b(null);
                } else {
                    this.func_184185_a(SoundEvents.field_187662_cZ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 6.2f + 1.0f);
                    int count = itemStack.func_190916_E();
                    int stolenAmount = this.field_70146_Z.nextInt(count) + 1;
                    if (stolenAmount > count) {
                        stolenAmount = count;
                    }
                    this.setStolen(true);
                    if (!this.field_70170_p.field_72995_K) {
                        ItemStack copy = itemStack.func_77946_l();
                        copy.func_190920_e(stolenAmount);
                        this.field_70180_af.func_187227_b(ITEM, (Object)copy);
                        this.field_70180_af.func_187217_b(ITEM);
                        itemStack.func_190918_g(stolenAmount);
                    }
                    this.func_184185_a(CreepsSoundHandler.thiefStealSound, this.func_70599_aP(), this.func_70647_i());
                    this.func_70624_b(null);
                    this.goX = 0.045;
                    this.goZ = 0.045;
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        this.goX *= -1.0;
                    }
                    if (this.field_70146_Z.nextInt(5) == 0) {
                        this.goZ *= -1.0;
                    }
                    for (int i = 0; i < 10; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                    }
                }
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.thiefSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.thiefHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.thiefDeathSound;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void setStolen(boolean b) {
        this.field_70180_af.func_187227_b(stolen, (Object)b);
    }

    public boolean getStolen() {
        return (Boolean)this.field_70180_af.func_187225_a(stolen);
    }

    public void findPlayerToAttack() {
        if (this.getStolen() || this.func_70638_az() != null) {
            return;
        }
        EntityPlayer player = this.field_70170_p.func_184136_b((Entity)this, 16.0);
        if (player != null) {
            for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                if (itemStack.func_190926_b()) continue;
                if (this.field_70146_Z.nextInt(2) == 0) {
                    this.func_184185_a(CreepsSoundHandler.thiefFindPlayerSound, this.func_70599_aP(), this.func_70647_i());
                }
                this.func_70624_b((EntityLivingBase)player);
                return;
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsThief");
        props.func_74757_a("Stolen", this.getStolen());
        props.func_74782_a("Item", (NBTBase)((ItemStack)this.field_70180_af.func_187225_a(ITEM)).func_77955_b(new NBTTagCompound()));
        compound.func_74782_a("MoreCreepsThief", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsThief");
        if (props.func_74764_b("Stolen")) {
            this.setStolen(props.func_74767_n("Stolen"));
        }
        this.field_70180_af.func_187227_b(ITEM, (Object)new ItemStack(props.func_74775_l("Item")));
        this.field_70180_af.func_187217_b(ITEM);
    }

    @Override
    protected void dropItemsOnDeath() {
        ItemStack itemStack = ((ItemStack)this.field_70180_af.func_187225_a(ITEM)).func_77946_l();
        if (!itemStack.func_190926_b()) {
            this.func_70099_a(itemStack, 0.0f);
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @Override
    public float maxShrink() {
        return 0.4f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

