/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGuineaPig;
import com.morecreepsrevival.morecreeps.common.entity.EntityHotdog;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntityTombstone
extends EntityCreepBase {
    private NBTTagCompound additionalProps = new NBTTagCompound();

    public EntityTombstone(World worldIn) {
        super(worldIn);
    }

    public EntityTombstone(World worldIn, EntityCreepBase deadEntity) {
        this(worldIn);
        this.creatureType = EnumCreatureType.AMBIENT;
        this.field_70728_aV = 0;
        this.func_70012_b(deadEntity.field_70165_t, deadEntity.field_70163_u, deadEntity.field_70161_v, deadEntity.field_70177_z, 0.0f);
        this.baseSpeed = 0.0;
        this.setBaseTexture(deadEntity.getBaseTexture());
        this.setCreepTypeName(deadEntity.getCreepTypeName());
        this.setLevel(deadEntity.getLevel());
        this.setCreepName(deadEntity.getCreepName());
        this.setExperience(deadEntity.getExperience());
        this.setTotalDamage(deadEntity.getTotalDamage());
        this.setArmor(deadEntity.getArmor());
        this.setInterest(deadEntity.getInterest());
        this.setOwner(deadEntity.func_184753_b());
        this.setWanderState(deadEntity.getWanderState());
        this.setHealthBoost(deadEntity.getHealthBoost());
        this.setSkillAttack(deadEntity.getSkillAttack());
        this.setSkillDefend(deadEntity.getSkillDefend());
        this.setSkillHealing(deadEntity.getSkillHealing());
        this.setSkillSpeed(deadEntity.getSkillSpeed());
        deadEntity.onTombstoneCreate(this.additionalProps);
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            return CreepsSoundHandler.tombstoneSound;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Override
    public boolean func_70094_T() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != CreepsItemHandler.lifeGem) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Use a \u00a74LifeGem\u00a7f on this tombstone to bring your pet back to life!"));
            }
            return true;
        }
        if (!this.isPlayerOwner(player)) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("This is not your tamed pet!"));
            }
            return true;
        }
        itemStack.func_190918_g(1);
        player.func_184609_a(hand);
        this.smoke();
        if (!this.field_70170_p.field_72995_K) {
            EntityCreepBase entity = null;
            switch (this.getCreepTypeName()) {
                case "Guinea Pig": {
                    entity = new EntityGuineaPig(this.field_70170_p);
                    break;
                }
                case "Hotdog": {
                    entity = new EntityHotdog(this.field_70170_p);
                    break;
                }
            }
            if (entity != null) {
                entity.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                entity.setBaseTexture(this.getBaseTexture());
                entity.setLevel(Math.max(1, this.getLevel() - 1));
                entity.setCreepName(this.getCreepName());
                entity.setExperience(this.getExperience());
                entity.setTotalDamage(this.getTotalDamage());
                entity.setArmor(this.getArmor());
                entity.setInterest(this.getInterest());
                entity.setOwner(this.func_184753_b());
                entity.setWanderState(this.getWanderState());
                entity.setHealthBoost(this.getHealthBoost());
                entity.setSkillAttack(this.getSkillAttack());
                entity.setSkillDefend(this.getSkillDefend());
                entity.setSkillHealing(this.getSkillHealing());
                entity.setSkillSpeed(this.getSkillSpeed());
                entity.onRevive(this.additionalProps);
                entity.setInitialHealth();
                this.field_70170_p.func_72838_d((Entity)entity);
                this.func_70106_y();
            }
        }
        return true;
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/tombstone.png");
    }

    @Override
    public void func_70636_d() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70636_d();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("MoreCreepsTombstone", (NBTBase)this.additionalProps);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.additionalProps = compound.func_74775_l("MoreCreepsTombstone");
    }

    @Override
    public boolean func_70097_a(@Nullable DamageSource damageSource, float amt) {
        return false;
    }
}

