/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.helpers.CreepsUtil;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityTrophy
extends EntityCreepBase {
    private static final int defaultLifetime = 75;
    private static final DataParameter<Integer> partyTime = EntityDataManager.func_187226_a(EntityTrophy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> trophyLifespan = EntityDataManager.func_187226_a(EntityTrophy.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> rotationDegrees = EntityDataManager.func_187226_a(EntityTrophy.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityTrophy(World world) {
        super(world);
        this.setCreepName("Trophy");
        this.setModelSize(1.5f);
        this.field_70728_aV = 0;
        this.baseHealth = 1.0f;
        this.baseSpeed = 0.0;
        this.func_184224_h(true);
        this.func_70105_a(1.0f, 5.0f);
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(partyTime, (Object)(this.field_70146_Z.nextInt(30) + 40));
        this.field_70180_af.func_187214_a(trophyLifespan, (Object)75);
        this.field_70180_af.func_187214_a(rotationDegrees, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.trophySmashSound;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/trophy.png");
    }

    @Override
    public void func_70636_d() {
        float rotationCurr = ((Float)this.field_70180_af.func_187225_a(rotationDegrees)).floatValue();
        if (rotationCurr < 360.0f) {
            this.field_70180_af.func_187227_b(rotationDegrees, (Object)Float.valueOf(rotationCurr + 9.0f));
        } else {
            this.field_70180_af.func_187227_b(rotationDegrees, (Object)Float.valueOf(rotationCurr - 351.0f));
        }
        this.func_70034_d(rotationCurr);
        this.func_181013_g(rotationCurr);
        this.func_70101_b(rotationCurr, 0.0f);
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (this.field_70181_x > 0.0) {
            this.field_70181_x = 0.0;
        }
        if ((Integer)this.field_70180_af.func_187225_a(partyTime) > 1) {
            this.field_70180_af.func_187227_b(partyTime, (Object)((Integer)this.field_70180_af.func_187225_a(partyTime) - 1));
            this.spawnConfetti();
        }
        if ((Integer)this.field_70180_af.func_187225_a(trophyLifespan) > 0) {
            this.field_70180_af.func_187227_b(trophyLifespan, (Object)((Integer)this.field_70180_af.func_187225_a(trophyLifespan) - 1));
            if ((Integer)this.field_70180_af.func_187225_a(trophyLifespan) < 1) {
                this.func_70106_y();
                int amt = this.field_70146_Z.nextInt(25) + 10;
                for (int i = 0; i < amt; ++i) {
                    this.func_145779_a(CreepsItemHandler.money, 1);
                }
            }
        }
    }

    @Override
    protected void dropItemsOnDeath() {
        int amt = this.field_70146_Z.nextInt(25) + 10;
        for (int i = 0; i < amt; ++i) {
            this.func_145779_a(CreepsItemHandler.money, 1);
        }
    }

    private void spawnConfetti() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            double factor1 = CreepsUtil.GetRandomUnitMinus(this.field_70146_Z);
            double factor2 = CreepsUtil.GetRandomUnitMinus(this.field_70146_Z);
            Vec2f movDir = new Vec2f((float)factor1, (float)factor2);
            Item selecteditem = (Item)Item.field_150901_e.func_186801_a(this.field_70146_Z);
            Particle particle = CreepsUtil.SpawnEatingParticle(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, movDir.field_189982_i * 0.11f, 0.6, movDir.field_189983_j * 0.11f, 1.5f, selecteditem);
            if (particle == null) break;
            particle.func_187114_a(80);
        }
    }

    public void positionCorrectlyAround(EntityPlayer player) {
        World world = player.field_70170_p;
        Vec3d plook = player.func_70676_i(1.0f);
        int result = -1;
        int ychange = 0;
        for (int i = 1; i <= 10; ++i) {
            double xv = player.field_70165_t + plook.field_72450_a * (double)i;
            double yv = 0.01 + (double)((int)player.field_70163_u);
            double zv = player.field_70161_v + plook.field_72449_c * (double)i;
            BlockPos p0 = new BlockPos(xv, yv + 1.0, zv);
            BlockPos p1 = new BlockPos(xv, yv - 1.0, zv);
            BlockPos p2 = new BlockPos(xv, yv - 2.0, zv);
            BlockPos p3 = new BlockPos(xv, yv + 2.0, zv);
            if (!world.func_175667_e(p0) || !world.func_175667_e(p1) || !world.func_175667_e(p2) || !world.func_175667_e(p3) || !world.func_175623_d(p0)) break;
            if (world.func_175623_d(new BlockPos(xv, yv, zv))) {
                if (world.func_175623_d(p1)) {
                    if (world.func_175623_d(p2)) break;
                    ychange = -1;
                    result = i;
                    continue;
                }
                ychange = 0;
                result = i;
                continue;
            }
            if (!world.func_175623_d(p3)) break;
            ychange = 1;
            result = i;
        }
        if (result == -1) {
            this.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        } else {
            this.func_70107_b(player.field_70165_t + plook.field_72450_a * (double)result, 0.001 + (double)((int)player.field_70163_u) + (double)ychange, player.field_70161_v + plook.field_72449_c * (double)result);
        }
    }
}

