/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityVHS
extends EntityCreepBase
implements IEntityCanChangeSize {
    private UUID angerTargetUUID;
    public int angerLevel;

    public EntityVHS(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Walking VHS");
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseSpeed = 0.35;
        this.baseHealth = 15.0f;
        this.angerLevel = 0;
        this.func_70105_a(1.55f, 1.25f);
        this.field_70728_aV = 10;
        this.updateAttributes();
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.75, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(32.0, 32.0, 32.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                if (!(entity1 instanceof EntityVHS)) continue;
                EntityVHS vhs = (EntityVHS)entity1;
                vhs.getAngry(entity);
            }
            this.getAngry(entity);
        }
        return super.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), i);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.angry()) {
            --this.angerLevel;
        }
    }

    private void getAngry(Entity entity) {
        this.func_70624_b((EntityLivingBase)entity);
        this.angerLevel += 100 + this.field_70146_Z.nextInt(100);
    }

    public boolean angry() {
        return this.angerLevel > 0;
    }

    public int func_142015_aE() {
        return this.angerLevel;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Item item;
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) == CreepsItemHandler.vhsTape) {
            this.func_70624_b(null);
            this.func_184185_a(CreepsSoundHandler.vhsInsert, this.func_70599_aP(), this.func_70647_i());
            itemStack.func_190918_g(1);
            for (int j = 0; j < 10; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(5) == 1) {
            this.func_145779_a(CreepsItemHandler.vhsTape, this.field_70146_Z.nextInt(1) + 1);
        }
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/vhs.png");
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.vhsHurt;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.vhsDeath;
    }

    @Override
    public float maxShrink() {
        return 0.3f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

