/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.MoreCreepsAndWeirdos;
import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityShrink;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageOpenGuiTamableEntityName;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityZebra
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final String[] names = new String[]{"Stanley", "Cid", "Hunchy", "The Heat", "Herman the Hump", "Dr. Hump", "Little Lousie", "Spoony G", "Mixmaster C", "The Maestro", "Duncan the Dude", "Charlie Camel", "Chip", "Charles Angstrom III", "Mr. Charles", "Cranky Carl", "Carl the Rooster", "Tiny the Peach", "Desert Dan", "Dungby", "Doofus"};
    private static final DataParameter<Integer> tamedCookies = EntityDataManager.func_187226_a(EntityZebra.class, (DataSerializer)DataSerializers.field_187192_b);
    private int gallopTime = 0;

    public EntityZebra(World worldIn) {
        super(worldIn);
        this.setCreepTypeName("Zebra");
        this.setModelSize(2.0f);
        this.func_70105_a(this.field_70130_N * 2.0f, this.field_70131_O * 2.0f);
        this.baseHealth = 25.0f;
        this.baseAttackDamage = 2.0;
        this.baseSpeed = 0.325f;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(tamedCookies, (Object)(this.field_70146_Z.nextInt(7) + 1));
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/zebra.png");
    }

    @Override
    protected String[] getTamedNames() {
        return names;
    }

    @Override
    public float func_180484_a(BlockPos blockPos) {
        Block block = this.field_70170_p.func_180495_p(blockPos).func_177230_c();
        if (block == Blocks.field_150362_t || block == Blocks.field_150349_c) {
            return 10.0f;
        }
        return super.func_180484_a(blockPos);
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.horseHeadSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.hippoHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.hippoDeathSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(Items.field_151147_al, this.field_70146_Z.nextInt(3) + 1);
        }
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_145779_a(CreepsItemHandler.zebraHide, 1);
        }
    }

    public int func_70641_bl() {
        return 5;
    }

    @Override
    public void func_70636_d() {
        this.field_70158_ak = true;
        super.func_70636_d();
    }

    @Override
    public boolean isTamable() {
        return true;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.getFirstPassenger();
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger) && passenger instanceof EntityPlayer) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + 2.5 - (double)((2.75f - this.getModelSize()) * 1.1f), this.field_70161_v);
            return;
        }
        super.func_184232_k(passenger);
    }

    @Override
    public boolean isRideable() {
        return true;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            Entity controllingPassenger = this.func_184179_bs();
            if (!(controllingPassenger instanceof EntityLivingBase)) {
                return;
            }
            EntityLivingBase riddenByEntity = (EntityLivingBase)controllingPassenger;
            this.baseSpeed = 1.95;
            this.updateMoveSpeed();
            riddenByEntity.field_70137_T = 0.0;
            this.field_70126_B = this.field_70177_z = riddenByEntity.field_70177_z;
            this.field_70125_A = 0.0f;
            this.field_70127_C = 0.0f;
            float f = 1.0f;
            double moveSpeed = riddenByEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
            if (moveSpeed > 0.01 && moveSpeed < 10.0) {
                f = (float)moveSpeed;
            }
            forward = riddenByEntity.field_191988_bg / f * (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 1.95f;
            strafe = riddenByEntity.field_70702_br / f * (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 1.95f;
            if (this.field_70122_E && (forward != 0.0f || strafe != 0.0f)) {
                this.field_70181_x += (double)0.1610004f;
            }
            if (forward == 0.0f && strafe == 0.0f) {
                this.field_70703_bu = false;
                this.gallopTime = 0;
            }
            if (forward != 0.0f && this.gallopTime++ > 10) {
                this.gallopTime = 0;
                if (this.func_70072_I()) {
                    this.func_184185_a(CreepsSoundHandler.giraffeSplashSound, this.func_70599_aP(), 1.2f);
                } else {
                    this.func_184185_a(CreepsSoundHandler.giraffeGallopSound, this.func_70599_aP(), 1.2f);
                }
            }
            if (this.field_70122_E && !this.field_70703_bu) {
                if (riddenByEntity instanceof EntityPlayer && MoreCreepsAndWeirdos.proxy.isJumpKeyDown((EntityPlayer)riddenByEntity)) {
                    this.field_70703_bu = true;
                }
                if (this.field_70703_bu) {
                    this.field_70181_x += (double)0.37f;
                }
            }
            if (this.field_70122_E && this.field_70703_bu) {
                double d = Math.abs(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                if (d > 0.13) {
                    double d2 = 0.13 / d;
                    this.field_70159_w *= d2;
                    this.field_70179_y *= d2;
                }
                this.field_70159_w *= 2.95;
                this.field_70179_y *= 2.95;
            }
        } else {
            this.baseSpeed = 0.2;
            this.updateMoveSpeed();
        }
        super.func_191986_a(strafe, vertical, forward);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        if (this.isTamed()) {
            if (player.func_70093_af() && this.isPlayerOwner(player)) {
                if (!this.field_70170_p.field_72995_K) {
                    CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageOpenGuiTamableEntityName(this.func_145782_y()), (EntityPlayerMP)player);
                }
                return true;
            }
        } else if (!this.func_184207_aI()) {
            ItemStack itemStack = player.func_184586_b(hand);
            if (!itemStack.func_190926_b()) {
                Item item = itemStack.func_77973_b();
                if (item == Items.field_151106_aX) {
                    this.func_184185_a(CreepsSoundHandler.hotdogEatSound, this.func_70599_aP(), this.func_70647_i());
                    itemStack.func_190918_g(1);
                    this.setHealthBoost(this.getHealthBoost() + 10);
                    this.updateHealth();
                    this.addHealth(10.0f);
                    int cookieCount = this.getTamedCookies();
                    this.setTamedCookies(--cookieCount);
                    if (cookieCount > 0) {
                        if (!this.field_70170_p.field_72995_K) {
                            player.func_145747_a((ITextComponent)new TextComponentString("You need \u00a76" + cookieCount + " cookie" + (cookieCount == 1 ? "" : "s") + " \u00a7fto tame this speedy Zebra."));
                        }
                    } else {
                        this.tame(player);
                    }
                    this.smoke();
                    return true;
                }
            } else if (!this.field_70170_p.field_72995_K) {
                int cookieCount = this.getTamedCookies();
                player.func_145747_a((ITextComponent)new TextComponentString("You need \u00a76" + cookieCount + " cookie" + (cookieCount == 1 ? "" : "s") + " \u00a7fto tame this speedy Zebra."));
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean func_70094_T() {
        if (this.getFirstPassenger() != null) {
            return false;
        }
        return super.func_70094_T();
    }

    @Override
    public boolean canPlayerRide(EntityPlayer player) {
        if (this.isPlayerOwner(player) && this.getModelSize() < 1.0f) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Your Zebra is too small to ride!"));
            }
            return false;
        }
        return super.canPlayerRide(player);
    }

    protected void setTamedCookies(int i) {
        this.field_70180_af.func_187227_b(tamedCookies, (Object)i);
    }

    public int getTamedCookies() {
        return (Integer)this.field_70180_af.func_187225_a(tamedCookies);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsZebra");
        props.func_74768_a("TamedCookies", this.getTamedCookies());
        compound.func_74782_a("MoreCreepsZebra", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsZebra");
        if (props.func_74764_b("TamedCookies")) {
            this.setTamedCookies(props.func_74762_e("TamedCookies"));
        }
    }

    @Override
    protected void doAttackJump(Entity entity) {
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(entity.field_70161_v - this.field_70161_v, entity.field_70165_t - this.field_70165_t)) - 90.0f;
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        this.field_70159_w = d0 / f * 0.2 * (0.850000011920929 + this.field_70159_w * (double)0.2f);
        this.field_70179_y = d1 / f * 0.2 * ((double)0.8f + this.field_70179_y * (double)0.2f);
        this.field_70181_x = 0.10000000596246449;
        this.field_70143_R = -25.0f;
    }

    @Override
    public boolean func_70652_k(@Nonnull Entity entity) {
        return super.func_70652_k(entity);
    }

    @Override
    protected SoundEvent getTamedSound() {
        return CreepsSoundHandler.guineaPigLevelUpSound;
    }

    @Override
    public float maxShrink() {
        return 0.3f;
    }

    @Override
    public float getShrinkRayAmount() {
        return 0.2f;
    }

    @Override
    public void onShrink(EntityShrink source) {
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }

    @Override
    public float getGrowRayAmount() {
        return 0.2f;
    }

    @Override
    public void onGrow(EntityGrow source) {
    }
}

