/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.world;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.entity.EntityCastleCritter;
import com.morecreepsrevival.morecreeps.common.entity.EntityCastleGuard;
import com.morecreepsrevival.morecreeps.common.entity.EntityCastleKing;
import com.morecreepsrevival.morecreeps.common.entity.EntityMummy;
import com.morecreepsrevival.morecreeps.common.helpers.CreepsUtil;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenCastle
extends WorldGenerator {
    private static Template STRUCTURE = null;
    private static BlockPos SIZE_STRUCTURE = null;
    private static final int maxObstruct = 300;
    private static final int castleHeight = 5;
    private int topFloor = 0;
    private int floor = 1;

    public static boolean tryCasheStructure(World world) {
        if (STRUCTURE != null) {
            return true;
        }
        ResourceLocation location = new ResourceLocation("morecreeps", "castle(noentities)");
        MinecraftServer serv = world.func_73046_m();
        TemplateManager manager = ((WorldServer)world).func_184163_y();
        STRUCTURE = manager.func_189942_b(serv, location);
        if (STRUCTURE == null) {
            return false;
        }
        SIZE_STRUCTURE = STRUCTURE.func_186259_a();
        return true;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        return this.newGenerate(world, rand, pos);
    }

    public boolean newGenerate(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        if (!WorldGenCastle.tryCasheStructure(world)) {
            return false;
        }
        BlockPos structurepos = this.findStructurePos(world, rand, pos);
        if (structurepos == null) {
            return false;
        }
        BlockPos structuresize = SIZE_STRUCTURE;
        PlacementSettings settings = new PlacementSettings().func_186226_b(false).func_186222_a(false);
        IBlockState state = world.func_180495_p(structurepos);
        world.func_184138_a(structurepos, state, state, 3);
        STRUCTURE.func_186253_b(world, structurepos, settings);
        int stx = structuresize.func_177958_n() + structurepos.func_177958_n();
        int sty = structurepos.func_177956_o() - 1;
        int stz = structuresize.func_177952_p() + structurepos.func_177952_p();
        int bgx = structurepos.func_177958_n() - 1;
        int bgy = structurepos.func_177956_o() - 11;
        int bgz = structurepos.func_177952_p() - 1;
        Biome biome = world.func_180494_b(structurepos);
        Block topblock = biome.field_76752_A.func_177230_c();
        Block fillerblock = biome.field_76753_B.func_177230_c();
        this.fillCorners(world, topblock, bgx, sty + 1, bgz, stx, sty + 1, stz);
        this.fillCorners(world, fillerblock, bgx, bgy, bgz, stx, sty, stz);
        EntityCastleKing king = new EntityCastleKing(world);
        king.func_70012_b(structurepos.func_177958_n() + structuresize.func_177958_n() / 2, structurepos.func_177956_o() + structuresize.func_177956_o(), structurepos.func_177952_p() + structuresize.func_177952_p() / 2, 360.0f, 0.0f);
        king.determineBaseTexture();
        king.setInitialHealth();
        king.setNoDespawn(true);
        world.func_72838_d((Entity)king);
        return true;
    }

    public boolean oldGenerate(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        int k;
        int j;
        int i;
        Biome biome = world.func_180494_b(pos);
        if (!(MoreCreepsConfig.spawnInNonVanillaBiomes && MoreCreepsConfig.hasBiome(Objects.requireNonNull(biome.getRegistryName()).toString()) || Objects.requireNonNull(biome.getRegistryName()).func_110624_b().equals("minecraft"))) {
            return false;
        }
        for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
            if (type != BiomeDictionary.Type.NETHER && type != BiomeDictionary.Type.END) continue;
            return false;
        }
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int castleX = x + rand.nextInt(8) - rand.nextInt(8);
        int castleY = 200;
        int castleZ = z + rand.nextInt(8) - rand.nextInt(8);
        int castlePosX = castleX;
        int castlePosY = castleY;
        int castlePosZ = castleZ;
        int foundation = 0;
        int foundationDepth = 0;
        boolean alternate = true;
        while (foundation < 3) {
            foundation = 0;
            Block block1 = world.func_180495_p(new BlockPos(castlePosX - 4, castlePosY - foundationDepth, castlePosZ - 4)).func_177230_c();
            Block block2 = world.func_180495_p(new BlockPos(castlePosX + 30, castlePosY - foundationDepth, castlePosZ - 4)).func_177230_c();
            Block block3 = world.func_180495_p(new BlockPos(castlePosX - 4, castlePosY - foundationDepth, castlePosZ + 30)).func_177230_c();
            Block block4 = world.func_180495_p(new BlockPos(castlePosX + 30, castlePosY - foundationDepth, castlePosZ + 30)).func_177230_c();
            if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i || block2 == Blocks.field_150355_j || block2 == Blocks.field_150358_i || block3 == Blocks.field_150355_j || block3 == Blocks.field_150358_i || block4 == Blocks.field_150355_j || block4 == Blocks.field_150358_i) {
                return false;
            }
            if (block1 != Blocks.field_150350_a && block1 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block2 != Blocks.field_150350_a && block2 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block3 != Blocks.field_150350_a && block3 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block4 != Blocks.field_150350_a && block4 != Blocks.field_150362_t) {
                ++foundation;
            }
            ++foundationDepth;
        }
        castlePosY = castleY = castlePosY - foundationDepth + 2;
        if (!(world.func_175667_e(new BlockPos(castleX - 4, castleY, castleZ - 4)) && world.func_175667_e(new BlockPos(castleX + 30, castleY, castleZ - 4)) && world.func_175667_e(new BlockPos(castleX + 30, castleY, castleZ + 30)) && world.func_175667_e(new BlockPos(castleX - 4, castleY, castleZ + 30)))) {
            return false;
        }
        int maxI = 42;
        int area = 0;
        for (i = 0; i < maxI; i += 2) {
            for (int k2 = -12 + i; k2 < 38; k2 += 2) {
                for (j = -12 + i; j < 38; j += 2) {
                    Block block = world.func_180495_p(new BlockPos(x + k2, castlePosY + i, z + j)).func_177230_c();
                    if (block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150364_r || block == Blocks.field_150363_s || ++area <= 300) continue;
                    return false;
                }
            }
        }
        this.floor = 1;
        this.topFloor = 0;
        for (i = -1; i < maxI; ++i) {
            for (int k3 = -12; k3 < 38; ++k3) {
                for (j = -12; j < 38; ++j) {
                    world.func_175698_g(new BlockPos(castlePosX + k3, castlePosY + i, castlePosZ + j));
                }
            }
        }
        for (i = 2; i < 5; ++i) {
            for (int k4 = -12; k4 < 38; ++k4) {
                for (j = -12; j < 38; ++j) {
                    BlockPos blockPos = new BlockPos(castlePosX + k4, castlePosY - i, castlePosZ + j);
                    if (!world.func_175623_d(blockPos)) continue;
                    world.func_175656_a(blockPos, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
        for (i = -10; i < 36; ++i) {
            for (int k5 = -10; k5 < 36; ++k5) {
                world.func_175656_a(new BlockPos(castlePosX + i, castlePosY - 1, castlePosZ + k5), Blocks.field_150355_j.func_176223_P());
            }
        }
        maxI = 28;
        for (i = -7; i < maxI; i += 7) {
            TileEntityMobSpawner spawner;
            BlockPos blockPos;
            int spawnX;
            for (int k6 = -4; k6 < 30; ++k6) {
                for (j = -4; j < 30; ++j) {
                    BlockPos blockPos2 = new BlockPos(castlePosX + k6, castlePosY + 6 + i, castlePosZ + j);
                    if ((world.func_175623_d(blockPos2) || world.func_180495_p(blockPos2).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(blockPos2).func_177230_c() == Blocks.field_150358_i) && rand.nextInt(50) != 0) {
                        world.func_175656_a(blockPos2, Blocks.field_150334_T.func_176223_P());
                    }
                    if (!world.func_175623_d(blockPos2 = new BlockPos(castlePosX + k6, castlePosY + 7 + i, castlePosZ + j)) || rand.nextInt(25) != 0 || i >= 21) continue;
                    world.func_175656_a(blockPos2, Blocks.field_150321_G.func_176223_P());
                    if (rand.nextInt(10) != 0) continue;
                    world.func_175656_a(new BlockPos(castlePosX + k6, castlePosY + 8 + i, castlePosZ + j), Blocks.field_150321_G.func_176223_P());
                }
            }
            int placed = 0;
            while (placed < 2) {
                int spawnZ;
                spawnX = rand.nextInt(20) - 10;
                blockPos = new BlockPos(castlePosX + 10 + spawnX, castlePosY + 7 + i, castlePosZ + 5 + (spawnZ = rand.nextInt(20) - 10));
                if (!world.func_175623_d(blockPos)) continue;
                world.func_175656_a(blockPos, Blocks.field_150474_ac.func_176223_P());
                spawner = new TileEntityMobSpawner();
                spawner.func_145881_a().func_190894_a(this.populateSpawner(rand));
                world.func_175690_a(blockPos, (TileEntity)spawner);
                ++placed;
            }
            if (i != 21) continue;
            placed = 0;
            while (placed < 2) {
                int spawnZ;
                spawnX = rand.nextInt(20) - 10;
                blockPos = new BlockPos(castlePosX + 10 + spawnX, castlePosY + 7 + i, castlePosZ + 5 + (spawnZ = rand.nextInt(20) - 10));
                if (!world.func_175623_d(blockPos)) continue;
                world.func_175656_a(blockPos, Blocks.field_150474_ac.func_176223_P());
                spawner = new TileEntityMobSpawner();
                spawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityCastleGuard.class));
                world.func_175690_a(blockPos, (TileEntity)spawner);
                ++placed;
            }
        }
        this.buildTower(world, rand, castleX, castleY, castleZ, castlePosX, castlePosY, castlePosZ, true, new ItemStack(CreepsItemHandler.earthGem), rand.nextInt(5) + 1);
        maxI = 29;
        for (i = 5; i < 20; ++i) {
            for (int k7 = 0; k7 < 10; ++k7) {
                for (j = -2; j < maxI; ++j) {
                    world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + j, castlePosZ - 5), this.cobbler(1, rand));
                }
            }
        }
        for (i = 4; i < 21; ++i) {
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 29, castlePosZ - 5), this.cobbler(1, rand));
            }
            alternate = !alternate;
            world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 20, castlePosZ - 6), this.cobbler(1, rand));
            world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 16, castlePosZ - 6), this.cobbler(1, rand));
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 10, castlePosZ - 6), this.cobbler(1, rand));
            }
            world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 9, castlePosZ - 6), this.cobbler(1, rand));
        }
        this.buildTower(world, rand, castleX, castleY, castleZ, castlePosX + 25, castlePosY, castlePosZ, false, new ItemStack(CreepsItemHandler.miningGem), rand.nextInt(5) + 1);
        for (i = 5; i < 20; ++i) {
            for (int j2 = 0; j2 < 10; ++j2) {
                for (k = -2; k < maxI; ++k) {
                    world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + k, castlePosZ + 29), this.cobbler(1, rand));
                }
            }
        }
        for (i = 4; i < 21; ++i) {
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 29, castlePosZ + 29), this.cobbler(1, rand));
            }
            alternate = !alternate;
            world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 20, castlePosZ + 30), this.cobbler(1, rand));
            world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 16, castlePosZ + 30), this.cobbler(1, rand));
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 10, castlePosZ + 30), this.cobbler(1, rand));
            }
            world.func_175656_a(new BlockPos(castlePosX + i, castlePosY + 9, castlePosZ + 30), this.cobbler(1, rand));
        }
        this.buildTower(world, rand, castleX, castleY, castleZ, castlePosX + 25, castlePosY, castlePosZ + 25, false, new ItemStack(CreepsItemHandler.skyGem), rand.nextInt(5) + 1);
        for (i = 5; i < 20; ++i) {
            for (int j3 = 0; j3 < 10; ++j3) {
                for (k = -2; k < maxI; ++k) {
                    world.func_175656_a(new BlockPos(castlePosX - 5, castlePosY + k, castlePosZ + i), this.cobbler(1, rand));
                }
            }
        }
        for (i = 4; i < 21; ++i) {
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX - 5, castlePosY + 29, castlePosZ + i), this.cobbler(1, rand));
            }
            alternate = !alternate;
            world.func_175656_a(new BlockPos(castlePosX - 6, castlePosY + 20, castlePosZ + i), this.cobbler(1, rand));
            world.func_175656_a(new BlockPos(castlePosX - 6, castlePosY + 16, castlePosZ + i), this.cobbler(1, rand));
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX - 6, castlePosY + 10, castlePosZ + i), this.cobbler(1, rand));
            }
            world.func_175656_a(new BlockPos(castlePosX - 6, castlePosY + 9, castlePosZ + i), this.cobbler(1, rand));
        }
        this.buildTower(world, rand, castleX, castleY, castleZ, castlePosX, castlePosY, castlePosZ + 25, true, new ItemStack(CreepsItemHandler.healingGem), rand.nextInt(5) + 1);
        for (i = 5; i < 20; ++i) {
            for (int j4 = 0; j4 < 10; ++j4) {
                for (k = -2; k < maxI; ++k) {
                    world.func_175656_a(new BlockPos(castlePosX + 29, castlePosY + k, castlePosZ + i), this.cobbler(1, rand));
                }
            }
        }
        for (i = 4; i < 21; ++i) {
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX + 29, castlePosY + 29, castlePosZ + i), this.cobbler(1, rand));
            }
            alternate = !alternate;
            world.func_175656_a(new BlockPos(castlePosX + 30, castlePosY + 20, castlePosZ + i), this.cobbler(1, rand));
            world.func_175656_a(new BlockPos(castlePosX + 30, castlePosY + 16, castlePosZ + i), this.cobbler(1, rand));
            if (alternate) {
                world.func_175656_a(new BlockPos(castlePosX + 30, castlePosY + 10, castlePosZ + i), this.cobbler(1, rand));
            }
            world.func_175656_a(new BlockPos(castlePosX + 30, castlePosY + 9, castlePosZ + i), this.cobbler(1, rand));
        }
        maxI = 22;
        for (i = 0; i < maxI; i += 7) {
            for (int j5 = 6; j5 < 20; j5 += 3) {
                CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + j5, castlePosY + 4 + i, castlePosZ - 4));
                CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + j5, castlePosY + 4 + i, castlePosZ + 28));
                if (j5 <= 6 || j5 >= 17) continue;
                CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX - 4, castlePosY + 4 + i, castlePosZ + j5));
                CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 28, castlePosY + 4 + i, castlePosZ + j5));
            }
        }
        for (i = 11; i < 15; ++i) {
            for (int j6 = 0; j6 < 4; ++j6) {
                world.func_175698_g(new BlockPos(castlePosX + i, castlePosY + j6, castlePosZ - 5));
                world.func_175698_g(new BlockPos(castlePosX + i, castlePosY + j6, castlePosZ + 29));
            }
        }
        for (i = 11; i < 15; ++i) {
            for (int j7 = 0; j7 < 6; ++j7) {
                for (k = 0; k < 4; ++k) {
                    world.func_175656_a(new BlockPos(castlePosX + i, castlePosY - 1, castlePosZ - 6 - j7), Blocks.field_150344_f.func_176223_P());
                    world.func_175656_a(new BlockPos(castlePosX + i, castlePosY - 1, castlePosZ + 30 + j7), Blocks.field_150344_f.func_176223_P());
                }
            }
        }
        CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 9, castlePosY + 5, castlePosZ + 30));
        CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 16, castlePosY + 5, castlePosZ + 30));
        CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 9, castlePosY + 5, castlePosZ - 6));
        CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 16, castlePosY + 5, castlePosZ - 6));
        maxI = 35;
        for (i = 0; i < maxI; i += 7) {
            for (int j8 = 0; j8 < 2; ++j8) {
                world.func_175656_a(new BlockPos(castlePosX + 17, castlePosY + i, castlePosZ - 1 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
                world.func_175656_a(new BlockPos(castlePosX + 5, castlePosY + i, castlePosZ - 1 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
                world.func_175656_a(new BlockPos(castlePosX + 17, castlePosY + i, castlePosZ + 24 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
                world.func_175656_a(new BlockPos(castlePosX + 5, castlePosY + i, castlePosZ + 24 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
                world.func_175656_a(new BlockPos(castlePosX + 19, castlePosY + i, castlePosZ - 1 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
                world.func_175656_a(new BlockPos(castlePosX + 7, castlePosY + i, castlePosZ - 1 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
                world.func_175656_a(new BlockPos(castlePosX + 19, castlePosY + i, castlePosZ + 24 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
                world.func_175656_a(new BlockPos(castlePosX + 7, castlePosY + i, castlePosZ + 24 + j8), Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
            }
        }
        for (i = 0; i < maxI; i += 7) {
            for (int j9 = 0; j9 < 7; ++j9) {
                for (k = 0; k < 9; ++k) {
                    world.func_175656_a(new BlockPos(castlePosX + 9 + j9, castlePosY + i, castlePosZ + 16 - k), Blocks.field_150333_U.func_176223_P());
                }
            }
        }
        for (i = 0; i < maxI; i += 7) {
            for (int j10 = 0; j10 < 9; j10 += 3) {
                world.func_175656_a(new BlockPos(castlePosX + 9 + j10, castlePosY + i, castlePosZ + 16), Blocks.field_150334_T.func_176223_P());
                world.func_175656_a(new BlockPos(castlePosX + 9 + j10, castlePosY + i + 1, castlePosZ + 16), Blocks.field_150334_T.func_176223_P());
                CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 9 + j10, castlePosY + i + 2, castlePosZ + 16));
                world.func_175656_a(new BlockPos(castlePosX + 9 + j10, castlePosY + i, castlePosZ + 8), Blocks.field_150334_T.func_176223_P());
                world.func_175656_a(new BlockPos(castlePosX + 9 + j10, castlePosY + i + 1, castlePosZ + 8), Blocks.field_150334_T.func_176223_P());
                CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 9 + j10, castlePosY + i + 2, castlePosZ + 8));
            }
        }
        boolean gemFlag = false;
        int gemRand = rand.nextInt(5) + 1;
        for (int i2 = 0; i2 < maxI; i2 += 7) {
            world.func_175656_a(new BlockPos(castlePosX + 12, castlePosY + i2, castlePosZ + 13), Blocks.field_150334_T.func_176223_P());
            world.func_175656_a(new BlockPos(castlePosX + 12, castlePosY + i2, castlePosZ + 12), Blocks.field_150334_T.func_176223_P());
            world.func_175656_a(new BlockPos(castlePosX + 12, castlePosY + i2 + 1, castlePosZ + 12), Blocks.field_150486_ae.func_176223_P());
            BlockPos chestPos = new BlockPos(castlePosX + 12, castlePosY + i2 + 1, castlePosZ + 13);
            world.func_175656_a(chestPos, Blocks.field_150486_ae.func_176223_P());
            TileEntityChest chest = new TileEntityChest();
            world.func_175690_a(chestPos, (TileEntity)chest);
            int maxJ = rand.nextInt(20);
            for (int j11 = 0; j11 < maxJ; ++j11) {
                ItemStack itemStack = this.populateChest(this.floor, rand);
                if (itemStack != null) {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), itemStack);
                }
                if (gemFlag || gemRand != i2 / 7) continue;
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), new ItemStack(CreepsItemHandler.fireGem));
                gemFlag = true;
            }
        }
        EntityCastleKing king = new EntityCastleKing(world);
        king.func_70012_b(castlePosX + 15, castlePosY + 35, castlePosZ + 12, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        king.determineBaseTexture();
        king.setInitialHealth();
        king.setNoDespawn(true);
        world.func_72838_d((Entity)king);
        return true;
    }

    private boolean mobExists(String mobClass) {
        return false;
    }

    private ResourceLocation populateSpawner(Random rand) {
        if (this.topFloor == 1) {
            return EntityList.func_191306_a(EntityCastleGuard.class);
        }
        int i = rand.nextInt(10);
        switch (this.floor) {
            case 0: {
                if (i < 5) {
                    return EntityList.func_191306_a(EntityCastleCritter.class);
                }
                return EntityList.func_191306_a(EntitySkeleton.class);
            }
            case 1: {
                if (i < 5) {
                    return EntityList.func_191306_a(EntityCastleCritter.class);
                }
                return EntityList.func_191306_a(EntityCastleGuard.class);
            }
            case 2: {
                if (i > 5) {
                    return EntityList.func_191306_a(EntityMummy.class);
                }
                if (i < 5) {
                    return EntityList.func_191306_a(EntityCastleCritter.class);
                }
                return EntityList.func_191306_a(EntityCastleGuard.class);
            }
            case 3: {
                if (i < 5) {
                    return EntityList.func_191306_a(EntityCastleCritter.class);
                }
                return EntityList.func_191306_a(EntitySkeleton.class);
            }
            case 4: {
                if (i < 5) {
                    return EntityList.func_191306_a(EntitySpider.class);
                }
                return EntityList.func_191306_a(EntitySkeleton.class);
            }
            case 5: {
                if (i < 5) {
                    return EntityList.func_191306_a(EntityCastleCritter.class);
                }
                return EntityList.func_191306_a(EntityCastleGuard.class);
            }
        }
        return EntityList.func_191306_a(EntityCastleGuard.class);
    }

    private void buildTower(World world, Random rand, int castleX, int castleY, int castleZ, int castlePosX, int castlePosY, int castlePosZ, boolean backTower, ItemStack gemType, int gemFloor) {
        int topY = castlePosY - 13;
        int l = rand.nextInt(3);
        boolean gemFlag = false;
        int maxI = 6;
        this.floor = 1;
        this.topFloor = 0;
        for (int i = 0; i < maxI; ++i) {
            int k;
            topY += 7;
            if (i == 5) {
                this.topFloor = 1;
            }
            for (k = 0; k < 7; ++k) {
                if (topY == castlePosY - 6 && k < 4) {
                    k = 4;
                }
                for (int j = -7; j < 7; ++j) {
                    for (int q = -7; q < 7; ++q) {
                        int x = j + castlePosX;
                        int y = k + topY;
                        int z = q + castlePosZ;
                        BlockPos blockPos = new BlockPos(x, y, z);
                        if (q == -7) {
                            if (j <= -5 || j >= 4) continue;
                            world.func_175656_a(blockPos, this.cobbler(l, rand));
                            continue;
                        }
                        if (q == -6 || q == -5) {
                            if (j == -5 || j == 4) {
                                world.func_175656_a(blockPos, this.cobbler(l, rand));
                                continue;
                            }
                            if (q == -6) {
                                if (j == (k + 1) % 7 - 3) {
                                    if (k == 6 && this.topFloor == 1) {
                                        world.func_175656_a(blockPos, this.cobbler(l, rand));
                                    } else {
                                        world.func_175656_a(blockPos, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
                                    }
                                    if (k != 5) continue;
                                    world.func_175656_a(new BlockPos(x - 7, y, z), Blocks.field_150334_T.func_176223_P());
                                    continue;
                                }
                                if (j >= 4 || j <= -5) continue;
                                world.func_175698_g(blockPos);
                                continue;
                            }
                            if (q != -5 || j <= -5 || j >= 5) continue;
                            if (k != 0 && k != 6 || j != -4 && j != 3) {
                                if (k == 5 && (j == 3 || j == -4)) {
                                    world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                    continue;
                                }
                                world.func_175656_a(blockPos, this.cobbler(l, rand));
                                continue;
                            }
                            world.func_175698_g(blockPos);
                            continue;
                        }
                        if (q == -4 || q == -3 || q == 2 || q == 3) {
                            if (j == -6 || j == 5) {
                                world.func_175656_a(blockPos, this.cobbler(l, rand));
                                continue;
                            }
                            if (j <= -6 || j >= 5) continue;
                            if (k == 5) {
                                world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                continue;
                            }
                            if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150486_ae) continue;
                            world.func_175698_g(blockPos);
                            continue;
                        }
                        if (q > -3 && q < 2) {
                            if (j == -7 || j == 6) {
                                if (k < 0 || k > 3 || j != -7 && j != 6 || q != -1 && q != 0) {
                                    world.func_175656_a(blockPos, this.cobbler(l, rand));
                                    continue;
                                }
                                if ((j != -7 || !backTower) && (j != 6 || backTower)) continue;
                                world.func_175656_a(blockPos, Blocks.field_150359_w.func_176223_P());
                                continue;
                            }
                            if (j <= -7 || j >= 6) continue;
                            if (k == 5) {
                                world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                continue;
                            }
                            world.func_175698_g(blockPos);
                            continue;
                        }
                        if (q == 4) {
                            if (j == -5 || j == 4) {
                                world.func_175656_a(blockPos, this.cobbler(l, rand));
                                continue;
                            }
                            if (j <= -5 || j >= 4) continue;
                            if (k == 5) {
                                world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                continue;
                            }
                            world.func_175698_g(blockPos);
                            continue;
                        }
                        if (q == 5) {
                            if (j == -4 || j == -3 || j == 2 || j == 3) {
                                world.func_175656_a(blockPos, this.cobbler(l, rand));
                                continue;
                            }
                            if (j <= -3 || j >= 2) continue;
                            if (k == 5) {
                                world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                continue;
                            }
                            world.func_175656_a(blockPos, this.cobbler(l, rand));
                            continue;
                        }
                        if (q != 6 || j <= -3 || j >= 2) continue;
                        world.func_175656_a(blockPos, this.cobbler(l, rand));
                    }
                }
            }
            if (this.floor == 2) {
                world.func_175656_a(new BlockPos(castlePosX + 3, topY, castlePosZ - 5), this.cobbler(l, rand));
                world.func_175656_a(new BlockPos(castlePosX + 3, topY - 1, castlePosZ - 5), this.cobbler(l, rand));
            }
            if (this.topFloor != 1) {
                if (rand.nextInt(5) == 0) {
                    BlockPos blockPos = new BlockPos(castlePosX + 2, topY + 6, castlePosZ + 2);
                    world.func_175656_a(blockPos, Blocks.field_150474_ac.func_176223_P());
                    TileEntityMobSpawner mobSpawner = new TileEntityMobSpawner();
                    mobSpawner.func_145881_a().func_190894_a(this.populateSpawner(rand));
                    world.func_175690_a(blockPos, (TileEntity)mobSpawner);
                }
                BlockPos blockPos = new BlockPos(castlePosX - 3, topY + 6, castlePosZ + 2);
                world.func_175656_a(blockPos, Blocks.field_150474_ac.func_176223_P());
                TileEntityMobSpawner mobSpawner = new TileEntityMobSpawner();
                mobSpawner.func_145881_a().func_190894_a(this.populateSpawner(rand));
                world.func_175690_a(blockPos, (TileEntity)mobSpawner);
                world.func_175656_a(new BlockPos(castlePosX, topY + 6, castlePosZ - 3), Blocks.field_150334_T.func_176223_P());
                world.func_175656_a(new BlockPos(castlePosX - 1, topY + 6, castlePosZ - 3), Blocks.field_150334_T.func_176223_P());
            }
            if (topY + 56 >= 120 && this.floor == 1) {
                this.floor = 2;
            }
            if (this.topFloor != 1) {
                for (k = 0; k < 2; ++k) {
                    BlockPos blockPos1 = new BlockPos(castlePosX - k, topY + 7, castlePosZ - 3);
                    world.func_175656_a(blockPos1, Blocks.field_150486_ae.func_176223_P());
                    TileEntityChest chest = new TileEntityChest();
                    world.func_175690_a(blockPos1, (TileEntity)chest);
                    int maxJ = 1 + l + k;
                    for (int j = 0; j < maxJ; ++j) {
                        ItemStack itemStack = this.populateChest(this.floor, rand);
                        if (itemStack == null) continue;
                        chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), itemStack);
                    }
                    if (gemFloor != this.floor || gemFlag) continue;
                    chest.func_70299_a(0, gemType);
                    gemFlag = true;
                }
            }
            CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 3, topY, castlePosZ - 6));
            CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX - 4, topY, castlePosZ - 6));
            CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX + 1, topY, castlePosZ - 4));
            CreepsUtil.TryPlaceTorch(world, new BlockPos(castlePosX - 2, topY, castlePosZ - 4));
            if (this.topFloor == 1) continue;
            int maxK = this.floor * 4 + l - 8;
            for (int k2 = 0; k2 < maxK; ++k2) {
                BlockPos blockPos;
                int x = 5 - rand.nextInt(12);
                int y = topY + 5;
                int z = 5 - rand.nextInt(10);
                if (z < -2 && x < 4 && x > -5 && x != 1 && x != -2 || world.func_180495_p(blockPos = new BlockPos(x += castlePosX, y, z += castlePosZ)).func_177230_c() != Blocks.field_150334_T || world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c() == Blocks.field_150474_ac) continue;
                world.func_175698_g(blockPos);
            }
            ++this.floor;
        }
    }

    private IBlockState cobbler(int i, Random rand) {
        if (i == 1 && rand.nextInt(3) > 0) {
            return Blocks.field_150341_Y.func_176223_P();
        }
        return Blocks.field_150347_e.func_176223_P();
    }

    private ItemStack populateChest(int i, Random rand) {
        int j = rand.nextInt(8 * i);
        if (j > 40) {
            j = 40;
        }
        switch (j) {
            case 1: {
                return new ItemStack(Items.field_151015_O, rand.nextInt(12) + 3);
            }
            case 2: {
                return new ItemStack(Items.field_151120_aE, rand.nextInt(6) + 6);
            }
            case 3: {
                return new ItemStack(Items.field_151106_aX, rand.nextInt(6) + 6);
            }
            case 4: {
                return new ItemStack(Items.field_151032_g, rand.nextInt(30) + 10);
            }
            case 5: {
                return new ItemStack(CreepsItemHandler.money, rand.nextInt(4) + 1);
            }
            case 6: {
                return new ItemStack(CreepsItemHandler.evilEgg, rand.nextInt(4) + 1);
            }
            case 7: {
                return new ItemStack(Items.field_151116_aA, 1);
            }
            case 8: {
                return new ItemStack(Items.field_151121_aF, 1);
            }
            case 9: {
                return new ItemStack(Items.field_151034_e, 1);
            }
            case 10: {
                return new ItemStack(Items.field_151053_p, 1);
            }
            case 11: {
                return new ItemStack((Item)Items.field_151031_f, 1);
            }
            case 12: {
                return new ItemStack(CreepsItemHandler.bandaid, rand.nextInt(15) + 1);
            }
            case 13: {
                return new ItemStack(CreepsItemHandler.blorpCola, rand.nextInt(10) + 5);
            }
            case 14: {
                return new ItemStack(Items.field_151155_ap, 1);
            }
            case 15: {
                return new ItemStack(Items.field_151015_O, rand.nextInt(10) + 5);
            }
            case 16: {
                return new ItemStack(Items.field_151025_P, 1);
            }
            case 17: {
                return new ItemStack(Items.field_151035_b, 1);
            }
            case 18: {
                return new ItemStack(Items.field_151036_c, 1);
            }
            case 19: {
                return new ItemStack(Items.field_151133_ar, 1);
            }
            case 20: {
                return new ItemStack(Items.field_151037_a, 1);
            }
            case 21: {
                return new ItemStack(CreepsItemHandler.evilEgg, rand.nextInt(15) + 1);
            }
            case 22: {
                return new ItemStack(CreepsItemHandler.gooDonut, rand.nextInt(15) + 1);
            }
            case 23: {
                return new ItemStack(CreepsItemHandler.money, rand.nextInt(10) + 1);
            }
            case 24: {
                return new ItemStack(Items.field_151131_as, 1);
            }
            case 25: {
                return new ItemStack(CreepsItemHandler.frisbee, 1);
            }
            case 26: {
                return new ItemStack(Items.field_151105_aU, 1);
            }
            case 27: {
                return new ItemStack(CreepsItemHandler.money, rand.nextInt(10) + 5);
            }
            case 28: {
                return new ItemStack(Items.field_151117_aB, 1);
            }
            case 29: {
                return new ItemStack(CreepsItemHandler.lolly, rand.nextInt(4) + 1);
            }
            case 30: {
                return new ItemStack(CreepsItemHandler.money, rand.nextInt(24) + 1);
            }
            case 32: {
                return new ItemStack(Items.field_151045_i, 1);
            }
            case 33: {
                return new ItemStack((Item)Items.field_151169_ag, 1);
            }
            case 34: {
                return new ItemStack((Item)Items.field_151161_ac, 1);
            }
            case 35: {
                return new ItemStack((Item)Items.field_151151_aj, 1);
            }
            case 36: {
                return new ItemStack(CreepsItemHandler.shrinkRay, 1);
            }
            case 37: {
                return new ItemStack(CreepsItemHandler.horseHeadGem, 1);
            }
            case 38: {
                return new ItemStack(Items.field_151045_i, 1);
            }
            case 39: {
                return new ItemStack(Items.field_151153_ao, 1);
            }
            case 40: {
                return new ItemStack(CreepsItemHandler.money, rand.nextInt(49) + 1);
            }
        }
        return null;
    }

    public BlockPos findStructurePos(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (!(MoreCreepsConfig.spawnInNonVanillaBiomes && MoreCreepsConfig.hasBiome(Objects.requireNonNull(biome.getRegistryName()).toString()) || Objects.requireNonNull(biome.getRegistryName()).func_110624_b().equals("minecraft"))) {
            return null;
        }
        for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
            if (type != BiomeDictionary.Type.NETHER && type != BiomeDictionary.Type.END) continue;
            return null;
        }
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int castleX = x + rand.nextInt(8) - rand.nextInt(8);
        int castleY = 200;
        int castleZ = z + rand.nextInt(8) - rand.nextInt(8);
        int castlePosX = castleX;
        int castlePosY = castleY;
        int castlePosZ = castleZ;
        int foundation = 0;
        int foundationDepth = 0;
        boolean alternate = true;
        while (foundation < 3) {
            foundation = 0;
            Block block1 = world.func_180495_p(new BlockPos(castlePosX - 4, castlePosY - foundationDepth, castlePosZ - 4)).func_177230_c();
            Block block2 = world.func_180495_p(new BlockPos(castlePosX + 30, castlePosY - foundationDepth, castlePosZ - 4)).func_177230_c();
            Block block3 = world.func_180495_p(new BlockPos(castlePosX - 4, castlePosY - foundationDepth, castlePosZ + 30)).func_177230_c();
            Block block4 = world.func_180495_p(new BlockPos(castlePosX + 30, castlePosY - foundationDepth, castlePosZ + 30)).func_177230_c();
            if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i || block2 == Blocks.field_150355_j || block2 == Blocks.field_150358_i || block3 == Blocks.field_150355_j || block3 == Blocks.field_150358_i || block4 == Blocks.field_150355_j || block4 == Blocks.field_150358_i) {
                return null;
            }
            if (block1 != Blocks.field_150350_a && block1 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block2 != Blocks.field_150350_a && block2 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block3 != Blocks.field_150350_a && block3 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block4 != Blocks.field_150350_a && block4 != Blocks.field_150362_t) {
                ++foundation;
            }
            ++foundationDepth;
        }
        castlePosY = castleY = castlePosY - foundationDepth + 2;
        if (!(world.func_175667_e(new BlockPos(castleX - 4, castleY, castleZ - 4)) && world.func_175667_e(new BlockPos(castleX + 30, castleY, castleZ - 4)) && world.func_175667_e(new BlockPos(castleX + 30, castleY, castleZ + 30)) && world.func_175667_e(new BlockPos(castleX - 4, castleY, castleZ + 30)))) {
            return null;
        }
        int maxI = 42;
        int area = 0;
        for (int i = 0; i < maxI; i += 2) {
            for (int k = -12 + i; k < 38; k += 2) {
                for (int j = -12 + i; j < 38; j += 2) {
                    Block block = world.func_180495_p(new BlockPos(x + k, castlePosY + i, z + j)).func_177230_c();
                    if (block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150364_r || block == Blocks.field_150363_s || ++area <= 300) continue;
                    return null;
                }
            }
        }
        return new BlockPos(castleX, castleY - 1, castleZ);
    }

    private void fillCorners(World world, Block block, int xm, int ym, int zm, int xmx, int ymx, int zmx) {
        IBlockState state = block.func_176223_P();
        for (int ynow = ym; ynow <= ymx; ++ynow) {
            BlockPos pos2;
            BlockPos pos;
            int i;
            for (i = xm; i <= xmx; ++i) {
                pos = new BlockPos(i, ynow, zm);
                if (!world.func_180495_p(pos).func_185913_b()) {
                    world.func_175656_a(pos, state);
                }
                if (world.func_180495_p(pos2 = new BlockPos(i, ynow, zmx)).func_185913_b()) continue;
                world.func_175656_a(pos2, state);
            }
            for (i = zm; i <= zmx; ++i) {
                pos = new BlockPos(xm, ynow, i);
                if (!world.func_180495_p(pos).func_185913_b()) {
                    world.func_175656_a(pos, state);
                }
                if (world.func_180495_p(pos2 = new BlockPos(xmx, ynow, i)).func_185913_b()) continue;
                world.func_175656_a(pos2, state);
            }
        }
    }
}

