/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.world;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessagePlayBattleCastleSound;
import com.morecreepsrevival.morecreeps.common.networking.message.MessagePlayPyramidDiscoveredSound;
import com.morecreepsrevival.morecreeps.common.world.WorldGenCastle;
import com.morecreepsrevival.morecreeps.common.world.WorldGenPyramid;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WorldGenStructures
implements IWorldGenerator {
    private int pyramidCount = 0;
    private int castleCount = 0;

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateStructures(world, rand, chunkX, chunkZ);
    }

    public boolean isValidDim(World world) {
        int dimension = world.field_73011_w.getDimension();
        boolean isValid = true;
        for (int did : MoreCreepsConfig.dimensionGenWl) {
            if (did == dimension) {
                isValid = true;
                return isValid;
            }
            isValid = false;
        }
        return isValid;
    }

    private void generateStructures(World world, Random rand, int chunkX, int chunkZ) {
        if (this.isValidDim(world)) {
            BlockPos pos;
            if (MoreCreepsConfig.pyramidGen) {
                if (this.pyramidCount >= 1100 - MoreCreepsConfig.pyramidRarity * 100 + 100) {
                    if (rand.nextInt(30) == 0 && new WorldGenPyramid().func_180709_b(world, rand, pos = new BlockPos((chunkX << 4) + rand.nextInt(16) + 16, 65, (chunkZ << 4) + rand.nextInt(16) + 16))) {
                        this.pyramidCount = 0;
                        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72314_b(256.0, 256.0, 256.0))) {
                            CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayPyramidDiscoveredSound(), (EntityPlayerMP)player);
                        }
                    }
                } else {
                    ++this.pyramidCount;
                }
            }
            if (MoreCreepsConfig.castleGen) {
                if (this.castleCount >= 1100 - MoreCreepsConfig.castleRarity * 100 + 1300) {
                    if (rand.nextInt(30) == 0 && new WorldGenCastle().func_180709_b(world, rand, pos = new BlockPos((chunkX << 4) + rand.nextInt(16) + 16, rand.nextInt(40) + 80, (chunkZ << 4) + rand.nextInt(16) + 16))) {
                        this.castleCount = 0;
                        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72314_b(256.0, 256.0, 256.0))) {
                            CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessagePlayBattleCastleSound(), (EntityPlayerMP)player);
                        }
                    }
                } else {
                    ++this.castleCount;
                }
            }
        }
    }
}

