/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageDismountEntity;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCreepBase
extends EntityCreature {
    private static final DataParameter<String> texture = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> wanderState = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> modelSize = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> criticalHitCooldown = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> unmountTimer = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> hammerSwing = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> size = EntityDataManager.func_187226_a(EntityCreepBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected String baseTexture = "";
    protected float baseHealth = 100.0f;
    protected double baseSpeed = 1.0;
    protected double baseAttackDamage = 1.0;
    protected float currentSize = 1.0f;
    protected float widthActual;
    protected float heightActual;
    protected EnumCreatureType creatureType = EnumCreatureType.CREATURE;
    protected boolean spawnOnlyAtNight = false;
    private int internalWanderState = 0;

    public EntityCreepBase(World worldIn) {
        super(worldIn);
        this.field_70143_R = -25.0f;
        this.field_70728_aV = 5;
        this.updateAttributes();
    }

    protected static float getArmorHealthBonus(int armorLevel) {
        switch (armorLevel) {
            case 1: {
                return 5.0f;
            }
            case 2: {
                return 15.0f;
            }
            case 3: {
                return 9.0f;
            }
            case 4: {
                return 22.0f;
            }
        }
        return 0.0f;
    }

    protected void func_70105_a(float width, float height) {
        super.func_70105_a(width * this.currentSize, height * this.currentSize);
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        if (this.getCreatureType() == EnumCreatureType.MONSTER) {
            return SoundCategory.HOSTILE;
        }
        return SoundCategory.NEUTRAL;
    }

    protected void onDismount(Entity entity) {
    }

    public void func_184210_p() {
        if (!this.field_70170_p.field_72995_K) {
            CreepsPacketHandler.INSTANCE.sendToAll((IMessage)new MessageDismountEntity(this.func_145782_y()));
        }
        this.field_70143_R = -25.0f;
        this.field_70180_af.func_187227_b(unmountTimer, (Object)20);
        SoundEvent unmountSound = this.getUnmountSound();
        if (unmountSound != null) {
            this.func_184185_a(unmountSound, this.func_70599_aP(), this.func_70647_i());
        }
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        this.onDismount(entity);
    }

    public boolean func_180431_b(@Nonnull DamageSource damageSource) {
        if (this.func_184218_aH()) {
            return true;
        }
        return super.func_180431_b(damageSource);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(texture, (Object)"");
        this.field_70180_af.func_187214_a(size, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(wanderState, (Object)0);
        this.field_70180_af.func_187214_a(modelSize, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(criticalHitCooldown, (Object)5);
        this.field_70180_af.func_187214_a(unmountTimer, (Object)0);
        this.field_70180_af.func_187214_a(hammerSwing, (Object)Float.valueOf(0.0f));
    }

    protected void updateAttributes() {
        this.updateHealth();
        this.updateMoveSpeed();
        this.updateTexture();
        this.updateAttackStrength();
        this.updateModelSize();
    }

    protected void updateModelSize() {
        this.widthActual = this.field_70130_N;
        this.heightActual = this.field_70131_O;
    }

    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        switch (this.getWanderState()) {
            case 0: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
                break;
            }
            case 1: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
                break;
            }
            case 2: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
                this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
                this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
                break;
            }
        }
    }

    protected void clearAITasks() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.updateAttributes();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEntity");
        props.func_74776_a("ModelSize", this.getModelSize());
        props.func_74778_a("BaseTexture", this.baseTexture);
        props.func_74776_a("SizeCreep", ((Float)this.field_70180_af.func_187225_a(size)).floatValue());
        props.func_74768_a("WanderState", this.getWanderState());
        compound.func_74782_a("MoreCreepsEntity", (NBTBase)props);
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEntity");
        if (props.func_74764_b("ModelSize")) {
            this.setModelSize(props.func_74760_g("ModelSize"));
        }
        if (props.func_74764_b("BaseTexture")) {
            this.baseTexture = props.func_74779_i("BaseTexture");
        } else {
            String[] availableTextures = this.getAvailableTextures();
            if (availableTextures.length > 0) {
                this.baseTexture = availableTextures[this.field_70146_Z.nextInt(availableTextures.length)];
            }
        }
        if (props.func_74764_b("SizeCreep")) {
            this.putSizeNBT(props.func_74760_g("SizeCreep"));
        }
        if (props.func_74764_b("WanderState")) {
            this.setWanderState(props.func_74762_e("WanderState"));
        }
        this.updateAttributes();
        super.func_70037_a(compound);
    }

    public void determineBaseTexture() {
        if (!this.baseTexture.isEmpty()) {
            return;
        }
        String[] availableTextures = this.getAvailableTextures();
        if (availableTextures.length > 0) {
            this.baseTexture = availableTextures[this.field_70146_Z.nextInt(availableTextures.length)];
        }
        this.updateTexture();
    }

    public void setInitialHealth() {
        this.func_70606_j(this.func_110138_aP());
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        super.func_180482_a(difficulty, livingData);
        this.determineBaseTexture();
        this.setInitialHealth();
        return livingData;
    }

    protected double getMoveSpeed() {
        return this.baseSpeed;
    }

    protected double getAttackDamage() {
        return this.baseAttackDamage;
    }

    protected void updateMoveSpeed() {
        double speed = this.getMoveSpeed();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
    }

    public boolean isCreatureType(@Nullable EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.func_104002_bU()) {
            return false;
        }
        return this.getCreatureType() == type;
    }

    public EnumCreatureType getCreatureType() {
        return this.creatureType;
    }

    protected float getBaseHealth() {
        return this.baseHealth;
    }

    protected void updateHealth() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getBaseHealth());
    }

    protected void updateAttackStrength() {
        double attackDamage = this.getAttackDamage();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(attackDamage);
    }

    public void addHealth(float amt) {
        this.func_70606_j(Math.max(0.0f, Math.min(this.func_110138_aP(), this.func_110143_aJ() + amt)));
    }

    protected void updateTexture() {
        if (this.baseTexture == null || this.baseTexture.isEmpty()) {
            return;
        }
        String builder = this.baseTexture + ".png";
        this.setTexture(builder);
    }

    public int getWanderState() {
        return (Integer)this.field_70180_af.func_187225_a(wanderState);
    }

    public void setWanderState(int i) {
        this.field_70180_af.func_187227_b(wanderState, (Object)i);
    }

    public boolean canRidePlayer() {
        return false;
    }

    protected double getRidingYOffset() {
        return 0.5;
    }

    public double func_70033_W() {
        Entity entity = this.func_184187_bx();
        if (entity != null) {
            return this.getRidingYOffset() * (double)(entity.func_184188_bt().indexOf((Object)this) + 1);
        }
        return 0.0;
    }

    protected boolean shouldJumpWhileAttacking(Entity entity) {
        return false;
    }

    protected void doAttackJump(Entity entity) {
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(entity.field_70161_v - this.field_70161_v, entity.field_70165_t - this.field_70165_t)) - 90.0f;
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        this.field_70159_w = d0 / f * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
        this.field_70179_y = d1 / f * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
        this.field_70181_x = 0.4f;
        this.field_70143_R = -25.0f;
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        SoundEvent angrySound;
        if (this.field_70122_E && this.shouldJumpWhileAttacking(entity)) {
            this.doAttackJump(entity);
        }
        if (this.field_70146_Z.nextInt(5) == 0 && (angrySound = this.getAngrySound()) != null) {
            this.func_184185_a(angrySound, this.func_70599_aP(), this.func_70647_i());
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (flag) {
            int j = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
            if (j > 0) {
                entity.func_70015_d(j * 4);
            }
            if (entity instanceof EntityPlayer) {
                ItemStack itemStack2;
                EntityPlayer player = (EntityPlayer)entity;
                ItemStack itemStack = this.func_184614_ca();
                ItemStack itemStack3 = itemStack2 = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemStack.func_190926_b() && !itemStack2.func_190926_b() && itemStack.func_77973_b().canDisableShield(itemStack, itemStack2, (EntityLivingBase)player, (EntityLivingBase)this) && itemStack2.func_77973_b().isShield(itemStack2, (EntityLivingBase)player)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        player.func_184811_cZ().func_185145_a(itemStack2.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean canMount(Entity entity) {
        return true;
    }

    public boolean func_184205_a(@Nonnull Entity entity, boolean force) {
        if (!force && !this.canMount(entity)) {
            return false;
        }
        boolean flag = super.func_184205_a(entity, force);
        if (flag) {
            this.field_70177_z = entity.field_70177_z;
            SoundEvent mountSound = this.getMountSound();
            if (mountSound != null) {
                this.func_184185_a(mountSound, this.func_70599_aP(), this.func_70647_i());
            }
            this.field_70180_af.func_187227_b(unmountTimer, (Object)20);
        }
        return flag;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.func_70089_S() && itemStack.func_190926_b() && this.canRidePlayer() && this.canRidePlayer(player)) {
            if (!player.equals((Object)this.func_184187_bx())) {
                if (this.isStackable()) {
                    this.func_82149_j((Entity)player);
                    this.func_184205_a((Entity)player, true);
                } else {
                    this.func_184220_m((Entity)player);
                }
            } else {
                this.func_184210_p();
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean canRidePlayer(EntityPlayer player) {
        return !this.isTamable();
    }

    public boolean isTamable() {
        return false;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        if (!this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            this.dropItemsOnDeath();
        }
        super.func_70645_a(cause);
    }

    protected void dropItemsOnDeath() {
    }

    public boolean func_70094_T() {
        if (this.func_184218_aH() || (Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0) {
            return false;
        }
        return super.func_70094_T();
    }

    public boolean func_70648_aU() {
        return this.func_184218_aH() || (Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0;
    }

    public void func_184206_a(DataParameter<?> parameter) {
        super.func_184206_a(parameter);
        if (parameter.func_187155_a() == size.func_187155_a() && this.currentSize != ((Float)this.field_70180_af.func_187225_a(size)).floatValue()) {
            this.currentSize = ((Float)this.field_70180_af.func_187225_a(size)).floatValue();
            this.func_70105_a(this.widthActual, this.heightActual);
        }
    }

    public boolean func_82171_bF() {
        return this.isRideable() && this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_70636_d() {
        float f;
        super.func_70636_d();
        this.func_82168_bl();
        if (this.func_70013_c() > 0.5f) {
            this.field_70708_bq += 2;
        }
        if ((Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0) {
            this.field_70180_af.func_187227_b(unmountTimer, (Object)((Integer)this.field_70180_af.func_187225_a(unmountTimer) - 1));
        }
        if (this.shouldBurnInDay() && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            this.func_70015_d(this.getBurnInDayTime());
        }
    }

    protected int getBurnInDayTime() {
        return 20;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent getMountSound() {
        return null;
    }

    protected SoundEvent getUnmountSound() {
        return null;
    }

    protected SoundEvent getEatSound() {
        return null;
    }

    protected SoundEvent getFullSound() {
        return null;
    }

    protected SoundEvent getSpeedUpSound() {
        return null;
    }

    protected SoundEvent getSpeedDownSound() {
        return null;
    }

    protected SoundEvent getLevelUpSound() {
        return null;
    }

    protected SoundEvent getCriticalHitSound() {
        return null;
    }

    protected SoundEvent getAngrySound() {
        return null;
    }

    protected String[] getTamedNames() {
        return new String[0];
    }

    protected String[] getAvailableTextures() {
        return new String[0];
    }

    protected boolean func_70692_ba() {
        if (this.func_104002_bU()) {
            return false;
        }
        return super.func_70692_ba();
    }

    public int func_70627_aG() {
        return 120;
    }

    public void resetTarget() {
        this.func_70624_b(null);
        this.func_70604_c(null);
    }

    public void resetModelSize() {
        this.setModelSize(1.0f);
    }

    public float getModelSize() {
        return ((Float)this.field_70180_af.func_187225_a(modelSize)).floatValue();
    }

    protected void setModelSize(float f) {
        this.field_70180_af.func_187227_b(modelSize, (Object)Float.valueOf(f));
    }

    public void shrinkModelSize(float f, float maxShrink) {
        this.setModelSize(Math.max(maxShrink, this.getModelSize() - f));
    }

    public void growModelSize(float f, float maxGrowth) {
        this.setModelSize(Math.max(0.0f, Math.min(maxGrowth, this.getModelSize() + f)));
    }

    public void growHitboxSize(float f) {
        this.field_70180_af.func_187227_b(size, (Object)Float.valueOf(((Float)this.field_70180_af.func_187225_a(size)).floatValue() + f));
    }

    public void shrinkHitboxSize(float f) {
        this.field_70180_af.func_187227_b(size, (Object)Float.valueOf(((Float)this.field_70180_af.func_187225_a(size)).floatValue() - f));
    }

    public void decreaseMoveSpeed(float f) {
        this.baseSpeed -= (double)f;
        this.updateMoveSpeed();
    }

    public void increaseMoveSpeed(float f) {
        this.baseSpeed += (double)f;
        this.updateMoveSpeed();
    }

    public String getTexture() {
        return (String)this.field_70180_af.func_187225_a(texture);
    }

    protected void setTexture(String textureIn) {
        this.field_70180_af.func_187227_b(texture, (Object)textureIn);
    }

    protected void putSizeNBT(float f) {
        this.field_70180_af.func_187227_b(size, (Object)Float.valueOf(f));
    }

    public boolean isRideable() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean isStackable() {
        return false;
    }

    public String getBaseTexture() {
        return this.baseTexture;
    }

    protected void setBaseTexture(String baseTextureIn) {
        this.baseTexture = baseTextureIn;
    }

    public void func_70071_h_() {
        if (this.internalWanderState != this.getWanderState()) {
            this.func_184651_r();
            this.internalWanderState = this.getWanderState();
        }
        super.func_70071_h_();
        if (this.getHammerSwing() < 0.0f) {
            this.addHammerSwing(0.45f);
        } else {
            this.setHammerSwing(0.0f);
        }
        if (this.getCreatureType() == EnumCreatureType.MONSTER && !this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public float func_180484_a(BlockPos blockPos) {
        if (this.getCreatureType() == EnumCreatureType.MONSTER && this.spawnOnlyAtNight) {
            return 0.5f - this.field_70170_p.func_175724_o(blockPos);
        }
        return this.field_70170_p.func_175724_o(blockPos) - 0.5f;
    }

    protected boolean isValidLightLevel() {
        if (!this.spawnOnlyAtNight) {
            return true;
        }
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockPos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockPos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockPos);
            this.field_70170_p.func_175692_b(j);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public float getHammerSwing() {
        return ((Float)this.field_70180_af.func_187225_a(hammerSwing)).floatValue();
    }

    public void setHammerSwing(float f) {
        this.field_70180_af.func_187227_b(hammerSwing, (Object)Float.valueOf(f));
    }

    public void addHammerSwing(float f) {
        this.setHammerSwing(this.getHammerSwing() + f);
    }

    public void takeHammerSwing(float f) {
        this.setHammerSwing(this.getHammerSwing() - f);
    }

    public boolean func_184638_cS() {
        return false;
    }

    public boolean canBleed() {
        return true;
    }

    protected Entity getFirstPassenger() {
        Iterator iterator = this.func_184188_bt().iterator();
        if (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            return entity;
        }
        return null;
    }

    protected SoundEvent getKillSound() {
        return null;
    }

    protected SoundEvent getMissSound() {
        return null;
    }

    public int getUnmountTimer() {
        return (Integer)this.field_70180_af.func_187225_a(unmountTimer);
    }

    public void cloneEntity() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(World.class);
            EntityCreepBase newEntity = (EntityCreepBase)((Object)constructor.newInstance(this.field_70170_p));
            newEntity.func_82149_j((Entity)this);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_70014_b(compound);
            newEntity.func_70037_a(compound);
            newEntity.func_70606_j(this.func_110143_aJ());
            this.field_70170_p.func_72838_d((Entity)newEntity);
            this.func_70106_y();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean func_70055_a(@Nonnull Material material) {
        if (material == Material.field_151586_h && this.func_184218_aH() && (Integer)this.field_70180_af.func_187225_a(unmountTimer) > 0) {
            return false;
        }
        return super.func_70055_a(material);
    }
}

