/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityTombstone;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIFollowOwner;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIFollowOwnerTarget;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIOwnerHurtByTarget;
import com.morecreepsrevival.morecreeps.common.entity.ai.EntityCreepAIOwnerHurtTarget;
import com.morecreepsrevival.morecreeps.common.helpers.EffectHelper;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageOpenGuiTamableEntity;
import java.lang.reflect.Constructor;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCreepBaseOwnable
extends EntityCreepBase
implements IEntityOwnable {
    private static final DataParameter<Integer> level = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> owner = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> experience = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> totalDamage = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> creepTypeName = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> speedBoost = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> healthBoost = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skillHealing = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skillAttack = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skillDefend = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> skillSpeed = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> interest = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> armor = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> healTimer = EntityDataManager.func_187226_a(EntityCreepBaseOwnable.class, (DataSerializer)DataSerializers.field_187192_b);
    private int internalWanderState = 0;

    public EntityCreepBaseOwnable(World worldIn) {
        super(worldIn);
    }

    protected static float getArmorHealthBonus(int armorLevel) {
        switch (armorLevel) {
            case 1: {
                return 5.0f;
            }
            case 2: {
                return 15.0f;
            }
            case 3: {
                return 9.0f;
            }
            case 4: {
                return 22.0f;
            }
        }
        return 0.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(level, (Object)1);
        this.field_70180_af.func_187214_a(owner, (Object)"");
        this.field_70180_af.func_187214_a(experience, (Object)0);
        this.field_70180_af.func_187214_a(totalDamage, (Object)0);
        this.field_70180_af.func_187214_a(creepTypeName, (Object)"creep");
        this.field_70180_af.func_187214_a(skillHealing, (Object)0);
        this.field_70180_af.func_187214_a(skillAttack, (Object)0);
        this.field_70180_af.func_187214_a(skillDefend, (Object)0);
        this.field_70180_af.func_187214_a(skillSpeed, (Object)0);
        this.field_70180_af.func_187214_a(interest, (Object)0);
        this.field_70180_af.func_187214_a(healTimer, (Object)0);
        this.field_70180_af.func_187214_a(armor, (Object)0);
        this.field_70180_af.func_187214_a(speedBoost, (Object)0);
        this.field_70180_af.func_187214_a(healthBoost, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        switch (this.getWanderState()) {
            case 0: 
            case 1: {
                if (!this.isTamed()) break;
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
                break;
            }
            case 2: {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityCreepAIFollowOwner(this, 1.0, 6.0f, 2.0f));
                if (!this.isTamed()) break;
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityCreepAIOwnerHurtByTarget(this));
                this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityCreepAIOwnerHurtTarget(this));
                this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityCreepAIFollowOwnerTarget(this));
                break;
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEntity");
        props.func_74768_a("Level", this.getLevel());
        props.func_74768_a("Interest", ((Integer)this.field_70180_af.func_187225_a(interest)).intValue());
        props.func_74768_a("TotalDamage", this.getTotalDamage());
        props.func_74768_a("Experience", this.getExperience());
        props.func_74768_a("HealthBoost", ((Integer)this.field_70180_af.func_187225_a(healthBoost)).intValue());
        props.func_74768_a("SpeedBoost", this.getSpeedBoost());
        props.func_74768_a("Armor", ((Integer)this.field_70180_af.func_187225_a(armor)).intValue());
        props.func_74768_a("SkillHealing", this.getSkillHealing());
        props.func_74768_a("SkillAttack", this.getSkillAttack());
        props.func_74768_a("SkillDefend", this.getSkillDefend());
        props.func_74768_a("SkillSpeed", this.getSkillSpeed());
        UUID owner = this.func_184753_b();
        if (owner != null) {
            props.func_74778_a("Owner", owner.toString());
        }
        compound.func_74782_a("MoreCreepsEntity", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEntity");
        if (props.func_74764_b("ModelSize")) {
            this.setModelSize(props.func_74760_g("ModelSize"));
        }
        if (props.func_74764_b("HealthBoost")) {
            this.setHealthBoost(props.func_74762_e("HealthBoost"));
        }
        if (props.func_74764_b("Level")) {
            this.setLevel(props.func_74762_e("Level"));
        }
        if (props.func_74764_b("Interest")) {
            this.setInterest(props.func_74762_e("Interest"));
        }
        if (props.func_74764_b("TotalDamage")) {
            this.setTotalDamage(props.func_74762_e("TotalDamage"));
        }
        if (props.func_74764_b("Experience")) {
            this.setExperience(props.func_74762_e("Experience"));
        }
        if (props.func_74764_b("Armor")) {
            this.setArmor(props.func_74762_e("Armor"));
        }
        if (props.func_74764_b("SkillHealing")) {
            this.setSkillHealing(props.func_74762_e("SkillHealing"));
        }
        if (props.func_74764_b("SkillAttack")) {
            this.setSkillAttack(props.func_74762_e("SkillAttack"));
        }
        if (props.func_74764_b("SkillDefend")) {
            this.setSkillDefend(props.func_74762_e("SkillDefend"));
        }
        if (props.func_74764_b("SkillSpeed")) {
            this.setSkillSpeed(props.func_74762_e("SkillSpeed"));
        }
        if (props.func_74764_b("Owner")) {
            this.setOwner(UUID.fromString(props.func_74779_i("Owner")));
        }
        this.updateAttributes();
        super.func_70037_a(compound);
    }

    @Override
    protected void updateAttackStrength() {
        double attackDamage = this.getAttackDamage() + this.getLevelDamageMultiplier() * (double)(this.getLevel() - 1);
        switch (this.getArmor()) {
            case 1: {
                attackDamage += 1.0;
                break;
            }
            case 2: {
                attackDamage += 3.0;
                break;
            }
            case 3: {
                attackDamage += 2.0;
                break;
            }
            case 4: {
                attackDamage += 6.0;
                break;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(attackDamage);
    }

    @Override
    protected void updateMoveSpeed() {
        double speed = this.getMoveSpeed() + this.getLevelSpeedMultiplier() * (double)(this.getLevel() - 1);
        if (this.getSpeedBoost() > 0) {
            speed += 0.75;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
    }

    public int getInterest() {
        return (Integer)this.field_70180_af.func_187225_a(interest);
    }

    protected void setInterest(int i) {
        this.field_70180_af.func_187227_b(interest, (Object)Math.max(0, Math.min(100, i)));
    }

    protected void addInterest(int i, EntityPlayer player) {
        if (!this.isTamable() || this.isTamed()) {
            return;
        }
        this.setInterest(this.getInterest() + i);
        if (this.getInterest() >= 100) {
            this.tame(player);
        }
    }

    public void feed(EntityPlayer player, float healthToAdd, int interestToAdd) {
        this.addHealth(healthToAdd);
        this.addInterest(interestToAdd, player);
        SoundEvent fullSound = this.getFullSound();
        SoundEvent eatSound = this.func_110143_aJ() >= this.func_110138_aP() && fullSound != null ? fullSound : this.getEatSound();
        if (eatSound != null) {
            this.func_184185_a(eatSound, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public int getArmor() {
        return (Integer)this.field_70180_af.func_187225_a(armor);
    }

    protected void setArmor(int i) {
        this.field_70180_af.func_187227_b(armor, (Object)i);
        this.updateHealth();
        this.updateAttackStrength();
        this.updateTexture();
    }

    @Override
    protected void updateHealth() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(this.getBaseHealth() + this.getLevelHealthMultiplier() * (float)(this.getLevel() - 1) + (float)this.getHealthBoost() + EntityCreepBaseOwnable.getArmorHealthBonus(this.getArmor())));
    }

    @Override
    protected void doAttackJump(Entity entity) {
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(entity.field_70161_v - this.field_70161_v, entity.field_70165_t - this.field_70165_t)) - 90.0f;
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        this.field_70159_w = d0 / f * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
        this.field_70179_y = d1 / f * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
        this.field_70181_x = 0.4f;
        this.field_70143_R = -25.0f;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.func_70089_S()) {
            if (itemStack.func_190926_b()) {
                if (player.func_70093_af() && this.isTamed() && this.isPlayerOwner(player) && this.canUseTamableMenu()) {
                    if (!this.field_70170_p.field_72995_K) {
                        CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageOpenGuiTamableEntity(this.func_145782_y()), (EntityPlayerMP)player);
                    }
                    return true;
                }
                if (this.isRideable() && this.canPlayerRide(player) && !player.equals((Object)this.getFirstPassenger()) && player.func_184220_m((Entity)this)) {
                    return true;
                }
            } else {
                Item item = itemStack.func_77973_b();
                if (this.isTamed() && this.isPlayerOwner(player) && this.canUseTamableMenu() && (item == Items.field_151122_aG || item == Items.field_151121_aF || this.shouldOpenTamableMenu(item))) {
                    if (!this.field_70170_p.field_72995_K) {
                        CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageOpenGuiTamableEntity(this.func_145782_y()), (EntityPlayerMP)player);
                    }
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource cause) {
        if (!this.field_70729_aU && !this.field_70170_p.field_72995_K) {
            if (this.isTamed() && this.canBeRevived()) {
                if (!(this instanceof EntityTombstone)) {
                    EntityTombstone tombstone = new EntityTombstone(this.field_70170_p, this);
                    tombstone.determineBaseTexture();
                    tombstone.setInitialHealth();
                    this.field_70170_p.func_72838_d((Entity)tombstone);
                }
            } else {
                this.dropItemsOnDeath();
            }
        }
        super.func_70645_a(cause);
    }

    @Override
    public void func_70636_d() {
        int speedBoost;
        super.func_70636_d();
        int iSkillHealing = this.getSkillHealing();
        if ((Integer)this.field_70180_af.func_187225_a(healTimer) > 0) {
            this.field_70180_af.func_187227_b(healTimer, (Object)((Integer)this.field_70180_af.func_187225_a(healTimer) - 1));
        }
        if (iSkillHealing > 0 && (Integer)this.field_70180_af.func_187225_a(healTimer) < 1 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.field_70180_af.func_187227_b(healTimer, (Object)((6 - iSkillHealing) * 200));
            this.addHealth(iSkillHealing);
            for (int i = 0; i < iSkillHealing; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
            }
            this.func_70626_be();
        }
        if ((speedBoost = this.getSpeedBoost()) > 0) {
            this.setSpeedBoost(--speedBoost);
            if (speedBoost < 1) {
                SoundEvent speedDownSound;
                EntityPlayer owner;
                if (!this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
                    owner.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.speed_boost", new Object[]{this.func_70005_c_()}));
                }
                if ((speedDownSound = this.getSpeedDownSound()) != null) {
                    this.func_184185_a(speedDownSound, this.func_70599_aP(), this.func_70647_i());
                }
                this.updateMoveSpeed();
            }
        }
    }

    protected void giveSpeedBoost(int speedBoost) {
        EntityPlayer owner;
        EffectHelper.smoke(this.field_70170_p, (Entity)this, this.field_70146_Z, true);
        this.setSpeedBoost(Math.max(0, this.getSpeedBoost()) + speedBoost);
        this.updateMoveSpeed();
        SoundEvent speedUpSound = this.getSpeedUpSound();
        if (speedUpSound != null) {
            this.func_184185_a(speedUpSound, this.func_70599_aP(), this.func_70647_i());
        }
        int speedBoostLeft = Math.max(this.getSpeedBoost() / 21 / 60, 0);
        if (!this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
            owner.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.speed_boost.left", new Object[]{this.func_70005_c_(), speedBoostLeft}));
        }
    }

    @Override
    protected String[] getTamedNames() {
        return new String[0];
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.isTamed()) {
            return false;
        }
        return super.func_70692_ba();
    }

    protected void clearOwner() {
        this.field_70180_af.func_187227_b(owner, (Object)"");
    }

    @Nullable
    public UUID func_184753_b() {
        String uuid = (String)this.field_70180_af.func_187225_a(owner);
        if (uuid.isEmpty()) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    public boolean isPlayerOwner(EntityPlayer player) {
        if (player == null || this.func_184753_b() == null) {
            return false;
        }
        return player.func_110124_au().equals(this.func_184753_b());
    }

    @Nullable
    public EntityPlayer getOwner() {
        UUID owner = this.func_184753_b();
        if (owner != null) {
            return this.field_70170_p.func_152378_a(owner);
        }
        return null;
    }

    public void setOwner(UUID uuid) {
        this.field_70180_af.func_187227_b(owner, (Object)uuid.toString());
    }

    public void setOwner(EntityPlayer player) {
        this.field_70180_af.func_187227_b(owner, (Object)player.func_110124_au().toString());
    }

    @Override
    protected void updateTexture() {
        if (this.baseTexture == null || this.baseTexture.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder().append(this.baseTexture);
        switch (this.getArmor()) {
            case 1: {
                builder.append("l");
                break;
            }
            case 2: {
                builder.append("g");
                break;
            }
            case 3: {
                builder.append("i");
                break;
            }
            case 4: {
                builder.append("d");
                break;
            }
        }
        builder.append(".png");
        this.setTexture(builder.toString());
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(level);
    }

    protected void setLevel(int i) {
        this.field_70180_af.func_187227_b(level, (Object)i);
    }

    public void tame(EntityPlayer player) {
        SoundEvent tamedSound;
        this.setInterest(0);
        this.setOwner(player);
        this.updateAttributes();
        this.func_70606_j(this.func_110138_aP());
        this.setWanderState(2);
        if (!this.func_145818_k_()) {
            this.func_96094_a(this.getTamedNames()[ThreadLocalRandom.current().nextInt(this.getTamedNames().length)]);
        }
        if ((tamedSound = this.getTamedSound()) != null) {
            this.func_184185_a(tamedSound, this.func_70599_aP(), this.func_70647_i());
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.tamed", new Object[]{this.func_70005_c_()}));
        }
    }

    public void untame() {
        this.clearOwner();
        this.func_96094_a("");
        this.setInterest(0);
    }

    public boolean isTamed() {
        return this.func_184753_b() != null;
    }

    @Override
    public boolean canRidePlayer(EntityPlayer player) {
        return !this.isTamable() || this.isTamed() && this.isPlayerOwner(player);
    }

    @Override
    public boolean isRideable() {
        return false;
    }

    public boolean canPlayerRide(EntityPlayer player) {
        return !this.isTamable() || this.isTamed() && this.isPlayerOwner(player);
    }

    protected boolean shouldOpenTamableMenu(Item item) {
        return false;
    }

    protected boolean canUseTamableMenu() {
        return false;
    }

    public String getLevelName() {
        return "";
    }

    public int getLevelDamage() {
        return 0;
    }

    public int getMaxLevel() {
        return 1;
    }

    protected void addExperience(int i) {
        this.setExperience(this.getExperience() + i);
    }

    public int getExperience() {
        return (Integer)this.field_70180_af.func_187225_a(experience);
    }

    protected void setExperience(int i) {
        this.field_70180_af.func_187227_b(experience, (Object)i);
    }

    public void addTotalDamage(int i) {
        this.addExperience(i);
        if ((i += this.getTotalDamage()) >= this.getLevelDamage() && this.getLevel() < this.getMaxLevel()) {
            SoundEvent levelUpSound;
            EntityPlayer player;
            int lvl = this.getLevel() + 1;
            this.setLevel(lvl);
            this.setTotalDamage(0);
            int healthBoostNew = this.field_70146_Z.nextInt(4);
            this.setHealthBoost(healthBoostNew);
            this.updateAttributes();
            this.addHealth((float)healthBoostNew + this.getLevelHealthMultiplier());
            if (!this.field_70170_p.field_72995_K && (player = this.getOwner()) != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.level_increase", new Object[]{this.func_70005_c_(), lvl}));
            }
            if ((levelUpSound = this.getLevelUpSound()) != null) {
                this.func_184185_a(levelUpSound, this.func_70599_aP(), this.func_70647_i());
            }
            return;
        }
        this.setTotalDamage(i);
    }

    public int getTotalDamage() {
        return (Integer)this.field_70180_af.func_187225_a(totalDamage);
    }

    protected void setTotalDamage(int i) {
        this.field_70180_af.func_187227_b(totalDamage, (Object)i);
    }

    protected float getLevelHealthMultiplier() {
        return 1.0f;
    }

    protected double getLevelDamageMultiplier() {
        return 1.0;
    }

    protected double getLevelSpeedMultiplier() {
        return 0.0;
    }

    public boolean shouldAttackEntity(EntityLivingBase target) {
        return !this.isTamed() || !(target instanceof EntityCreepBaseOwnable) || !((EntityCreepBaseOwnable)target).isPlayerOwner(this.getOwner());
    }

    @Override
    public boolean func_70652_k(@Nonnull Entity entity) {
        SoundEvent angrySound;
        if (this.field_70122_E && this.shouldJumpWhileAttacking(entity)) {
            this.doAttackJump(entity);
        }
        if (this.field_70146_Z.nextInt(5) == 0 && (angrySound = this.getAngrySound()) != null) {
            this.func_184185_a(angrySound, this.func_70599_aP(), this.func_70647_i());
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (flag) {
            int j = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
            if (j > 0) {
                entity.func_70015_d(j * 4);
            }
            if (entity instanceof EntityPlayer) {
                ItemStack itemStack2;
                EntityPlayer player = (EntityPlayer)entity;
                ItemStack itemStack = this.func_184614_ca();
                ItemStack itemStack3 = itemStack2 = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemStack.func_190926_b() && !itemStack2.func_190926_b() && itemStack.func_77973_b().canDisableShield(itemStack, itemStack2, (EntityLivingBase)player, (EntityLivingBase)this) && itemStack2.func_77973_b().isShield(itemStack2, (EntityLivingBase)player)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        player.func_184811_cZ().func_185145_a(itemStack2.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entity);
            if (this.isTamed() && this.canLevelUp()) {
                int iSkillAttack = this.getSkillAttack();
                this.addTotalDamage((int)((double)f * (1.85 + (double)iSkillAttack)));
                double hitChance = 1.0 + (double)(this.getLevel() * 5) + (double)(iSkillAttack * 4);
                if (hitChance < 5.0) {
                    hitChance = 5.0;
                }
                if ((double)this.field_70146_Z.nextInt(100) > 100.0 - hitChance) {
                    SoundEvent killSound;
                    float damageDealt = f * 0.75f;
                    if (damageDealt < 1.0f) {
                        damageDealt = 1.0f;
                    }
                    if ((Integer)this.field_70180_af.func_187225_a(EntityCreepBase.criticalHitCooldown) > 0) {
                        this.field_70180_af.func_187227_b(EntityCreepBase.criticalHitCooldown, (Object)((Integer)this.field_70180_af.func_187225_a(EntityCreepBase.criticalHitCooldown) - 1));
                    }
                    if (iSkillAttack > 1 && this.field_70146_Z.nextInt(100) > 100 - iSkillAttack * 2 && (Integer)this.field_70180_af.func_187225_a(EntityCreepBase.criticalHitCooldown) < 1) {
                        float hp = ((EntityLivingBase)entity).func_110143_aJ();
                        if (damageDealt < hp) {
                            damageDealt = hp;
                        }
                        this.field_70180_af.func_187227_b(EntityCreepBase.criticalHitCooldown, (Object)(50 - iSkillAttack * 8));
                        SoundEvent criticalHitSound = this.getCriticalHitSound();
                        if (criticalHitSound != null) {
                            entity.func_184185_a(criticalHitSound, 1.0f, 1.0f);
                        }
                        this.addTotalDamage(25);
                    }
                    if (((EntityLivingBase)entity).func_110143_aJ() - damageDealt <= 0.0f && (killSound = this.getKillSound()) != null) {
                        this.func_184185_a(killSound, this.func_70599_aP(), this.func_70647_i());
                    }
                    this.addTotalDamage((int)((double)damageDealt * (1.85 + (double)iSkillAttack)));
                    return entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)entity), damageDealt);
                }
            }
        }
        return flag;
    }

    public Team func_96124_cp() {
        EntityPlayer owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entity) {
        EntityPlayer owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            if (owner.equals((Object)entity)) {
                return true;
            }
            return owner.func_184191_r(entity);
        }
        return super.func_184191_r(entity);
    }

    public int getSpeedBoost() {
        return (Integer)this.field_70180_af.func_187225_a(speedBoost);
    }

    protected void setSpeedBoost(int i) {
        this.field_70180_af.func_187227_b(speedBoost, (Object)i);
    }

    public int getHealthBoost() {
        return (Integer)this.field_70180_af.func_187225_a(healthBoost);
    }

    protected void setHealthBoost(int healthBoostIn) {
        this.field_70180_af.func_187227_b(healthBoost, (Object)healthBoostIn);
    }

    public int getSkillAttack() {
        return (Integer)this.field_70180_af.func_187225_a(skillAttack);
    }

    protected void setSkillAttack(int i) {
        this.field_70180_af.func_187227_b(skillAttack, (Object)i);
    }

    public int getSkillHealing() {
        return (Integer)this.field_70180_af.func_187225_a(skillHealing);
    }

    protected void setSkillHealing(int i) {
        this.field_70180_af.func_187227_b(skillHealing, (Object)i);
    }

    public int getSkillDefend() {
        return (Integer)this.field_70180_af.func_187225_a(skillDefend);
    }

    protected void setSkillDefend(int i) {
        this.field_70180_af.func_187227_b(skillDefend, (Object)i);
    }

    public int getSkillSpeed() {
        return (Integer)this.field_70180_af.func_187225_a(skillSpeed);
    }

    protected void setSkillSpeed(int i) {
        this.field_70180_af.func_187227_b(skillSpeed, (Object)i);
    }

    public int getSkillLevel(String skill) {
        switch (skill) {
            case "attack": {
                return this.getSkillAttack();
            }
            case "defend": {
                return this.getSkillDefend();
            }
            case "healing": {
                return this.getSkillHealing();
            }
            case "speed": {
                return this.getSkillSpeed();
            }
        }
        return 0;
    }

    public int getRequiredLevelForSkill(String skill) {
        return this.getSkillLevel(skill) * 5;
    }

    public boolean canLevelSkill(String skill) {
        return this.getSkillLevel(skill) < 5 && this.getLevel() >= this.getRequiredLevelForSkill(skill);
    }

    public void levelUpSkill(String skill) {
        if (this.getSkillLevel(skill) >= 5) {
            return;
        }
        switch (skill) {
            case "attack": {
                this.setSkillAttack(this.getSkillAttack() + 1);
                this.updateAttackStrength();
                break;
            }
            case "defend": {
                this.setSkillDefend(this.getSkillDefend() + 1);
                break;
            }
            case "healing": {
                this.setSkillHealing(this.getSkillHealing() + 1);
                break;
            }
            case "speed": {
                this.setSkillSpeed(this.getSkillSpeed() + 1);
                this.updateMoveSpeed();
                break;
            }
        }
    }

    @Override
    public void func_70071_h_() {
        EntityLivingBase target = this.func_70638_az();
        if (target != null && target.equals((Object)this.getOwner())) {
            this.func_70624_b(null);
        }
        super.func_70071_h_();
    }

    public void onRevive(NBTTagCompound compound) {
    }

    public void onTombstoneCreate(NBTTagCompound compound) {
    }

    protected SoundEvent getTamedSound() {
        return null;
    }

    public boolean canLevelUp() {
        return false;
    }

    public boolean canBeRevived() {
        return false;
    }

    @Override
    public void cloneEntity() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(World.class);
            EntityCreepBaseOwnable newEntity = (EntityCreepBaseOwnable)((Object)constructor.newInstance(this.field_70170_p));
            newEntity.func_82149_j((Entity)this);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_70014_b(compound);
            newEntity.func_70037_a(compound);
            newEntity.func_70606_j(this.func_110143_aJ());
            this.field_70170_p.func_72838_d((Entity)newEntity);
            this.func_70106_y();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

