/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityDogHouse;
import com.morecreepsrevival.morecreeps.common.entity.EntityEvilChicken;
import com.morecreepsrevival.morecreeps.common.entity.EntityEvilCreature;
import com.morecreepsrevival.morecreeps.common.entity.EntityEvilLight;
import com.morecreepsrevival.morecreeps.common.entity.EntityEvilPig;
import com.morecreepsrevival.morecreeps.common.entity.EntityEvilSnowman;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityEvilScientist
extends EntityCreepBase
implements IMob,
IEntityCanChangeSize {
    private static final DataParameter<Integer> stage = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> trulyEvil = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> towerBuilt = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> experimentTimer = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> experimentStart = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> numExperiments = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> towerHeight = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> towerPos = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> water = EntityDataManager.func_187226_a(EntityEvilScientist.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityEvilScientist(World worldIn) {
        super(worldIn);
        this.creatureType = EnumCreatureType.MONSTER;
        this.field_70178_ae = true;
        this.baseHealth = (float)this.field_70146_Z.nextInt(30) + 10.0f;
        this.baseSpeed = 0.3;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(stage, (Object)0);
        this.field_70180_af.func_187214_a(trulyEvil, (Object)false);
        this.field_70180_af.func_187214_a(experimentTimer, (Object)(this.field_70146_Z.nextInt(100) + 100));
        this.field_70180_af.func_187214_a(numExperiments, (Object)(this.field_70146_Z.nextInt(3) + 1));
        this.field_70180_af.func_187214_a(towerBuilt, (Object)false);
        this.field_70180_af.func_187214_a(experimentStart, (Object)false);
        this.field_70180_af.func_187214_a(towerHeight, (Object)0);
        this.field_70180_af.func_187214_a(towerPos, (Object)new BlockPos(0, 0, 0));
        this.field_70180_af.func_187214_a(water, (Object)false);
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    protected void updateTexture() {
        if (this.getTrulyEvil()) {
            this.setTexture("textures/entity/evilscientistblown.png");
        } else {
            this.setTexture("textures/entity/evilscientist.png");
        }
    }

    public int getStage() {
        return (Integer)this.field_70180_af.func_187225_a(stage);
    }

    protected void setStage(int i) {
        this.field_70180_af.func_187227_b(stage, (Object)i);
    }

    @Override
    protected double getMoveSpeed() {
        if (this.getTrulyEvil()) {
            return 0.5;
        }
        return super.getMoveSpeed();
    }

    public boolean getTrulyEvil() {
        return (Boolean)this.field_70180_af.func_187225_a(trulyEvil);
    }

    protected void setTrulyEvil(boolean b) {
        this.field_70180_af.func_187227_b(trulyEvil, (Object)b);
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.evilLaughSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.evilHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.evilExplosionSound;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_145779_a(Items.field_151157_am, this.field_70146_Z.nextInt(3) + 1);
        } else {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150354_m), this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource damageSource) {
        this.tearDownTower();
        super.func_70645_a(damageSource);
    }

    public void func_70106_y() {
        this.tearDownTower();
        super.func_70106_y();
    }

    private void tearDownTower() {
        if (!this.getTowerBuilt()) {
            return;
        }
        BlockPos blockPos = this.getTowerPos();
        int towerX = blockPos.func_177958_n();
        int towerY = blockPos.func_177956_o();
        int towerZ = blockPos.func_177952_p();
        for (int b = 0; b < this.getTowerHeight() + 1; ++b) {
            this.field_70170_p.func_175698_g(new BlockPos(towerX, towerY + b, towerZ));
            for (int c = 0; c < 3; ++c) {
                for (int d = 0; d < 3; ++d) {
                    for (int k = 0; k < 4; ++k) {
                        for (int j = 0; j < 10; ++j) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)(2.0f + (float)towerX) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, (double)(1.0f + (float)towerY + (float)b) + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) + 2.0, 2.0 + ((double)towerZ + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f)) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                        }
                    }
                    this.field_70170_p.func_175698_g(new BlockPos(towerX + d, towerY + b, towerZ + c + 1));
                    this.field_70170_p.func_175698_g(new BlockPos(towerX + c + 1, towerY + b, towerZ + d));
                }
            }
        }
        this.setTowerBuilt(false);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean getTowerBuilt() {
        return (Boolean)this.field_70180_af.func_187225_a(towerBuilt);
    }

    protected void setTowerBuilt(boolean b) {
        this.field_70180_af.func_187227_b(towerBuilt, (Object)b);
    }

    public boolean getExperimentStart() {
        return (Boolean)this.field_70180_af.func_187225_a(experimentStart);
    }

    protected void setExperimentStart(boolean b) {
        this.field_70180_af.func_187227_b(experimentStart, (Object)b);
    }

    public int getExperimentTimer() {
        return (Integer)this.field_70180_af.func_187225_a(experimentTimer);
    }

    protected void setExperimentTimer(int i) {
        this.field_70180_af.func_187227_b(experimentTimer, (Object)i);
    }

    public int getNumExperiments() {
        return (Integer)this.field_70180_af.func_187225_a(numExperiments);
    }

    protected void setNumExperiments(int i) {
        this.field_70180_af.func_187227_b(numExperiments, (Object)i);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEvilScientist");
        props.func_74768_a("ExperimentTimer", this.getExperimentTimer());
        props.func_74757_a("ExperimentStart", this.getExperimentStart());
        props.func_74768_a("Stage", this.getStage());
        props.func_74768_a("NumExperiments", this.getNumExperiments());
        props.func_74757_a("TrulyEvil", this.getTrulyEvil());
        props.func_74757_a("TowerBuilt", this.getTowerBuilt());
        props.func_74768_a("TowerHeight", this.getTowerHeight());
        BlockPos blockPos = this.getTowerPos();
        props.func_74768_a("TowerPosX", blockPos.func_177958_n());
        props.func_74768_a("TowerPosY", blockPos.func_177956_o());
        props.func_74768_a("TowerPosZ", blockPos.func_177952_p());
        compound.func_74782_a("MoreCreepsEvilScientist", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsEvilScientist");
        if (props.func_74764_b("ExperimentTimer")) {
            this.setExperimentTimer(props.func_74762_e("ExperimentTimer"));
        }
        if (props.func_74764_b("ExperimentStart")) {
            this.setExperimentStart(props.func_74767_n("ExperimentStart"));
        }
        if (props.func_74764_b("Stage")) {
            this.setStage(props.func_74762_e("Stage"));
        }
        if (props.func_74764_b("NumExperiments")) {
            this.setNumExperiments(props.func_74762_e("NumExperiments"));
        }
        if (props.func_74764_b("TrulyEvil")) {
            this.setTrulyEvil(props.func_74767_n("TrulyEvil"));
        }
        if (props.func_74764_b("TowerBuilt")) {
            this.setTowerBuilt(props.func_74767_n("TowerBuilt"));
        }
        if (props.func_74764_b("TowerHeight")) {
            this.setTowerHeight(props.func_74762_e("TowerHeight"));
        }
        if (props.func_74764_b("TowerPosX") && props.func_74764_b("TowerPosY") && props.func_74764_b("TowerPosZ")) {
            this.setTowerPos(new BlockPos(props.func_74762_e("TowerPosX"), props.func_74762_e("TowerPosY"), props.func_74762_e("TowerPosZ")));
        }
    }

    @Override
    public void func_70636_d() {
        int towerZ;
        int towerY;
        int towerX;
        super.func_70636_d();
        this.field_70143_R = 0.0f;
        if (this.getStage() == 3 && this.field_70163_u + 3.0 < (double)(this.getTowerPos().func_177956_o() + this.getTowerHeight())) {
            this.setStage(2);
        }
        if (this.getStage() == 0) {
            if (this.getExperimentTimer() > 0 && !this.getExperimentStart()) {
                this.setExperimentTimer(this.getExperimentTimer() - 1);
            }
            if (this.getExperimentTimer() < 1) {
                this.setExperimentStart(true);
                this.setStage(1);
                this.setExperimentTimer(this.field_70146_Z.nextInt(5000) + 100);
            }
        }
        if (this.getStage() == 1 && this.field_70122_E && this.getExperimentStart() && this.field_70163_u > 63.0) {
            int towerX2 = MathHelper.func_76128_c((double)this.field_70165_t) + 2;
            int towerY2 = MathHelper.func_76128_c((double)this.field_70163_u);
            int towerZ2 = MathHelper.func_76128_c((double)this.field_70161_v) + 2;
            this.setTowerPos(new BlockPos(towerX2, towerY2, towerZ2));
            this.setTowerHeight(this.field_70146_Z.nextInt(20) + 10);
            int iTowerHeight = this.getTowerHeight();
            int area = 0;
            for (int i = 0; i < iTowerHeight; ++i) {
                for (int q = 0; q < 3; ++q) {
                    for (int k = 0; k < 3; ++k) {
                        area += Block.func_149682_b((Block)this.field_70170_p.func_180495_p(new BlockPos(towerX2 + k, towerY2 + i, towerZ2 + q + 1)).func_177230_c());
                        area += Block.func_149682_b((Block)this.field_70170_p.func_180495_p(new BlockPos(towerX2 + q + 1, towerY2 + i, towerZ2 + k)).func_177230_c());
                    }
                }
            }
            boolean housesNear = false;
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0))) {
                if (!(entity instanceof EntityDogHouse)) continue;
                housesNear = true;
                break;
            }
            Block checkBlock = this.field_70170_p.func_180495_p(new BlockPos(towerX2 + 2, towerY2 - 1, towerZ2 + 2)).func_177230_c();
            if (!housesNear && area == 0 && checkBlock != Blocks.field_150350_a && checkBlock != Blocks.field_150355_j && checkBlock != Blocks.field_150358_i && this.field_70170_p.func_72890_a((Entity)this, 20.0) != null) {
                this.setTowerBuilt(true);
                for (int a = 0; a < iTowerHeight; ++a) {
                    for (int b = 0; b < 3; ++b) {
                        for (int c = 0; c < 3; ++c) {
                            Block block = Blocks.field_150347_e;
                            if (this.field_70146_Z.nextInt(5) == 0) {
                                block = Blocks.field_150341_Y;
                            }
                            this.field_70170_p.func_175656_a(new BlockPos(towerX2 + c, towerY2 + a, towerZ2 + b + 1), block.func_176223_P());
                            block = Blocks.field_150347_e;
                            if (this.field_70146_Z.nextInt(5) == 0) {
                                block = Blocks.field_150341_Y;
                            }
                            this.field_70170_p.func_175656_a(new BlockPos(towerX2 + b + 1, towerY2 + a, towerZ2 + c), block.func_176223_P());
                        }
                    }
                }
                this.field_70170_p.func_175656_a(new BlockPos(towerX2 + 2, towerY2 + iTowerHeight, towerZ2 + 2), Blocks.field_150462_ai.func_176223_P());
                for (int i = 0; i < iTowerHeight; ++i) {
                    this.field_70170_p.func_175656_a(new BlockPos(towerX2, towerY2 + i, towerZ2), Blocks.field_150468_ap.func_176223_P());
                }
                this.setStage(2);
            } else {
                this.setStage(0);
                this.setExperimentTimer(this.field_70146_Z.nextInt(100) + 50);
                this.setExperimentStart(false);
            }
        }
        if (this.getStage() == 2) {
            BlockPos blockPos = this.getTowerPos();
            towerX = blockPos.func_177958_n();
            towerY = blockPos.func_177956_o();
            towerZ = blockPos.func_177952_p();
            if (this.field_70165_t < (double)towerX) {
                this.field_70159_w = 0.2f;
            }
            if (this.field_70161_v < (double)towerZ) {
                this.field_70179_y = 0.2f;
            }
            if (Math.abs(this.field_70165_t - (double)towerX) < (double)0.4f && Math.abs(this.field_70161_v - (double)towerZ) < (double)0.4f) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.3f;
                this.field_70170_p.func_175698_g(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 2, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (this.field_70163_u > (double)(towerY + this.getTowerHeight())) {
                    this.field_70181_x = 0.0;
                    this.field_70161_v += 1.0;
                    this.field_70165_t += 1.0;
                    this.setStage(3);
                    this.setExperimentTimer(this.field_70146_Z.nextInt(1000) + 500);
                    this.setExperimentStart(false);
                }
            }
        }
        if (this.getStage() == 3) {
            BlockPos blockPos = this.getTowerPos();
            towerX = blockPos.func_177958_n();
            towerY = blockPos.func_177956_o();
            towerZ = blockPos.func_177952_p();
            int iTowerHeight = this.getTowerHeight();
            this.func_70107_b(towerX + 2, towerY + iTowerHeight + 1, towerZ + 2);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.baseSpeed = 0.0;
            this.updateMoveSpeed();
            if (this.getExperimentTimer() > 0) {
                this.setExperimentTimer(this.getExperimentTimer() - 1);
            }
            if (this.field_70146_Z.nextInt(200) == 0) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, (double)MathHelper.func_76128_c((double)this.field_70165_t), (double)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 3), (double)MathHelper.func_76128_c((double)this.field_70161_v), true));
            }
            if (this.field_70146_Z.nextInt(150) == 0 && !this.getWater()) {
                this.field_70170_p.func_175656_a(new BlockPos(towerX + 2, towerY + iTowerHeight, towerZ + 1), Blocks.field_150358_i.func_176223_P());
                this.field_70170_p.func_175656_a(new BlockPos(towerX + 3, towerY + iTowerHeight, towerZ + 2), Blocks.field_150358_i.func_176223_P());
                this.field_70170_p.func_175656_a(new BlockPos(towerX + 1, towerY + iTowerHeight, towerZ + 2), Blocks.field_150358_i.func_176223_P());
                this.field_70170_p.func_175656_a(new BlockPos(towerX + 2, towerY + iTowerHeight, towerZ + 3), Blocks.field_150358_i.func_176223_P());
                this.setWater(true);
            }
            if (this.field_70146_Z.nextInt(8) == 0) {
                EntityEvilLight evilLight = new EntityEvilLight(this.field_70170_p);
                evilLight.func_70012_b(towerX, towerY + iTowerHeight, towerZ, this.field_70177_z, 0.0f);
                evilLight.determineBaseTexture();
                evilLight.setInitialHealth();
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)evilLight);
                }
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                for (int i = 0; i < 4; ++i) {
                    for (int k = 0; k < 10; ++k) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)(2.0f + (float)towerX) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, (double)(1.0f + (float)towerY + (float)iTowerHeight) + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) + 2.0, 2.0 + ((double)towerZ + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f)) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                    }
                }
            }
            if (!this.getExperimentStart()) {
                for (int i = 0; i < 4; ++i) {
                    for (int k = 0; k < 10; ++k) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)(2.0f + (float)towerX) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, (double)(1.0f + (float)towerY + (float)iTowerHeight) + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) + 2.0, 2.0 + ((double)towerZ + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f)) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                    }
                }
                EntityEvilLight evilLight = new EntityEvilLight(this.field_70170_p);
                evilLight.func_70012_b(towerX, towerY + iTowerHeight + 10, towerZ, this.field_70177_z, 0.0f);
                evilLight.determineBaseTexture();
                evilLight.setInitialHealth();
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)evilLight);
                }
                this.setExperimentStart(true);
            }
            if (this.getExperimentTimer() < 1) {
                this.field_70170_p.func_72876_a(null, (double)(towerX + 2), (double)(towerY + iTowerHeight + 4), (double)(towerZ + 2), 2.0f, true);
                this.setExperimentStart(true);
                this.setStage(4);
            }
        }
        if (this.getStage() == 4) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            int randInt = this.field_70146_Z.nextInt(5) + 1;
            for (int i = 0; i < randInt; ++i) {
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, (double)(x + this.field_70146_Z.nextInt(4) - 2), (double)(y + 6), (double)(z + this.field_70146_Z.nextInt(4) - 2), true));
            }
            this.func_184185_a(CreepsSoundHandler.evilExplosionSound, this.func_70599_aP(), this.func_70647_i());
            this.setTrulyEvil(true);
            this.updateTexture();
            this.updateHealth();
            this.addHealth(50.0f);
            randInt = this.field_70146_Z.nextInt(4) + 1;
            BlockPos blockPos = this.getTowerPos();
            int towerX3 = blockPos.func_177958_n();
            int towerY3 = blockPos.func_177956_o();
            int towerZ3 = blockPos.func_177952_p();
            int iTowerHeight = this.getTowerHeight();
            block19: for (int i = 0; i < randInt; ++i) {
                switch (this.field_70146_Z.nextInt(4)) {
                    case 0: 
                    case 4: {
                        int randInt2 = this.field_70146_Z.nextInt(8) + 2;
                        for (int j = 0; j < randInt2; ++j) {
                            EntityEvilSnowman evilSnowman = new EntityEvilSnowman(this.field_70170_p);
                            evilSnowman.func_70012_b(towerX3 + this.field_70146_Z.nextInt(3), towerY3 + iTowerHeight + 1, towerZ3 + this.field_70146_Z.nextInt(3), this.field_70177_z, 0.0f);
                            evilSnowman.determineBaseTexture();
                            evilSnowman.setInitialHealth();
                            evilSnowman.field_70159_w = this.field_70146_Z.nextFloat() * 0.3f;
                            evilSnowman.field_70181_x = this.field_70146_Z.nextFloat() * 0.4f;
                            evilSnowman.field_70179_y = this.field_70146_Z.nextFloat() * 0.4f;
                            evilSnowman.field_70143_R = -35.0f;
                            if (this.field_70170_p.field_72995_K) continue;
                            this.field_70170_p.func_72838_d((Entity)evilSnowman);
                        }
                        continue block19;
                    }
                    case 1: {
                        EntityEvilCreature evilCreature = new EntityEvilCreature(this.field_70170_p);
                        evilCreature.func_70012_b(towerX3, towerY3 + iTowerHeight + 1, towerZ3, this.field_70177_z, 0.0f);
                        evilCreature.determineBaseTexture();
                        evilCreature.setInitialHealth();
                        if (this.field_70170_p.field_72995_K) continue block19;
                        this.field_70170_p.func_72838_d((Entity)evilCreature);
                        continue block19;
                    }
                    case 2: {
                        EntityEvilPig evilPig = new EntityEvilPig(this.field_70170_p);
                        evilPig.func_70012_b(towerX3, towerY3 + iTowerHeight + 1, towerZ3, this.field_70177_z, 0.0f);
                        evilPig.determineBaseTexture();
                        evilPig.setInitialHealth();
                        if (this.field_70170_p.field_72995_K) continue block19;
                        this.field_70170_p.func_72838_d((Entity)evilPig);
                        continue block19;
                    }
                    case 3: {
                        EntityEvilChicken evilChicken = new EntityEvilChicken(this.field_70170_p);
                        evilChicken.func_70012_b(towerX3 + this.field_70146_Z.nextInt(3), towerY3 + iTowerHeight + 1, towerZ3 + this.field_70146_Z.nextInt(3), this.field_70177_z, 0.0f);
                        evilChicken.determineBaseTexture();
                        evilChicken.setInitialHealth();
                        evilChicken.field_70159_w = this.field_70146_Z.nextFloat() * 0.3f;
                        evilChicken.field_70181_x = this.field_70146_Z.nextFloat() * 0.4f;
                        evilChicken.field_70179_y = this.field_70146_Z.nextFloat() * 0.4f;
                        evilChicken.field_70143_R = -35.0f;
                        if (this.field_70170_p.field_72995_K) continue block19;
                        this.field_70170_p.func_72838_d((Entity)evilChicken);
                        continue block19;
                    }
                }
            }
            this.setNumExperiments(this.getNumExperiments() - 1);
            if (this.getNumExperiments() < 1) {
                this.setNumExperiments(this.field_70146_Z.nextInt(4) + 1);
                this.setStage(5);
            } else {
                this.setStage(3);
                this.setExperimentTimer(this.field_70146_Z.nextInt(500) + 500);
                this.setExperimentStart(false);
            }
        }
        if (this.getStage() == 5) {
            this.tearDownTower();
            this.setStage(6);
        }
        if (this.getStage() == 6) {
            this.setExperimentTimer(this.field_70146_Z.nextInt(5000) + 100);
            this.setStage(0);
        }
    }

    public int getTowerHeight() {
        return (Integer)this.field_70180_af.func_187225_a(towerHeight);
    }

    protected void setTowerHeight(int i) {
        this.field_70180_af.func_187227_b(towerHeight, (Object)i);
    }

    public BlockPos getTowerPos() {
        return (BlockPos)this.field_70180_af.func_187225_a(towerPos);
    }

    protected void setTowerPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(towerPos, (Object)new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        this.field_70180_af.func_187217_b(towerPos);
    }

    public boolean getWater() {
        return (Boolean)this.field_70180_af.func_187225_a(water);
    }

    protected void setWater(boolean b) {
        this.field_70180_af.func_187227_b(water, (Object)b);
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.getStage() != 0) {
            return false;
        }
        return super.func_70692_ba();
    }

    @Override
    public float maxShrink() {
        return 0.4f;
    }

    @Override
    public float getRayAmount() {
        return 0.2f;
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }
}

