/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityInvisibleMan
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final DataParameter<Boolean> anger = EntityDataManager.func_187226_a(EntityInvisibleMan.class, (DataSerializer)DataSerializers.field_187198_h);
    private int angerLevel;
    private boolean hasAngryTexture = false;
    private UUID angerTargetUUID;

    public EntityInvisibleMan(World world) {
        super(world);
        this.creatureType = EnumCreatureType.MONSTER;
        this.baseHealth = (float)this.field_70146_Z.nextInt(40) + 40.0f;
        this.baseSpeed = 0.3;
        this.func_70105_a(0.8f, 1.8f);
        this.field_70180_af.func_187227_b(anger, (Object)false);
        this.angerLevel = 0;
        super.setTexture("textures/entity/invisibleman.png");
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151055_y));
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(anger, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(32.0, 32.0, 32.0));
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                if (!(entity1 instanceof EntityInvisibleMan)) continue;
                EntityInvisibleMan entityinvisibleman = (EntityInvisibleMan)entity1;
                entityinvisibleman.becomeAngryAt(entity);
            }
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), i);
    }

    private void becomeAngryAt(Entity entity) {
        this.func_70624_b((EntityLivingBase)entity);
        this.angerLevel += 80 + this.field_70146_Z.nextInt(80);
        this.field_70180_af.func_187227_b(anger, (Object)true);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        boolean serverSaysWeAreAngry = (Boolean)this.field_70180_af.func_187225_a(anger);
        if (this.hasAngryTexture && !serverSaysWeAreAngry) {
            this.setTexture("textures/entity/invisibleman.png");
            this.hasAngryTexture = false;
            this.func_184185_a(CreepsSoundHandler.invisibleManForget, 1.0f, 1.0f);
        }
        if (!this.hasAngryTexture && serverSaysWeAreAngry) {
            this.setTexture("textures/entity/invisiblemanmad.png");
            this.hasAngryTexture = true;
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isAngry()) {
            --this.angerLevel;
            if (!this.isAngry()) {
                this.field_70180_af.func_187227_b(anger, (Object)false);
            }
        } else {
            this.func_70624_b(null);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    public int func_142015_aE() {
        return this.angerLevel;
    }

    protected SoundEvent func_184639_G() {
        return this.angerLevel == 0 ? CreepsSoundHandler.invisibleManSound : CreepsSoundHandler.invisibleManAngry;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.invisibleManHurt;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.invisibleManDeath;
    }

    @Override
    protected void dropItemsOnDeath() {
        this.func_145779_a(Items.field_151055_y, 3);
        this.func_145779_a(Items.field_151034_e, 1);
    }

    @Override
    public float maxShrink() {
        return 0.4f;
    }

    @Override
    public float getRayAmount() {
        return 0.2f;
    }

    @Override
    public float maxGrowth() {
        return 4.0f;
    }
}

