/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityKid;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityLolliman
extends EntityCreepBase
implements IEntityCanChangeSize {
    private static final DataParameter<Boolean> kidMounted = EntityDataManager.func_187226_a(EntityLolliman.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> kidCheck = EntityDataManager.func_187226_a(EntityLolliman.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> rocketTime = EntityDataManager.func_187226_a(EntityLolliman.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> treats = EntityDataManager.func_187226_a(EntityLolliman.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityLolliman(World world) {
        super(world);
        this.func_70105_a(0.9f, 3.0f);
        this.setModelSize(2.0f);
        this.baseHealth = 25.0f;
        this.baseSpeed = 0.3;
        this.updateAttributes();
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/lolliman.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(kidMounted, (Object)false);
        this.field_70180_af.func_187214_a(kidCheck, (Object)0);
        this.field_70180_af.func_187214_a(rocketTime, (Object)0);
        this.field_70180_af.func_187214_a(treats, (Object)0);
    }

    @Override
    public void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        if (!this.getKidMounted()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        }
    }

    @Override
    public boolean func_70094_T() {
        if (this.getKidMounted()) {
            return false;
        }
        return super.func_70094_T();
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(CreepsItemHandler.lolly, this.field_70146_Z.nextInt(3) + 1);
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(CreepsItemHandler.sundae, this.field_70146_Z.nextInt(3) + 1);
        }
    }

    protected SoundEvent func_184639_G() {
        return CreepsSoundHandler.lollimanSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.lollimanHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.lollimanDeathSound;
    }

    public boolean getKidMounted() {
        return (Boolean)this.field_70180_af.func_187225_a(kidMounted);
    }

    protected void setKidMounted(boolean b) {
        this.field_70180_af.func_187227_b(kidMounted, (Object)b);
    }

    @Override
    protected boolean shouldJumpWhileAttacking(Entity entity) {
        return true;
    }

    @Override
    protected void doAttackJump(Entity entity) {
        this.field_70177_z = (float)Math.toDegrees(Math.atan2(entity.field_70161_v - this.field_70161_v, entity.field_70165_t - this.field_70165_t)) - 90.0f;
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70161_v - this.field_70161_v;
        double f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        this.field_70159_w = d0 / f * 0.2 * (0.850000011920929 + this.field_70159_w * (double)0.2f);
        this.field_70179_y = d1 / f * 0.2 * ((double)0.8f + this.field_70179_y * (double)0.2f);
        this.field_70181_x = 0.10000000596246449;
        this.field_70143_R = -25.0f;
    }

    @Override
    public void func_70636_d() {
        block13: {
            block14: {
                super.func_70636_d();
                if (this.getKidMounted()) break block14;
                this.field_70180_af.func_187227_b(kidCheck, (Object)((Integer)this.field_70180_af.func_187225_a(kidCheck) + 1));
                if ((Integer)this.field_70180_af.func_187225_a(kidCheck) <= 10) break block13;
                this.field_70180_af.func_187227_b(kidCheck, (Object)0);
                for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(2.0, 2.0, 2.0))) {
                    if (!(entity instanceof EntityKid)) continue;
                    this.func_184185_a(CreepsSoundHandler.lollimanTakeOffSound, this.func_70599_aP(), this.func_70647_i());
                    this.baseSpeed = 0.0;
                    this.updateMoveSpeed();
                    this.field_70181_x = 0.6f;
                    if (!this.field_70170_p.field_72995_K) {
                        entity.func_184220_m((Entity)this);
                        this.setKidMounted(true);
                    }
                    break block13;
                }
                break block13;
            }
            this.field_70181_x = 0.25;
            this.field_70180_af.func_187227_b(rocketTime, (Object)((Integer)this.field_70180_af.func_187225_a(rocketTime) + 1));
            if ((Integer)this.field_70180_af.func_187225_a(rocketTime) > 5) {
                this.field_70180_af.func_187227_b(rocketTime, (Object)0);
                int randInt = this.field_70146_Z.nextInt(2) + 1;
                for (int i = 0; i < randInt; ++i) {
                    this.field_70180_af.func_187227_b(treats, (Object)((Integer)this.field_70180_af.func_187225_a(treats) + 1));
                    if ((Integer)this.field_70180_af.func_187225_a(treats) == 30) {
                        this.func_184185_a(CreepsSoundHandler.lollimanExplodeSound, this.func_70599_aP(), this.func_70647_i());
                    }
                    if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(3) == 0) {
                        EntityItem entityItem;
                        switch (this.field_70146_Z.nextInt(4)) {
                            case 1: {
                                entityItem = this.func_70099_a(new ItemStack(Items.field_151106_aX, 1), 1.0f);
                                break;
                            }
                            case 2: {
                                entityItem = this.func_70099_a(new ItemStack(Items.field_151105_aU, 1), 1.0f);
                                break;
                            }
                            case 4: {
                                entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.sundae, 1), 1.0f);
                                break;
                            }
                            default: {
                                entityItem = this.func_70099_a(new ItemStack(CreepsItemHandler.lolly, 1), 1.0f);
                            }
                        }
                        if (entityItem != null) {
                            entityItem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                            entityItem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                        }
                    }
                    if (!(this.field_70163_u > 100.0) && (Integer)this.field_70180_af.func_187225_a(treats) <= 55) continue;
                    for (Entity entity : this.func_184188_bt()) {
                        entity.func_70106_y();
                    }
                    this.func_70106_y();
                    if ((Integer)this.field_70180_af.func_187225_a(treats) <= 50) continue;
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 2.5f, true);
                }
            }
        }
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getRayAmount() {
        return 0.25f;
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }
}

