/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.entity;

import com.morecreepsrevival.morecreeps.common.MoreCreepsAndWeirdos;
import com.morecreepsrevival.morecreeps.common.entity.EntityBullet;
import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBase;
import com.morecreepsrevival.morecreeps.common.entity.EntityGrow;
import com.morecreepsrevival.morecreeps.common.entity.EntityRatMan;
import com.morecreepsrevival.morecreeps.common.entity.IEntityCanChangeSize;
import com.morecreepsrevival.morecreeps.common.helpers.InventoryHelper;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import com.morecreepsrevival.morecreeps.common.networking.CreepsPacketHandler;
import com.morecreepsrevival.morecreeps.common.networking.message.MessageOpenGuiSneakySal;
import com.morecreepsrevival.morecreeps.common.sounds.CreepsSoundHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntitySneakySal
extends EntityCreepBase
implements IRangedAttackMob,
IEntityCanChangeSize {
    public static final int[] itemPrices = new int[]{10, 200, 100, 20, 175, 150, 225, 50, 350, 100, 150, 10, 200, 150, 250};
    public static final Item[] itemDefinitions = new Item[]{CreepsItemHandler.blorpCola, CreepsItemHandler.armyGem, CreepsItemHandler.horseHeadGem, CreepsItemHandler.bandaid, CreepsItemHandler.shrinkRay, CreepsItemHandler.extinguisher, CreepsItemHandler.growRay, CreepsItemHandler.frisbee, CreepsItemHandler.lifeGem, CreepsItemHandler.gun, CreepsItemHandler.raygun, CreepsItemHandler.popsicle, CreepsItemHandler.earthGem, CreepsItemHandler.fireGem, CreepsItemHandler.skyGem};
    private static final DataParameter<Integer> dissedMax = EntityDataManager.func_187226_a(EntitySneakySal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> sale = EntityDataManager.func_187226_a(EntitySneakySal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> salePrice = EntityDataManager.func_187226_a(EntitySneakySal.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> shooting = EntityDataManager.func_187226_a(EntitySneakySal.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> shootingDelay = EntityDataManager.func_187226_a(EntitySneakySal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<NBTTagCompound> shopItems = EntityDataManager.func_187226_a(EntitySneakySal.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Boolean> blackFriday = EntityDataManager.func_187226_a(EntitySneakySal.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntitySneakySal(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 2.0f);
        this.setModelSize(1.5f);
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(CreepsItemHandler.salGun));
        this.baseHealth = (float)this.field_70146_Z.nextInt(50) + 50.0f;
        this.baseAttackDamage = 3.0;
        this.baseSpeed = 0.3f;
        this.updateAttributes();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dissedMax, (Object)(this.field_70146_Z.nextInt(4) + 1));
        this.field_70180_af.func_187214_a(sale, (Object)(this.field_70146_Z.nextInt(2000) + 100));
        this.field_70180_af.func_187214_a(salePrice, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(shooting, (Object)false);
        this.field_70180_af.func_187214_a(shootingDelay, (Object)0);
        this.field_70180_af.func_187214_a(shopItems, (Object)new NBTTagCompound());
        ((NBTTagCompound)this.field_70180_af.func_187225_a(shopItems)).func_74783_a("Items", new int[30]);
        this.field_70180_af.func_187217_b(shopItems);
        this.field_70180_af.func_187214_a(blackFriday, (Object)false);
    }

    @Override
    protected void updateTexture() {
        this.setTexture("textures/entity/sneakysal.png");
    }

    @Override
    protected void func_184651_r() {
        this.clearAITasks();
        NodeProcessor nodeProcessor = this.func_70661_as().func_189566_q();
        nodeProcessor.func_186316_c(true);
        nodeProcessor.func_186317_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 25, 75, 50.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        this.setShooting(true);
        this.field_70180_af.func_187227_b(shootingDelay, (Object)10);
        this.func_184185_a(CreepsSoundHandler.bulletSound, this.func_70599_aP(), this.func_70647_i());
        EntityBullet bullet = new EntityBullet(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - bullet.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        bullet.func_70186_c(d0, d1 + (double)target.field_70131_O * (double)0.2f, d2, 1.6f, 0.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)bullet);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            return CreepsSoundHandler.giraffeSound;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return CreepsSoundHandler.salHurtSound;
    }

    protected SoundEvent func_184615_bR() {
        return CreepsSoundHandler.salDeadSound;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return super.func_184645_a(player, hand);
        }
        if (this.getDissedMax() > 0) {
            if (this.getSalePrice() == 0.0f || (Integer)this.field_70180_af.func_187225_a(sale) < 1) {
                this.restock();
            }
            if (!(this.func_70638_az() instanceof EntityPlayer) && !this.field_70170_p.field_72995_K) {
                CreepsPacketHandler.INSTANCE.sendTo((IMessage)new MessageOpenGuiSneakySal(this.func_145782_y()), (EntityPlayerMP)player);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        EntityLivingBase target;
        EntityPlayer player;
        super.func_70636_d();
        this.setBlackFriday(MoreCreepsAndWeirdos.isBlackFriday());
        if ((Integer)this.field_70180_af.func_187225_a(shootingDelay) > 0) {
            this.field_70180_af.func_187227_b(shootingDelay, (Object)((Integer)this.field_70180_af.func_187225_a(shootingDelay) - 1));
            if ((Integer)this.field_70180_af.func_187225_a(shootingDelay) < 1) {
                this.setShooting(false);
            }
        }
        if ((Integer)this.field_70180_af.func_187225_a(sale) > 0) {
            this.field_70180_af.func_187227_b(sale, (Object)((Integer)this.field_70180_af.func_187225_a(sale) - 1));
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            double xHeading = -MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
            double zHeading = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + xHeading * 0.5, this.field_70163_u + 2.0, this.field_70161_v + zHeading * 0.5, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
        }
        if (this.getDissedMax() < 1 && this.func_70638_az() == null && (player = this.field_70170_p.func_72890_a((Entity)this, 16.0)) != null && this.func_70685_l((Entity)player) && !player.field_71075_bZ.field_75102_a) {
            this.func_70624_b((EntityLivingBase)player);
        }
        if ((target = this.func_70638_az()) instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
            this.func_70624_b(null);
        }
    }

    public void smoke() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) + (double)i, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.06, this.field_70146_Z.nextGaussian() * 0.06, this.field_70146_Z.nextGaussian() * 0.06, new int[0]);
            }
        }
    }

    private void restock() {
        int i;
        this.field_70180_af.func_187227_b(sale, (Object)(this.field_70146_Z.nextInt(2000) + 100));
        if (this.isBlackFriday()) {
            this.field_70180_af.func_187227_b(salePrice, (Object)Float.valueOf(0.5f));
        } else {
            this.field_70180_af.func_187227_b(salePrice, (Object)Float.valueOf(1.0f - (this.field_70146_Z.nextFloat() * 0.25f - this.field_70146_Z.nextFloat() * 0.25f)));
        }
        int[] currentItems = ((NBTTagCompound)this.field_70180_af.func_187225_a(shopItems)).func_74759_k("Items");
        for (i = 0; i < itemDefinitions.length; ++i) {
            currentItems[i] = i;
        }
        for (i = 0; i < itemDefinitions.length; ++i) {
            int k = this.field_70146_Z.nextInt(itemDefinitions.length);
            int l = currentItems[i];
            currentItems[i] = currentItems[k];
            currentItems[k] = l;
        }
        this.field_70180_af.func_187217_b(shopItems);
    }

    @Override
    protected void dropItemsOnDeath() {
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.func_145779_a(CreepsItemHandler.rocket, this.field_70146_Z.nextInt(5) + 1);
        }
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource cause) {
        this.smoke();
        super.func_70645_a(cause);
    }

    public boolean getShooting() {
        return (Boolean)this.field_70180_af.func_187225_a(shooting);
    }

    private void setShooting(boolean b) {
        this.field_70180_af.func_187227_b(shooting, (Object)b);
    }

    public int[] getShopItems() {
        return ((NBTTagCompound)this.field_70180_af.func_187225_a(shopItems)).func_74759_k("Items");
    }

    public float getSalePrice() {
        return ((Float)this.field_70180_af.func_187225_a(salePrice)).floatValue();
    }

    public void ripOff() {
        if (this.getDissedMax() < 1) {
            return;
        }
        this.setDissedMax(this.getDissedMax() - 1);
        if (this.field_70146_Z.nextInt(9) == 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, this.func_70599_aP(), this.func_70647_i());
            switch (this.field_70146_Z.nextInt(15) + 1) {
                case 1: {
                    this.func_145779_a(CreepsItemHandler.armyGem, 1);
                    break;
                }
                case 2: {
                    this.func_145779_a(CreepsItemHandler.horseHeadGem, 1);
                    break;
                }
                case 4: {
                    this.func_145779_a(CreepsItemHandler.shrinkRay, 1);
                    break;
                }
                case 5: {
                    this.func_145779_a(CreepsItemHandler.extinguisher, 1);
                    break;
                }
                case 6: {
                    this.func_145779_a(CreepsItemHandler.growRay, 1);
                    break;
                }
                case 7: {
                    this.func_145779_a(CreepsItemHandler.frisbee, 1);
                    break;
                }
                case 8: {
                    this.func_145779_a(CreepsItemHandler.lifeGem, 1);
                    break;
                }
                case 9: {
                    this.func_145779_a(CreepsItemHandler.gun, 1);
                    break;
                }
                case 10: {
                    this.func_145779_a(CreepsItemHandler.raygun, 1);
                    break;
                }
                default: {
                    this.func_145779_a(CreepsItemHandler.bandaid, 1);
                }
            }
            return;
        }
        int randInt = this.field_70146_Z.nextInt(15) + 5;
        double d = -MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
        double d1 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
        for (int i = 0; i < randInt; ++i) {
            EntityRatMan ratMan = new EntityRatMan(this.field_70170_p);
            ratMan.func_70012_b(this.field_70165_t + d * 1.0 + (double)this.field_70146_Z.nextInt(4) - 2.0, this.field_70163_u - 1.0, this.field_70161_v + d1 * 1.0 + (double)this.field_70146_Z.nextInt(4) - 2.0, this.field_70177_z, 0.0f);
            ratMan.field_70181_x = 1.0;
            ratMan.determineBaseTexture();
            ratMan.setInitialHealth();
            if (this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_72838_d((Entity)ratMan);
        }
        this.func_184185_a(CreepsSoundHandler.salRatsSound, 1.0f, 1.0f);
    }

    public void buyItem(EntityPlayer player, int itemId) {
        if (this.getDissedMax() < 1 || itemId < 0 || itemId >= itemDefinitions.length) {
            return;
        }
        int item = this.getShopItems()[itemId];
        if (InventoryHelper.takeItem(player.field_71071_by, CreepsItemHandler.money, Math.round((float)itemPrices[item] * this.getSalePrice()))) {
            this.func_145779_a(itemDefinitions[item], 1);
            this.func_184185_a(CreepsSoundHandler.salSaleSound, 1.0f, 1.0f);
        } else {
            this.func_184185_a(CreepsSoundHandler.salNoMoneySound, 1.0f, 1.0f);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsSneakySal");
        props.func_74768_a("Sale", ((Integer)this.field_70180_af.func_187225_a(sale)).intValue());
        props.func_74776_a("SalePrice", this.getSalePrice());
        props.func_74768_a("DissedMax", this.getDissedMax());
        compound.func_74782_a("MoreCreepsSneakySal", (NBTBase)props);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagCompound props = compound.func_74775_l("MoreCreepsSneakySal");
        if (props.func_74764_b("Sale")) {
            this.field_70180_af.func_187227_b(sale, (Object)props.func_74762_e("Sale"));
        }
        if (props.func_74764_b("SalePrice")) {
            this.field_70180_af.func_187227_b(salePrice, (Object)Float.valueOf(props.func_74760_g("SalePrice")));
        }
        if (props.func_74764_b("DissedMax")) {
            this.setDissedMax(props.func_74762_e("DissedMax"));
        }
        this.restock();
    }

    @Override
    public boolean func_70097_a(@Nonnull DamageSource damageSource, float amt) {
        if (damageSource.func_76346_g() instanceof EntityPlayer) {
            this.setDissedMax(0);
        }
        return super.func_70097_a(damageSource, amt);
    }

    public boolean isBlackFriday() {
        return (Boolean)this.field_70180_af.func_187225_a(blackFriday);
    }

    private void setBlackFriday(boolean b) {
        this.field_70180_af.func_187227_b(blackFriday, (Object)b);
    }

    public int getDissedMax() {
        return (Integer)this.field_70180_af.func_187225_a(dissedMax);
    }

    public void setDissedMax(int i) {
        this.field_70180_af.func_187227_b(dissedMax, (Object)i);
    }

    @Override
    public float maxShrink() {
        return 0.5f;
    }

    @Override
    public float getRayAmount() {
        return 0.2f;
    }

    @Override
    public float maxGrowth() {
        return 5.0f;
    }

    @Override
    public void onGrow(EntityGrow source) {
        this.setDissedMax(0);
    }
}

