/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.helpers;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CreepsUtil {
    static final float fullRadian = (float)Math.PI;
    static ParticleBreaking.Factory eatingParticlesFactory = new ParticleBreaking.Factory();

    public static Vec2f RandomVector2dNormalized(Random rand) {
        float randfactor = (float)CreepsUtil.GetRandomUnit(rand);
        float resultangle = (float)Math.PI * randfactor;
        return new Vec2f(MathHelper.func_76134_b((float)resultangle), MathHelper.func_76126_a((float)resultangle));
    }

    public static Vec3d RandomVector3dNormalized(Random rand) {
        float randfactorhorizontal = (float)CreepsUtil.GetRandomUnit(rand);
        float randfactorvertical = (float)CreepsUtil.GetRandomUnit(rand);
        float horizontalangle = (float)Math.PI * randfactorhorizontal;
        float verticalangle = (float)Math.PI * randfactorvertical;
        return new Vec3d((double)MathHelper.func_76134_b((float)horizontalangle), (double)MathHelper.func_76134_b((float)verticalangle), (double)MathHelper.func_76126_a((float)horizontalangle));
    }

    public static double GetRandomUnit(Random rand) {
        return (double)rand.nextInt(100000) * 1.0E-5;
    }

    public static double GetRandomUnitMinus(Random rand) {
        return (double)(rand.nextInt(200000) - 100000) * 1.0E-5;
    }

    public static Particle SpawnEatingParticle(World world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float size, Item itemFodder) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return null;
        }
        Particle toSpawn = eatingParticlesFactory.func_178902_a(-1, world, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, new int[]{Item.func_150891_b((Item)itemFodder)});
        toSpawn.func_70541_f(size);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(toSpawn);
        return toSpawn;
    }

    public static void SpawnEatingParticleRGB(World world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float size, float colorRed, float colorGreen, float colorBlue, Item itemFodder) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        Particle toSpawn = eatingParticlesFactory.func_178902_a(-1, world, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, new int[]{Item.func_150891_b((Item)itemFodder)});
        toSpawn.func_70541_f(size);
        toSpawn.func_70538_b(colorRed, colorGreen, colorBlue);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(toSpawn);
    }

    public static boolean TryPlaceTorch(World world, BlockPos pos) {
        boolean sucess;
        IBlockState basestate = Blocks.field_150478_aa.func_176223_P();
        if (!world.func_175623_d(pos)) {
            return false;
        }
        Block block = basestate.func_177230_c();
        EnumFacing facing = EnumFacing.DOWN;
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.NORTH, block)) {
            facing = EnumFacing.NORTH;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.SOUTH, block)) {
            facing = EnumFacing.SOUTH;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.WEST, block)) {
            facing = EnumFacing.WEST;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.EAST, block)) {
            facing = EnumFacing.EAST;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.UP, block)) {
            facing = EnumFacing.UP;
        }
        boolean bl = sucess = facing != EnumFacing.DOWN;
        if (sucess) {
            world.func_180501_a(pos, basestate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing), 2);
        }
        return sucess;
    }

    public static boolean TryPlaceRedstoneTorch(World world, BlockPos pos) {
        boolean sucess;
        IBlockState basestate = Blocks.field_150429_aA.func_176223_P();
        if (!world.func_175623_d(pos)) {
            return false;
        }
        Block block = basestate.func_177230_c();
        EnumFacing facing = EnumFacing.DOWN;
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.NORTH, block)) {
            facing = EnumFacing.NORTH;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.SOUTH, block)) {
            facing = EnumFacing.SOUTH;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.WEST, block)) {
            facing = EnumFacing.WEST;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.EAST, block)) {
            facing = EnumFacing.EAST;
        }
        if (CreepsUtil.CanPlaceTorchOn(world, pos, EnumFacing.UP, block)) {
            facing = EnumFacing.UP;
        }
        boolean bl = sucess = facing != EnumFacing.DOWN;
        if (sucess) {
            world.func_180501_a(pos, basestate.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing), 2);
        }
        return sucess;
    }

    private static boolean CanPlaceTorchOn(World worldIn, BlockPos pos, EnumFacing facing, Block block) {
        EnumFacing enumfacing = facing;
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        IBlockState state = worldIn.func_180495_p(pos);
        return worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) == BlockFaceShape.SOLID;
    }
}

