/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.networking.message;

import com.morecreepsrevival.morecreeps.common.entity.EntityCreepBaseOwnable;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSetEntityWanderState
implements IMessage {
    private int entityId;
    private int wanderState;

    public MessageSetEntityWanderState() {
    }

    public MessageSetEntityWanderState(int entityIdIn, int wanderStateIn) {
        this.entityId = entityIdIn;
        this.wanderState = wanderStateIn;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeShort(this.wanderState);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.wanderState = buf.readShort();
    }

    public static class MessageHandler
    implements IMessageHandler<MessageSetEntityWanderState, IMessage> {
        public IMessage onMessage(MessageSetEntityWanderState message, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                EntityCreepBaseOwnable creep;
                Entity entity = world.func_73045_a(message.entityId);
                if (entity instanceof EntityCreepBaseOwnable && (creep = (EntityCreepBaseOwnable)entity).isPlayerOwner((EntityPlayer)player)) {
                    creep.setWanderState(message.wanderState);
                    switch (message.wanderState) {
                        case 0: {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.wanderstate.0", new Object[]{creep.func_70005_c_()}));
                            break;
                        }
                        case 1: {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.wanderstate.1", new Object[]{creep.func_70005_c_()}));
                            break;
                        }
                        case 2: {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.morecreeps.wanderstate.2", new Object[]{creep.func_70005_c_()}));
                            break;
                        }
                    }
                }
            });
            return null;
        }
    }
}

