/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.world;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.entity.EntityCastleKing;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenCastle
extends WorldGenerator {
    private static final int maxObstruct = 300;
    private static final int castleHeight = 5;
    private static Template STRUCTURE = null;
    private static BlockPos SIZE_STRUCTURE = null;

    public static boolean tryCacheStructure(World world) {
        if (STRUCTURE != null) {
            return true;
        }
        ResourceLocation location = new ResourceLocation("morecreeps", "castle(noentities)");
        MinecraftServer serv = world.func_73046_m();
        TemplateManager manager = ((WorldServer)world).func_184163_y();
        STRUCTURE = manager.func_189942_b(serv, location);
        if (STRUCTURE == null) {
            return false;
        }
        SIZE_STRUCTURE = STRUCTURE.func_186259_a();
        return true;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        return this.newGenerate(world, rand, pos);
    }

    public boolean newGenerate(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        if (!WorldGenCastle.tryCacheStructure(world)) {
            return false;
        }
        BlockPos structurepos = this.findStructurePos(world, rand, pos);
        if (structurepos == null) {
            return false;
        }
        BlockPos structuresize = SIZE_STRUCTURE;
        PlacementSettings settings = new PlacementSettings().func_186226_b(false).func_186222_a(false);
        IBlockState state = world.func_180495_p(structurepos);
        world.func_184138_a(structurepos, state, state, 3);
        STRUCTURE.func_186253_b(world, structurepos, settings);
        ArrayList<TileEntityChest> collectedChests = new ArrayList<TileEntityChest>();
        for (int x = 0; x < structuresize.func_177958_n(); ++x) {
            for (int y = 0; y < structuresize.func_177956_o(); ++y) {
                for (int z = 0; z < structuresize.func_177952_p(); ++z) {
                    TileEntity tileEntity;
                    BlockPos currentPos = structurepos.func_177982_a(x, y, z);
                    if (world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150486_ae || !((tileEntity = world.func_175625_s(currentPos)) instanceof TileEntityChest)) continue;
                    collectedChests.add((TileEntityChest)tileEntity);
                }
            }
        }
        ArrayList<ResourceLocation> lootTablesToSet = new ArrayList<ResourceLocation>();
        lootTablesToSet.add(new ResourceLocation("morecreeps", "chests/castle_earth_gem"));
        lootTablesToSet.add(new ResourceLocation("morecreeps", "chests/castle_fire_gem"));
        lootTablesToSet.add(new ResourceLocation("morecreeps", "chests/castle_healing_gem"));
        lootTablesToSet.add(new ResourceLocation("morecreeps", "chests/castle_mining_gem"));
        lootTablesToSet.add(new ResourceLocation("morecreeps", "chests/castle_sky_gem"));
        for (int i = 0; i < collectedChests.size() - 5; ++i) {
            lootTablesToSet.add(new ResourceLocation("morecreeps", "chests/castle"));
        }
        for (TileEntityChest collectedChest : collectedChests) {
            collectedChest.func_174888_l();
            collectedChest.func_189404_a((ResourceLocation)lootTablesToSet.remove(rand.nextInt(lootTablesToSet.size())), rand.nextLong());
        }
        int stx = structuresize.func_177958_n() + structurepos.func_177958_n();
        int sty = structurepos.func_177956_o() - 1;
        int stz = structuresize.func_177952_p() + structurepos.func_177952_p();
        int bgx = structurepos.func_177958_n() - 1;
        int bgy = structurepos.func_177956_o() - 11;
        int bgz = structurepos.func_177952_p() - 1;
        Biome biome = world.func_180494_b(structurepos);
        Block topblock = biome.field_76752_A.func_177230_c();
        Block fillerblock = biome.field_76753_B.func_177230_c();
        this.fillCorners(world, topblock, bgx, sty + 1, bgz, stx, sty + 1, stz);
        this.fillCorners(world, fillerblock, bgx, bgy, bgz, stx, sty, stz);
        EntityCastleKing king = new EntityCastleKing(world);
        king.func_70012_b(structurepos.func_177958_n() + structuresize.func_177958_n() / 2, structurepos.func_177956_o() + structuresize.func_177956_o(), structurepos.func_177952_p() + structuresize.func_177952_p() / 2, 360.0f, 0.0f);
        king.determineBaseTexture();
        king.setInitialHealth();
        king.func_110163_bv();
        world.func_72838_d((Entity)king);
        return true;
    }

    public BlockPos findStructurePos(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (!(MoreCreepsConfig.Spawn.spawnInNonVanillaBiomes && MoreCreepsConfig.hasBiome(Objects.requireNonNull(biome.getRegistryName()).toString()) || Objects.requireNonNull(biome.getRegistryName()).func_110624_b().equals("minecraft"))) {
            return null;
        }
        for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
            if (type != BiomeDictionary.Type.NETHER && type != BiomeDictionary.Type.END) continue;
            return null;
        }
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int castleX = x + rand.nextInt(8) - rand.nextInt(8);
        int castleY = 200;
        int castleZ = z + rand.nextInt(8) - rand.nextInt(8);
        int castlePosX = castleX;
        int castlePosY = castleY;
        int castlePosZ = castleZ;
        int foundation = 0;
        int foundationDepth = 0;
        boolean alternate = true;
        while (foundation < 3) {
            foundation = 0;
            Block block1 = world.func_180495_p(new BlockPos(castlePosX - 4, castlePosY - foundationDepth, castlePosZ - 4)).func_177230_c();
            Block block2 = world.func_180495_p(new BlockPos(castlePosX + 30, castlePosY - foundationDepth, castlePosZ - 4)).func_177230_c();
            Block block3 = world.func_180495_p(new BlockPos(castlePosX - 4, castlePosY - foundationDepth, castlePosZ + 30)).func_177230_c();
            Block block4 = world.func_180495_p(new BlockPos(castlePosX + 30, castlePosY - foundationDepth, castlePosZ + 30)).func_177230_c();
            if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i || block2 == Blocks.field_150355_j || block2 == Blocks.field_150358_i || block3 == Blocks.field_150355_j || block3 == Blocks.field_150358_i || block4 == Blocks.field_150355_j || block4 == Blocks.field_150358_i) {
                return null;
            }
            if (block1 != Blocks.field_150350_a && block1 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block2 != Blocks.field_150350_a && block2 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block3 != Blocks.field_150350_a && block3 != Blocks.field_150362_t) {
                ++foundation;
            }
            if (block4 != Blocks.field_150350_a && block4 != Blocks.field_150362_t) {
                ++foundation;
            }
            ++foundationDepth;
        }
        castlePosY = castleY = castlePosY - foundationDepth + 2;
        if (!(world.func_175667_e(new BlockPos(castleX - 4, castleY, castleZ - 4)) && world.func_175667_e(new BlockPos(castleX + 30, castleY, castleZ - 4)) && world.func_175667_e(new BlockPos(castleX + 30, castleY, castleZ + 30)) && world.func_175667_e(new BlockPos(castleX - 4, castleY, castleZ + 30)))) {
            return null;
        }
        int maxI = 42;
        int area = 0;
        for (int i = 0; i < maxI; i += 2) {
            for (int k = -12 + i; k < 38; k += 2) {
                for (int j = -12 + i; j < 38; j += 2) {
                    Block block = world.func_180495_p(new BlockPos(x + k, castlePosY + i, z + j)).func_177230_c();
                    if (block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150364_r || block == Blocks.field_150363_s || ++area <= 300) continue;
                    return null;
                }
            }
        }
        return new BlockPos(castleX, castleY - 1, castleZ);
    }

    private void fillCorners(World world, Block block, int xm, int ym, int zm, int xmx, int ymx, int zmx) {
        IBlockState state = block.func_176223_P();
        for (int ynow = ym; ynow <= ymx; ++ynow) {
            BlockPos pos2;
            BlockPos pos;
            int i;
            for (i = xm; i <= xmx; ++i) {
                pos = new BlockPos(i, ynow, zm);
                if (!world.func_180495_p(pos).func_185913_b()) {
                    world.func_175656_a(pos, state);
                }
                if (world.func_180495_p(pos2 = new BlockPos(i, ynow, zmx)).func_185913_b()) continue;
                world.func_175656_a(pos2, state);
            }
            for (i = zm; i <= zmx; ++i) {
                pos = new BlockPos(xm, ynow, i);
                if (!world.func_180495_p(pos).func_185913_b()) {
                    world.func_175656_a(pos, state);
                }
                if (world.func_180495_p(pos2 = new BlockPos(xmx, ynow, i)).func_185913_b()) continue;
                world.func_175656_a(pos2, state);
            }
        }
    }
}

