/*
 * Decompiled with CFR 0.152.
 */
package com.morecreepsrevival.morecreeps.common.world;

import com.morecreepsrevival.morecreeps.common.config.MoreCreepsConfig;
import com.morecreepsrevival.morecreeps.common.entity.EntityBabyMummy;
import com.morecreepsrevival.morecreeps.common.entity.EntityBlackSoul;
import com.morecreepsrevival.morecreeps.common.entity.EntityMummy;
import com.morecreepsrevival.morecreeps.common.entity.EntityPyramidGuardian;
import com.morecreepsrevival.morecreeps.common.items.CreepsItemHandler;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenPyramid
extends WorldGenerator {
    private static final int rows = 35;
    private static final int columns = 35;
    private static final int maxObstruct = 100;
    private static final int wallCode = 7;
    private static final int pathCode = 15;
    private static final int emptyCode = 0;
    private static final int visitedCode = 4;
    private int[][] maze = new int[36][36];

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
        int i3;
        int i2;
        int j;
        int i;
        int i4;
        Biome biome = world.func_180494_b(pos);
        if (!(MoreCreepsConfig.Spawn.spawnInNonVanillaBiomes && MoreCreepsConfig.hasBiome(Objects.requireNonNull(biome.getRegistryName()).toString()) || Objects.requireNonNull(biome.getRegistryName()).func_110624_b().equals("minecraft"))) {
            return false;
        }
        for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
            if (type != BiomeDictionary.Type.NETHER && type != BiomeDictionary.Type.END) continue;
            return false;
        }
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int area = 0;
        for (int count = 0; count < 20; count += 2) {
            int iMax = 35 - count + 2;
            for (i4 = -2 + count; i4 < iMax; i4 += 2) {
                int jMax = 35 - count + 2;
                for (int j2 = -2 + count; j2 < jMax; j2 += 2) {
                    if (world.func_175623_d(new BlockPos(x + i4, y + count, z + j2)) || ++area <= 100) continue;
                    return false;
                }
            }
        }
        if (!(world.func_175667_e(pos) && world.func_175667_e(new BlockPos(x + 35, y, z)) && world.func_175667_e(new BlockPos(x, y, z + 35)) && world.func_175667_e(new BlockPos(x + 35, y, z + 35)) && world.func_180495_p(new BlockPos(x + rand.nextInt(16), y - 2, z + rand.nextInt(16))).func_177230_c() == Blocks.field_150354_m)) {
            return false;
        }
        this.makeMaze();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.maze[33 - i][33 - j] = 0;
            }
        }
        for (i = -2; i < 21; ++i) {
            int rowCount = 35 - i + 2;
            for (int j3 = -2 + i; j3 < rowCount; ++j3) {
                int columnCount = 35 - i + 2;
                for (int q = -2 + i; q < columnCount; ++q) {
                    world.func_175656_a(new BlockPos(x + j3, y + i, z + q), Blocks.field_150322_A.func_176223_P());
                }
            }
        }
        for (i = 0; i < 35; ++i) {
            for (j = 0; j < 35; ++j) {
                world.func_175656_a(new BlockPos(x + i, y, z + j), Block.func_149729_e((int)this.maze[i][j]).func_176223_P());
                world.func_175656_a(new BlockPos(x + i, y - 1, z + j), Block.func_149729_e((int)this.maze[i][j]).func_176223_P());
                world.func_175656_a(new BlockPos(x + i, y - 2, z + j), Blocks.field_150357_h.func_176223_P());
            }
        }
        for (i = 0; i < 30; ++i) {
            i2 = rand.nextInt(29) + 3;
            if (this.maze[i2][i3 = rand.nextInt(29) + 3] != 7) continue;
            world.func_175656_a(new BlockPos(x + i2, y, z + 16), Blocks.field_150359_w.func_176223_P());
        }
        for (i = 0; i < 15; ++i) {
            i2 = rand.nextInt(29) + 3;
            if (this.maze[i2][i3 = rand.nextInt(29) + 3] != 7) continue;
            world.func_175656_a(new BlockPos(x + i2, y - 1, z + i3), Blocks.field_150322_A.func_176223_P());
            world.func_175656_a(new BlockPos(x + i2, y, z + i3), Blocks.field_150322_A.func_176223_P());
        }
        for (i = 0; i < 20; ++i) {
            i2 = rand.nextInt(32) + 3;
            if (this.maze[i2][i3 = rand.nextInt(32) + 3] != 0) continue;
            world.func_175656_a(new BlockPos(x + i2, y - 1, z + i3), Block.func_149729_e((int)30).func_176223_P());
            if (rand.nextInt(4) != 0) continue;
            world.func_175656_a(new BlockPos(x + i2, y, z + i3), Blocks.field_150321_G.func_176223_P());
        }
        for (i = 0; i < 30; ++i) {
            i2 = rand.nextInt(29) + 3;
            if (this.maze[i2][i3 = rand.nextInt(29) + 3] != 7) continue;
            world.func_175656_a(new BlockPos(x + i2, y, z + i3), Blocks.field_150478_aa.func_176223_P());
        }
        int mobCounter = 0;
        block48: while (mobCounter < 6) {
            int i22;
            i4 = rand.nextInt(32) + 1;
            if (this.maze[i4][i22 = rand.nextInt(32) + 1] != 7) continue;
            ++mobCounter;
            world.func_175698_g(new BlockPos(x + i4, y - 1, z + i22));
            world.func_175698_g(new BlockPos(x + i4, y, z + i22));
            world.func_175656_a(new BlockPos(x + i4, y - 1, z + i22), Blocks.field_150474_ac.func_176223_P());
            TileEntityMobSpawner mobSpawner = new TileEntityMobSpawner();
            world.func_175690_a(new BlockPos(x + i4, y - 1, z + i22), (TileEntity)mobSpawner);
            switch (rand.nextInt(5)) {
                case 0: {
                    mobSpawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityBlackSoul.class));
                    continue block48;
                }
                case 1: {
                    mobSpawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityBabyMummy.class));
                    continue block48;
                }
            }
            mobSpawner.func_145881_a().func_190894_a(EntityList.func_191306_a(EntityMummy.class));
        }
        world.func_175698_g(new BlockPos(x + 1, y - 1, z));
        world.func_175698_g(new BlockPos(x + 1, y, z));
        for (i4 = 0; i4 < 5; ++i4) {
            world.func_175698_g(new BlockPos(x + 1, y - 1, z - i4));
            world.func_175698_g(new BlockPos(x + 1, y, z - i4));
            world.func_175656_a(new BlockPos(x + 1, y, z - i4), Blocks.field_150478_aa.func_176223_P());
        }
        world.func_175656_a(new BlockPos(x - 1, y, z - 5), Blocks.field_150478_aa.func_176223_P());
        world.func_175656_a(new BlockPos(x + 1, y, z - 5), Blocks.field_150478_aa.func_176223_P());
        world.func_175656_a(new BlockPos(x, y, z - 5), Blocks.field_150478_aa.func_176223_P());
        for (i4 = 1; i4 < 25; ++i4) {
            world.func_175698_g(new BlockPos(x - 1, y + i4, z - 5));
            world.func_175698_g(new BlockPos(x + 1, y + i4, z - 5));
            world.func_175698_g(new BlockPos(x, y + i4, z - 5));
        }
        world.func_175656_a(new BlockPos(x, y + 26, z - 5), Blocks.field_150478_aa.func_176223_P());
        EntityItem entityItem = new EntityItem(world, (double)x + (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f - 2.0, (double)y + (double)(world.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6 - 2.0, (double)z + (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f - 2.0, new ItemStack(Items.field_151103_aS, 5));
        world.func_72838_d((Entity)entityItem);
        world.func_175656_a(new BlockPos(x + 35 - 2, y - 1, z + 35 - 2), Block.func_149729_e((int)54).func_176223_P());
        TileEntityChest chest = new TileEntityChest();
        world.func_175690_a(new BlockPos(x + 35 - 2, y - 1, z + 35 - 2), (TileEntity)chest);
        block51: for (int i5 = 0; i5 < chest.func_70302_i_(); ++i5) {
            switch (rand.nextInt(50)) {
                case 0: {
                    chest.func_70299_a(i5, new ItemStack(CreepsItemHandler.gooDonut, rand.nextInt(15) + 1));
                    continue block51;
                }
                case 1: {
                    chest.func_70299_a(i5, new ItemStack(CreepsItemHandler.bandaid, rand.nextInt(15) + 1));
                    continue block51;
                }
                case 2: {
                    chest.func_70299_a(i5, new ItemStack(CreepsItemHandler.raygun, 1));
                    continue block51;
                }
                case 3: {
                    chest.func_70299_a(i5, new ItemStack(CreepsItemHandler.money, rand.nextInt(15) + 1));
                    continue block51;
                }
                case 4: {
                    chest.func_70299_a(i5, new ItemStack(CreepsItemHandler.blorpCola, rand.nextInt(10) + 5));
                    continue block51;
                }
                case 5: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151025_P, 1));
                    continue block51;
                }
                case 6: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151153_ao, 1));
                    continue block51;
                }
                case 7: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151043_k, rand.nextInt(3) + 2));
                    continue block51;
                }
                case 8: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151042_j, rand.nextInt(5) + 2));
                    continue block51;
                }
                case 9: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151016_H, rand.nextInt(4) + 2));
                    continue block51;
                }
                case 10: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151110_aK, rand.nextInt(3) + 1));
                    continue block51;
                }
                case 11: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151015_O, rand.nextInt(12) + 2));
                    continue block51;
                }
                case 12: {
                    chest.func_70299_a(i5, new ItemStack(CreepsItemHandler.evilEgg, rand.nextInt(15) + 1));
                    continue block51;
                }
                case 13: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151045_i, rand.nextInt(2) + 1));
                    continue block51;
                }
                case 14: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151040_l, 1));
                    continue block51;
                }
                case 15: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151048_u, 1));
                    continue block51;
                }
                case 16: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151103_aS, 1));
                    continue block51;
                }
                case 17: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151032_g, rand.nextInt(30) + 10));
                    continue block51;
                }
                case 18: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151055_y, 1));
                    continue block51;
                }
                case 19: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151117_aB, 1));
                    continue block51;
                }
                case 20: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151120_aE, rand.nextInt(6) + 6));
                    continue block51;
                }
                case 21: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151121_aF, rand.nextInt(16) + 6));
                    continue block51;
                }
                case 22: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151122_aG, 1));
                    continue block51;
                }
                case 23: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151106_aX, rand.nextInt(6) + 6));
                    continue block51;
                }
                case 24: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151105_aU, rand.nextInt(6) + 6));
                    continue block51;
                }
                case 25: {
                    chest.func_70299_a(i5, new ItemStack(Items.field_151133_ar, rand.nextInt(6) + 6));
                    continue block51;
                }
                case 26: {
                    chest.func_70299_a(i5, new ItemStack(CreepsItemHandler.evilEgg, rand.nextInt(40) + 1));
                    continue block51;
                }
            }
        }
        EntityPyramidGuardian guardian = new EntityPyramidGuardian(world);
        guardian.func_70012_b(x + 35 - 2, y - 1, z + 35 - 3, 300.0f, 0.0f);
        guardian.determineBaseTexture();
        guardian.setInitialHealth();
        guardian.func_110163_bv();
        world.func_72838_d((Entity)guardian);
        for (int i6 = 0; i6 < 35; ++i6) {
            for (int q = 0; q < 35; ++q) {
                world.func_175656_a(new BlockPos(x + i6, y + 1, z + q), Block.func_149729_e((int)7).func_176223_P());
            }
        }
        return true;
    }

    private void makeMaze() {
        int j;
        int i;
        int maze1 = 0;
        int maze2 = 0;
        int[] ai = new int[612];
        int[] ai2 = new int[612];
        for (int i2 = 0; i2 < 35; ++i2) {
            for (int j2 = 0; j2 < 35; ++j2) {
                this.maze[i2][j2] = 7;
            }
        }
        int rowsMax = 34;
        int columnsMax = 34;
        for (i = 1; i < rowsMax; i += 2) {
            for (j = 1; j < columnsMax; j += 2) {
                this.maze[i][j] = -(++maze1);
                if (i < 33) {
                    ai[maze2] = i + 1;
                    ai2[maze2] = j;
                    ++maze2;
                }
                if (j >= 33) continue;
                ai[maze2] = i;
                ai2[maze2] = j + 1;
                ++maze2;
            }
        }
        for (i = maze2 - 1; i > 0; --i) {
            j = (int)(Math.random() * (double)i);
            if (ai[j] % 2 == 1 && this.maze[ai[j]][ai2[j] - 1] != this.maze[ai[j]][ai2[j] + 1]) {
                this.fill(ai[j], ai2[j] - 1, this.maze[ai[j]][ai2[j] - 1], this.maze[ai[j]][ai2[j] + 1]);
                this.maze[ai[j]][ai2[j]] = this.maze[ai[j]][ai2[j] + 1];
            } else if (ai[j] % 2 == 0 && this.maze[ai[j] - 1][ai2[j]] != this.maze[ai[j] + 1][ai2[j]]) {
                this.fill(ai[j] - 1, ai2[j], this.maze[ai[j] - 1][ai2[j]], this.maze[ai[j] + 1][ai2[j]]);
                this.maze[ai[j]][ai2[j]] = this.maze[ai[j] + 1][ai2[j]];
            }
            ai[j] = ai[i];
            ai2[j] = ai2[i];
        }
        for (i = 0; i < rowsMax; ++i) {
            for (j = 1; j < columnsMax; ++j) {
                if (this.maze[i][j] >= 0) continue;
                this.maze[i][j] = 0;
            }
        }
    }

    private void fill(int i, int x, int y, int z) {
        if (i < 0) {
            i = 0;
        }
        if (x < 0) {
            x = 0;
        }
        if (i > 35) {
            i = 35;
        }
        if (x > 35) {
            x = 35;
        }
        if (this.maze[i][x] == y) {
            this.maze[i][x] = z;
            this.fill(i + 1, x, y, z);
            this.fill(i - 1, x, y, z);
            this.fill(i, x + 1, y, z);
            this.fill(i, x - 1, y, z);
        }
    }
}

