/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_3264;
import net.pixeldreamstudios.rpgsystems.compat.KevsLibraryCritCompat;
import net.pixeldreamstudios.rpgsystems.compat.showbuild.ShowBuildCompatNetServer;
import net.pixeldreamstudios.rpgsystems.config.RPGSystemsConfig;
import net.pixeldreamstudios.rpgsystems.network.EnemyNet;
import net.pixeldreamstudios.rpgsystems.network.PartyNet;
import net.pixeldreamstudios.rpgsystems.network.SystemNet;
import net.pixeldreamstudios.rpgsystems.network.TitleNet;
import net.pixeldreamstudios.rpgsystems.network.TitlePowerNet;
import net.pixeldreamstudios.rpgsystems.party.PartyCommands;
import net.pixeldreamstudios.rpgsystems.pet.PetCommands;
import net.pixeldreamstudios.rpgsystems.title.TitleCommands;
import net.pixeldreamstudios.rpgsystems.title.TitleConditionEvents;
import net.pixeldreamstudios.rpgsystems.title.data.TitlesDataReloader;
import net.pixeldreamstudios.rpgsystems.title.power.PowerInit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPGSystems
implements ModInitializer {
    public static final String MOD_ID = "rpg-systems";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rpg-systems");

    public void onInitialize() {
        RPGSystemsConfig.load();
        SystemNet.registerServer();
        if (RPGSystemsConfig.get().systems.party) {
            PartyNet.initCommon();
        }
        if (FabricLoader.getInstance().isModLoaded("showmeyourbuild")) {
            ShowBuildCompatNetServer.initServer();
        }
        EnemyNet.initCommon();
        if (RPGSystemsConfig.get().systems.title) {
            ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new TitlesDataReloader());
            TitleNet.registerServer();
            TitleConditionEvents.register();
            PowerInit.init();
            TitlePowerNet.registerServer();
        }
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (RPGSystemsConfig.get().systems.party) {
                PartyCommands.register((CommandDispatcher<class_2168>)dispatcher);
            }
            if (RPGSystemsConfig.get().systems.pet) {
                PetCommands.register((CommandDispatcher<class_2168>)dispatcher);
            }
            if (RPGSystemsConfig.get().systems.title) {
                TitleCommands.register((CommandDispatcher<class_2168>)dispatcher);
            }
        });
        KevsLibraryCritCompat.init();
        LOGGER.info("RPG Systems loaded. Enabled systems -> party={}, pet={}, title={}", new Object[]{RPGSystemsConfig.get().systems.party, RPGSystemsConfig.get().systems.pet, RPGSystemsConfig.get().systems.title});
    }
}

