/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.rpgsystems.client.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.pixeldreamstudios.rpgsystems.client.config.MiscClientConfig;

@Environment(value=EnvType.CLIENT)
public final class MiscOptionsScreen
extends class_437 {
    private final class_437 parent;
    private class_342 inviteX;
    private class_342 inviteY;
    private class_342 joinX;
    private class_342 joinY;
    private class_342 invPlateX;
    private class_342 invPlateY;
    private class_342 titleBtnDX;
    private class_342 titleBtnDY;
    private class_342 partyBtnDX;
    private class_342 partyBtnDY;
    private ScrollForm form;
    private double formScroll = 0.0;

    public MiscOptionsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Misc UI Positions"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.method_37067();
        int centerX = this.field_22789 / 2;
        int colW = 280;
        int fieldW = 80;
        int rowH = 20;
        int top = 56;
        int bottomPad = 70;
        int formH = Math.max(60, this.field_22790 - top - bottomPad);
        MiscClientConfig cfg = MiscClientConfig.get();
        this.inviteX = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.inviteY = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.joinX = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.joinY = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.invPlateX = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.invPlateY = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.titleBtnDX = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.titleBtnDY = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.partyBtnDX = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.partyBtnDY = new class_342(this.field_22793, 0, 0, fieldW, rowH, (class_2561)class_2561.method_43473());
        this.inviteX.method_1852(String.valueOf(cfg.inviteHudX));
        this.inviteY.method_1852(String.valueOf(cfg.inviteHudY));
        this.joinX.method_1852(String.valueOf(cfg.joinRequestHudX));
        this.joinY.method_1852(String.valueOf(cfg.joinRequestHudY));
        this.invPlateX.method_1852(String.valueOf(cfg.inviteInventoryX));
        this.invPlateY.method_1852(String.valueOf(cfg.inviteInventoryY));
        this.titleBtnDX.method_1852(String.valueOf(cfg.handledTitlesBtnOffsetX));
        this.titleBtnDY.method_1852(String.valueOf(cfg.handledTitlesBtnOffsetY));
        this.partyBtnDX.method_1852(String.valueOf(cfg.handledPartyBtnOffsetX));
        this.partyBtnDY.method_1852(String.valueOf(cfg.handledPartyBtnOffsetY));
        int formX = centerX - colW / 2;
        this.form = new ScrollForm(formX, top, colW, formH, this.field_22793, () -> this.formScroll, s -> {
            this.formScroll = s;
        });
        this.form.addRow("Join Request HUD X (from left)", this.joinX, 0);
        this.form.addRow("Join Request HUD Y (from bottom)", this.joinY, 4);
        this.form.addRow("Invite Inventory Plate X (from left)", this.invPlateX, 0);
        this.form.addRow("Invite Inventory Plate Y (from bottom)", this.invPlateY, 4);
        this.form.addRow("Titles Button dX (relative to screen x)", this.titleBtnDX, 0);
        this.form.addRow("Titles Button dY (relative to screen y)", this.titleBtnDY, 4);
        this.form.addRow("Party Button dX (relative to screen x)", this.partyBtnDX, 0);
        this.form.addRow("Party Button dY (relative to screen y)", this.partyBtnDY, 0);
        this.form.addRow("Invite HUD X (from left)", this.inviteX, 0);
        this.form.addRow("Invite HUD Y (from bottom)", this.inviteY, 0);
        this.method_37063((class_364)this.form);
        int btnY = top + formH + 16;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.applyAndSave();
            this.field_22787.method_1507(this.parent);
        }).method_46437(100, rowH).method_46433(centerX - 180, btnY).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset Defaults"), b -> {
            cfg.resetDefaults();
            MiscClientConfig.save();
            this.field_22787.method_1507((class_437)new MiscOptionsScreen(this.parent));
        }).method_46437(120, rowH).method_46433(centerX - 50, btnY).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46437(100, rowH).method_46433(centerX + 100, btnY).method_46431());
    }

    public void method_25410(class_310 mc, int w, int h) {
        String a = this.inviteX != null ? this.inviteX.method_1882() : "";
        String b = this.inviteY != null ? this.inviteY.method_1882() : "";
        String c = this.joinX != null ? this.joinX.method_1882() : "";
        String d = this.joinY != null ? this.joinY.method_1882() : "";
        String e = this.invPlateX != null ? this.invPlateX.method_1882() : "";
        String f = this.invPlateY != null ? this.invPlateY.method_1882() : "";
        String g = this.titleBtnDX != null ? this.titleBtnDX.method_1882() : "";
        String htx = this.titleBtnDY != null ? this.titleBtnDY.method_1882() : "";
        String i = this.partyBtnDX != null ? this.partyBtnDX.method_1882() : "";
        String j = this.partyBtnDY != null ? this.partyBtnDY.method_1882() : "";
        double prev = this.formScroll;
        super.method_25410(mc, w, h);
        this.method_25426();
        this.inviteX.method_1852(a);
        this.inviteY.method_1852(b);
        this.joinX.method_1852(c);
        this.joinY.method_1852(d);
        this.invPlateX.method_1852(e);
        this.invPlateY.method_1852(f);
        this.titleBtnDX.method_1852(g);
        this.titleBtnDY.method_1852(htx);
        this.partyBtnDX.method_1852(i);
        this.partyBtnDY.method_1852(j);
        this.formScroll = prev;
    }

    public boolean method_25401(double mouseX, double mouseY, double horiz, double vert) {
        if (this.form != null && this.form.method_25405(mouseX, mouseY)) {
            return this.form.method_25401(mouseX, mouseY, horiz, vert);
        }
        return super.method_25401(mouseX, mouseY, horiz, vert);
    }

    private static int parseIntSafe(class_342 f, int fallback) {
        try {
            return Integer.parseInt(f.method_1882().trim());
        }
        catch (Throwable t) {
            return fallback;
        }
    }

    private void applyAndSave() {
        MiscClientConfig cfg = MiscClientConfig.get();
        cfg.inviteHudX = MiscOptionsScreen.parseIntSafe(this.inviteX, cfg.inviteHudX);
        cfg.inviteHudY = MiscOptionsScreen.parseIntSafe(this.inviteY, cfg.inviteHudY);
        cfg.joinRequestHudX = MiscOptionsScreen.parseIntSafe(this.joinX, cfg.joinRequestHudX);
        cfg.joinRequestHudY = MiscOptionsScreen.parseIntSafe(this.joinY, cfg.joinRequestHudY);
        cfg.inviteInventoryX = MiscOptionsScreen.parseIntSafe(this.invPlateX, cfg.inviteInventoryX);
        cfg.inviteInventoryY = MiscOptionsScreen.parseIntSafe(this.invPlateY, cfg.inviteInventoryY);
        cfg.handledTitlesBtnOffsetX = MiscOptionsScreen.parseIntSafe(this.titleBtnDX, cfg.handledTitlesBtnOffsetX);
        cfg.handledTitlesBtnOffsetY = MiscOptionsScreen.parseIntSafe(this.titleBtnDY, cfg.handledTitlesBtnOffsetY);
        cfg.handledPartyBtnOffsetX = MiscOptionsScreen.parseIntSafe(this.partyBtnDX, cfg.handledPartyBtnOffsetX);
        cfg.handledPartyBtnOffsetY = MiscOptionsScreen.parseIntSafe(this.partyBtnDY, cfg.handledPartyBtnOffsetY);
        MiscClientConfig.save();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_25420(ctx, mouseX, mouseY, delta);
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
    }

    private static final class ScrollForm
    extends class_339 {
        private static final int LABEL_COLOR = 0xAAAAAA;
        private static final int ROW_GAP = 24;
        private final List<Row> rows = new ArrayList<Row>();
        private final class_327 tr;
        private final DoubleSupplier getInitialScroll;
        private final DoubleConsumer onScrollChanged;
        private double scroll;
        private int contentHeight;
        private class_339 focusedChild;

        ScrollForm(int x, int y, int w, int h, class_327 tr, DoubleSupplier initialScroll, DoubleConsumer onScrollChanged) {
            super(x, y, w, h, (class_2561)class_2561.method_43473());
            this.tr = tr;
            this.getInitialScroll = initialScroll;
            this.onScrollChanged = onScrollChanged;
            this.scroll = this.clamp(initialScroll.getAsDouble());
        }

        void addRow(String label, class_342 field, int extraBottomSpace) {
            this.rows.add(new Row(label, field, extraBottomSpace));
        }

        protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
            this.scroll = this.clamp(this.scroll == 0.0 ? this.getInitialScroll.getAsDouble() : this.scroll);
            this.layoutChildren();
            int x = this.method_46426();
            int y = this.method_46427();
            int w = this.method_25368();
            int h = this.method_25364();
            ctx.method_44379(x, y, x + w, y + h);
            int drawY = y - (int)Math.round(this.scroll);
            for (Row r : this.rows) {
                ctx.method_51433(this.tr, r.label, x, drawY + 4, 0xAAAAAA, false);
                r.field.method_25394(ctx, mouseX, mouseY, delta);
                drawY += 24 + r.extraBottom;
            }
            ctx.method_44380();
        }

        public boolean method_25402(double mx, double my, int button) {
            if (!this.method_25405(mx, my)) {
                return false;
            }
            for (Row r : this.rows) {
                if (!r.field.method_25402(mx, my, button)) continue;
                this.setFocusedChild((class_339)r.field);
                return true;
            }
            this.setFocusedChild(null);
            return true;
        }

        public boolean method_25406(double mx, double my, int button) {
            boolean any = false;
            for (Row r : this.rows) {
                any |= r.field.method_25406(mx, my, button);
            }
            return any;
        }

        protected void method_47399(class_6382 builder) {
        }

        public boolean method_25401(double mx, double my, double horiz, double vert) {
            if (!this.method_25405(mx, my)) {
                return false;
            }
            this.scroll = this.clamp(this.scroll - vert * 18.0);
            this.onScrollChanged.accept(this.scroll);
            this.layoutChildren();
            return true;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.focusedChild != null && this.focusedChild.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            for (Row r : this.rows) {
                if (!r.field.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            if (this.focusedChild != null && this.focusedChild.method_25400(chr, modifiers)) {
                return true;
            }
            for (Row r : this.rows) {
                if (!r.field.method_25400(chr, modifiers)) continue;
                return true;
            }
            return super.method_25400(chr, modifiers);
        }

        private void setFocusedChild(class_339 w) {
            if (this.focusedChild == w) {
                return;
            }
            if (this.focusedChild != null) {
                this.focusedChild.method_25365(false);
            }
            this.focusedChild = w;
            if (this.focusedChild != null) {
                this.focusedChild.method_25365(true);
            }
        }

        private void layoutChildren() {
            int x = this.method_46426();
            int y = this.method_46427() - (int)Math.round(this.scroll);
            int w = this.method_25368();
            int fieldW = 80;
            int drawY = y;
            for (Row r : this.rows) {
                int fieldX = x + w - fieldW;
                int fieldY = drawY;
                r.field.method_46421(fieldX);
                r.field.method_46419(fieldY);
                r.field.method_25358(fieldW);
                drawY += 24 + r.extraBottom;
            }
            this.contentHeight = Math.max(0, drawY - y);
        }

        private int maxScroll() {
            return Math.max(0, this.contentHeight - this.method_25364());
        }

        private double clamp(double s) {
            int max = this.maxScroll();
            if (s < 0.0) {
                return 0.0;
            }
            if (s > (double)max) {
                return max;
            }
            return s;
        }

        private static final class Row {
            final String label;
            final class_342 field;
            final int extraBottom;

            Row(String label, class_342 field, int extraBottom) {
                this.label = label;
                this.field = field;
                this.extraBottom = extraBottom;
            }
        }
    }
}

